%
% Test out: HBOQ144solvr solves Galactic dynamics problem
%
%   1. Initialisation
%      - set  initial t0=0;
%             initial y0 = [2.5 ; 0  ; 0  ; 0  ; (25+sqrt(6961-3200*log(5)))/40;  0.2];
%             integration final time "tend"
%                long term integration tend = 10000
%
%   2. Perform the integration : call  "HBOQ144solvr"
%   3. Output
%       write on file "HBd123RKMaxGE.txt" the following informations:
%         - number of steps, number of function evaluations, 
%           Max. global error, number of failed attempts and Max. energy error 
%


% INITIALIZATION :
clear all
format long e

  fid = fopen('HBd123RKMaxGE.txt','a');
  fname = 'Prbgaldyn' ;
  fname3 = 'Prbgaldynd1_d3outp' ;

  nbcmp=6;

% act   tend = 10000.0 
  tend = 100 

   fprintf (fid,'HB_d123  METHOD prb %15s, %15s, tend= %7.2e, %15s \n', fname,fname3, tend, datestr(now)) ;

RELTOL = 5e-14

% PART: det set of TOL 
mxnbt = 20 ;
for itol=1:mxnbt
   TOLT(itol) = 10^(-itol) ;
end;
%  end (for itol=1:mxnbt)
% end  PART : det set of TOL

q= 1;

nbpos = 10;

ipb = 5+2  ;

itmin =11 ; itmax = 11 ;
% MAIN LOOP  TOL = 1e-1, 1e-2,.., 1e-9  (1 TOL/ iteration) --------------------
for itol=itmin:itmax

TOL = 1* TOLT(itol);

t0 =0 ;
y0 = [ 2.5 ; 0  ; 0  ; 0  ; (25+sqrt(6961-3200*log(5)))/40  ;  0.2 ];

% ((********* ham0 ****************************
% yc(1)=q1
% yc(2)=q2
% yc(3)=q3
% yc(4)=p1
% yc(5)=p2
% yc(6)=p3

yc = y0 ;

 q1=yc(1) ; q2=yc(2) ; q3=yc(3) ; p1=yc(4) ; p2=yc(5) ; p3=yc(6) ;

% p 107, Barrio
a=1.25 ; b=1.0; c=0.75 ; A=1.0 ; C=1.0 ; om= 0.25 ;
a2=a*a; b2=b*b; c2=c*c ;

% ok ham0_1 = 0.5*(p1^2+p2^2+p3^2 ) +om*(p1*q2 -p2*q1) +A* log(C +q1^2/a^2 +q2^2/b^2 +q3^2/c^2 ) 

ham0 = 0.5*(yc(4)^2+yc(5)^2+yc(6)^2 ) +om*(yc(4)*yc(2) -yc(5)*yc(1)) +A* log(C +yc(1)^2/a^2 + yc(2)^2/b^2 +yc(3)^2/c^2 ) 

% ********* ham0 ****************************))

RELTOL=5e-14

% ---- cputime ---------------
   scput =cputime ;

 [ tvals, yvals, fvals, f2vals, f3vals, res  ] = HBOQ144solvr( RELTOL, TOL, fname, fname3, t0, tend, y0) ;

% ---- cputime ---------------
      cput = cputime- scput  

% print out statistics
% with index j-1,  yvals(n+1+nbpos, . )  cont solution

NFE = res(1)
% nb succes step:
n=res(2)-1 
nreje=res(3) 
% cput=res(4) 

% *******MAX GE CALCUL: ***********
MAXGE = -9999;
me=-9999.9 
t2 = t0; y2= y0 ;
sizey1 =n+1+nbpos   ;
tvalssizey1vstendzero = tvals(sizey1) -tend
 if tvals(sizey1) ~= tend
    tvalssizey1netend = tvals(sizey1)
    end; 
 
% MAX GE CALCUL: -------
  options = odeset('RelTol',5e-14,'AbsTol',[ 5e-14  ] , 'Stats',[ 'off' ]);

MAXGE = -9999;
t2 = t0; y2= y0 ;

  [ te, ye, o3e ] = ode113(fname ,  tvals(10:sizey1) , y0,options) ;

 sizey1 =n+nbpos   ;

for id = 11:1:sizey1
   tc = tvals(id) ;

   t1= t2;  t2 = tc;   y1 = y2 ;

   MAXGE= max(MAXGE, max(abs( (yvals(:,id))-ye(id-9, :)' ))) ;

   % ************* (( ham *****************
   yc(1) = yvals(1,id) ;
   yc(2) = yvals(2,id) ;
   yc(3) = yvals(3,id) ;
   yc(4) = yvals(4,id) ;
   yc(5) = yvals(5,id) ;
   yc(6) = yvals(6,id) ;

   ham = 0.5*(yc(4)^2+yc(5)^2+yc(6)^2 ) +om*(yc(4)*yc(2) -yc(5)*yc(1)) +A* log(C +yc(1)^2/a^2 + yc(2)^2/b^2 +yc(3)^2/c^2 ) ;
   ham = abs(ham/ham0 - 1.D0);
   if(ham >=  me) me = ham ; 
          end ;
   % ************* ham )) *****************

   if rem(id-5,40)== 0
      id=id
      tc=tc
      me=me
      MAXGE =MAXGE 
   end
%%%  end if

end;
% (end  for id = 11:1:sizey1

% end MAX GE *******************

% ########  RESULTS: galdyn 85    #############

  fprintf (fid,'HBRK  METHOD   %15s, %15s, nsuccesstp = %5.0f, nreje = %5.0f,  %15s \n', fname, fname3, n+1, nreje ,datestr(now)) ;
 fprintf (fid,' HBO14_4Ed123NFE( 85, %3.0f ) = %5.0f ; HBO14_4Ed123NST( 85, %3.0f ) = %5.0f ; HBO14_4Ed123MXGE( 85, %3.0f ) = %7.2e  ; HBO14_4Ed123REJ( 85, %3.0f ) = %7.0f  ; HBO14_4Ed123ENER( 85, %3.0f ) = %7.2e  ; \n'  ,itol, NFE ,itol, n  ,itol, MAXGE,itol, nreje , itol, me ) ;

end;
% end for itol=1:mxnbt (LOOP  TOL = 1e-1, 1e-2,.., 1e-9  (1 TOL/ iteration) ----------)
















