function [yderv, yder2v, yder3v ] = fnctn(tc, yc)

format long e

%  Barrio et al ..VSVO  Formulation of Taylor method ...

a=1.25 ; b=1.0; c=0.75 ; A=1.0 ; C=1.0 ; om= 0.25 ;
a2=a*a; b2=b*b; c2=c*c ;


o=1;


x(o)=yc(1);
y(o)=yc(2);
z(o)=yc(3);
p(o)=yc(4);
q(o)=yc(5);
r(o)=yc(6);


   ft(2)=2;
   ft(3)= 6;
   ft(4) = 24 ;
   ft(5) =   120 ;
   ft(6) =   720 ;
   ft(7) =   5040 ;
   ft(8) =   40320 ;
   ft(9) =      362880 ;
   ft(10) =     3628800 ;
   ft(11) =    39916800 ;
   ft(12) =   479001600 ;
   ft(13) =     6.227020800000000e+09 ;
   ft(14) =     8.717829120000000e+10 ;
   ft(15) =     1.307674368000000e+12 ;
   ft(16) =     2.092278988800000e+13 ;
   ft(17) =     3.556874280960000e+14 ;



y123(o) = (C+x(o)*x(o)/a2 +y(o)*y(o)/b2+z(o)*z(o)/c2)  ; 


% MAIN FUNCTION EXPRESSION :
%  3 equations system : 
% ******** 1st deriv: *******************

x(1+o)= p(o) + om*y(o)  ;
y(1+o)= q(o) - om*x(o)  ;
z(1+o)= r(o) ;
p(1+o)=  -(-om*q(o)  + (A*y123^(-1) )*2*x(o)/a2 ) ;
q(1+o)= -(om*p(o)  + (A*y123^(-1) )*2*y(o)/b2 )  ;
r(1+o)= -( + (A*y123^(-1) )*2*z(o)/c2 ) ;


% ******** 2nd deriv: *******************
% y123( o)^(-1) => expo. alp=-1
% p353 Martin Lara et Al
alp=-1.0;
B(o)= y123( o)^(-1) ;
y123(1+o) =  2*x(o)*x(1+o)/a2 + 2*y(o)*y(1+o)/b2 + 2*z(o)*z(1+o)/c2 ;

m=1;
Bderm=0;
for jdx=1:m
   Bderm=Bderm+((alp+1)*jdx-m)*y123(o+jdx)*B(m-jdx+o) ;
end;
B(o+m)=Bderm/(m*y123(o)) ;

smBx=0;
for jdx=0:m
   smBx=smBx+B(o+jdx)*x(m-jdx+o) ;
end;

smBy=0;
for jdx=0:m
   smBy=smBy+B(o+jdx)*y(m-jdx+o) ;
end;

smBz=0;
for jdx=0:m
   smBz=smBz+B(o+jdx)*z(m-jdx+o) ;
end;

mp1=m+1;
x(mp1 +o)= (p(m+o) + om*y(m+o))/mp1  ;
y(mp1 +o)= (q(m+o) - om*x(m+o))/mp1  ;
z(mp1 +o)= r(m+o)/mp1 ;
p(mp1 +o)=  -(-om*q(m+o)  + smBx*A *2/a2 )/mp1 ;
q(mp1 +o)= -(om*p(m+o)  + smBy*A *2/b2 )/mp1  ;
r(mp1 +o)= -( + smBz* A *2 /c2 )/mp1 ;


% ******** 3rd deriv: *******************
% y123( o)^(-1) => expo. alp=-1
% p353 Martin Lara et Al
% alp=-1.0;
%B(o)= y123( o)^(-1) ;

m=2;

smxx=0;
for jdx=0:m
   smxx=smxx+x(o+jdx)*x(m-jdx+o) ;
end;
smyy=0;
for jdx=0:m
   smyy=smyy+y(o+jdx)*y(m-jdx+o) ;
end;
smzz=0;
for jdx=0:m
   smzz=smzz+z(o+jdx)*z(m-jdx+o) ;
end;

y123(m+o) = smxx/a2 +smyy/b2 +smzz/c2 ;


Bderm=0;
for jdx=1:m
   Bderm=Bderm+((alp+1)*jdx-m)*y123(o+jdx)*B(m-jdx+o) ;
end;
B(o+m)=Bderm/(m*y123(o)) ;

smBx=0;
for jdx=0:m
   smBx=smBx+B(o+jdx)*x(m-jdx+o) ;
end;

smBy=0;
for jdx=0:m
   smBy=smBy+B(o+jdx)*y(m-jdx+o) ;
end;

smBz=0;
for jdx=0:m
   smBz=smBz+B(o+jdx)*z(m-jdx+o) ;
end;

mp1=m+1;
x(mp1 +o)= (p(m+o) + om*y(m+o))/mp1  ;
y(mp1 +o)= (q(m+o) - om*x(m+o))/mp1  ;
z(mp1 +o)= r(m+o)/mp1 ;
p(mp1 +o)=  -(-om*q(m+o)  + smBx*A *2/a2 )/mp1 ;
q(mp1 +o)= -(om*p(m+o)  + smBy*A *2/b2 )/mp1  ;
r(mp1 +o)= -( + smBz* A *2 /c2 )/mp1 ;



% ******** OUTPUT *******************


 yderv = [ x(1+o) ; y(1+o) ; z(1+o) ; p(1+o) ; q(1+o) ; r(1+o)  ] ; 
 yder2v =[ x(2+o)*ft(2); y(2+o)*ft(2) ; z(2+o)*ft(2) ; p(2+o)*ft(2); q(2+o)*ft(2) ; r(2+o)*ft(2)    ] ;
 yder3v =[ x(3+o)*ft(3); y(3+o)*ft(3) ; z(3+o)*ft(3) ; p(3+o)*ft(3); q(3+o)*ft(3) ; r(3+o)*ft(3)    ] ;



% END OF FUNCTION EXPRESSION


