function [yderv, yder2v, yder3v ] = fnctn(tc, yc)

format long e

% p618, T E Hull, W.H. Enright,..Comparing  Num Methods

o=1;

x(o)=yc(1) ;
y(o)=yc(2) ;
z(o)=yc(3);
w(o)=yc(4);

   ft(2)=2;
   ft(3)= 6;
   ft(4) = 24 ;
   ft(5) =   120 ;
   ft(6) =   720 ;
   ft(7) =   5040 ;
   ft(8) =   40320 ;
   ft(9) =      362880 ;
   ft(10) =     3628800 ;
   ft(11) =    39916800 ;
   ft(12) =   479001600 ;
   ft(13) =     6.227020800000000e+09 ;
   ft(14) =     8.717829120000000e+10 ;
   ft(15) =     1.307674368000000e+12 ;
   ft(16) =     2.092278988800000e+13 ;
   ft(17) =     3.556874280960000e+14 ;

re2(o) =x(o)*x(o) + y(o)*y(o) ;


% MAIN FUNCTION EXPRESSION :
%  4 equations system : 

% *************** yc 1st deriv: **************************************

 x(1+o) =  z(o) ;
 y(1+o) =  w(o) ;
 z(1+o) = -x(o)*re2(o)^(-1.5)    ;
 w(1+o) = -y(o)*re2(o)^(-1.5)  ;


% ******** 2nd deriv: *******************
% re2( o)^(-1.5) => expo. alp=-1.5
% p353 Martin Lara et Al
alp=-1.5;
B(o)= re2( o)^(-1.5) ;

m=1;

re2(1+o) =2*x(o)*x(1+o) + 2*y(o)*y(1+o) ;


Bderm=0;
for jdx=1:m
   Bderm=Bderm+((alp+1)*jdx-m)*re2(o+jdx)*B(m-jdx+o) ;
end;
B(o+m)=Bderm/(m*re2(o)) ;

smBx=0;
for jdx=0:m
   smBx=smBx+B(o+jdx)*x(m-jdx+o) ;
end;
smBy=0;
for jdx=0:m
   smBy=smBy+B(o+jdx)*y(m-jdx+o) ;
end;

mp1=m+1 ;
x(mp1 +o) =  z(m+o)/mp1  ;
y(mp1 +o) =  w(m+o)/mp1  ;
z(mp1 +o) = -smBx/mp1       ;
w(mp1 +o) = -smBy/mp1     ;


% ******** 3rd deriv: *******************
% re2( o)^(-1.5) => expo. alp=-1.5
% p353 Martin Lara et Al
%alp=-1.5;
%B(o)= re2( o)^(-1.5) ;
%re2(1+o) =2*x(o)*x(1+o) + 2*y(o)*y(1+o) ;

m=2;

smxx=0;
for jdx=0:m
   smxx=smxx+x(o+jdx)*x(m-jdx+o) ;
end;
smyy=0;
for jdx=0:m
   smyy=smyy+y(o+jdx)*y(m-jdx+o) ;
end;
re2(m+o) =(smxx + smyy) ; 


Bderm=0;
for jdx=1:m
   Bderm=Bderm+((alp+1)*jdx-m)*re2(o+jdx)*B(m-jdx+o) ;
end;
B(o+m)=Bderm/(m*re2(o)) ;

smBx=0;
for jdx=0:m
   smBx=smBx+B(o+jdx)*x(m-jdx+o) ;
end;
smBy=0;
for jdx=0:m
   smBy=smBy+B(o+jdx)*y(m-jdx+o) ;
end;

mp1=m+1 ;
x(mp1 +o) =  z(m+o)/mp1  ;
y(mp1 +o) =  w(m+o)/mp1  ;
z(mp1 +o) = -smBx/mp1       ;
w(mp1 +o) = -smBy/mp1     ;



 yderv = [ x(1+o) ; y(1+o) ; z(1+o) ; w(1+o) ] ; 
 yder2v = [ x(2+o)*ft(2)  ; y(2+o)*ft(2) ; z(2+o)*ft(2) ; w(2+o)*ft(2)  ] ;
 yder3v = [ x(3+o)*ft(3)  ; y(3+o)*ft(3) ; z(3+o)*ft(3) ; w(3+o)*ft(3)  ] ;



% END OF FUNCTION EXPRESSION

