function [tvals, yvals, fvals, f2vals, f3vals, res] = fnctn(RELTOL, TOL, fname, fname3, t0, tend, y0) ;

% 
% HBOQ144solvr,  non-stiff differential equations solver of order 14.
% 			
% [tvals, yvals, fvals, f2vals, f3vals, res] = HBOQ144solvr( RELTOL, TOL, fname, fname3, t0, tend, y0)  
%  integrates the system of differential equations y' = f(t,y) from time t0 to tend with
%    initial conditions y0.
%   Function fname(t,y) must return a column vector
%     corresponding to f(t,y)
%   Function fname3(t,y) must return three column vectors: 
%     (1) a column vector corresponding to f(t,y)
%     (2) a column vector corresponding to f'(t,y)
%     (3) a column vector corresponding to f''(t,y)
% 
%  The formula of "HBOQ144solvr"  uses y',  y'' and y''' as in Obrechkoff methods.
%  Simple formulae are derived once for all to obtain the values of Hermite-Birkhoff
%  interpolation polynomials in terms of Lagrange basis functions
%  for 16 quantized stepsize ratios. The coefficients of 
%  these formulae are stored in "HBOQ144coefsmat.m"
% 
%  Each row in the solution array "yvals', derivatives "fvals","f2vals" and "f3vals"
%  corresponds to a time returned in the column vector "tvals"
%  
% Input parameters to "HBOQ144solvr" ---------
% 
%   RELTOL -- not used in this code
%   TOL -- error tolerance
%   fname -- Function fname(t,y) must return a column vector
%        corresponding to f(t,y)
%   fname3 -- Function fname3(t,y) must return three column vectors: 
%       (1) a column vector corresponding to f(t,y)
%       (2) a column vector corresponding to f'(t,y)
%       (3) a column vector corresponding to f''(t,y)
%   t0 -- starting integration time
%   tend -- final integration time
%   y0 -- vector of initial conditions 
% 
% Output parameters from "HBOQ144solvr" --------
% 
%   tvals -- independent variable
%   yvals -- solution array
%   fvals -- first derivative of solution array "yvals'
%   f2vals -- second derivative of solution array "yvals'
%   f3vals -- third derivative of solution array "yvals'
%   res
% 	res(1) -- number of function evaluations ;
% 	res(2) -- number of success steps   ;
% 	res(3) -- number of failed attempts  ;
% 
% 
% This code is explained in more details in
% Hermite-Birkhoff-Obrechkoff 4-stage 4-step ODE solver of order 14
% with quantized stepsize by
% Truong Nguyen-Ba, Philip W. Sharp, and Remi Vaillancourt
% Journal of Computational and Applied Mathematics, submitted.
% 
% Please inform the authors of any errors in the code or the
% documentation
%

% ************** Table of sections and subsections of "HBOQ144solvr.m" ******************************
% 
% SECTION 1. INITIALIZATION
%     SUBS 1.A  INPUT THE MATRIX OF COEFFICIENTS 
%           file  "HBOQ144coefsmat"
% 
%     SUBS 1.B THE FIRST FOUR EQUAL CONSECUTIVE STEPSIZES 
%         are obtained by the procedure "HBO7_4initd123steps"
% 
% SECTION 2. PERFORM THE INTEGRATION : 
%       MAIN LOOP TO ADVANCE INTEGRATION FROM x_n to x_{n+3} PER ITERATION 
%          {
%            (SUBS 2.A) SUBLOOP REPEAT THE FOLLOWING FOUR STEPS UNTIL err_est <= TOL
%              {
% 
%               SUBS 2.A.1 STEP1 : TO ADVANCE INTEGRATION FROM x_n to x_{n+1} 
%                   The values y_jpc2,y_jpc3,y_jpc4 and ynew of
%                   predictors P2, P3, P4 and Integration Formula  respectively are obtained 
%                   (y_jpc2,y_jpc3,y_jpc4 and ynew of STEP1)
% 
%               SUBS 2.A.2 STEP2 : TO ADVANCE INTEGRATION FROM x_{n+1} to x_{n+2} 
%                   The values y_jpc2,y_jpc3,y_jpc4 and ynew of
%                   predictors P2, P3, P4 and Integration Formula  respectively are obtained 
%                   (y_jpc2,y_jpc3,y_jpc4 and ynew of STEP2)
% 
%               SUBS 2.A.3 STEP3 : TO ADVANCE INTEGRATION FROM x_{n+2} to x_{n+3} 
%                   The values y_jpc2,y_jpc3,y_jpc4 and ynew of
%                   predictors P2, P3, P4 and Integration Formula  respectively are obtained 
%                   (y_jpc2,y_jpc3,y_jpc4 and ynew of STEP3)
% 
%                   The current quantized stepsizes are used to compute the new error estimate 
%                   "err_est" 
% 
%               If err_est > TOL
%                   {
%                      failed attempt:
%                      calculate smaller step size stsize = 0.7* h
%                      and return to  SUBS 2.A.1 STEP1 
%                    }
% 
%               }
%               (end of SUBLOOP Repeat the following three steps until err_est <= TOL)
% 
% 
%               The current step is accepted:
% 
%            SUBS 2.B STEPSIZE SELECTION:
% 
%               The next three consecutive stepsizes stsize are obtained by the following formula 
%                    stsize  = h *stfac *(TOL/err_est )^(1.0/14.0) ;  
%               "stsize" are then quantized and stored back into "stsize"
% 
%            SUBS 2.C INTERPOLATION  
%                if  (tc > tend) use interpolation procedure "HBO14_d123interp" to get ynew
% 
%           }
%          (end of MAIN LOOP  to advance integration from x_n to x_{n+3} per 1 iteration)
% 
% It is to be noted that the section number and name mentioned above are identical to  
% the section number and name appeared in the code 

 format long e

%************** PARAM: ********************
 hmax = 0.1*abs(tend-t0)  ; 
 stfac=0.64 ;
% stfac=0.71 ;
% ok stfac=0.74 ;
%  stfac=0.81 ;
 nbinitst = 4;
 nbeps=6 ;
%************** END PARAM **************

% ************ SECTION 1. INITIALIZATION **************************

 nbcmp=size(y0,1);

% *****  SUBS 1.A  INPUT THE MATRIX OF COEFFICIENTS ***

 HBOQ144coefsmat ;

 tvals =zeros(1,150000) ;
 yvals = zeros(nbcmp,150000) ; 
 fvals = zeros(nbcmp,150000);
 f2vals = zeros(nbcmp,150000);
 f3vals = zeros(nbcmp,150000);

 %   ode45 hmin:  eps = 2.220446049250313e-16
 eps = 2.220446049250313e-16 ;
%
% INITIALIZATION :
% clear all
 q= 1;
 nbpos = 10;
 tc = t0 ;
 yc =y0;

% options = odeset('RelTol', 5e-14,'AbsTol',[ 5e-14  ] , 'Stats',[ 'off' ]);

k=1111;
j=0;
oc=3 ;

% ********* SUBS 1.B THE FIRST FOUR EQUAL CONSECUTIVE STEPSIZES
%              are obtained by the procedure "HBO7_4initd123steps"                       

[tvals, yvals, fvals, f2vals, f3vals, res, j, h] = HBO7_4initd123steps( RELTOL, TOL, fname,fname3, t0, tend, y0, nbinitst, tvals, yvals, fvals, f2vals, f3vals) ;

yc = yvals(:,j+nbpos) ;
tc = tvals(j+nbpos) ;
hv = h; 

MAXGE = -9999;
oc=1111 ;
abmhbnfe=nbinitst*2 ;
t2 = t0; y2= y0 ;
% j=nbinitst
nreje=0;
tc = tvals(j+nbpos)  ;
hnew = h ;

% INIT PARAM.

c1=0; c2=1/3 ; c3=2/3 ; c4=1;

%   compeps of hmin:  compeps = 2.220446049250313e-16
    compeps = 2.220446049250313e-16 ;
    hmin = 16*compeps*abs(tc);

   ft2=2;   ft3= 6;   ft4 = 24 ;   ft5 =   120 ;   ft6 =   720 ;
   ft7 =   5040 ;   ft8 =   40320 ;   ft9 =      362880 ;
   ft10 =     3628800 ;   ft11 =    39916800 ;   ft12 =   479001600 ;
   ft13 =     6.227020800000000e+09 ;
   ft14 =     8.717829120000000e+10 ;   ft15 =     1.307674368000000e+12 ;
   ft16 =     2.092278988800000e+13 ;
   ft17 =     3.556874280960000e+14 ;

   ift2 =     5.000000000000000e-01  ;   ift3 =     1.666666666666667e-01 ;
   ift4 =     4.166666666666666e-02 ;
   ift5 =     8.333333333333333e-03 ;    ift6 =     1.388888888888889e-03 ;
   ift7 =     1.984126984126984e-04 ;
   ift8 =     2.480158730158730e-05 ;     ift9 =     2.755731922398589e-06 ;
   ift10 =     2.755731922398589e-07;
   ift11 =     2.505210838544172e-08;   ift12 =     2.087675698786810e-09;
   ift13 =     1.605904383682161e-10;
   ift14 =     1.147074559772972e-11;   ift15 =     7.647163731819816e-13;
   ift16 =     4.779477332387385e-14;   ift17 =     2.811457254345521e-15;      
   
   c22= c2*c2/2 ;c23= c22*c2/3  ; c24= c23*c2/4  ;
   c25= c24*c2/5  ; c26= c25*c2/6  ; c27= c26*c2/7  ;
   c28= c27*c2/8  ; c29= c28*c2/9  ; c210=c29*c2/10  ;
   c211=c210*c2/11  ; c212=c211*c2/12  ;
   c213=c212*c2/13  ; c214=c213*c2/14  ;  

   c32= c3*c3/2 ; c33= c32*c3/3  ; c34= c33*c3/4  ; c35= c34*c3/5  ;
   c36= c35*c3/6  ; c37= c36*c3/7  ;
   c38= c37*c3/8  ; c39= c38*c3/9  ; c310=c39*c3/10  ;
   c311=c310*c3/11  ; c312=c311*c3/12  ;
   c313=c312*c3/13  ; c314=c313*c3/14  ;

%for id = 20:20
  alpm6(20 )=0.0 ;  alpm5(20 )=0.0 ;  alpm4(20 )=0.0 ;  alpm3(20 )=0.0;
  alpm2(20 )=0.0;  alpm1(20 )=0.0;  alp(20 )=0.0;
  am14(20 )=0.0;  am13(20 )=0.0;  am12(20 )=0.0;  am11(20 )=0.0;
  am10(20 )=0.0;  am9(20 )=0.0;  am8(20 )=0.0;
  am7(20 )=0.0;  am6(20 )=0.0;  am5(20 )=0.0;  am4(20 )=0.0;
  am3(20 )=0.0;  am2(20 )=0.0;  am1(20 )=0.0;
% end;
 lhs(1,1)=0;
%     -->    col1_2(:,1)=  yvals(m0jd ,:); ...  
  col1_7=zeros(nbcmp,6) ;
  col8_11=zeros(nbcmp,4) ;
  col12_15=zeros(nbcmp,4) ;

% INIT 
  xtab = zeros(37,1 ) ;      

% **** SECTION 2. PERFORM THE INTEGRATION : 
%      MAIN LOOP TO ADVANCE INTEGRATION FROM x_n to x_{n+3} PER ITERATION *****************

 while  tvals(j+nbpos) < tend

    hmin = 16*eps*abs(tc);

    if j >= nbinitst+1000000

       cprogjm6h =      tvals (j-6+nbpos) - tvals(j-7+nbpos)
       cprogjm5h =      tvals (j-5+nbpos) - tvals(j-6+nbpos)
       cprogjm4h =      tvals (j-4+nbpos) - tvals(j-5+nbpos)
       cprogjm3h =      tvals (j-3+nbpos) - tvals(j-4+nbpos)
       cprogjm2h =      tvals (j-2+nbpos) - tvals(j-3+nbpos)
       cprogjm1h =      tvals (j-1+nbpos) - tvals(j-2+nbpos)
       cprogjh =      tvals (j+nbpos) - tvals(j-1+nbpos)      
       h =h
       tc =tvals(j+nbpos)
       j = j
       options = odeset('RelTol',5e-14,'AbsTol',[5e-14  ] , 'Stats',[ 'off' ]);
       [ t, y, o3 ] = ode113(fname, [0 tc], y0,options) ;

       n____aft_integ_yval_zero =  yvals(:,j+nbpos) - transpose( y(size(y,1) ,:) )

       maxge  = max( abs( yvals(:,j+nbpos) - transpose( y(size(y,1) ,:) )))
       NBSTEPS = j

%      MAXGE=MAXGE
       return
       end;

   h=hnew;

   err_est=9999;

   if (h <= hmin )
      h=1.2*hmin ;
      end;

   preh=tvals(j+nbpos)-tvals(j-1+nbpos) ;

%  (SUBS 2.A) SUBLOOP REPEAT THE FOLLOWING FOUR STEPS UNTIL err_est <= TOL 
%     to advance integration from x_n to x_{n+3}

      while ( err_est > TOL  )&( h > hmin)

% **** SUBS 2.A.1 STEP1 : TO ADVANCE INTEGRATION FROM x_n to x_{n+1} ****

      jpnbpos=j+nbpos;

      m14jd=jpnbpos-14  ;  m13jd=jpnbpos-13  ;  m12jd=jpnbpos-12  ;
      m11jd=jpnbpos-11 ;m10jd=jpnbpos-10  ;m9jd=jpnbpos-9  ;
      m8jd=jpnbpos-8  ;m7jd=jpnbpos-7  ;

      m6jd=jpnbpos-6  ;m5jd=jpnbpos-5  ;m4jd=jpnbpos-4  ;m3jd=jpnbpos-3  ;
      m2jd=jpnbpos-2  ;m1jd=jpnbpos-1  ;m0jd=jpnbpos  ;

      xkm11 =tvals(m11jd ) ;
      xkm10 =tvals(m10jd ) ;       xkm9 = tvals(m9jd ) ;       xkm8 = tvals(m8jd ) ;
      xkm7 = tvals(m7jd ) ;

      xkm6 = tvals(m6jd ) ;       xkm5 = tvals(m5jd ) ;       xkm4 = tvals(m4jd ) ;
      xkm3 = tvals(m3jd ) ;
      xkm2 = tvals(m2jd ) ;       xkm1 = tvals(m1jd ) ;        xk1 =  tvals(m0jd ) ;
      xk2 = tvals(jpnbpos) + c2* h;
      tc=xk1 ;
      xk3 = tvals(jpnbpos) + c3*h;       xk4 = tvals(jpnbpos) + c4*h;

      rra = h/(xk1-xkm1)  ; 

      irr = round( rra*10 ) ; 
      %   solv_irr=irr

      b_v(1)  =cfos4_1(  irr)  ;
      b_v(2)  =cfos4_2(  irr)  ;
      b_v(3)  =cfos4_3(  irr)  ;
      b_v(4)  =cfos4_4(  irr)  ;
      b_v(5)  =cfos4_5(  irr)  ;
      b_v(6)  =cfos4_6(  irr)  ;
      b_v(7)  =cfos4_7(  irr)  ;
      b_v(8)  =cfos4_8(  irr)  ;
      b_v(9)  =cfos4_9(  irr)  ;
      b_v(10) =cfos4_10(  irr)  ;
      b_v(11) =cfos4_11(  irr)  ;
      b_v(12) =cfos4_12(  irr)  ;
      b_v(13) =cfos4_13(  irr)  ;
      b_v(14) =cfos4_14(  irr)  ;
      b_v(15) =cfos4_15(  irr)  ;

      % der1:
      b4   = b_v(1)  ;
      b3   = b_v(2) ;
      b2   = b_v(3)   ;
      b1   = b_v(4)   ; 

      % ( alp(20,2) = acf(20,1 ) = b1 )
      am1201   = b_v(5) ;
      am2201   = b_v(6) ;
      am3201   = b_v(7) ;

      % der2:
      alp203   = b_v(8)   ;
      am1202   = b_v(9) ;
      am2202   = b_v(10) ;
      am3202   = b_v(11) ;

      % der3:
      alp204   = b_v(12)   ;
      am1203   = b_v(13) ;
      am2203   = b_v(14) ;
      am3203   = b_v(15) ;

      %  LP2014   = b_v(15) ;

      Qbv1_7 = [ b_v(1); b_v(2); b_v(3) ; b_v(4) ; b_v(5) ; b_v(6) ; b_v(7)  ] ;
      Qbv8_11= [  b_v(8) ; b_v(9) ; b_v(10) ;  b_v(11)   ] ;
      Qbv12_15= [  b_v(12) ; b_v(13) ; b_v(14) ; b_v(15)  ] ;

      hQbv1_7=h*Qbv1_7  ;
      h2Qbv8_11=h*h*Qbv8_11 ;
      h3Qbv12_15=h*h*h*Qbv12_15  ;

       yk1 = yvals(:, m0jd) ;

       col1_7(:,4) =fvals( :, m0jd);      
       col1_7(:,5) =fvals( :, m1jd);      
       col1_7(:,6) =fvals( :, m2jd);      
       col1_7(:,7) =fvals( :, m3jd);      

       col8_11(:,1) =f2vals(:, m0jd);      
       col8_11(:,2) =f2vals(:, m1jd);      
       col8_11(:,3) =f2vals(:, m2jd);      
       col8_11(:,4) =f2vals(:, m3jd);      

       col12_15(:,1) =f3vals( :, m0jd);      
       col12_15(:,2) =f3vals( :, m1jd);      
       col12_15(:,3) =f3vals( :, m2jd);      
       col12_15(:,4) =f3vals( :, m3jd);      

       % *********** PART 2:   HB12_6d1_6d2prdos1   *********************
       xtab(1) = xk2 ;
        %   solvr_irr=irr

       b_v(2)  =cfos1_1(  irr)  ;
       b_v(3)  =cfos1_2(  irr)  ;
       b_v(4)  =cfos1_3(  irr)  ;
       b_v(5)  =cfos1_4(  irr)  ;
       b_v(6)  =cfos1_5(  irr)  ;
       b_v(7)  =cfos1_6(  irr)  ;
       b_v(8)  =cfos1_7(  irr)  ;
       b_v(9)  =cfos1_8(  irr)  ;
       b_v(10) =cfos1_9(  irr)  ;
       b_v(11) =cfos1_10(  irr)  ;
       b_v(12) =cfos1_11(  irr)  ;
       b_v(13) =cfos1_12(  irr)  ;

       bv1_7 = [0; 0; 0; b_v(2); b_v(3) ; b_v(4) ; b_v(5)];

       bv8_11= [b_v(6); b_v(7) ; b_v(8) ; b_v(9)];

       bv12_15= [b_v(10) ; b_v(11) ; b_v(12) ; b_v(13)];

       hbv1_7 =h*bv1_7 ;
       h2bv8_11=h*h*bv8_11;
       h3bv12_15=h*h*h*bv12_15 ;

       y_jpc2 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15;
       %       step1y_jpc2zero =  y_jpc2 - exp(-(tc+h*c2))

       fnewk2 =  feval(fname, xk2  , y_jpc2);
       col1_7(:,3)=fnewk2 ;

       % ************  PART (Compute 2nd  predictor) ***********
       %      (at point tc + c3*h)

       b_v(1)  =cfos2_1(  irr)  ;
       b_v(2)  =cfos2_2(  irr)  ;
       b_v(3)  =cfos2_3(  irr)  ;
       b_v(4)  =cfos2_4(  irr)  ;
       b_v(5)  =cfos2_5(  irr)  ;
       b_v(6)  =cfos2_6(  irr)  ;
       b_v(7)  =cfos2_7(  irr)  ;
       b_v(8)  =cfos2_8(  irr)  ;
       b_v(9)  =cfos2_9(  irr)  ;
       b_v(10) =cfos2_10(  irr)  ;
       b_v(11) =cfos2_11(  irr)  ;
       b_v(12) =cfos2_12(  irr)  ;
       b_v(13) =cfos2_13(  irr)  ;

       bv1_7 = [ 0; 0 ; b_v(1) ; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5) ] ;
       bv8_11= [   b_v(6) ; b_v(7) ; b_v(8) ; b_v(9) ] ;
       bv12_15= [  b_v(10) ; b_v(11) ; b_v(12) ; b_v(13) ] ;

       hbv1_7 =h*bv1_7 ;
       h2bv8_11=h*h*bv8_11;
       h3bv12_15=h*h*h*bv12_15 ;

       y_jpc3 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15 ;

%       step1y_jpc3zero =  y_jpc3 - exp(-(tc+h*c3))  

       fnewk3 =  feval(fname, xk3  , y_jpc3);
       col1_7(:,2)=fnewk3 ;

       % ************  PART (Compute predictor c4) ***********
       %      (at point tc + c4*h)

       b_v(1)  =cfos3_1(  irr)  ;
       b_v(2)  =cfos3_2(  irr)  ;
       b_v(3)  =cfos3_3(  irr)  ;
       b_v(4)  =cfos3_4(  irr)  ;
       b_v(5)  =cfos3_5(  irr)  ;
       b_v(6)  =cfos3_6(  irr)  ;

       b_v(7)  =cfos3_7(  irr)  ;
       b_v(8)  =cfos3_8(  irr)  ;
       b_v(9)  =cfos3_9(  irr)  ;
       b_v(10) =cfos3_10(  irr)  ;
       b_v(11) =cfos3_11(  irr)  ;
       b_v(12) =cfos3_12(  irr)  ;
       b_v(13) =cfos3_13(  irr)  ;
       b_v(14) =cfos3_14(  irr)  ;

       bv1_7 = [ 0 ; b_v(1) ; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5) ; b_v(6)  ] ;
       bv8_11= [   b_v(7) ; b_v(8) ; b_v(9) ;  b_v(10)   ] ;
       bv12_15= [   b_v(11) ; b_v(12) ; b_v(13)  ; b_v(14)    ] ;

       hbv1_7 =h*bv1_7 ;
       h2bv8_11=h*h*bv8_11;
       h3bv12_15=h*h*h*bv12_15 ;

       y_jpc4 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;
%       step1y_jpc4zero =  y_jpc4 - exp(-(tc+h*c4))  

       fnewk4 =  feval(fname, xk4  , y_jpc4);
       col1_7(:,1)=fnewk4 ;

%  ******** IF *****************************************************
       ynew = yk1 + col1_7*hQbv1_7 +col8_11*h2Qbv8_11 +col12_15*h3Qbv12_15     ;

%        step1ynew_zero =  ynew- exp(-(tc+h))
       tnew = tc + h;

       [ fnew, f2new, f3new ] = feval(fname3 , tnew, ynew) ;  

%  ********  STEP1 ))) *****************

      jpnbposp1=j+nbpos+1;
      tvals(jpnbposp1 ) =  tnew;
      yvals(:,jpnbposp1 ) = ynew; 
      fvals(:,jpnbposp1 )=  fnew ; 
      f2vals(:,jpnbposp1)=  f2new ; 
      f3vals(:,jpnbposp1)=  f3new ; 
      j = j+1 ;

% ***** SUBS 2.A.2 STEP2 : TO ADVANCE INTEGRATION FROM x_{n+1} to x_{n+2} ****

      jpnbpos=j+nbpos;
      m14jd=jpnbpos-14  ;  m13jd=jpnbpos-13  ;  m12jd=jpnbpos-12  ;m11jd=jpnbpos-11 ;m10jd=jpnbpos-10  ;m9jd=jpnbpos-9  ;
      m8jd=jpnbpos-8  ;m7jd=jpnbpos-7  ;

      m6jd=jpnbpos-6  ;m5jd=jpnbpos-5  ;m4jd=jpnbpos-4  ;m3jd=jpnbpos-3  ;
      m2jd=jpnbpos-2  ;m1jd=jpnbpos-1  ;m0jd=jpnbpos  ;

      xkm14 =tvals(m14jd ) ;  xkm13 =tvals(m13jd ) ;  xkm12 =tvals(m12jd ) ;   xkm11 =tvals(m11jd ) ;
      xkm10 =tvals(m10jd ) ;  xkm9 = tvals(m9jd ) ;       xkm8 = tvals(m8jd ) ;    xkm7 = tvals(m7jd ) ;

      xkm6 = tvals(m6jd ) ;  xkm5 = tvals(m5jd ) ;   xkm4 = tvals(m4jd ) ;   xkm3 = tvals(m3jd ) ;
      xkm2 = tvals(m2jd ) ;  xkm1 = tvals(m1jd ) ;      xk1 =  tvals(m0jd ) ;  xk2 = tvals(jpnbpos) + c2* h;
      tc=xk1 ;
      xk3 = tvals(jpnbpos) + c3*h;       xk4 = tvals(jpnbpos) + c4*h;

      xtab(1) = xk3  ;
      xtab(2) = xkm11 ;
      xtab(3) = xkm10 ;
      xtab(4) = xkm9  ;
      xtab(5) = xkm8  ;
      xtab(6) = xkm7  ;
      xtab(7) = xkm6  ;
      xtab(8) = xkm5  ;
      xtab(9) = xkm4  ;
      xtab(10) =xkm3  ;
      xtab(11) =xkm2  ;
      xtab(12) =xkm1  ;
      xtab(13) =xk1   ;
      xtab(14) =xk2   ;
      xtab(15) =xk3   ; 
      xtab(16) =c2    ; 
      xtab(17) =c3    ;

       b_v(1)  =cfos8_1(  irr)  ;
       b_v(2)  =cfos8_2(  irr)  ;
       b_v(3)  =cfos8_3(  irr)  ;
       b_v(4)  =cfos8_4(  irr)  ;
       b_v(5)  =cfos8_5(  irr)  ;
       b_v(6)  =cfos8_6(  irr)  ;
       b_v(7)  =cfos8_7(  irr)  ;
       b_v(8)  =cfos8_8(  irr)  ;
       b_v(9)  =cfos8_9(  irr)  ;
       b_v(10) =cfos8_10(  irr)  ;
       b_v(11) =cfos8_11(  irr)  ;
       b_v(12) =cfos8_12(  irr)  ;
       b_v(13) =cfos8_13(  irr)  ;
       b_v(14) =cfos8_14(  irr)  ;
       b_v(15) =cfos8_15(  irr)  ;

       % der1:
       b4   = b_v(1)  ;
       b3   = b_v(2) ;
       b2   = b_v(3)   ;
       b1   = b_v(4)   ; 

       % ( alp(20,2) = acf(20,1 ) = b1 )
       am1201   = b_v(5) ;
       am2201   = b_v(6) ;
       am3201   = b_v(7) ;

       % der2:
       alp203   = b_v(8)   ;
       am1202   = b_v(9) ;
       am2202   = b_v(10) ;
       am3202   = b_v(11) ;

       % der3:
       alp204   = b_v(12)   ;
       am1203   = b_v(13) ;
       am2203   = b_v(14) ;
       am3203   = b_v(15) ;

       Qbv1_7 = [ b_v(1); b_v(2); b_v(3) ; b_v(4) ; b_v(5) ; b_v(6) ; b_v(7)  ] ;
       Qbv8_11= [  b_v(8) ; b_v(9) ; b_v(10) ;  b_v(11)   ] ;
       Qbv12_15= [  b_v(12) ; b_v(13) ; b_v(14) ; b_v(15)  ] ;

       hQbv1_7=h*Qbv1_7  ;
       h2Qbv8_11=h*h*Qbv8_11 ;
       h3Qbv12_15=h*h*h*Qbv12_15  ;

       yk1 = yvals(:, m0jd) ;

       col1_7(:,4) =fvals( :, m0jd);      
       col1_7(:,5) =fvals( :, m1jd);      
       col1_7(:,6) =fvals( :, m2jd);      
       col1_7(:,7) =fvals( :, m3jd);      

       col8_11(:,1) =f2vals(:, m0jd);      
       col8_11(:,2) =f2vals(:, m1jd);      
       col8_11(:,3) =f2vals(:, m2jd);      
       col8_11(:,4) =f2vals(:, m3jd);      

       col12_15(:,1) =f3vals( :, m0jd);      
       col12_15(:,2) =f3vals( :, m1jd);      
       col12_15(:,3) =f3vals( :, m2jd);      
       col12_15(:,4) =f3vals( :, m3jd);      

% *********** PART 2:   HB12_6d1_6d2prdos1   *********************

%        xtab(1) = xk2 ;

       b_v(2)  =cfos5_1(  irr)  ;
       b_v(3)  =cfos5_2(  irr)  ;
       b_v(4)  =cfos5_3(  irr)  ;
       b_v(5)  =cfos5_4(  irr)  ;

       b_v(6)  =cfos5_5(  irr)  ;
       b_v(7)  =cfos5_6(  irr)  ;
       b_v(8)  =cfos5_7(  irr)  ;
       b_v(9)  =cfos5_8(  irr)  ;
       b_v(10) =cfos5_9(  irr)  ;
       b_v(11) =cfos5_10(  irr)  ;
       b_v(12) =cfos5_11(  irr)  ;
       b_v(13) =cfos5_12(  irr)  ;

       bv1_7 = [ 0; 0; 0; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5)   ] ;

       bv8_11= [  b_v(6) ; b_v(7) ; b_v(8) ; b_v(9)   ] ;

       bv12_15= [  b_v(10) ; b_v(11) ; b_v(12) ; b_v(13)   ] ;

       hbv1_7 =h*bv1_7 ;
       h2bv8_11=h*h*bv8_11;
       h3bv12_15=h*h*h*bv12_15 ;

       y_jpc2 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;

%       step2y_jpc2zero =  y_jpc2 - exp(-(tc+h*c2))  

       fnewk2 =  feval(fname, xk2  , y_jpc2);
       col1_7(:,3)=fnewk2 ;
 
% ************  PART (Compute 2nd of 2 predictors) ***********
%      (at point tc + c3*h)

      b_v(1)  =cfos6_1(  irr)  ;
      b_v(2)  =cfos6_2(  irr)  ;
      b_v(3)  =cfos6_3(  irr)  ;
      b_v(4)  =cfos6_4(  irr)  ;
      b_v(5)  =cfos6_5(  irr)  ;

      b_v(6)  =cfos6_6(  irr)  ;
      b_v(7)  =cfos6_7(  irr)  ;
      b_v(8)  =cfos6_8(  irr)  ;
      b_v(9)  =cfos6_9(  irr)  ;
      b_v(10) =cfos6_10(  irr)  ;
      b_v(11) =cfos6_11(  irr)  ;
      b_v(12) =cfos6_12(  irr)  ;
      b_v(13) =cfos6_13(  irr)  ;

      bv1_7 = [ 0; 0; b_v(1) ; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5)   ] ;
      bv8_11= [   b_v(6) ; b_v(7) ; b_v(8) ; b_v(9)   ] ;
      bv12_15= [  b_v(10) ; b_v(11) ; b_v(12) ; b_v(13)   ] ;

      hbv1_7 =h*bv1_7 ;
      h2bv8_11=h*h*bv8_11;
      h3bv12_15=h*h*h*bv12_15 ;

      y_jpc3 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;

%       step2y_jpc3zero =  y_jpc3 - exp(-(tc+h*c3))  

     fnewk3 =  feval(fname, xk3  , y_jpc3);
     col1_7(:,2)=fnewk3 ;

% ************  PART (Compute 3rd  predictor) ***********
%      (at point tc + c3*h)

      b_v(1)  =cfos7_1(  irr)  ;
      b_v(2)  =cfos7_2(  irr)  ;
      b_v(3)  =cfos7_3(  irr)  ;
      b_v(4)  =cfos7_4(  irr)  ;
      b_v(5)  =cfos7_5(  irr)  ;
      b_v(6)  =cfos7_6(  irr)  ;
      b_v(7)  =cfos7_7(  irr)  ;
      b_v(8)  =cfos7_8(  irr)  ;
      b_v(9)  =cfos7_9(  irr)  ;
      b_v(10) =cfos7_10(  irr)  ;
      b_v(11) =cfos7_11(  irr)  ;
      b_v(12) =cfos7_12(  irr)  ;
      b_v(13) =cfos7_13(  irr)  ;
      b_v(14) =cfos7_14(  irr)  ;

      bv1_7 = [ 0 ; b_v(1) ; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5) ; b_v(6)  ] ;
      bv8_11= [   b_v(7) ; b_v(8) ; b_v(9) ;  b_v(10)   ] ;
      bv12_15= [   b_v(11) ; b_v(12) ; b_v(13)  ; b_v(14)    ] ;

      hbv1_7 =h*bv1_7 ;
      h2bv8_11=h*h*bv8_11;
      h3bv12_15=h*h*h*bv12_15 ;

      y_jpc4 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;

%       step2y_jpc4zero =  y_jpc4 - exp(-(tc+h*c4))  

      fnewk4 =  feval(fname, xk4  , y_jpc4);
      col1_7(:,1)=fnewk4 ;

%  ******** IF *****************************************************

      ynew = yk1 + col1_7*hQbv1_7 +col8_11*h2Qbv8_11 +col12_15*h3Qbv12_15     ;

%        step2ynew_zero =  ynew- exp(-(tc+h))

      tnew = tc + h;

     [ fnew, f2new, f3new ] = feval(fname3 , tnew, ynew) ;  

%  ***************  STEP2 ))) ****

      jpnbposp1=j+nbpos+1;
      tvals(jpnbposp1 ) =  tnew;
      yvals(:,jpnbposp1 ) = ynew; 
      fvals(:,jpnbposp1 )=  fnew ; 
      f2vals(:,jpnbposp1)=  f2new ; 
      f3vals(:,jpnbposp1)=  f3new ; 
      j = j+1 ;

% ***** SUBS 2.A.3 STEP3 : TO ADVANCE INTEGRATION FROM x_{n+2} to x_{n+3} ****

      jpnbpos=j+nbpos;
      m14jd=jpnbpos-14  ;  m13jd=jpnbpos-13  ;  m12jd=jpnbpos-12  ;m11jd=jpnbpos-11 ;m10jd=jpnbpos-10  ;m9jd=jpnbpos-9  ;
      m8jd=jpnbpos-8  ;m7jd=jpnbpos-7  ;

      m6jd=jpnbpos-6  ;m5jd=jpnbpos-5  ;m4jd=jpnbpos-4  ;m3jd=jpnbpos-3  ;
      m2jd=jpnbpos-2  ;m1jd=jpnbpos-1  ;m0jd=jpnbpos  ;

      xkm14 =tvals(m14jd ) ;       xkm13 =tvals(m13jd ) ;       xkm12 =tvals(m12jd ) ;       xkm11 =tvals(m11jd ) ;
      xkm10 =tvals(m10jd ) ;       xkm9 = tvals(m9jd ) ;       xkm8 = tvals(m8jd ) ;       xkm7 = tvals(m7jd ) ;

      xkm6 = tvals(m6jd ) ;       xkm5 = tvals(m5jd ) ;       xkm4 = tvals(m4jd ) ;       xkm3 = tvals(m3jd ) ;
      xkm2 = tvals(m2jd ) ;       xkm1 = tvals(m1jd ) ;        xk1 =  tvals(m0jd ) ;       xk2 = tvals(jpnbpos) + c2* h;
      tc=xk1 ;
      xk3 = tvals(jpnbpos) + c3*h;       xk4 = tvals(jpnbpos) + c4*h;

      b_v(1)  =cfos12_1(  irr)  ;
      b_v(2)  =cfos12_2(  irr)  ;
      b_v(3)  =cfos12_3(  irr)  ;
      b_v(4)  =cfos12_4(  irr)  ;
      b_v(5)  =cfos12_5(  irr)  ;
      b_v(6)  =cfos12_6(  irr)  ;
      b_v(7)  =cfos12_7(  irr)  ;
      b_v(8)  =cfos12_8(  irr)  ;
      b_v(9)  =cfos12_9(  irr)  ;
      b_v(10) =cfos12_10(  irr)  ;
      b_v(11) =cfos12_11(  irr)  ;
      b_v(12) =cfos12_12(  irr)  ;
      b_v(13) =cfos12_13(  irr)  ;
      b_v(14) =cfos12_14(  irr)  ;
      b_v(15) =cfos12_15(  irr)  ;

      % der1:
     b4   = b_v(1)  ;
     b3   = b_v(2) ;
     b2   = b_v(3)   ;
     b1   = b_v(4)   ; 

     % ( alp(20,2) = acf(20,1 ) = b1 )
     am1201   = b_v(5) ;
     am2201   = b_v(6) ;
     am3201   = b_v(7) ;

     % der2:
     alp203   = b_v(8)   ;
     am1202   = b_v(9) ;
     am2202   = b_v(10) ;
     am3202   = b_v(11) ;

   % der3:
     alp204   = b_v(12)   ;
     am1203   = b_v(13) ;
     am2203   = b_v(14) ;
     am3203   = b_v(15) ;

     Qbv1_7 = [ b_v(1); b_v(2); b_v(3) ; b_v(4) ; b_v(5) ; b_v(6) ; b_v(7)  ] ;
     Qbv8_11= [  b_v(8) ; b_v(9) ; b_v(10) ;  b_v(11)   ] ;
     Qbv12_15= [  b_v(12) ; b_v(13) ; b_v(14) ; b_v(15)  ] ;

     hQbv1_7=h*Qbv1_7  ;
     h2Qbv8_11=h*h*Qbv8_11 ;
     h3Qbv12_15=h*h*h*Qbv12_15  ;

     yk1 = yvals(:, m0jd) ;

     col1_7(:,4) =fvals( :, m0jd);      
     col1_7(:,5) =fvals( :, m1jd);      
     col1_7(:,6) =fvals( :, m2jd);      
     col1_7(:,7) =fvals( :, m3jd); 

     col8_11(:,1) =f2vals(:, m0jd);      
     col8_11(:,2) =f2vals(:, m1jd);      
     col8_11(:,3) =f2vals(:, m2jd);      
     col8_11(:,4) =f2vals(:, m3jd);      

     col12_15(:,1) =f3vals( :, m0jd);      
     col12_15(:,2) =f3vals( :, m1jd);      
     col12_15(:,3) =f3vals( :, m2jd);      
     col12_15(:,4) =f3vals( :, m3jd);      

% *********** PART 2:   HB12_6d1_6d2prdos1   *********************

      xtab(1) = xk2 ;

      b_v(2)  =cfos9_1(  irr)  ;
      b_v(3)  =cfos9_2(  irr)  ;
      b_v(4)  =cfos9_3(  irr)  ;
      b_v(5)  =cfos9_4(  irr)  ;
      b_v(6)  =cfos9_5(  irr)  ;
      b_v(7)  =cfos9_6(  irr)  ;
      b_v(8)  =cfos9_7(  irr)  ;
      b_v(9)  =cfos9_8(  irr)  ;
      b_v(10) =cfos9_9(  irr)  ;
      b_v(11) =cfos9_10(  irr)  ;
      b_v(12) =cfos9_11(  irr)  ;
      b_v(13) =cfos9_12(  irr)  ;

      bv1_7 = [ 0; 0; 0; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5)   ] ;
      bv8_11= [  b_v(6) ; b_v(7) ; b_v(8) ; b_v(9)   ] ;
      bv12_15= [  b_v(10) ; b_v(11) ; b_v(12) ; b_v(13)   ] ;

      hbv1_7 =h*bv1_7 ;
      h2bv8_11=h*h*bv8_11;
      h3bv12_15=h*h*h*bv12_15 ;

      y_jpc2 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;

%       step3y_jpc2zero =  y_jpc2 - exp(-(tc+h*c2))  

      fnewk2 =  feval(fname, xk2  , y_jpc2);
      col1_7(:,3)=fnewk2 ;

% ************  PART (Compute 2nd of 2 predictors) ***********
%      (at point tc + c3*h)

      b_v(1)  =cfos10_1(  irr)  ;
      b_v(2)  =cfos10_2(  irr)  ;
      b_v(3)  =cfos10_3(  irr)  ;
      b_v(4)  =cfos10_4(  irr)  ;
      b_v(5)  =cfos10_5(  irr)  ;
      b_v(6)  =cfos10_6(  irr)  ;
      b_v(7)  =cfos10_7(  irr)  ;
      b_v(8)  =cfos10_8(  irr)  ;
      b_v(9)  =cfos10_9(  irr)  ;
      b_v(10) =cfos10_10(  irr)  ;
      b_v(11) =cfos10_11(  irr)  ;
      b_v(12) =cfos10_12(  irr)  ;
      b_v(13) =cfos10_13(  irr)  ;

      bv1_7 = [ 0; 0 ; b_v(1) ; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5)   ] ;
      bv8_11= [   b_v(6) ; b_v(7) ; b_v(8) ; b_v(9)   ] ;
      bv12_15= [  b_v(10) ; b_v(11) ; b_v(12) ; b_v(13)   ] ;

      hbv1_7 =h*bv1_7 ;
      h2bv8_11=h*h*bv8_11;
      h3bv12_15=h*h*h*bv12_15 ;

      y_jpc3 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;

%     step3y_jpc3zero =  y_jpc3 - exp(-(tc+h*c3))  

      fnewk3 =  feval(fname, xk3  , y_jpc3);
      col1_7(:,2)=fnewk3 ;

% ************  PART (Compute 3rd  predictor) ***********
%      (at point tc + c3*h)

      b_v(1)  =cfos11_1(  irr)  ;
      b_v(2)  =cfos11_2(  irr)  ;
      b_v(3)  =cfos11_3(  irr)  ;
      b_v(4)  =cfos11_4(  irr)  ;
      b_v(5)  =cfos11_5(  irr)  ;
      b_v(6)  =cfos11_6(  irr)  ;
      b_v(7)  =cfos11_7(  irr)  ;
      b_v(8)  =cfos11_8(  irr)  ;
      b_v(9)  =cfos11_9(  irr)  ;
      b_v(10) =cfos11_10(  irr)  ;
      b_v(11) =cfos11_11(  irr)  ;
      b_v(12) =cfos11_12(  irr)  ;
      b_v(13) =cfos11_13(  irr)  ;
      b_v(14) =cfos11_14(  irr)  ;

      bv1_7 = [ 0 ; b_v(1) ; b_v(2) ; b_v(3) ; b_v(4) ; b_v(5) ; b_v(6)  ] ;
      bv8_11= [   b_v(7) ; b_v(8) ; b_v(9) ;  b_v(10)   ] ;
      bv12_15= [   b_v(11) ; b_v(12) ; b_v(13)  ; b_v(14)    ] ;

      hbv1_7 =h*bv1_7 ;
      h2bv8_11=h*h*bv8_11;
      h3bv12_15=h*h*h*bv12_15 ;

      y_jpc4 = yk1 + col1_7*hbv1_7 +col8_11*h2bv8_11 +col12_15*h3bv12_15     ;

%     step3y_jpc4zero =  y_jpc4 - exp(-(tc+h*c4))  

      fnewk4 =  feval(fname, xk4  , y_jpc4);
      col1_7(:,1)=fnewk4 ;

%  ******** IF *****************************************************
      ynew = yk1 + col1_7*hQbv1_7 +col8_11*h2Qbv8_11 +col12_15*h3Qbv12_15     ;

%     step3ynew_zero =  ynew- exp(-(tc+h))

%  **************  STEP3 ))) ******************

%      The current quantized stepsizes are used to compute the new error estimate 
%                   "err_est" 

      err_est = 0.0 ;

      b_v(1)  =cfos13_1(  irr)  ;
      b_v(2)  =cfos13_2(  irr)  ;
      b_v(3)  =cfos13_3(  irr)  ;
      b_v(4)  =cfos13_4(  irr)  ;
      b_v(5)  =cfos13_5(  irr)  ;
      b_v(6)  =cfos13_6(  irr)  ;
      b_v(7)  =cfos13_7(  irr)  ;
      b_v(8)  =cfos13_8(  irr)  ;
      b_v(9)  =cfos13_9(  irr)  ;
      b_v(10) =cfos13_10(  irr)  ;
      b_v(11) =cfos13_11(  irr)  ;
      b_v(12) =cfos13_12(  irr)  ;
      b_v(13) =cfos13_13(  irr)  ;
      b_v(14) =cfos13_14(  irr)  ;
      b_v(15) =cfos13_15(  irr)  ;

      SCPbv1_7 = [ b_v(1); b_v(2); b_v(3) ; b_v(4) ; b_v(5) ; b_v(6) ; b_v(7)   ] ;
      SCPbv8_11= [  b_v(8) ; b_v(9) ; b_v(10) ; b_v(11)  ] ;
      SCPbv12_15= [  b_v(12) ; b_v(13) ; b_v(14) ; b_v(15)   ] ;

      hSCPbv1_7=h*SCPbv1_7  ;
      h2SCPbv8_11=h*h*SCPbv8_11 ;
      h3SCPbv12_15=h*h*h*SCPbv12_15  ;

      y_est = yk1 + col1_7*hSCPbv1_7 +col8_11*h2SCPbv8_11 +col12_15*h3SCPbv12_15     ;

      err_est = max( abs(  y_est  - ynew  ) )  ;
      hold=h;

      % check if the current step is OK :
      if err_est >  TOL 
      %  (the computed step (hold) is rejected, compute smaller h )
      %       h =  max(  hold *0.7000, hmin) ;
         stsize =  max(  hold*0.7*stfac *(TOL/err_est)^(1.0/14.0), hmin) ;
         nreje=nreje+3;
         %      fprintf ('HB14_4Estep rej. step err_est= %7.2e,TOL= %7.2e, j= %5.0f, tc= %10.2e, hold= %7.2e, h= %7.2e, date=  %15s \n',err_est, TOL,j, tc, hold, h, datestr(now)) ;

         %  **** SECTION: determ. quant. step size h ***********

         hold=preh ;
         % ( hnew = max ( hnew, 0.5* h )  => )

         if (  ( stsize < hold*0.15 ) ) 
            nstsize = 0.1* hold ; end;

         if ( (hold *0.15 <= stsize) & ( stsize < hold*0.25 ) ) 
              nstsize = 0.2* hold ; end;

         if (  (hold *0.25 <= stsize)& ( stsize < hold*0.35 ) ) 
              nstsize = 0.3* hold ; end;

         if (  (hold *0.35 <= stsize)& ( stsize < hold*0.45 ) ) 
              nstsize = 0.4* hold ; end;

         if (  (hold *0.45 <= stsize)& ( stsize < hold*0.55 ) ) 
              nstsize = 0.5* hold ; end;

         if (  (hold *0.55 <= stsize)& ( stsize < hold*0.65 ) ) 
              nstsize = 0.6* hold ; end;

         if (  (hold *0.65 <= stsize)& ( stsize < hold*0.75 ) ) 
              nstsize = 0.7* hold ; end;

         if (  (hold *0.75 <= stsize)& ( stsize < hold*0.85 ) ) 
              nstsize = 0.8* hold ; end;

         if (  (hold *0.85 <= stsize)& ( stsize < hold* 0.95 ) ) 
              nstsize = 0.9* hold ; end;

         if (  (hold *0.95 <= stsize)& ( stsize < hold* 1.05 ) ) 
              nstsize = 1.0* hold ; end;

         if (  (hold *1.05 <= stsize)& ( stsize < hold* 1.15 ) ) 
              nstsize = 1.1* hold ; end;

         if (  (hold *1.15  <= stsize)& ( stsize < hold *1.250) ) 
              nstsize =  1.2*hold ; end;

         if (  (hold*1.25  <= stsize)& ( stsize < hold *1.40) ) 
              nstsize =  1.3*hold ; end;

         if (  (hold*1.4  <= stsize)& ( stsize < hold *1.60) ) 
              nstsize =  1.5*hold ; end;

         if (  (hold*1.6  <= stsize)& ( stsize < hold *1.80) ) 
              nstsize =  1.7*hold ; end;

         if   (hold *1.80 <= stsize)  
              nstsize = 1.9*  hold ; end;

         %   if (  (hold * 1.9  <= stsize) ) 
         %        nstsize =  2.0 *hold ; end;
  
         h = nstsize;

         % fprintf ('HB14_4E3step h/preh = %7.2e,  err_est= %7.2e,TOL= %7.2e, j= %5.0f, tc= %10.2e, hold= %7.2e, h= %7.2e, date=  %15s \n',h/preh, err_est, TOL,j, tc, hold, h, datestr(now)) ;

         % (import.: j=j-2)
         j=j-2 ;
        end;
        % (end if err_est > TOL) *****************

%        ynew_zero =  ynew- exp(-(tc+h))
  end;
% (--------- end  LOOP REPEAT UNTIL SUCCESS    while ( err_est > TOL ) ----------------

   tnew = tc + h;

   [ fnew, f2new, f3new ] = feval(fname3 , tnew, ynew) ;  

   col1_7(:,1)=fnew ;
        
   err_est = 0.0 ;

   y_est = yk1 + col1_7*hSCPbv1_7 +col8_11*h2SCPbv8_11 +col12_15*h3SCPbv12_15     ;

   err_est = max( abs(  y_est  - ynew  ) )  ;

   ordk=14;

   erk=err_est ;

%  ******* SUBS 2.B STEPSIZE SELECTION: *******

% EX: ordnew=14 <->  (TOL/erk )^(1.0/(14+1) )

%  (step size formula : h =hold, stsize = hnew)   
   if (erk ~= 0.0) 

% ACT    (HB../HB11 step cntrl)
       stsize = h *stfac *(TOL/erk )^(1.0/14.0) ;  
       
      else
      stsize = 2*h ;
      end ;
%  (end of step size formula : h =hold, stsize = hnew)

%  constraints that stsize must satisfy :
%     (a) h( next step) = max (h( next step), hmin, 0.5* h(last step))
%     (b) h( next step) = min (h( next step), hmax, 4 * h(last step))  

   stsize = max ( stsize, 0.1* h ) ;
   stsize = max ( stsize, hmin ) ;
   stsize = min( stsize, hmax) ;
   stsize = min( stsize, 4*h) ;

%  ********(( calc. quant. stzise **********

   if (  ( stsize < h*0.15 ) ) 
        nstsize = 0.1* h ; end;

   if (  (h *0.15 <= stsize)& ( stsize < h*0.25 ) ) 
        nstsize = 0.2* h ; end;

   if (  (h *0.25 <= stsize)& ( stsize < h*0.35 ) ) 
        nstsize = 0.3* h ; end;

   if (  (h *0.35 <= stsize)& ( stsize < h*0.45 ) ) 
        nstsize = 0.4* h ; end;

   if (  (h *0.45 <= stsize)& ( stsize < h*0.55 ) ) 
        nstsize = 0.5* h ; end;

   if (  (h *0.55 <= stsize)& ( stsize < h*0.65 ) ) 
        nstsize = 0.6* h ; end;

   if (  (h *0.65 <= stsize)& ( stsize < h*0.75 ) ) 
        nstsize = 0.7* h ; end;

   if (  (h *0.75 <= stsize)& ( stsize < h*0.85 ) ) 
        nstsize = 0.8* h ; end;

   if (  (h *0.85 <= stsize)& ( stsize < h* 0.95 ) ) 
        nstsize = 0.9* h ; end;

   if (  (h *0.95 <= stsize)& ( stsize < h* 1.05 ) ) 
        nstsize = 1.0* h ; end;

   if (  (h *1.05 <= stsize)& ( stsize < h* 1.15 ) ) 
        nstsize = 1.1* h ; end;

   if (  (h*1.15  <= stsize)& ( stsize < h *1.250) ) 
        nstsize =  1.2*h ; end;

   if (  (h*1.25  <= stsize)& ( stsize < h *1.40) ) 
        nstsize =  1.3*h ; end;

   if (  (h*1.4  <= stsize)& ( stsize < h *1.60) ) 
        nstsize =  1.5*h ; end;

   if (  (h*1.6  <= stsize)& ( stsize < h *1.80) ) 
        nstsize =  1.7*h ; end;

   if  (h *1.80 <= stsize) 
        nstsize = 1.9*  h ; end;  

   stsize = nstsize;

%  ******** calc. quant. stzise )) **********
   tc=tnew;
   yc=ynew ;

   hnew=stsize ;
 
%  (END OF INTEG STEP)

%  (yvals,tvals,.. UPDATE STEP)
   jpnbposp1=j+nbpos+1;
   tvals(jpnbposp1 ) =  tnew;
   yvals(:,jpnbposp1 ) = ynew; 
   fvals(:,jpnbposp1 )=  fnew ; 
   f2vals(:,jpnbposp1)=  f2new ; 
   f3vals(:,jpnbposp1)=  f3new ; 

%   ******* SUBS 2.C INTERPOLATION *******
%      if tc > tend ,  recalculate tc, yc using interpolation

   if( tc > tend)

       if xkm1 > tend
           j=j-2 ;
        else xk1 > tend
           j=j-1 ;               
        end;

       solvr_j=j

       jpnbpos=j+nbpos;

       m14jd=jpnbpos-14  ;  m13jd=jpnbpos-13  ;  m12jd=jpnbpos-12  ;
       m11jd=jpnbpos-11 ;m10jd=jpnbpos-10  ;m9jd=jpnbpos-9  ;
       m8jd=jpnbpos-8  ;m7jd=jpnbpos-7  ;
       m6jd=jpnbpos-6  ;m5jd=jpnbpos-5  ;m4jd=jpnbpos-4  ;m3jd=jpnbpos-3  ;
       m2jd=jpnbpos-2  ;m1jd=jpnbpos-1  ;m0jd=jpnbpos  ;

       xkm14 =tvals(m14jd ) ;       xkm13 =tvals(m13jd ) ;
       xkm12 =tvals(m12jd ) ;       xkm11 =tvals(m11jd ) ;
       xkm10 =tvals(m10jd ) ;       xkm9 = tvals(m9jd ) ;
       xkm8 = tvals(m8jd ) ;       xkm7 = tvals(m7jd ) ;
       xkm6 = tvals(m6jd ) ;       xkm5 = tvals(m5jd ) ;
       xkm4 = tvals(m4jd ) ;       xkm3 = tvals(m3jd ) ;
       xkm2 = tvals(m2jd ) ;       xkm1 = tvals(m1jd ) ;
       xk1 =  tvals(m0jd ) ;       xk2 = tvals(jpnbpos) + c2* h;
       yk1 =  yvals(:, m0jd ) ;
       tc=xk1 ;
       xk3 = tvals(jpnbpos) + c3*h;       xk4 = tvals(jpnbpos) + c4*h;

       xtab(1) = tend  ;
       xtab(2) = xkm11 ;
       xtab(3) = xkm10 ;
       xtab(4) = xkm9  ;
       xtab(5) = xkm8  ;
       xtab(6) = xkm7  ;
       xtab(7) = xkm6  ;
       xtab(8) = xkm5  ;
       xtab(9) = xkm4  ;
       xtab(10) =xkm3  ;
       xtab(11) =xkm2  ;
       xtab(12) =xkm1  ;
       xtab(13) =xk1   ;
       xtab(14) =xk1+h   ;
       % yfvalsNA = -111;

%      calculate y_int at tend using interpolation
        [ b_v  ] = HBO14_d123interp(xtab) ;

       y_int = yk1 + h* [ fvals(:, m0jd+1)  fvals(:, m0jd)  fvals(:, m1jd) fvals(:, m2jd) fvals(:, m3jd) ]* [  b_v(1) ; b_v(2) ; b_v(3) ;  b_v(4) ;    b_v(5)  ]+ h*h* [ f2vals(:, m0jd+1)  f2vals(:, m0jd)  f2vals(:, m1jd) f2vals(:, m2jd) f2vals(:, m3jd) ]* [ b_v(6) ; b_v(7) ; b_v(8) ; b_v(9) ;    b_v(10)  ] + h*h*h* [ f3vals(:, m0jd+1)  f3vals(:, m0jd)  f3vals(:, m1jd) f3vals(:, m2jd)]* [   b_v(11) ; b_v(12) ; b_v(13) ; b_v(14)  ] ;

%        y_int_zero =  y_int- exp(-tend )

       tnew=tend ;
       ynew=y_int ;

       jpnbposp1=j+nbpos+1;
       tvals(jpnbposp1 ) =  tnew;
       yvals(:,jpnbposp1 ) = ynew; 

       end;
%      (end if( tc > tend))

   j = j+1 ;
   prevh = h ;
end
%%%%%%%%%%%% ( END OF MAIN LOOP  1 integration step/ iteration) %%%%%%%%%%%

% print statistics
% with index j-1,  yvals(n+1+nbpos, . )  cont solution
n=j-1;

NFE = nbinitst*8 +(n+1+nreje-nbinitst)*nbeps 

res(1)=NFE;
% nb succes step:
res(2)=n+1 ;
res(3)=nreje ;

HBO14prog_nsuccst=n+1
HBO14prog_nreje=nreje

% res(4)=cput ;


