function [ tvals, yvals, fvals, f2vals,f3vals, res, j, h  ] = fnctn( RELTOL, TOL, fname,fname3, t0, tend, y0 , nbinitst, tvals, yvals, fvals, f2vals, f3vals) ;


% 
% HBO7_4initd123steps,  non-stiff differential equations solver of order 7.
% 			
%  [ tvals, yvals, fvals, f2vals, f3vals, res, j, h  ] = HBO7_4initd123steps( RELTOL, TOL, fname,fname3, t0, tend, y0, nbinitst, tvals, yvals, fvals, f2vals, f3vals) ;

%  integrates the system of differential equations y' = f(t,y) from time t0 
%     and provides four starting values for "HBO14_4E7_4_4_3stqsolvr" with
%     initial conditions y0.
%   Function fname(t,y) must return a column vector
%     corresponding to f(t,y)
%   Function fname3(t,y) must return three column vectors: 
%     (1) a column vector corresponding to f(t,y)
%     (2) a column vector corresponding to f'(t,y)
%     (3) a column vector corresponding to f''(t,y)
% 
%  The formula of one-step "HBO7_4initd123steps"  uses y',  y'' and y''' as in Taylor methods.
%  This formula is obtained by casting Taylor method of order 3 and
%  a 6-stage Runge-Kutta method of order 5 into one form. 
% 
%  Each row in the solution array "yvals', derivatives "fvals","f2vals" and "f3vals"
%   corresponds to a time returned in the column vector "tvals"
%  
% Input parameters to "HBO7_4initd123steps" --
% 
%   RELTOL -- not used in this code
%   TOL -- error tolerance
%   fname -- Function fname(t,y) must return a column vector
%        corresponding to f(t,y)
%   fname3 -- Function fname3(t,y) must return three column vectors: 
%       (1) a column vector corresponding to f(t,y)
%       (2) a column vector corresponding to f'(t,y)
%       (3) a column vector corresponding to f''(t,y)
%   t0 -- starting integration time
%   tend -- final integration time
%   y0 -- vector of initial conditions 
% 
% Output parameters from "HBO7_4initd123steps"  --
% 
%   tvals -- independent variable
%   yvals -- solution array
%   fvals -- first derivative of solution array "yvals'
%   f2vals -- second derivative of solution array "yvals'
%   f3vals -- third derivative of solution array "yvals'
%   res
% 	res(1) -- number of function evaluations ;
% 	res(2) -- number of success steps   ;
% 	res(3) -- number of failed attempts  ;
% 

format long e



%------- PARAM: -------
%   ode45 hmin:  eps = 2.220446049250313e-16
 eps = 2.220446049250313e-16 ;
 hmax = 0.1*abs(tend-t0)  ; 
 stfac=0.9 ;

 nbeps=6+2  ;
 hmin = 16*eps ;

%------- END PARAM ----



 nbcmp=size(y0,1);

 nbpos=10;

TOL111=TOL/500

tc = t0;
yc =y0;

[f0, f20, f30  ] = feval(fname3, tc,yc) ;

fc=f0;
f2c=f20;
f3c=f30;




% first guess for step size:
  sc = norm(y0)*RELTOL+ TOL111 ;  

% orig  sc = norm(y0)*RELTOL+ TOL ;  

%%%  d0 =p168norm(y0) = norm(y0)/(sqrt(nbcmp)*sc)
  d0 = norm(y0)/(sqrt(nbcmp)*sc) ; 

%   d0 = norm(y0); 

%%%%  d1 = norm(fc)/(sqrt(nbcmp)*sc)
 d1 = norm(fc)/(sqrt(nbcmp)*sc) ;

  h0=0.01*(d0/d1) ;
  if (d0 < 0.00001)||(d1 < 0.00001)
    h0= 1e-6;
    end;
%   (if (d0 < 0.00001)||(d1 < 0.00001) )
% perform one expl. Euler step
  y1=y0+h0*(fc );
  fc1 = feval(fname, tc+h0,y1) ;

% compute d2 = p168norm(fc1-fc)/h0
  d2 = (norm(fc1-fc)/(sqrt(nbcmp)*sc))/h0 ;

% e) p169: (order p=5)
  h1=(0.01/max(d1,d2))^(1/6) ;

  if (max(d1,d2) <= 10^(-15) )
     h1=max(10^(-6), h0*10^(-3));
     end;

  h=min(100*h0, h1) ;
  p169h=h


% ----------------------------


  k=1111 ;




iter=0;

erk=1111 ;

% ****** iteration until abs(erk) .le. TOL111 *********************
while  abs(erk) > TOL111

%         temp:for idx=1:4
%  TOL/1000

   hold=h;

  j=0 ;
  jpnbpos=j+nbpos;
  tvals(jpnbpos ) =  t0;
  yvals(:,jpnbpos) = y0; 
  fvals(:,jpnbpos) = f0;
  f2vals(:,jpnbpos)= f20;
  f3vals(:,jpnbpos)= f30;
  tc=t0 ;
  yc =y0;
  fc=f0;


%    HBO7initsteph1=h 
    iter=iter+1 ;

%    HBO7initsteperk=erk

% ---------------------------------------


j=0 ;
nreje=0;

% hnew = h ;
cnsth=h ;


% init param:

 pow = 1/6;

% -------- HBO7 --------------

% #### DP5 c(i): #########
 c1 = 0 ;  c2 =     1.0/5.0 ;
 c3 =     3.000000000000000e-01 ; c4 =     8.000000000000000e-01 ;
 c5 =     8.888888888888888e-01 ; c6 = 1.0 ; c7 = 1.0 ;


% A: c_i
 A = [1/5; 3.0e-01; 8.0e-01 ; 8/9  ;  1.0];



% E = coeffs(IF y) - coeffs(SCP y)

 Ebv1_6 = [ 3062780599/29816473381-581429233/7480971313 ;  -1533181/7306695+9222278/50999049  ;  605283937/1107746875-4539313/7992920 ; 41554493/75355849-3692668/11716025  ; 0 ;  720961/77876101-14791056/67227925 ] ; 
 Ebv7   = [-27007585/1439293967-1563392/45805487 ] ;
 Ebv8   = [ -67337485/46017752461-1015453/304980503 ];


% *** B *****************
% HBO7
% c2    c3       c4             c5                    c6                    IF
B=[
   0     0        0              0                     0                3062780599/29816473381
   0     0        0              0              -9749783/42956078       -1533181/7306695
   0     0        0         -7617722/20101141   3327355531/11484129947   605283937/1107746875 
   0     0     16384/2025    57594571/1807044    86767468/3359647        41554493/75355849 
   0    81/320  -1088/75     -26032617/407999     -34264951556/628358387            0
  1/5   3/64   14612/2025   150112116/4521287    83898588/2830417        720961/77876101  ];
bv7= [ 1/50  ;  -9/1600 ;  536/675 ;  14035033/3600870 ;  28792462/7935665 ;   -27007585/1439293967 ];
bv8= [ 1/750 ;  -9/16000 ; 64/5625 ;  4635333/57807374 ;  11257698/122298911 ; -67337485/46017752461    ];


 col1_6 = zeros(nbcmp,6);
 col7   = zeros(nbcmp,1);



% ----- cputime ------------------------------
 scput= cputime;


% ( MAIN LOOP  1 integration step/ iteration)


 while  j  < nbinitst


  if j >= 1000000

% ---- cputime -----------
      cput = cputime- scput  

      
    h =h
    tc =tvals(j+nbpos)
    j = j

    options = odeset('RelTol',5e-14,'AbsTol',[5e-14  ] , 'Stats',[ 'off' ]);

    [ t, ode45y, o3 ] = ode45(fname, [0 tc], y0,options) ;
    n____aft_integ_yval1_zero =  yvals(:,j+nbpos) - ode45y( size(ode45y,1) ,:)'

    NBSTEPS = j



%    MAXGE=MAXGE
      return
      end;

%     h=hnew;
     h=cnsth ;
%     HBO7init_h=h


   if((tc+h) > tend)
       h=tend-tc ;
       end;
%  (MAIN INTEG STEP)

    t=tc;
    xk1=tc ;
    jpnbpos=j+nbpos;
    col1_6(:,6) =fvals( :,jpnbpos);      
    col7(:,1)  =f2vals( :,jpnbpos );      
    col8(:,1)  =f3vals( :,jpnbpos );      



     hB=h*B   ;
     h2=h*h ;
     h3=h2*h;
     h2bv7=h2*bv7 ;
     h3bv8=h3*bv8 ;


     hA = h * A;
     hB = h * B;

%     step_y=y

%    yc2
    col1_6(:,5) = feval(fname,t+hA(1), yc + col1_6*hB(:,1) + col7*h2bv7(1)+ col8*h3bv8(1)  );
 
%    yc3
    col1_6(:,4) = feval(fname,t+hA(2), yc + col1_6*hB(:,2) + col7*h2bv7(2)+ col8*h3bv8(2)  );
 
%    yc4
    col1_6(:,3) = feval(fname,t+hA(3), yc + col1_6*hB(:,3) + col7*h2bv7(3)+ col8*h3bv8(3)  );

%    yc5
    col1_6(:,2) = feval(fname,t+hA(4), yc + col1_6*hB(:,4) + col7*h2bv7(4)+ col8*h3bv8(4)  );

%    yc6
    col1_6(:,1) = feval(fname,t+hA(5), yc + col1_6*hB(:,5) + col7*h2bv7(5)+ col8*h3bv8(5)  );

    ynew = yc  + col1_6*hB(:,6) + col7*h2bv7(6)+ col8*h3bv8(6) ;


    tnew = tc + h ;


    [fnew, f2new, f3new] = feval(fname3, tnew, ynew) ;
    col1_6(:,1)=fnew ;

%   import: (ode45)  {col1_6(:,1)=fnew} -> erk =..
    erk = max(abs(h* col1_6 * Ebv1_6 + h2 *col7 * Ebv7+ h3 *col8 * Ebv8   ))   ;




  tc=tnew;
  yc=ynew ;
  jpnbposp1=j+nbpos+1;

% fvals(:,jpnbposp1 ) = fnew vect : nbcmp X 1
% f2vals(:,jpnbposp1) = f2new vect : nbcmp X 1

  fvals(:,jpnbposp1 )= fnew; 
  f2vals(:,jpnbposp1 )= f2new; 
  f3vals(:,jpnbposp1 )= f3new; 



%  -----(END OF INTEG STEP) --------------------


%  (yvals,tvals,.. UPDATE STEP)

   tvals(jpnbposp1 ) =  tc;
   yvals(:,jpnbposp1 ) =  yc; 


   prevh = h ;
   j = j+1 ;



end
% ( END OF MAIN LOOP  1 integration step/ iteration) -------------





  if abs(erk) > TOL111

%      fprintf ('HBO7_6Estep rej. step err_est= %7.2e,TOL= %7.2e, j= %5.0f, tc= %10.2e, hold= %7.2e, h= %7.2e, date=  %15s \n',erk, TOL111,j, tc, hold, h, datestr(now)) ;


      %     ******* (( PART :  STEP SIZE ********************
      %     ode45 hmin:  eps = 2.220446049250313e-16
      %      eps = 2.220446049250313e-16 ;
      %    hmin = 16*eps*abs(tc);    stephmin2=hmin


      %  (step size formula : h =hold, stsize = hnew)   
         if (erk ~= 0.0) 

      % ACT    (HB../HB11 step cntrl)
            stsize = h *0.7*stfac *(TOL111/erk )^pow  ;  
       
            else
            stsize = 2*h ;
            end ;
      %  (end of step size formula : h =hold, stsize = hnew)

      %  constraints that stsize must satisfy :
      %     (a) h( next step) = max (h( next step), hmin, 0.5* h(last step))
      %     (b) h( next step) = min (h( next step), hmax, 4 * h(last step))


         stsize = max ( stsize, 0.5* h ) ;
         stsize = max ( stsize, hmin ) ;
         stsize = min( stsize, hmax) ;
         stsize = min( stsize, 4*h) ;



        h=stsize ;

      %  ******* PART :  STEP SIZE )) ********************


      end;
%     (if abs(erk) > TOL111)


 end;
% (end while  abs(erk) > TOL111) **********************************************************************************





% ---- cputime -------------------------------
%      cput = cputime- scput  



% print out statistics
% with index j-1,  yvals(n+1+nbpos, . )  cont solution
n=j-1;
nb_f_eval=(n+1+nreje)*nbeps ;



NFE=nb_f_eval;



res(1)=NFE;
% nb succes step:
res(2)=n+1 ;
res(3)=nreje ;


%HBO7step_nstep=res(2)
%HBO7step_nNFE=res(1)
%HBO7step_TOL=TOL

% return




