function [parout] = fnctn(xtab) ;


% ******* Table of sections and subsections of "HBO14_d123interp.m" ***************
% 
% SECTION 1. INITIALIZATION
% SECTION 2. PERFORM THE RESOLUTION OF VANDERMONDE TYPE SYSTEM : 
%     STEP(1): Iteration to overwrite b_v2 
%              with  lop(4,.),lop(5,.),...,lop(13,.)*b_v2
%              (for matrix operations b_v2=l13*l12*...*l5*l4*b_v2)
%     STEP (2): Iteration overwrite b_v2 
%        with  U(3,.),U(4,.),...,U(13,.)*invdiag()* b_v2
%        (for matrix operations b_v2() = U3*U4*... *U12*U13*invdiag()*b_v2() )
%     STEP (3): Operations to overwrite b_v2 
%           with  U(2,.)* b_v2
%        (for matrix operations b_v2() = U2*b_v2() )
%     STEP (4): Operations to overwrite b_v2 
%           with  U(1,.)* b_v2
%        (for matrix operations b_v2() = U1*b_v2() )
%     STEP (5): OUTPUT 


format long e

%%%%%%%%%%% SECTION 1. INITIALIZATION %%%%%%%%%%%

       x = xtab(1);
       xkm11= xtab(2);
       xkm10= xtab(3);
       xkm9 = xtab(4);
       xkm8 = xtab(5);
       xkm7 = xtab(6);
       xkm6 = xtab(7);
       xkm5 = xtab(8);
       xkm4 = xtab(9);
       xkm3 = xtab(10);
       xkm2 = xtab(11);
       xkm1 = xtab(12);
       xk1  = xtab(13);
       xkp1  = xtab(14);

       hl = (xkp1-xk1);

       hm11= (xkm11-xk1)/hl;
       hm10= (xkm10-xk1)/hl;
       hm9 = (xkm9-xk1)/hl;
       hm8 = (xkm8-xk1)/hl;
       hm7 = (xkm7-xk1)/hl;
       hm6 = (xkm6-xk1)/hl;
       hm5 = (xkm5-xk1)/hl;
       hm4 = (xkm4-xk1)/hl;   hm3 = (xkm3-xk1)/hl;
       hm2 = (xkm2-xk1)/hl;   hm1 = (xkm1-xk1)/hl;
       hp1 = (xkp1-xk1)/hl;
       hin = (x-xk1)/hl;
   
       ft2=2;
       ft3= 6;
       ft4 =    24;
       ft5 =   120;
       ft6 =   720;
       ft7 =    5040;
       ft8 =    40320;
       ft9 =    362880;
       ft10 =  3628800;
       ft11 =  39916800;
       ft12 =  479001600;
       ft13 =  6.227020800000000e+09;
       ft14 =  8.717829120000000e+10;
       ft15 =  1.307674368000000e+12;
       ft16 =  2.092278988800000e+13;
       ft17 =  3.556874280960000e+14;     

        c2 =    6.666666666666666e-01;
        c22 =     2.222222222222222e-01;
        c23 =     4.938271604938271e-02;
        c24 =     8.230452674897118e-03;
        c25 =     1.097393689986282e-03;
        c26 =     1.219326322206980e-04;
        c27 =     1.161263164006648e-05;
        c28 =     9.677193033388730e-07;
        c29 =     7.168291135843504e-08;
        c210 =     4.778860757229003e-09;
        c211 =     2.896279246805456e-10;
        c212 =     1.609044026003031e-11;
        c213 =     8.251507825656569e-13;
        c214 =     3.929289440788842e-14;
        c215 =     1.746350862572819e-15;


       hin2= hin*hin/2;
       hin3= hin2 *hin/3;
       hin4= hin3 *hin/4;
       hin5= hin4 *hin/5;
       hin6= hin5 *hin/6;
       hin7= hin6 *hin/7;
       hin8= hin7 *hin/8;
       hin9= hin8 *hin/9;
       hin10=hin9 *hin/10;
       hin11=hin10*hin/11;
       hin12=hin11*hin/12;
       hin13=hin12*hin/13;
       hin14=hin13*hin/14;
       hin15=hin14*hin/15;
       hin16=hin15*hin/16;

       hp12= hp1*hp1/2;
       hp13= hp12 *hp1/3;
       hp14= hp13 *hp1/4;
       hp15= hp14 *hp1/5;
       hp16= hp15 *hp1/6;
       hp17= hp16 *hp1/7;
       hp18= hp17 *hp1/8;
       hp19= hp18 *hp1/9;
       hp110=hp19 *hp1/10;
       hp111=hp110*hp1/11;
       hp112=hp111*hp1/12;
       hp113=hp112*hp1/13;
       hp114=hp113*hp1/14;
       hp115=hp114*hp1/15;
       hp116=hp115*hp1/16;

       hm12= hm1*hm1/2;
       hm13= hm12 *hm1/3;
       hm14= hm13 *hm1/4;
       hm15= hm14 *hm1/5;
       hm16= hm15 *hm1/6;
       hm17= hm16 *hm1/7;
       hm18= hm17 *hm1/8;
       hm19= hm18 *hm1/9;
       hm110=hm19 *hm1/10;
       hm111=hm110*hm1/11;
       hm112=hm111*hm1/12;
       hm113=hm112*hm1/13;
       hm114=hm113*hm1/14;
       hm115=hm114*hm1/15;
       hm116=hm115*hm1/16;
    
       hm22= hm2*hm2/2;
       hm23= hm22 *hm2/3;
       hm24= hm23 *hm2/4;
       hm25= hm24 *hm2/5;
       hm26= hm25 *hm2/6;
       hm27= hm26 *hm2/7;
       hm28= hm27 *hm2/8;
       hm29= hm28 *hm2/9;
       hm210=hm29 *hm2/10;
       hm211=hm210*hm2/11;
       hm212=hm211*hm2/12;
       hm213=hm212*hm2/13;
       hm214=hm213*hm2/14;
       hm215=hm214*hm2/15;
       hm216=hm215*hm2/16;

       hm32= hm3*hm3/2;
       hm33= hm32 *hm3/3;
       hm34= hm33 *hm3/4;
       hm35= hm34 *hm3/5;
       hm36= hm35 *hm3/6;
       hm37= hm36 *hm3/7;
       hm38= hm37 *hm3/8;
       hm39= hm38 *hm3/9;
       hm310=hm39 *hm3/10;
       hm311=hm310*hm3/11;
       hm312=hm311*hm3/12;
       hm313=hm312*hm3/13;
       hm314=hm313*hm3/14;
       hm315=hm314*hm3/15;
       hm316=hm315*hm3/16;

       hm42= hm4*hm4/2;
       hm43= hm42 *hm4/3;
       hm44= hm43 *hm4/4;
       hm45= hm44 *hm4/5;
       hm46= hm45 *hm4/6;
       hm47= hm46 *hm4/7;
       hm48= hm47 *hm4/8;
       hm49= hm48 *hm4/9;
       hm410=hm49 *hm4/10;
       hm411=hm410*hm4/11;
       hm412=hm411*hm4/12;
       hm413=hm412*hm4/13;
       hm414=hm413*hm4/14;  
       hm415=hm414*hm4/15;  
       hm416=hm415*hm4/16;  

       hm52= hm5*hm5/2;
       hm53= hm52 *hm5/3;
       hm54= hm53 *hm5/4;
       hm55= hm54 *hm5/5;
       hm56= hm55 *hm5/6;
       hm57= hm56 *hm5/7;
       hm58= hm57 *hm5/8;
       hm59= hm58 *hm5/9;
       hm510=hm59 *hm5/10;
       hm511=hm510*hm5/11;
       hm512=hm511*hm5/12;
       hm513=hm512*hm5/13;
       hm514=hm513*hm5/14;
       hm515=hm514*hm5/15;
       hm516=hm515*hm5/16;
      
       n=14;

       RHS=[hin; hin2; hin3; hin4; hin5; hin6; hin7; hin8; hin9; hin10; hin11; hin12; hin13; hin14];

       invdiag(1:n)=1;

       A_MAT2col(4) =hp1;
       A_MAT2col(5) =hp1;
       A_MAT2col(6) =hp1;
       A_MAT2col(7) =hm1;
       A_MAT2col(8) =hm1;
       A_MAT2col(9) =hm1;
       A_MAT2col(10)=hm2;
       A_MAT2col(11)=hm2;
       A_MAT2col(12)=hm2;
       A_MAT2col(13)=hm3;
       A_MAT2col(14)=hm3;

       for idx=5:n
         multip =-A_MAT2col(idx-1)/(idx-1);
         invdiag(idx)= invdiag(idx-1)*multip; 
       end;
       % (end for idx=4:n-1)

       lop(4,5) = -4/hp1;
       lop(4,6) = -5/hp1;
       lop(4,7) = -6/hp1;
       lop(4,8) = -7/hp1;
       lop(4,9) = -8/hp1;
       lop(4,10)= -9/hp1;
       lop(4,11)= -10/hp1;
       lop(4,12)= -11/hp1;
       lop(4,13)= -12/hp1;
       lop(4,14)= -13/hp1;

       lop(5,6) = -4/hp1;
       lop(5,7) = -5/hp1;
       lop(5,8) = -6/hp1;
       lop(5,9) = -7/hp1;
       lop(5,10)= -8/hp1;
       lop(5,11)= -9/hp1;
       lop(5,12)= -10/hp1;
       lop(5,13)= -11/hp1;
       lop(5,14)= -12/hp1;

       lop(6,7) = -4/hp1;
       lop(6,8) = -5/hp1;
       lop(6,9) = -6/hp1;
       lop(6,10)= -7/hp1;
       lop(6,11)= -8/hp1;
       lop(6,12)= -9/hp1;
       lop(6,13)= -10/hp1;
       lop(6,14)= -11/hp1;

       lop(7,8) = -4/hm1;
       lop(7,9) = -5/hm1;
       lop(7,10)= -6/hm1;
       lop(7,11)= -7/hm1;
       lop(7,12)= -8/hm1;
       lop(7,13)= -9/hm1;
       lop(7,14)= -10/hm1;

       lop(8,9) = -4/hm1;
       lop(8,10)= -5/hm1;
       lop(8,11)= -6/hm1;
       lop(8,12)= -7/hm1;
       lop(8,13)= -8/hm1;
       lop(8,14)= -9/hm1;

       lop(9,10)= -4/hm1;
       lop(9,11)= -5/hm1;
       lop(9,12)= -6/hm1;
       lop(9,13)= -7/hm1;
       lop(9,14)= -8/hm1;

       lop(10,11)= -4/hm2;
       lop(10,12)= -5/hm2;
       lop(10,13)= -6/hm2;
       lop(10,14)= -7/hm2;

       lop(11,12)= -4/hm2;
       lop(11,13)= -5/hm2;
       lop(11,14)= -6/hm2;

       lop(12,13)= -4/hm2;
       lop(12,14)= -5/hm2;

       lop(13,14)= -4/hm3;



     % ----- U oper. ------------

     U(1,4) =  1/hp1;
     U(1,7) =  1/(hm1-hp1);
     U(1,10)=1/(hm2-hm1);
     U(1,13)=1/(hm3-hm2);

     U(2,4)=  2/hp1;
     U(2,5)=  2/(hp1);
     U(2,7)=  2/(hm1-hp1);
     U(2,8)=  2/(hm1-hp1);
     U(2,10)=2/(hm2-hm1);
     U(2,11)=2/(hm2-hm1);
     U(2,13)=2/(hm3-hm2);
     U(2,14)=2/(hm3-hm2);

     U(3,4)=  3/hp1;
     U(3,5)=  3/hp1;
     U(3,6)=  3/hp1;
     U(3,7)=  3/(hm1-hp1);
     U(3,8)=  3/(hm1-hp1);
     U(3,9)=  3/(hm1-hp1);
     U(3,10)=3/(hm2-hm1);
     U(3,11)=3/(hm2-hm1);
     U(3,12)=3/(hm2-hm1);
     U(3,13)=3/(hm3-hm2);
     U(3,14)=3/(hm3-hm2);

     U(4,5)=  4/hp1;
     U(4,6)=  4/hp1;
     U(4,7)=  4/hm1;
     U(4,8)=  4/(hm1-hp1);
     U(4,9)=  4/(hm1-hp1);
     U(4,10)=4/(hm2-hp1);
     U(4,11)=4/(hm2-hm1);
     U(4,12)=4/(hm2-hm1);
     U(4,13)=4/(hm3-hm1);
     U(4,14)=4/(hm3-hm2);

     U(5,6)=  5/hp1;
     U(5,7)=  5/hm1;
     U(5,8)=  5/hm1;
     U(5,9)=  5/(hm1-hp1);
     U(5,10)=5/(hm2-hp1);
     U(5,11)=5/(hm2-hp1);
     U(5,12)=5/(hm2-hm1);
     U(5,13)=5/(hm3-hm1);
     U(5,14)=5/(hm3-hm1);
     
     U(6,7)=  6/hm1;
     U(6,8)=  6/hm1;
     U(6,9)=  6/hm1;
     U(6,10)=6/(hm2-hp1);
     U(6,11)=6/(hm2-hp1);
     U(6,12)=6/(hm2-hp1);
     U(6,13)=6/(hm3-hm1);
     U(6,14)=6/(hm3-hm1);
     
     U(7,8)=  7/hm1;
     U(7,9)=  7/hm1;
     U(7,10)=7/hm2;
     U(7,11)=7/(hm2-hp1);
     U(7,12)=7/(hm2-hp1);
     U(7,13)=7/(hm3-hp1);
     U(7,14)=7/(hm3-hm1);

     U(8,9)=  8/hm1;
     U(8,10)=8/hm2;
     U(8,11)=8/hm2;
     U(8,12)=8/(hm2-hp1);
     U(8,13)=8/(hm3-hp1);
     U(8,14)=8/(hm3-hp1);

     U(9,10)=9/hm2;
     U(9,11)=9/hm2;
     U(9,12)=9/hm2;
     U(9,13)=9/(hm3-hp1);
     U(9,14)=9/(hm3-hp1);

     U(10,11)=10/hm2;
     U(10,12)=10/hm2;
     U(10,13)=10/hm3;
     U(10,14)=10/(hm3-hp1);

     U(11,12)=11/hm2;
     U(11,13)=11/hm3;
     U(11,14)=11/hm3;

     U(12,13)=12/hm3;
     U(12,14)=12/hm3;

     U(13,14)=13/hm3;

% %%%%%%%%%%% SECTION 2. PERFORM THE RESOLUTION OF VANDERMONDE TYPE SYSTEM : %%%%%
%                        (FIND b_v2())
   b_v2=RHS;

% ***** STEP(1): The following iteration overwrite b_v2 *************
%        with  lop(4,.),lop(5,.),...,lop(13,.)*b_v2
%
%        (corresponding matrix operations:
%              b_v2=l13*l12*...*l5*l4*b_v2)

   for k=4:n-1
      for idx=n:-1:k+1
        b_v2( idx)=b_v2( idx-1)+lop(k,idx)*b_v2( idx);
      end;
   end;
   %%  (end for k=..:n-1)

% ***** STEP (2): The following iteration overwrite b_v2 ***************
%        with  U(3,.),U(4,.),...,U(13,.)*invdiag()* b_v2
%
%        ( corresponding to matrix operations
%          b_v2() = U3*U4*... *U12*U13*invdiag()*b_v2() )
   
   for k=1:n
     b_v2(k)= invdiag(k)* b_v2(k);
   end;
   %%% (end for k=n-1:-1:1)

   % ACT for k=n-1:-1:3
   for k=n-1:-1:3
      for idx=k+1:n
         b_v2(idx)= U(k, idx) *b_v2(idx);
      end;
      % (end for idx=k+1:n)

      for idx=k:n-1
         b_v2(idx)= b_v2( idx)-b_v2( idx+1);
      end;
      % (end for i=k:n-1)
   end;
   %(end for k=n-1:-1:3)

% ***** STEP (3): The following operations overwrite b_v2 *************
%           with  U(2,.)* b_v2

   b_v2(4)= U(2,4)* b_v2(4);
   b_v2(5)= U(2,5)* b_v2(5);
   b_v2(7)= U(2,7)* b_v2(7);
   b_v2(8)= U(2,8)* b_v2(8);
   b_v2(10)=U(2,10)*b_v2(10);
   b_v2(11)=U(2,11)*b_v2(11);
   b_v2(13)=U(2,13)*b_v2(13);
   b_v2(14)=U(2,14)*b_v2(14);

   b_v2(2)= b_v2( 2)-b_v2( 4);
   b_v2(4)= b_v2( 4)-b_v2( 5);
   b_v2(5)= b_v2( 5)-b_v2( 7);
   b_v2(7)= b_v2( 7)-b_v2( 8);
   b_v2(8)= b_v2( 8)-b_v2(10);
   b_v2(10)=b_v2(10)-b_v2(11);
   b_v2(11)=b_v2(11)-b_v2(13);
   b_v2(13)=b_v2(13)-b_v2(14);

% ***** STEP (4): The following iteration overwrites b_v2 *************
%           with  U(1,.)* b_v2

   for idx=4:3:n-1
      b_v2(idx)= U(1, idx) *b_v2(idx);
   end;
   % (end for i=k+1:n)

   for idx=1:3:n-4
      b_v2(idx)= b_v2( idx)-b_v2( idx+3);
   end;
% (end for i=k:n-1)

% ***** STEP (5): OUTPUT  *************

   b_v(1)=b_v2(4);
   b_v(2)=b_v2(1);
   b_v(3)=b_v2(7);
   b_v(4)=b_v2(10);
   b_v(5)=b_v2(13);
   b_v(6)=b_v2(5);
   b_v(7)=b_v2(2);
   b_v(8)=b_v2(8);
   b_v(9)=b_v2(11);
   b_v(10)=b_v2(14);
   b_v(11)=b_v2(6);
   b_v(12)=b_v2(3);
   b_v(13)=b_v2(9);
   b_v(14)=b_v2(12);

   parout(1:n)=b_v(1:n );
                    
