
% Test out: HBOQ144solvr solves Kepler's problem with eccentricity = 0.999999

%   1. Initialisation
%      - set  initial t0=0;
%             initial y0 = [ (1-epsv);    0 ;   0 ;   sqrt((1+epsv)/(1-epsv)) ] 
%                where epsv=0.999999 ;
%             integration final time "tend"
%                (test for var. step)  ecc near 1 and long term integ. : t0 =0  to  tend=200* 2*pi
%
%   2. Perform the integration : call  "HBOQ144solvr"
%   3. Output
%       write on file "HBd123RKMaxGE.txt" the following informations:
%         - CPU time, number of steps, number of function evaluations, 
%           Max. global error, Max. energy error and Max. angular momentum error
%
% INITIALIZATION :
clear all
format long e

  fid = fopen('HBd123RKMaxGE.txt','a');
  fname = 'PrbD1' ;
  fname3 = 'PrbD1d1_d3outp' ;
  tend=10*pi
%  (test for var. step) with ecc. near 1 and long term integ. :  tend=200* 2*pi
   fprintf (fid,' HB_d123  METHOD prb %15s, %15s,  %15s tend= %7.2e\n', fname,fname3,datestr(now), tend) ;

RELTOL = 5e-14

% PART: det set of TOL 
mxnbt = 20 ;
for itol=1:mxnbt
   TOLT(itol) = 10^(-itol) ;
end;
%  end (for itol=1:mxnbt)
% end  PART : det set of TOL

nbcmp=4;
q= 1;

nbpos = 10;
%  Problem D1 : epsv = 0.1
%  Problem D2 : epsv = 0.3
%  Problem D3 : epsv = 0.5
%  Problem D4 : epsv = 0.7
%  Problem D5 : epsv = 0.9
epsv=0.999999 ;

% start insert
ipb = 5+2  ;

% (epsv=0.999999 ; max of itmax = 9)
itmin =9 ; itmax = 9 ;
% MAIN LOOP  TOL = 1e-1, 1e-2,.., 1e-9  (1 TOL/ iteration) --------------------
for itol=itmin:itmax

TOL = 1* TOLT(itol);
% end insert

t0=0;
y0 = [ (1-epsv);    0 ;   0 ;   sqrt((1+epsv)/(1-epsv)) ] 

RELTOL=5e-14

% ---- cputime ---------------
   scput =cputime ;

 [tvals, yvals, fvals, f2vals, f3vals, res] = HBOQ144solvr(RELTOL, TOL, fname, fname3, t0, tend, y0) ;

% ---- cputime ---------------
      cput = cputime- scput  

% print out statistics
% with index j-1,  yvals(n+1+nbpos, . )  cont solution

NFE = res(1)
% nb succes step:
n=res(2)-1 
nreje=res(3) 
% cput=res(4) 

% MAX GE CALCUL: -------
  options = odeset('RelTol',5e-14,'AbsTol',[ 5e-14  ] , 'Stats',[ 'off' ]);

MAXGE = -9999;
t2 = t0; y2= y0 ;

 sizey1 =n+nbpos+1   ;
 tvalssizey1tendzero = tvals(sizey1)-tend
 if tvals(sizey1) ~= tend
    tvalssizey1netend = tvals(sizey1)
    end;

% Initial energy value:
ham0 = 0.5D0*(y0(3)*y0(3) + y0(4)*y0(4))   - 1.D0/sqrt(y0(1)*y0(1) + y0(2)*y0(2))
me = 0 ;
mxame = 0.0 ;
% init angular momentum value:
% (dy1/dt)*y2 - (dy2/dt) *y1 = A  for some constant A
am0 = y0(3)*y0(2) -  y0(4)*y0(1) ;

 for id = 11:1:sizey1
    tc = tvals(id) ;

    t1= t2;  t2 = tc;   y1 = y2 ;

%  "exact" solution : 
     u0=0 ;
      options=[] ; 
     [ u, fval] = fzero('kepleq' , u0, options, t2, epsv ) ; 
%  cprogKepler_eqzero= u- epsv *sin(u) -tc
   y2(1) = cos(u) -epsv ; 
   y2(2) = sqrt(1-epsv*epsv)* sin(u)  ; 
   y2(3) = -sin(u)/(1-epsv*cos(u)) ;
   y2(4) = sqrt(1-epsv*epsv)*cos(u)/(1-epsv*cos(u));

   MAXGE= max(MAXGE, max(abs( (yvals(:,id))-y2(:)))) ;

yid(1)=yvals(1,id) ;
yid(2)=yvals(2,id) ;
yid(3)=yvals(3,id) ;
yid(4)=yvals(4,id) ;

% *** test hamiltonian value ****************************
 ham = 0.5D0*(yid(3)*yid(3) + yid(4)*yid(4))  - 1.D0/sqrt(yid(1)*yid(1) + yid(2)*yid(2)) ;
 ham = abs(ham/ham0 - 1.D0) ;
 if (ham >=  me) me = ham ;         
             end;

% *** test angular momentum value ********************
am = yid(3)*yid(2) -  yid(4)*yid(1) ;
am = abs(am/am0 - 1.D0) ;
 if (am >=  mxame) mxame = am ;         
             end;

  if rem(id-5,40)== 0
     id=id
     tc=tc
     MAXGE =MAXGE 
     me=me
     mxame =mxame 
     end
%    end if
end;
% end for id = 11:1:sizey1  -------------

% #####   RESULTS: D5:20 #############

  fprintf (fid,' HBRK  METHOD   %15s, %15s, nsuccesstp = %5.0f, nreje = %5.0f,  %15s \n', fname, fname3, n+1, nreje ,datestr(now)) ;

  fprintf (fid,' HBO14_4Ed123CPU( 89, %3.0f ) = %7.2e ;  HBO14_4Ed123NS( 89, %3.0f ) = %5.0f ; HBO14_4Ed123NFE( 89, %3.0f ) = %5.0f ;  HBO14_4Ed123MXGE( 89, %3.0f ) = %7.2e  ;  HBO14_4Ed123ENER( 89, %3.0f ) = %7.2e  ;  HBO14_4Ed123AME( 89, %3.0f ) = %7.2e  ; \n'  ,itol, cput, itol, n, itol, NFE ,itol, MAXGE , itol, me , itol, mxame ) ;

% ####### END  RESULTS: ###########
end;
% end for itol=1:mxnbt (LOOP  TOL = 1e-1, 1e-2,.., 1e-9  (1 TOL/ iteration) ----------)














