%
% Test out: HBOQ144solvr solves A1 problem of DETEST
%
%   1. Initialisation
%      - set  initial t0=0;
%             initial y0 = [ 1 ];
%             integration final time "tend"
%                long term integration tend =    min(20, - log(TOL))
%
%   2. Perform the integration : call  "HBOQ144solvr"
%   3. Output
%       write on file "HBd123RKMaxGE.txt" the following informations:
%         - CPU time, number of steps, number of function evaluations, 
%           Max. global error 
%


% INITIALIZATION :
  clear all
  format long e

  fid = fopen('HBd123RKMaxGE.txt','a');


   
  fname ='PrbA1';

  fname3 = 'PrbA1d1_d3outp' ;

% act  tend = min(20, - log(TOL)) 

% temp test tend:
  tend = 20.0 



 fprintf (fid,'HB_1osd123  METHOD prb  %15s,  %15s, tend= %9.2e \n', fname, datestr(now), tend) ;



nbpos=10;

% PART: det set of TOL, strtstp(itol) 
mxnbt = 20 ;
for itol=1:mxnbt
  TOLT(itol) = 10^(-itol) ;
  strtstp(itol) = 20/(itol*2+20) ;
end;


%  end (for itol=1:mxnbt)
% end  PART : det set of TOL


nbcmp=1;
q= 0;

nbpos = 10;

% start insert
ipb = 1 ;

itmin =9 ;  itmax = 9 ;
% MAIN LOOP  TOL = 1e-1, 1e-2,.., 1e-9  (1 TOL/ iteration) --------------------
for itol=itmin:itmax

TOL = 1.0* TOLT(itol);
% end insert

t0 =0 ;
y0 =  1 ;


RELTOL=5e-14 ;
MAXGE = -99990.0;


% ---- cputime ---------------
      scput = cputime ;

 [ tvals, yvals, fvals, f2vals, f3vals, res  ] = HBOQ144solvr( RELTOL, TOL, fname, fname3, t0, tend, y0) ;



% ---- cputime ---------------
      cput = cputime- scput  


NFE = res(1)
% nb succes step:
n=res(2)-1 
nreje=res(3) 

% MAX GE CALCUL:
 sizey1 =n+nbpos+1   ;

 for id =  nbpos+1:sizey1
  tc = tvals(id) ;
   yanal = exp(-tc) ;

  abserr=abs( yvals(:,id)  -yanal)
  MAXGE = max(MAXGE, abs( yvals(:,id)  -yanal) ) ;

if rem(id-5,1)== 0
   id=id
   tc=tc
   MAXGE =MAXGE 
   end
%  end if

 end;
% (end for id = 1:sizey1
% end MAX GE



% print out statistics

NFE = res(1);
% nb succes step:
n=res(2)-1 ;
nreje=res(3) ;


% *********** RESULTS: **********

 fprintf (fid,'HB  METHOD   %15s, nsuccesstp = %5.0f, nreje = %5.0f,  %15s \n', fname, n+1, nreje ,datestr(now)) ;

  fprintf (fid,' HBO14_4Ed123CPU(  1, %3.0f ) = %7.2e ;  HBO14_4Ed123NS(  1, %3.0f ) = %5.0f ; HBO14_4Ed123NFE(  1, %3.0f ) = %5.0f ;  HBO14_4Ed123MXGE(  1, %3.0f ) = %7.2e   ;   \n'  ,itol, cput, itol, n, itol, NFE ,itol, MAXGE   ) ;




end;
% end for  itol=itmin:itmax (LOOP  TOL = 1e-1, 1e-2,.., 1e-9  (1 TOL/ iteration) ----------)






