//Dormand Prince DP(8,7)13M DAE solver

#include <math.h>
#include <iostream>

using namespace std;

__inline void fvo(double tc, double*yc,int ord, double TOL,double**yvalvo, int nbcmp);
__inline void f(double tc, double*yc,int ord, double TOL,double**yvalvo, int nbcmp);

//1 step DP87
static void DP87DAESolver1Step(double RELTOL,double TOL, double tc, double*yc,double h,int j,double**fvals,int nbpos,int nbcmp,double*hnew){
	//Input: 
	//RELTOL=relative tolerance, TOL: absolute tolerance, tc: current t, yc: current y
	//h: input stepsize, j+nbpos: index (in fvals) of the current f at tc, nbcmp: size(y)
	//fvals: array containing f=y' values

	//Output:
	//hnew: new stepsize to be used
	
	// p 180 Hairer
	int nbcmpP1=nbcmp+1;
	double hmax=10.0;//maximum stepsize
	////// (( PARAM //////////////////
	double   stfac=0.9 ;//safety factor for stepsize modification
	//   ode45 hmin:  compeps = 2.220446049250313e-16
	double  compeps = 2.220446049250313e-16 ;
	double  hmin = 16*compeps  ;//minimum stepsize
	double  eps = 2.220446049250313e-16 ;	
	//////  PARAM )) //////////////////

	int nder = 1 ;//number of derivatives of y used

	double**yfnew=new double*[3];//array containing y, y'
	for(int i=1;i<=2;i++)yfnew[i]=new double[nbcmpP1];

	//method's coefficients
	double be1 =13451932.0/455176623.0,be2=0.0,be3=0.0,be4=0.0,be5=0.0;
	double be6 =-808719846.0/976000145.0, be7 =1757004468.0/5645159321.0;
	double be8 =656045339.0/265891186.0, be9 =-3867574721.0/1518517206.0;
	double be10 =465885868.0/322736535.0, be11 =53011238.0/667516719.0;
	double be12 =2.0/45.0, be13 =0.0;

	// ////////////////////// b hat formula: (cont solution) ////////////////////////////////////////////////////////////////////////////
	double beh1 = 14005451.0/335480064.0 , beh2 =0.0, beh3 = 0.0, beh4 = 0.0, beh5 = 0.0;
	double beh6 =-59238493.0/1068277825.0 , beh7 = 181606767.0/758867731.0;
	double beh8 = 561292985.0/797845732.0 , beh9 =-1041891430.0/1371343529.0 ;
	double beh10 = 760417239.0/1151165299.0 , beh11 = 118820643.0/751138087.0 ;
	double beh12 = -528747749.0/2220607170.0, beh13 = 1.0/4.0 ;

	// A: 12 comp
	double*A=new double[14];
	A[1]=1.0/18.0 ;A[2]=1.0/12.0;A[3]=1.0/8.0;A[4]=5.0/16.0;A[5]=3.0/8.0;
	A[6]=59.0/400.0;A[7]=93.0/200.0;A[8]=5490023248.0/9719169821.0;A[9]=13.0/20.0 ;    
	A[10]=1201146811.0/1299019798.0 ; A[11]=1.0; A[12]= 1.0 ; A[13]=1.0;

	double**B=new double*[14];
	for(int i=1;i<=13;i++){
		B[i]=new double[14];
		for(int jj=1;jj<=13;jj++)B[i][jj]=0.0;
	}

	B[1][1]= 1.0/18.0 ;

	B[1][2]= 1.0/48.0;
	B[2][2]= 1.0/16.0 ;

	B[1][3]=  1.0/32.0; 
	B[2][3]= - 0.0 ;
	B[3][3]= +3.0/32.0;  

	B[1 ][4]= 5.0/16.0;
	B[2][4]=  0.0 ;
	B[3][4]= -75.0/64.0 ;
	B[4][4]=  75.0/64.0 ;

	B[1][5]= 3.0/80.0 ; 
	B[2][5]= 0.0 ;
	B[3][5]= 0.0  ;
	B[4][5]= 3.0/16.0  ;
	B[5][5]= 3.0/20.0 ;

	B[1][6]= 29443841.0/614563906.0 ; 
	B[2][6]= 0.0 ; 
	B[3][6]= 0.0 ; 
	B[4][6]= +77736538.0/692538347.0 ;
	B[5][6]=-28693883.0/1125000000.0 ;
	B[6][6]=+ 23124283.0/1800000000.0 ;

	B[1][7]= 16016141.0/946692911.0  ;
	B[2][7]=+0.0 ;
	B[3][7]=+0.0  ;
	B[4][7]=+ 61564180.0/158732637.0  ;
	B[5][7]=+22789713.0/633445777.0 ;
	B[6][7]=+545815736.0/2771057229.0 ;
	B[7][7]= - 180193667.0/1043307555.0 ;

	B[1][8]= 39632708.0/573591083.0  ;
	B[2][8]=+0.0 ;
	B[3][8]=+0.0 ;
	B[4][8]=-433636366.0/683701615.0  ;
	B[5][8]=-421739975.0/2616292301.0 ;
	B[6][8]= +100302831.0/723423059.0 ;
	B[7][8]=+790204164.0/839813087.0 ;
	B[8][8]= +800635310.0/3783071287.0; 

	B[1][9]= 246121993.0/1340847787.0  ;
	B[2][9]=+0.0  ;
	B[3][9]=+0.0  ;
	B[4][9]=-37695042795.0/15268766246.0 ;
	B[5][9]= -309121744.0/1061227803.0 ;
	B[6][9]= -12992083.0/490766935.0 ;
	B[7][9]= +6005943493.0/2108947869.0 ;
	B[8][9]= +393006217.0/1396673457.0 ;
	B[9][9]= +123872331.0/1001029789.0 ;

	B[1][10]= -1028468189.0/846180014.0 ; 
	B[2][10]= +0.0  ;
	B[3][10]= + 0.0  ;
	B[4][10]= +8478235783.0/508512852.0  ;
	B[5][10]= +1311729495.0/1432422823.0 ;
	B[6][10]= -10304129995.0/1701304382.0; 
	B[7][10]= -48777925059.0/3047939560.0 ;
	B[8][10]= +15336726248.0/1032824649.0 ;
	B[9][10]= -45442868181.0/3398467696.0  ;
	B[10][10]= +3065993473.0/597172653.0 ;

	B[1][11]= 185892177.0/718116043.0 ; 
	B[2][11]= +0.0  ;
	B[3][11]= +0.0  ;
	B[4][11]= -3185094517.0/667107341.0  ;
	B[5][11]= -477755414.0/1098053517.0  ;
	B[6][11]= -703635378.0/230739211.0  ;
	B[7][11]= +5731566787.0/1027545527.0 ; 
	B[8][11]= +5232866602.0/850066563.0  ;
	B[9][11]= -4093664535.0/808688257.0  ;
	B[10][11]= +3962137247.0/1805957418.0 ;
	B[11][11]=  +65686358.0/487910083.0 ; 

	B[1][12]= 403863854.0/491063109.0  ;
	B[2][12]= +0.0  ;
	B[3][12]= +0.0   ;
	B[4][12]= -5068492393.0/434740067.0  ;
	B[5][12]= -411421997.0/543043805.0  ;
	B[6][12]= +652783627.0/914296604.0   ;
	B[7][12]= +11173962825.0/925320556.0 ;
	B[8][12]=  -13158990841.0/6184727034.0;  
	B[9][12]= +3936647629.0/1978049680.0   ; 
	B[10][12]= -160528059.0/685178525.0  ;
	B[11][12]= +248638103.0/1413531060.0 ; 
	B[12][12]= 0.0;

	B[1][13]=beh1;B[2][13]=beh2;B[3][13]=beh3;B[4][13]=beh4;B[5][13]=beh5;
	B[6][13]=beh6;B[7][13]=beh7;B[8][13]=beh8;B[9][13]=beh9;B[10][13]=beh10;
	B[11][13]=beh11;B[12][13]=beh12;B[13][13]=beh13;

	double*y_estcf=new double[14];
	y_estcf[1]=be1;y_estcf[2]=be2;y_estcf[3]=be3;y_estcf[4]=be4;y_estcf[5]=be5;
	y_estcf[6]=be6;y_estcf[7]=be7;y_estcf[8]=be8;y_estcf[9]=be9;y_estcf[10]=be10;
	y_estcf[11]=be11;y_estcf[12]=be12;y_estcf[13]=be13;

	double* E=new double[14];
	for(int i=1;i<=13;i++)E[i]= B[i][13]  -y_estcf[i] ;

	double**fTbl=new double*[nbcmpP1];
	for(int i=1;i<=nbcmp;i++){
		fTbl[i]=new double[14];
		for(int jj=1;jj<=13;jj++)fTbl[i][jj]=0.0;
	}
	
	double*tempV=new double[nbcmpP1];
	double**hB=new double*[14];//h*B
	for(int i=1;i<=13;i++){
		hB[i]=new double[14];
	}
	double*hA=new double[14];//h*A
	
	int jpnbpos=j+nbpos;
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][1] = fvals[i][jpnbpos];

	for(int i=1;i<=13;i++){
		hA[i]=h*A[i];
		for(int jj=1;jj<=13;jj++)hB[i][jj]=h*B[i][jj];
	}

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][1];
	}
	f(tc+hA[1],tempV, nder, TOL,yfnew,nbcmp);

	for(int i=1;i<=nbcmp;i++)
		fTbl[i][2] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][2];
	}
	f(tc+hA[2],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][3] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][3];
	}
	f(tc+hA[3],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][4] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][4];
	}
	f(tc+hA[4],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][5] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][5];
					
	}
	f(tc+hA[5],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][6] = yfnew[2][i] ;
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][6];
		
	}
	f(tc+hA[6],tempV, nder, TOL,yfnew,nbcmp);

	for(int i=1;i<=nbcmp;i++)
		fTbl[i][7] = yfnew[2][i] ; 

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][7];

	}
	f(tc+hA[7],tempV, nder, TOL,yfnew,nbcmp);

	for(int i=1;i<=nbcmp;i++)
		fTbl[i][8] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][8];
		
	}
	f(tc+hA[8],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][9] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][9];
	}
	f(tc+hA[9],tempV, nder, TOL,yfnew,nbcmp);

	for(int i=1;i<=nbcmp;i++)
		fTbl[i][10] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][10];
	}
	f(tc+hA[10],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][11] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][11];
	}
	f(tc+hA[11],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][12] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=yc[i];
		for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][12];
	}
	f(tc+hA[12],tempV, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][13] = yfnew[2][i] ;

	double tnew = tc + hA[13];
	double*ynew=new double[nbcmpP1];
	for(int i=1;i<=nbcmp;i++){
		ynew[i] = yc[i];
		for(int jj=1;jj<=13;jj++)ynew[i]+=fTbl[i][jj]*hB[jj][13] ;
	}

	double*y_est=new double[nbcmpP1];
	for(int i=1;i<=nbcmp;i++){
		y_est[i] = yc[i];
		for(int jj=1;jj<=13;jj++)y_est[i]+=h*fTbl[i][jj]*y_estcf[jj] ;
	}
   
	fvo(tnew,ynew, nder, TOL,yfnew,nbcmp);
	for(int i=1;i<=nbcmp;i++)
		fTbl[i][13] = yfnew[2][i] ;

	for(int i=1;i<=nbcmp;i++){
		ynew[i]=yfnew[1][i] ;
	}
	double erk=0.0;//error
	double temp;
	for(int i=1;i<=nbcmp;i++){
		temp=0.0;
		for(int jj=1;jj<=13;jj++)temp+=fTbl[i][jj]*E[jj];
		erk=max(erk,fabs(temp));
	}
	erk = fabs(h) * erk  ;
       	    
	//   ode45 hmin:  eps = 2.220446049250313e-16
	//    eps = 2.220446049250313e-16 ;
	//    hmin = 16*eps*abs(tc);    stephmin2=hmin
	//  PART :  STEP SIZE ********************

	// EX: ordnew=14 <->  (TOL/erk )^(1.0/(14+1) )

	//  (step size formula : h =hold, stsize = hnew)   
	double stsize;
	if (erk != 0.0) {
		// ACT    (HB../HB11 step cntrl)
		stsize = h *stfac *pow(TOL/erk,1.0/8.0 ) ;  
	}else
	  stsize = 2*h ;

	//  (end of step size formula : h =hold, stsize = hnew)

	//  constraints that stsize must satisfy :
	//     (a) h( next step) = max (h( next step), hmin, 0.5* h(last step))
	//     (b) h( next step) = min (h( next step), hmax, 4 * h(last step))

	stsize = max ( stsize, 0.5* h ) ;
	stsize = max ( stsize, hmin ) ;
	stsize = min( stsize, hmax) ;
	stsize = min( stsize, 4*h) ;

	*hnew=stsize;//output

	//free memory
	delete yfnew[1];
	delete yfnew[2];
	delete yfnew;
	delete A;
	for(int i=1;i<=13;i++)delete B[i];
	delete B;
	delete y_estcf;
	delete E;
	for(int i=1;i<=nbcmp;i++)delete fTbl[i];
	delete fTbl;
	for(int i=1;i<=13;i++)delete hB[i];
	delete hB;
	delete tempV;
	delete hA;
	delete ynew;
	delete y_est;

}

static void DP87DAESolver(double RELTOL,double TOL, double t0, double tend, double*y0,double*tvals,double**yvals,double**fvals,int*res,int nbcmp,int nbMax){
	//-----input
	//RELTOL: relative tolerance
	//TOL: absolute tolerance
	//t0,tend: integration is done over [t0,tend]
	//y0: y(t_0)
	//nbcmp: size of y0
	//nbMax: max size of the arrays tvals, yvals, fvals
	
	//-----output
	//tvals: mesh t_i=tvals[i]
	//yvals: y_i[1:nbcmp]=yvals[1:nbcmp][i]
	//fvals: y'_i[1:nbcmp]=fvals[1:nbcmp][i]
	//res: res[1]=NFE, res[2]-1=number of success steps, res[3]=number of rejected steps	
	
	// p 180 Hairer
	int nbcmpP1=nbcmp+1;

	////// (( PARAM //////////////////
	double   stfac=0.9 ;//safety factor for stepsize modification
	//   ode45 hmin:  compeps = 2.220446049250313e-16
	double  compeps = 2.220446049250313e-16 ;
	double  hmin = 16*compeps  ;//minimum stepsize
	double  eps = 2.220446049250313e-16 ;
	int  nbpos=10;//index of first element in tvals/yvals/fvals
	int  nbeps=13 ;
	double  hmax = (tend-t0)/5 ;//maximum stepsize
	//////  PARAM )) //////////////////

	int  om=16 ;

	double tc = t0;//current t
	double*yc=new double[nbcmpP1];//current y
	for(int i=1;i<=nbcmp;i++)yc[i] =y0[i];

	int nder = 1 ;//number of derivatives of y used

	//array containing y and y'
	double**yfnew=new double*[3];double*fc=new double[nbcmpP1];
	for(int i=1;i<=2;i++)yfnew[i]=new double[nbcmpP1];

	fvo( tc,yc, nder, TOL,yfnew,nbcmp) ;//evaluate f
	for(int i=1;i<=nbcmp;i++)
		fc[i] = yfnew[2][i] ;

	double normYc=0.0;
	for(int i=1;i<=nbcmp;i++)normYc=max(normYc,fabs(yc[i]));
	double h=min( fabs(tend-t0), pow(TOL,0.2)/normYc ) ;

	// p 169, Hairer: first guess for step size: 

	int  j=0 ;
	int   jpnbpos=j+nbpos;
	tvals[jpnbpos ] =  tc;
	for(int i=1;i<=nbcmp;i++){
		yvals[i][jpnbpos] =  yc[i]; 
		fvals[i][jpnbpos] = fc[i];
	}
	
	double hnew;

	DP87DAESolver1Step(RELTOL,TOL/10000.0, tc, yc,h,j,fvals,nbpos,nbcmp,&hnew);

	h=hnew; 

	int	nreje=0;

	// tnguyen/hbrk/DP8varstep : p 72 Dormand& Prince "High order emb. RK form"

	// ////////////////////// b formula: (step cntrl) //////////////////////////////////////////////////////////////
	double be1 =13451932.0/455176623.0,be2=0.0,be3=0.0,be4=0.0,be5=0.0;
	double be6 =-808719846.0/976000145.0, be7 =1757004468.0/5645159321.0;
	double be8 =656045339.0/265891186.0, be9 =-3867574721.0/1518517206.0;
	double be10 =465885868.0/322736535.0, be11 =53011238.0/667516719.0;
	double be12 =2.0/45.0, be13 =0.0;
	  

	// ////////////////////// b hat formula: (cont solution) ////////////////////////////////////////////////////////////////////////////
	double beh1 = 14005451.0/335480064.0 , beh2 =0.0, beh3 = 0.0, beh4 = 0.0, beh5 = 0.0;
	double beh6 =-59238493.0/1068277825.0 , beh7 = 181606767.0/758867731.0;
	double beh8 = 561292985.0/797845732.0 , beh9 =-1041891430.0/1371343529.0 ;
	double beh10 = 760417239.0/1151165299.0 , beh11 = 118820643.0/751138087.0 ;
	double beh12 = -528747749.0/2220607170.0, beh13 = 1.0/4.0 ;

	// A: 12 comp
	double*A=new double[14];
	A[1]=1.0/18.0 ;A[2]=1.0/12.0;A[3]=1.0/8.0;A[4]=5.0/16.0;A[5]=3.0/8.0;
	A[6]=59.0/400.0;A[7]=93.0/200.0;A[8]=5490023248.0/9719169821.0;A[9]=13.0/20.0 ;    
	A[10]=1201146811.0/1299019798.0 ; A[11]=1.0; A[12]= 1.0 ; A[13]=1.0;

	// (( temp
	double c1 = 0 ,  c2 =     1.0/18.0 , c3 =  1.0/12.0   , c4 =   1.0/8.0  ;
	double c5 =    5.0/16.0 , c6 = 3.0/8.0 ,  c7 = 59.0/400.0 , c8 = 93.0/200.0;
	double c9 = 5490023248.0/9719169821.0 , c10 = 13.0/20.0 , c11 = 1201146811.0/1299019798.0;
	double c12 = 1.0, c13 = 1.0;
	//// temp ))

	double**B=new double*[14];
	for(int i=1;i<=13;i++){
		B[i]=new double[14];
		for(int jj=1;jj<=13;jj++)B[i][jj]=0.0;
	}

	B[1][1]= 1.0/18.0 ;

	B[1][2]= 1.0/48.0;
	B[2][2]= 1.0/16.0 ;

	B[1][3]=  1.0/32.0; 
	B[2][3]= - 0.0 ;
	B[3][3]= +3.0/32.0;  

	B[1 ][4]= 5.0/16.0;
	B[2][4]=  0.0 ;
	B[3][4]= -75.0/64.0 ;
	B[4][4]=  75.0/64.0 ;

	B[1][5]= 3.0/80.0 ; 
	B[2][5]= 0.0 ;
	B[3][5]= 0.0  ;
	B[4][5]= 3.0/16.0  ;
	B[5][5]= 3.0/20.0 ;

	B[1][6]= 29443841.0/614563906.0 ; 
	B[2][6]= 0.0 ; 
	B[3][6]= 0.0 ; 
	B[4][6]= +77736538.0/692538347.0 ;
	B[5][6]=-28693883.0/1125000000.0 ;
	B[6][6]=+ 23124283.0/1800000000.0 ;

	B[1][7]= 16016141.0/946692911.0  ;
	B[2][7]=+0.0 ;
	B[3][7]=+0.0  ;
	B[4][7]=+ 61564180.0/158732637.0  ;
	B[5][7]=+22789713.0/633445777.0 ;
	B[6][7]=+545815736.0/2771057229.0 ;
	B[7][7]= - 180193667.0/1043307555.0 ;


	B[1][8]= 39632708.0/573591083.0  ;
	B[2][8]=+0.0 ;
	B[3][8]=+0.0 ;
	B[4][8]=-433636366.0/683701615.0  ;
	B[5][8]=-421739975.0/2616292301.0 ;
	B[6][8]= +100302831.0/723423059.0 ;
	B[7][8]=+790204164.0/839813087.0 ;
	B[8][8]= +800635310.0/3783071287.0; 


	B[1][9]= 246121993.0/1340847787.0  ;
	B[2][9]=+0.0  ;
	B[3][9]=+0.0  ;
	B[4][9]=-37695042795.0/15268766246.0 ;
	B[5][9]= -309121744.0/1061227803.0 ;
	B[6][9]= -12992083.0/490766935.0 ;
	B[7][9]= +6005943493.0/2108947869.0 ;
	B[8][9]= +393006217.0/1396673457.0 ;
	B[9][9]= +123872331.0/1001029789.0 ;

	B[1][10]= -1028468189.0/846180014.0 ; 
	B[2][10]= +0.0  ;
	B[3][10]= + 0.0  ;
	B[4][10]= +8478235783.0/508512852.0  ;
	B[5][10]= +1311729495.0/1432422823.0 ;
	B[6][10]= -10304129995.0/1701304382.0; 
	B[7][10]= -48777925059.0/3047939560.0 ;
	B[8][10]= +15336726248.0/1032824649.0 ;
	B[9][10]= -45442868181.0/3398467696.0  ;
	B[10][10]= +3065993473.0/597172653.0 ;

	B[1][11]= 185892177.0/718116043.0 ; 
	B[2][11]= +0.0  ;
	B[3][11]= +0.0  ;
	B[4][11]= -3185094517.0/667107341.0  ;
	B[5][11]= -477755414.0/1098053517.0  ;
	B[6][11]= -703635378.0/230739211.0  ;
	B[7][11]= +5731566787.0/1027545527.0 ; 
	B[8][11]= +5232866602.0/850066563.0  ;
	B[9][11]= -4093664535.0/808688257.0  ;
	B[10][11]= +3962137247.0/1805957418.0 ;
	B[11][11]=  +65686358.0/487910083.0 ; 


	B[1][12]= 403863854.0/491063109.0  ;
	B[2][12]= +0.0  ;
	B[3][12]= +0.0   ;
	B[4][12]= -5068492393.0/434740067.0  ;
	B[5][12]= -411421997.0/543043805.0  ;
	B[6][12]= +652783627.0/914296604.0   ;
	B[7][12]= +11173962825.0/925320556.0 ;
	B[8][12]=  -13158990841.0/6184727034.0;  
	B[9][12]= +3936647629.0/1978049680.0   ; 
	B[10][12]= -160528059.0/685178525.0  ;
	B[11][12]= +248638103.0/1413531060.0 ; 
	B[12][12]= 0.0;

	B[1][13]=beh1;B[2][13]=beh2;B[3][13]=beh3;B[4][13]=beh4;B[5][13]=beh5;
	B[6][13]=beh6;B[7][13]=beh7;B[8][13]=beh8;B[9][13]=beh9;B[10][13]=beh10;
	B[11][13]=beh11;B[12][13]=beh12;B[13][13]=beh13;


	double*y_estcf=new double[14];
	y_estcf[1]=be1;y_estcf[2]=be2;y_estcf[3]=be3;y_estcf[4]=be4;y_estcf[5]=be5;
	y_estcf[6]=be6;y_estcf[7]=be7;y_estcf[8]=be8;y_estcf[9]=be9;y_estcf[10]=be10;
	y_estcf[11]=be11;y_estcf[12]=be12;y_estcf[13]=be13;

	double* E=new double[14];
	for(int i=1;i<=13;i++)E[i]= B[i][13]  -y_estcf[i] ;

	double**fTbl=new double*[nbcmpP1];
	for(int i=1;i<=nbcmp;i++){
		fTbl[i]=new double[14];
		for(int jj=1;jj<=13;jj++)fTbl[i][jj]=0.0;
	}

	double powD = 1.0/8.0;

	double err_est;//estimated error
	double*tempV=new double[nbcmpP1];
	double**hB=new double*[14];//h*B
	for(int i=1;i<=13;i++){
		hB[i]=new double[14];
	}
	double*hA=new double[14];//h*A
	double tnew;double*ynew=new double[nbcmpP1];double hold, erk,stsize,prevh;
	int jpnbposp1;
	
	double*fnew=new double[nbcmpP1];double*y_est=new double[nbcmpP1];
	// ( MAIN LOOP  1 integration step/ iteration)

	while  (tvals[j+nbpos] < tend){
		if (j >= 1000000){
			cout<<"j>=1000000. Must stop manually.\n";int jj;cin>>jj;
		}
		h=hnew;

		if((tc+h) > tend)h=tend-tc ;
	
		//  (MAIN INTEG STEP)

		err_est=9999;
		if (h <= hmin )
			h=1.2*hmin ;

		// LOOP REPEAT THE STEP UNTIL SUCCESS -----------------------
		while ( err_est > TOL && h > hmin){

			jpnbpos=j+nbpos;
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][1] = fvals[i][jpnbpos];

			for(int i=1;i<=13;i++){
				hA[i]=h*A[i];
				for(int jj=1;jj<=13;jj++)hB[i][jj]=h*B[i][jj];
			}

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][1];
			}
			f(tc+hA[1],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][2] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][2];
			}
			f(tc+hA[2],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][3] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][3];
			}
			f(tc+hA[3],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][4] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][4];
			}
			f(tc+hA[4],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][5] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][5];
			}
			f(tc+hA[5],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][6] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][6];
			}
			f(tc+hA[6],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][7] = yfnew[2][i] ; 

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][7];
			}
			f(tc+hA[7],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][8] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][8];
			}
			f(tc+hA[8],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][9] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][9];
			}
			f(tc+hA[9],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][10] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][10];
			}
			f(tc+hA[10],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][11] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][11];
			}
			f(tc+hA[11],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][12] = yfnew[2][i] ;

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				for(int jj=1;jj<=13;jj++)tempV[i]+=fTbl[i][jj]*hB[jj][12];
			}
			f(tc+hA[12],tempV, nder, TOL,yfnew,nbcmp);
			for(int i=1;i<=nbcmp;i++)
				fTbl[i][13] = yfnew[2][i] ;

			tnew = tc + hA[13];

			for(int i=1;i<=nbcmp;i++){
				ynew[i] = yc[i];
				for(int jj=1;jj<=13;jj++)ynew[i]+=fTbl[i][jj]*hB[jj][13] ;
			}

			for(int i=1;i<=nbcmp;i++){
				y_est[i] = yc[i];
				for(int jj=1;jj<=13;jj++)y_est[i]+=h*fTbl[i][jj]*y_estcf[jj] ;
			}

			// PART:  STEP SIZE, ORDER SELECTION 
			err_est=0.0;
			for(int i=1;i<=nbcmp;i++)
				err_est = max( err_est,fabs(  y_est[i]  - ynew[i]  ) )  ;

			hold=h;
			if (err_est >  TOL){ 
				//  (the computed step (hold) is rejected, compute smaller h )
				h =  max(  hold*0.7*stfac *pow(TOL/err_est,1.0/8.0), hmin) ;
				nreje=nreje+1;
			}
			// end if err_est > TOL
		}
		// (--------- end  LOOP REPEAT UNTIL SUCCESS    while ( err_est > TOL ) ----------------
	   
		fvo(tnew,ynew, nder, TOL,yfnew,nbcmp);//evaluate f
		for(int i=1;i<=nbcmp;i++)
			fTbl[i][13] = yfnew[2][i] ;
	
		for(int i=1;i<=nbcmp;i++){
			fnew[i]= fTbl[i][13]   ;
			ynew[i]=yfnew[1][i] ;
		}

		erk=0.0;//compute error
		double temp;
		for(int i=1;i<=nbcmp;i++){
			temp=0.0;
			for(int jj=1;jj<=13;jj++)temp+=fTbl[i][jj]*E[jj];
			erk=max(erk,fabs(temp));
		}
		erk = fabs(h) * erk  ;
	       
	    //   ode45 hmin:  eps = 2.220446049250313e-16
		//    eps = 2.220446049250313e-16 ;
		//    hmin = 16*eps*abs(tc);    stephmin2=hmin
		//  PART :  STEP SIZE ********************

		// EX: ordnew=14 <->  (TOL/erk )^(1.0/(14+1) )

		//  (step size formula : h =hold, stsize = hnew)   
		if (erk != 0.0) {
			// ACT    (HB../HB11 step cntrl)
			stsize = h *stfac *pow(TOL/erk,1.0/8.0 ) ;  
		}else
		  stsize = 2*h ;
	
		//  (end of step size formula : h =hold, stsize = hnew)

		//  constraints that stsize must satisfy :
		//     (a) h( next step) = max (h( next step), hmin, 0.5* h(last step))
		//     (b) h( next step) = min (h( next step), hmax, 4 * h(last step))



		stsize = max ( stsize, 0.5* h ) ;
		stsize = max ( stsize, hmin ) ;
		stsize = min( stsize, hmax) ;
		stsize = min( stsize, 4*h) ;

		tc=tnew;
	  
		jpnbposp1=j+nbpos+1;
		for(int i=1;i<=nbcmp;i++){
			fvals[i][jpnbposp1] =  fnew[i]; 
			yc[i]=ynew[i] ;
		}
		hnew=stsize ;

		//  -----(END OF INTEG STEP) --------------------

		//  (yvals,tvals,.. UPDATE STEP)

		tvals[jpnbposp1] =  tc;
		for(int i=1;i<=nbcmp;i++)
			yvals[i][jpnbposp1] =  yc[i]; 


		prevh = h ;
		j = j+1 ;

	}
	// ( END OF MAIN LOOP  1 integration step/ iteration) -------------

	// print out statistics
	// with index j-1,  yvals(n+1+nbpos, . )  cont solution
	int n=j-1;
	int nb_f_eval=(n+1+nreje)*nbeps ;

	int NFE=nb_f_eval;

	res[1]=NFE;
	// nb succes step:
	res[2]=n+1 ;
	res[3]=nreje ;

	//free memory
	delete yc;
	delete yfnew[1];
	delete yfnew[2];
	delete yfnew;
	delete fc;
	delete A;
	for(int i=1;i<=13;i++)delete B[i];
	delete B;
	delete y_estcf;
	delete E;
	for(int i=1;i<=nbcmp;i++)delete fTbl[i];
	delete fTbl;
	for(int i=1;i<=13;i++)delete hB[i];
	delete hB;
	delete hA;
	delete ynew;
	delete fnew;
	delete y_est;

}