#include "linSolver.cpp"
#include "autoDiff.cpp"

//Test problem (VO means variable order): 
//INPUT:  t, yyvc:y(t), ord:compute y^{(i)}(t) up to i=ord or ord+1, nbcmp:size(y)
//OUTPUT:  yvalvo/yvalvo: array containing the computed y^{(i)}(t)'s
static void fvo(double t, double*yyvc, int ord,double TOL, double**yvalvo,int nbcmp){
	
	// amplifier prob p379,  Hairer
	// tend = 0.2 TOL = 1e-4, Radau5 accepted 556 steps 
	// Newton method p 611, Burden Faires

	// k_d = -max_j d_j = -1 =>
	// stage k= k_d = -1: solve for Tayl coeffs y1 ,   y2,   y3 ,  z1 , z2 ;
	//    F(4) = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 )   ;
	//    F(5) = y3/R5 -z2*(1/R4 +1/R5) +Ub/R2 -0.99*fcoef  *( exp((z1-y1-y2)/den) -1 )  ;
	//
	// stage k=0: solve for Tayl coeffs  y1p ;   y2p;   y3p ;  z1p ; z2p , 5 lin eq :
	//             y1p ;   y2p;   y3p ;  z1p ; z2p   
	//    F(1) = -z1/R0 +Uet/R0 -C1*y1p  ;
	//    F(2) = -y2/R3 +  fcoef  *( exp((z1-y1-y2)/den) -1 ) -C2*y2p  ;
	//    F(3) = y3/R5 -z2/R5 +C3*y3p  ;
	//        (F(4)' = F(6))
	//    F(6) = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2)+ (Uept/R0) -0.01*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;
	//        (F(5)' = F(7))
	//    F(7) = y3p/R5 -z2p*(1/R4 +1/R5) - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;

	// corrector & f eval


	// input t, yyvc(1),yyvc(2) ,

	double*F=new double[8];
	for(int i=1;i<=7;i++)F[i]=0.0;
	int k=1 ;
	int N=99 ;
	//int o = 1 ;
	// TOL= 5e-13 ;
	double*ft=new double[20];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;
	   ft[18] =     ft[17]*18.0 ;
	   ft[19] =     ft[18]*19.0 ;

	//  Taylor output: y1, y2, y3, y1p, y2p, y3p (nbcmp=6)
	//  Newton iter output: y1, y2, y3, z1, z2  (5 var, 5 eq)
	//    =>  U1=z1 ; U2 = z1-y1 ; U3 = y2 ; U4 = z2 ; U5 = z2 - y3

	 double C1 = 1.0e-6 ,C2 = 2*C1  ,C3 = 3*C1,R0 = 1000.0 ,R1 = 9000.0 ;
	 double R2 = 9000.0 ,R3 = 9000.0 ,R4 = 9000.0 ,R5 = 9000.0 ;


	//C1 = 0.001 ;
	//C2 = 2*C1 ;  
	//C3 = 3*C1 ;
	//R0 = 100 ;
	//R1 = 900 ;
	//R2 = 900 ;
	//R3 = 900 ;
	//R4 = 900 ;
	//R5 = 900 ;



	// C1 = 0.8 ;C2 = 0.82*C1 ;  C3 = 0.83*C1 ;R0 = 1.2 ;R1 = 1.4 ;R2 = 1.4 ;R3 = 1.4 ;R4 = 1.4 ;R5 = 1.4 ;

	double pi=3.141592653589793238462643383279502884197169399375105820974944592;
	
	// act 
	double om=200*pi ;
	// om= 5 ;
	// tmp om*t = rem(om*t,2*pi ) ; 

	double Uet = 0.4*sin(om*t) ;
	double Uept = 0.4*cos(om*t)*om ;

	// Init :
	double Ub = 6.0 ;

	 // expy   = yyvc(1) ;
	double y1     = yyvc[1] ;
	double  y2     = yyvc[2] ;
	double  y3     = yyvc[3] ;
	double  y1p    = yyvc[4] ;
	double  y2p    = yyvc[5] ;
	double  y3p    = yyvc[6] ;


	//Uet = 0.4*sin(om*t) ;
	//Uept = 0.4*cos(om*t)*om ;

	// eq F(1)=0 & F(3)=0 =>  guess z1, z2:
	double z1 =  (Uet/R0 -C1*y1p)*R0 ;
	double z2 =   (y3/R5 +C3*y3p )*R5 ;
	// orig
	double den= 0.026 ;
	// den = 2.2 ;
	// den=1.0 ;
	// act
	double fcoef=1.0e-6 ;
	// fcoef=0.90 ;
	// fcoef=1.0 ;

	double ffU2mU3 = fcoef  *( exp((z1-y1-y2)/den) -1.0 ) ;



	// Alg. Eq 1 :   F(4) = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 ) = 0   ;
	// act   z1zero = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 ) 
	//  => z1pzero =  (1/R1+1/R2)*y1p -z1p*(1/R0 +1/R1 + 1/R2) +Uept/R0  -0.01*fcoef* exp((z1-y1-y2)/den) * (z1p-y1p-y2p)/den    ;

	// Alg Eq 1 =>  z1p = ..
	// ok  z1p = ((1/R1 +1/R2)*y1p+ Uept/R0 - fU2mU3p2*( -(y1p+y2p)/den ) )/(1/R0 +1/R1 +1/R2 + fU2mU3p2/den  ) ;

	 double z1p = ((1/R1 +1/R2)*y1p+ Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den)*( -(y1p+y2p)/den ) )/(1/R0 +1/R1 +1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den  ) ;

	// f'(z1-y1-y2) = fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)
	// act  z1pzero =  (1/R1+1/R2)*y1p -z1p*(1/R0 +1/R1 + 1/R2) +Uept/R0  -0.01*fcoef* exp((z1-y1-y2)/den) * (z1p-y1p-y2p)/den    

	//  z1pzero ?? = (1/R1 + 1/R2)*y1p + Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den)*(-(y1p+y2p)/den) -( z1p*(1/R0 +1/R1+1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den )  )

	// act z1p = ((1/R1 +1/R2)*y1p+ Uept/R0 -0.01*fcoef *exp((z1-y1-y2)/den)*(( -y1p-y2p)/den) )/(1/R0+1/R1+1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den) ;


	// Alg Eq 2 =>  z2p = ..

	int m=1 ;
	// **((
	// m=1 , expz1y1y2(1+m) = smexpz1y1y2 p 527
	// differentiation { exp((z1-y1-y2)/den) }
	int szTbl=ord+10;
	int szTblP1=szTbl+1;
	double*z1y1y2=new double[szTblP1];
	z1y1y2[1] = (z1-y1-y2)/den ;
	z1y1y2[2] = (z1p-y1p-y2p)/den ;
	double*expz1y1y2=new double[szTblP1];
	expz1y1y2[1] = exp((z1-y1-y2)/den) ;
	double smexpz1y1y2 = z1y1y2[2] *expz1y1y2[1];
	   
	expz1y1y2[2] = smexpz1y1y2 ;

	//expz1y1y2_1zero = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -expz1y1y2(2) 
	//expz1y1y2_1zero2 = expz1y1y2(1) * z1y1y2(2) -expz1y1y2(2) 

	double z2p = (y3p/R5 -0.99*fcoef *expz1y1y2[2] )/(1/R4+1/R5) ;

	// ok  z2pzero = y3p/R5 -z2p*(1/R4+1/R5) -0.99* fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)
	// ok:  z2p=   (y3p/R5 - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den))/(1/R4 +1/R5) ;


	////// **********(( Pryce's System Jacobian OK: **************
	//// STAGE k=0 
	//// (1) 5 SYSTEM EQUATIONS ( gen. Tayl Coeffs ) 
	//
		//   gen. Tayl Coeffs:   y1p ;   y2p;   y3p ;  z1p ; z2p ;   
	// 
	//    F(1) = -z1/R0 +Uet/R0 -C1*y1p  ;
	//    F(2) = -y2/R3 +  fcoef  *( exp((z1-y1-y2)/den) -1 ) -C2*y2p  ;
	//    F(3) = y3/R5 -z2/R5 +C3*y3p  ;
	//    // F(4) = (Alg Eq 1)' 
	//    F(4) = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2)+ (Uept/R0) -0.01*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;
	//    // F(5) = (Alg Eq 2)' 
	//    F(5) = y3p/R5 -z2p*(1/R4 +1/R5) - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;
	//
	////// (1) SYSTEM JAC. A_MAT ( gen. Tayl Coeffs: y1p ;   y2p;   y3p ;  z1p ; z2p ; ) 
	//A_MAT = ...
	//[    -C1,      0,      0,      0,      0; ...
	//      0,    -C2,      0,      0,      0 ; ...
	//      0,      0,     C3,      0,      0 ; ...
	// 1/R1+1/R2+1/100*fcoef*exp((z1-y1-y2)/den)/den, 1/100*fcoef*exp((z1-y1-y2)/den)/den,   0, -1/R0-1/R1-1/R2-1/100*fcoef*exp((z1-y1-y2)/den)/den,      0 ; ...
	//      99/100*fcoef*exp((z1-y1-y2)/den)/den,      99/100*fcoef*exp((z1-y1-y2)/den)/den,   1/R5,     -99/100*fcoef*exp((z1-y1-y2)/den)/den,     -1/R4-1/R5] ;
	//
	//RHS1 = z1/R0 -Uet/R0 ;
	//RHS2 = y2/R3 -  fcoef  *( exp((z1-y1-y2)/den) -1 ) ;
	//RHS3 = -y3/R5 +z2/R5   ;
	//RHS4 = - (Uept/R0)  ;
	//RHS5 = 0.0 ;
	//
	//RHS = [ RHS1; RHS2; RHS3; RHS4 ; RHS5 ] ;
	//
	//b_v = A_MAT\RHS ;
	//
	//bv1zero = b_v(1)-y1p
	//bv2zero = b_v(2)-y2p
	//bv3zero = b_v(3)-y3p
	//bv4zero = b_v(4)-z1p
	//bv5zero = b_v(5)-z2p

	//clear all
	//return
	//// ********** Pryce's System Jacobian OK: )) **************


	//   the values y1, y2, y3, z1, z2, y1p, y2p SHOULD be projected 
	//   onto the constraints manifold by means Newton iterations
	//     adjust  xvc  = [ y1   ; y2   ; y3   ;  z1  ; z2   ; y1p  ; y2p ];
	double*xvc=new double[8];
	double*JFvc=new double[8];
	 xvc[1]= y1; xvc[2]=y2   ; xvc[3]=y3   ;  xvc[4]=z1  ; xvc[5]=z2   ; xvc[6]=y1p  ; xvc[7]=y2p;
	for(int i=1;i<=7;i++) JFvc[i]=1111.0;
	// fprintf ('corr-feval :  y1 = //10.5e , y2= //10.5e, y3= //10.5e, z1= //10.5e, z2= //10.5e , t= //7.2e  \n', y1, y2, y3, z1, z2, t ) ;

	// fprintf ('corr-feval :  y1p = //10.5e , y2p= //10.5e, y3p= //10.5e  \n', y1p, y2p, y3p ) ;


	// Alg. Eq 1 :   F(4) = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 ) = 0   ;
	// Alg. Eq 2 :   F(5) = y3/R5 -z2*(1/R4 +1/R5) +Ub/R2 -0.99*fcoef  *( exp((z1-y1-y2)/den) -1 ) = 0 ;

	// act  while (k <= N )
	 double maxAbsJFvc=0.0;
	double**invJac=new double*[8];
	for(int i=1;i<=7;i++){
		invJac[i]=new double[8]; 
		maxAbsJFvc=max(maxAbsJFvc,fabs(JFvc[i]));
	}

	 while (k <= 99  && maxAbsJFvc >= TOL){

		// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
		// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

		//       y1 ;   y2;   y3 ;  z1 ; z2 ; y1p ; y2p  
		F[1] = -z1/R0 +Uet/R0 -C1*y1p  ;
		F[2] = -y2/R3 +  fcoef  *( exp((z1-y1-y2)/den) -1 ) -C2*y2p  ;
		F[3] = y3/R5 -z2/R5 +C3*y3p  ;
		F[4] = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 )   ;
		F[5] = y3/R5 -z2*(1/R4 +1/R5) +Ub/R2 -0.99*fcoef  *( exp((z1-y1-y2)/den) -1 )  ;
		// F(4)' = F(6)
		F[6] = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2)+ (Uept/R0) -0.01*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;
		// F(5)' = F(7)
		F[7] = y3p/R5 -z2p*(1/R4 +1/R5) - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;

		//fU2mU3p = fcoef *exp((z1-y1-y2)/den) ;
		//fU2mU3p2 = 0.01* fU2mU3p ;


		invJac[1][1] =    -(100*R1*R2*den+100*R0*R2*den+100*R0*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R0*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R0*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R0*R1-100*R2*R3*z1p*C2*R1-100*C2*R3*z1p*R0*R2-100*C2*R3*z1p*R0*R1+100*R2*R3*y1p*C2*R1+100*C2*R3*y1p*R0*R2+100*C2*R3*y1p*R0*R1+100*R2*R3*y2p*C2*R1+100*C2*R3*y2p*R0*R2+100*C2*R3*y2p*R0*R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[1][2] = fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[1][3] = 0 ;
	 
		invJac[1][4] = 100*R2*R1*(den+fcoef*exp(-(-z1+y1+y2)/den)*R3-z1p*C2*R3+y1p*C2*R3+y2p*C2*R3)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[1][5] = 0 ;
	 
		invJac[1][6] = -(100*C1*R1*R2*den+100*C1*R0*R2*den+100*C1*R0*R1*den+C1*fcoef*exp(-(-z1+y1+y2)/den)*R0*R1*R2+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R0*R2+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R0*R1+fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2*C2-100*C1*C2*R3*z1p*R1*R2-100*C1*C2*R3*z1p*R0*R2-100*C1*C2*R3*z1p*R0*R1+100*C1*C2*R3*y1p*R1*R2+100*C1*C2*R3*y1p*R0*R2+100*C1*C2*R3*y1p*R0*R1+100*C1*C2*R3*y2p*R1*R2+100*C1*C2*R3*y2p*R0*R2+100*C1*C2*R3*y2p*R0*R1)*R1*R2/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[1][7] =   1/99*(100*C1*R1*R2*den+100*C1*R0*R2*den+100*C1*R0*R1*den+100*R3*C2*den*R2+100*R3*C2*den*R1+C1*fcoef*exp(-(-z1+y1+y2)/den)*R0*R1*R2+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R0*R2+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R0*R1+fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2*C2-100*C1*C2*R3*z1p*R1*R2-100*C1*C2*R3*z1p*R0*R2-100*C1*C2*R3*z1p*R0*R1+100*C1*C2*R3*y1p*R1*R2+100*C1*C2*R3*y1p*R0*R2+100*C1*C2*R3*y1p*R0*R1+100*C1*C2*R3*y2p*R1*R2+100*C1*C2*R3*y2p*R0*R2+100*C1*C2*R3*y2p*R0*R1)*R1*R2/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;

		invJac[2][1] = 100*R3*(fcoef*exp(-(-z1+y1+y2)/den)-C2*z1p+C2*y1p+C2*y2p)*R2*R1/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[2][2] = -R3*(100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;



		invJac[2][3] = 0 ;
	 
		invJac[2][4] = -100*R3*(fcoef*exp(-(-z1+y1+y2)/den)-C2*z1p+C2*y1p+C2*y2p)*R2*R1/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[2][5] = 0 ;
	 
		invJac[2][6] = (fcoef*exp(-(-z1+y1+y2)/den)*C2*R1*R2-100*C1*C2*z1p*R1*R2+100*C1*C2*y1p*R1*R2+100*C1*C2*y2p*R1*R2+100*C2*den*R2+100*C2*den*R1+100*C1*fcoef*exp(-(-z1+y1+y2)/den)*R1*R2)*R1*R2*R3/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[2][7] = -1/99*(100*fcoef*fcoef*exp(-(-z1+y1+y2)/den)*exp(-(-z1+y1+y2)/den)*C1*R1*R1*R2*R2+200*R2*R2*den*C2*fcoef*exp(-(-z1+y1+y2)/den)*R1+200*R1*R1*den*C2*fcoef*exp(-(-z1+y1+y2)/den)*R2+fcoef*fcoef*exp(-(-z1+y1+y2)/den)*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2*C2-100*fcoef*exp(-(-z1+y1+y2)/den)*C1*C2*R1*R1*R2*R2*z1p+100*fcoef*exp(-(-z1+y1+y2)/den)*C1*C2*R1*R1*R2*R2*y1p+100*fcoef*exp(-(-z1+y1+y2)/den)*C1*C2*R1*R1*R2*R2*y2p+10000*R2*R2*den*den*C2+10000*R1*R1*den*den*C2+20000*R2*den*den*C2*R1)*R3/fcoef/exp(-(-z1+y1+y2)/den)/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[3][1] = -99*R4*fcoef*exp(-(-z1+y1+y2)/den)*R1*R2/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[3][2] =  -99*R3*fcoef*exp(-(-z1+y1+y2)/den)*(R2+R1)*R4/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[3][3] = R5+R4 ;
	  
		invJac[3][4] = 99*R4*fcoef*exp(-(-z1+y1+y2)/den)*R1*R2/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[3][5] = -R4 ;
	 
		invJac[3][6] = -99*fcoef*exp(-(-z1+y1+y2)/den)*(C1*R1*R2-R3*C2*R2-R3*C2*R1)*R1*R2*R4/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;

		invJac[3][7] = (-200*R2*den*R3*C2*R1-R2*R2*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*C2-R1*R1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2*C2+fcoef*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2*C1-100*R2*R2*den*R3*C2-100*R1*R1*den*R3*C2)*R4/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[4][1] = -R0 ;
	 
		invJac[4][2] = 0 ;
	 
		invJac[4][3] = 0 ;
	  
		invJac[4][4] = 0 ;
	  
		invJac[4][5] = 0 ;
	  
		invJac[4][6] = -R0*C1*R1*R2/(R2+R1) ;

		invJac[4][7] = 1/99*R0*C1*R1*R2/(R2+R1) ;
	  
		invJac[5][1] = -99*R4*fcoef*exp(-(-z1+y1+y2)/den)*R1*R2/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[5][2] = -99*R3*fcoef*exp(-(-z1+y1+y2)/den)*(R2+R1)*R4/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[5][3] = R4 ;
	 
		invJac[5][4] = 99*R4*fcoef*exp(-(-z1+y1+y2)/den)*R1*R2/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[5][5] = -R4;
	  
		invJac[5][6] = -99*fcoef*exp(-(-z1+y1+y2)/den)*(C1*R1*R2-R3*C2*R2-R3*C2*R1)*R1*R2*R4/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1);

		invJac[5][7] = (-200*R2*den*R3*C2*R1-R2*R2*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*C2-R1*R1*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2*C2+fcoef*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2*C1-100*R2*R2*den*R3*C2-100*R1*R1*den*R3*C2)*R4/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[6][1] = 0 ;
	 
		invJac[6][2] = 0 ;
	 
		invJac[6][3] = 0;
	  
		invJac[6][4] = 0;
	  
		invJac[6][5] = 0;
	 
		invJac[6][6] = R2*R1/(R2+R1) ;
	  
		invJac[6][7] = -1/99*R2*R1/(R2+R1) ;
	  
		invJac[7][1] = -100*R2*R1*(-z1p+y1p+y2p)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[7][2] = -100*R3*(R2+R1)*(-z1p+y1p+y2p)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		invJac[7][3] = 0 ;
	  
		invJac[7][4] = 100*R2*R1*(-z1p+y1p+y2p)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	  
		invJac[7][5] = 0;
	 
		invJac[7][6] = -(100*R2*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2-100*z1p*C1*R1*R2+100*R1*den+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1+100*y1p*C1*R1*R2+100*y2p*C1*R1*R2)*R1*R2/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;

		invJac[7][7] = 1/99*(-100*fcoef*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2*z1p*C1+100*fcoef*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2*y2p*C1+20000*R1*R2*den*den+100*fcoef*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2*y1p*C1+10000*R2*R2*den*den+10000*R1*R1*den*den+100*fcoef*fcoef*exp(-(-z1+y1+y2)/den)*exp(-(-z1+y1+y2)/den)*R1*R2*R2*R3+100*fcoef*fcoef*exp(-(-z1+y1+y2)/den)*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R3+20000*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1*R2*den+10000*R2*R2*den*fcoef*exp(-(-z1+y1+y2)/den)*R3+200*fcoef*exp(-(-z1+y1+y2)/den)*R1*R1*R2*den+200*fcoef*exp(-(-z1+y1+y2)/den)*R1*R2*R2*den+10000*R1*R1*den*fcoef*exp(-(-z1+y1+y2)/den)*R3+fcoef*fcoef*exp(-(-z1+y1+y2)/den)*exp(-(-z1+y1+y2)/den)*R1*R1*R2*R2)/fcoef/exp(-(-z1+y1+y2)/den)/(R2+R1)/(100*R3*y1p*C2*R2+100*R3*y1p*C2*R1+100*R3*y2p*C2*R2+100*R3*y2p*C2*R1+100*R2*den+100*R1*den+fcoef*exp(-(-z1+y1+y2)/den)*R1*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R2+100*fcoef*exp(-(-z1+y1+y2)/den)*R3*R1-100*R3*z1p*C2*R2-100*R3*z1p*C2*R1) ;
	 
		// act     JFvc = Jac\(-F) ;
		for(int i=1;i<=7;i++){
			JFvc[i]=0.0;
			for(int j=1;j<=7;j++)JFvc[i]+=invJac[i][j]*-F[j];
			xvc[i]+=JFvc[i] ;
		}

		k++;

		//clear all
		//return

		// xvc  = [ y1   ; y2   ; y3   ;  z1  ; z2   ; y1p  ; y2p ];

		y1 = xvc[1] ;
		y2 = xvc[2] ;
		y3 = xvc[3] ;
		z1 = xvc[4] ;
		z2 = xvc[5] ;
		y1p= xvc[6] ;
		y2p= xvc[7] ;

		maxAbsJFvc=0.0;
		for(int i=1;i<=7;i++)maxAbsJFvc=max(maxAbsJFvc,fabs(JFvc[i]));
	 
	}
	// ( while (k <= 2 ) & (max(abs(JFvc)) >= TOL))
	 
	// fprintf ( ' succ:  xvc = //10.5e \n', xvc ) ;       
	// fprintf ('y_{n+1}-fevalvo :  y1 = //10.5e , y2= //10.5e, y3= //10.5e, z1= //10.5e, z2= //10.5e , t= //7.2e  \n', y1, y2, y3, z1, z2, t ) ;


	double  fU2mU3p = fcoef *exp((z1-y1-y2)/den) ;
	double  fU2mU3p2 = 0.01* fU2mU3p ;

	double*y1tc=new double[szTblP1];
	double*y2tc=new double[szTblP1];
	double*y3tc=new double[szTblP1];
	double*z1tc=new double[szTblP1];
	double*z2tc=new double[szTblP1];
	  y1tc[1] = y1 ;
	  y2tc[1] = y2 ;
	  y3tc[1] = y3 ;
	  z1tc[1] = z1 ;
	  z2tc[1] = z2 ;

	  y1tc[2] = y1p ;
	  y2tc[2] = y2p ;
	  y3tc[2] = y3p ;

	// ********** ORIG EQUATIONS  : ****************
	double U1 = z1 ;
	double U2 = z1-y1 ;
	double U3 = y2 ;
	double U4 = z2 ;
	double U5 = z2 - y3 ;

	double U1p= z1p ;
	double U2p= z1p-y1p ;
	double U3p = y2p ;
	double U4p = z2p ;
	double U5p= z2p - y3p ;

	// act feval_node1zero = Uet/R0 -U1/R0 +C1*(U2p -U1p)
	// act feval_node2zero = Ub/R2 - U2*(1/R1 +1/R2) +C1*(U1p-U2p)-0.01*fcoef  *( exp((U2-U3)/den) -1 )
	// act feval_node3zero = fcoef  *( exp((U2-U3)/den) -1 ) -U3/R3 -C2*U3p
	// act feval_node4zero = Ub/R2 -U4/R4 +C3*(U5p - U4p) -0.99 *fcoef  *( exp((U2-U3)/den) -1 ) 
	// act feval_node5zero = -U5/R5 +C3*(U4p-U5p)

	// return

	// y1pp
	double y1pp = (-z1p/R0 + Uept/R0 )/C1 ;

	// act y1ppzero = -z1p/R0 + Uept/R0 -C1*y1pp

	// y2pp
	double y2pp = (-y2p/R3  + fU2mU3p *((z1p-y1p-y2p)/den))/C2 ;

	// act y2ppzero = -C2*y2pp - y2p/R3 + fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)

	double y3pp = (z2p/R5 -y3p/R5 )/C3 ;

	// act y3ppzero = C3*y3pp +y3p/R5-z2p/R5

	// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
	// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

	// act node1pzero= -z1p/R0 +Uept/R0 -C1*y1pp
	// act node3pzero= -y2p/R3 + fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -C2*y2pp
	// act node5pzero = y3p/R5 -z2p/R5 +C3*y3pp

	// act AE2pzero = y3p/R5 -z2p*(1/R4 +1/R5) - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)

	// return

	 U1=z1 ;
	 U2=z1-y1 ;
	 U3=y2 ;
	 U4=z2 ;
	 U5= z2-y3 ;

	// fprintf ('corr-feval :  U1 = //10.5e , U2=//10.5e,  U3= //10.5e, U4= //10.5e, U5= //10.5e  \n', U1, U2,  U3, U4, U5 ) ;

	// fprintf ('corr-feval :  Uet = //10.5e , z2=//10.5e,  y3= //10.5e, U5= //10.5e  \n', Uet, z2,  y3, U5 ) ;

	// fprintf ('corr-feval :  Uet = //10.5e , z1= //10.5e, y1p= //10.5e, y1= //10.5e, z1= //10.5e  \n', Uet,  z1, y1p, y1, z1 ) ;

	// fprintf ('corr-feval :  z1p = //10.5e , z2p= //10.5e, y1p= //10.5e, y2p= //10.5e, y3p= //10.5e  \n', z1p, z2p, y1p, y2p, y3p ) ;

	// fprintf ('corr-feval :  z1p = //10.5e , z2p= //10.5e, y1pp= //10.5e, y2pp= //10.5e, y3pp= //10.5e  \n', z1p, z2p, y1pp, y2pp, y3pp ) ;


	// ********** OK )) ******************

	// *** (( Uettc(1..)
	 double*Uettc=new double[szTblP1];
	  Uettc[1] = 0.4*sin(om*t) ;
	  Uettc[2] = 0.4*cos(om*t)*om  ;
	  Uettc[3] = - Uettc[1]*om*om/ft[2]  ;
	  for (int idx=3;idx<=ord+4;idx++){
		 Uettc[1+idx] = - ft[idx-2]*Uettc[idx-1]*om*om/ft[idx]  ;
		 //  Uettc(3) : Tayl coef 2 = der2/2! 
		 //Uettc(1+idx+2) = -0.4*cos(om*t)* (om)^(idx+2)/ft(idx+2)  ;
	  }
	// ***  Uettc(1..) )) ***


	  Uettc[1] = 0.4*sin(om*t) ;
	//////  Uettc(3) : Tayl coef 2 = der2/2! 
	//Uettc1zero =  Uettc(2) - 0.4*cos(om*t)*om 
	//Uettc2zero =  Uettc(3) - -0.4*sin(om*t)*om^2/ft(2) 
	//Uettc3zero =  Uettc(1+3) - -0.4*cos(om*t)*om^3/ft(3) 
	//Uettc4zero =  Uettc(1+4) -  0.4*sin(om*t)*om^4/ft(4) 
	//Uettc5zero =  Uettc(1+5) -  0.4*cos(om*t)*om^5/ft(5) 
	//Uettc6zero =  Uettc(1+6) - -0.4*sin(om*t)*om^6/ft(6) 
	//Uettc7zero =  Uettc(1+7) - -0.4*cos(om*t)*om^7/ft(7) 
	//Uettc8zero =  Uettc(1+8) -  0.4*sin(om*t)*om^8/ft(8) 
	//Uettc9zero =  Uettc(1+9) -  0.4*cos(om*t)*om^9/ft(9) 
	//Uettc10zero=  Uettc(1+10)- -0.4*sin(om*t)*om^10/ft(10) 
	//Uettc11zero=  Uettc(1+11)- -0.4*cos(om*t)*om^11/ft(11) 
	//Uettc12zero=  Uettc(1+12)-  0.4*sin(om*t)*om^12/ft(12) 
	// ***** prespos verif Uettc(1+idx)
	//clear all
	//return


	  z1tc[2] = z1p ;
	  z2tc[2] = z2p ;

	  y1tc[3] = y1pp/ft[2] ;
	  y2tc[3] = y2pp/ft[2] ;
	  y3tc[3] = y3pp/ft[2] ;


	  // y2tccopy(2) =  (- y2tc(1)/R3  + fcoef  * (expz1y1y2(1)-1) )/C2 ;
	  // act y2tccopy(2) =  (- y2/R3  + fcoef  * (exp((z1-y1-y2)/den)-1) )/C2 ;
	  // OK: y2tc1zero = y2tc(2)-y2tccopy(2)


	  // OK: expz1y1y2_1zero = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -expz1y1y2(2) 
	  // y2tccopy(3) =  (- y2tc(2)/R3  + fcoef  * expz1y1y2(2) )/C2/2 ;
	  // ok y2tc2zero = y2tc(3)-y2tccopy(3)


	  //z1y1y2(1) = (z1-y1-y2)/den ;
	  //z1y1y2(2) = (z1p-y1p-y2p)/den ;
		double*y1y2=new double[szTblP1];

	  y1y2[1] = (y1+y2)/den ;
	  y1y2[2] = (y1tc[2]+y2tc[2])/den ;
	// y1y2(3): Tayl coef 2 = der2/2!
	  y1y2[3] = (y1tc[3]+y2tc[3])/den ;

	  double*expzyy=new double[szTblP1];
	  expzyy[1] = expz1y1y2[1]* y1y2[2] ;

	// (( m=1 , 
	//   differentiation { exp((z1-y1-y2)/den)*(( y1p+y2p)/den) } p 527
	  double smexpzyy = 0.0 ;
	  for (int jdx=0;jdx<=1;jdx++){
		 smexpzyy = smexpzyy + expz1y1y2[2-jdx]* (jdx+1)* y1y2[1+jdx+1] ;
	  }
	  expzyy[2] = smexpzyy ;
	// ***))

	  //expzyyo1zero =expz1y1y2(2)* y1y2(2) +expz1y1y2(1)*2*y1y2(3)  -expzyy(2)
	  // ok expzyyo1zero2 = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)*(( y1p+y2p)/den) + exp((z1-y1-y2)/den)*(( y1pp+y2pp)/den) -expzyy(2)

	  // OK AAcopy(1) = ((1/R1 +1/R2)*y1p+ Uept/R0 - fU2mU3p2*( -(y1p+y2p)/den ) ) ;
	  double*AA=new double[szTblP1];
	  double*BB=new double[szTblP1];
	  AA[1] = (1/R1 +1/R2)*y1tc[2]+ Uettc[2]/R0 + 0.01*fcoef * expzyy[1] ;
	  // ok: AAzero3 = AA(1)-AAcopy(1)

	  // ok: BBcopy(1) = (1/R0 +1/R1 +1/R2 + fU2mU3p2/den ) ;
	  BB[1] = 1/R0 +1/R1 +1/R2 + 0.01*fcoef * expz1y1y2[1]/den ;
	  // ok: BBzero3 = BB(1)-BBcopy(1)

	// differentiation { AA(1) }
	//     AA(1) = ((1/R1 +1/R2)*y1p+ Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den) *( -(y1p+y2p)/den ) ) 
	//    => AA(2) = ...

	// => 

	  AA[2] = ((1/R1 +1/R2)*(2)*y1tc[3]+ (2)*  Uettc[3]/R0 + 0.01*fcoef * expzyy[2]) ;


	// BB(1)=(1/R0 +1/R1 +1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den  )

	  BB[2] = 0.01*fcoef * expz1y1y2[2]/den ;

	// differentiation { A/B }
	//    z1p = A/B => z1^{(1)} = 1/B^0(t) {A^{(1)}(t) - sm[z1^{(2-i)} * B^{(i)}(t) ] }  
	  //z1pzero = AA(1)/BB(1)- z1p

	  double smBz = z1tc[2]*BB[2] ;
	   
	  z1tc[3] = (AA[2] - smBz )/BB[1]/(2) ;

	//// z1p*B=A => verif:
	//  smxy = 0.0;
	//  for idx=0:1
	//     smxy = smxy + (2-idx)* z1tc(2-idx+1)*BB(1+idx) ;
	//  end;
	//  // OK: AAzero = AA(2)-smxy

	  // ********* verif (B*z1p)' = A' **************
	  // OK: AAzero=BB(1)*z1tc(3)+BB(2)*z1tc(2)-AA(2)
	  // OK: z1tc2zero = AA(2)/BB(1)+AA(1)*(-BB(2)/BB(1)^2) -z1tc(3 )

	// f(z1-y1-y2 ) = ffU2mU3 = fcoef  *( exp((z1-y1-y2)/den) -1 ) ;

	 z1y1y2[3] = (z1tc[3] -y1tc[3] -y2tc[3])/den ;

	 smexpz1y1y2 = 0.0 ;
	 for (int jdx=0;jdx<=1;jdx++){
		smexpz1y1y2 = smexpz1y1y2 + (2-jdx)*z1y1y2[3-jdx] *expz1y1y2[1+jdx] ;
	 }
	 expz1y1y2[3] =  smexpz1y1y2/(2) ;

	// OK: expz1y1y2_1zero = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -expz1y1y2(2) 
	// OK:   expz1y1y2_1zero2 = expz1y1y2(1) * z1y1y2(2) -expz1y1y2(2) 

	// act expz1y1y2_2zero =  exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)^2 + exp((z1-y1-y2)/den)*((z1pp-y1pp-y2pp)/den) -expz1y1y2(3)*2

	// =>
	// ok 
	// act expz1y1y2_2zero2 = z1y1y2(3)*2*expz1y1y2(1) +z1y1y2(2) *expz1y1y2(2) -expz1y1y2(3)*2 

	// ok : z1pzero2 = (1/R1 + 1/R2)*y1tc(2) + Uettc(2)/R0 - 0.01* fcoef *expz1y1y2(2) -( z1tc(2)*(1/R0+1/R1+1/R2)  )

	//  z1pzero = (1/R1 + 1/R2)*y1p + Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den)*(-(y1p+y2p)/den) -( z1p*(1/R0 +1/R1+1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den )  )


	// OK z1ppzero = (1/R1 + 1/R2)*y1tc(3) +Uettc(3)/R0 + 0.01* fcoef* expzyy(2) - ( z1tc(3) *(1/R0 +1/R1+1/R2 +0.01* fcoef *expz1y1y2(1)) +z1tc(2) *( 0.01* fcoef *expz1y1y2(2)) )



	//   z2p = (y3p/R5 -0.99*fcoef *expz1y1y2(2) )/(1/R4+1/R5) ;
	 z2tc[3] = ( y3tc[3]/R5 - 0.99*fcoef * expz1y1y2[3])/(1/R4+1/R5) ;

	// ok z2pzero = y3p/R5 -z2p*(1/R4+1/R5) -0.99* fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)
	// ok z2ppzero = y3tc(3)/R5 -z2tc(3)*(1/R4+1/R5) -0.99* fcoef *expz1y1y2(3)


	//  y1ppp   = ( z1pp/R0 - Uetpp/R0 )/C1  =>
	//     y1tc(4)  = ( z1tc(3)/R0 - Uettc(3)/R0 )/C1/(3) ;
	 y1tc[4]  = ( -z1tc[3]/R0 + Uettc[3]/R0 )/C1/(3) ;

	// simil.:  y2ppp = (- y2pp/R3  + fcoef * expz1y1y2pp )/C2 =>
	//     y2tc(4) = (- y2tc(3)/R3  + fcoef  * expz1y1y2(3) )/C2/(3) ;

	 y2tc[4] = (- y2tc[3]/R3  + fcoef  * expz1y1y2[3] )/C2/(3) ;

	// y3ppp
	 y3tc[4] = ( z2tc[3]/R5 - y3tc[3]/R5 )/C3/(3) ;

	// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
	// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

	// act node1ppzero = -z1tc(3)/R0 +Uettc(3)/R0 -C1*y1tc(1+3)*3
	// act node3ppzero= -y2tc(3)/R3 + fcoef *expz1y1y2(3) -C2*y2tc(1+3)*3

	// node5 eq = F(3)
	// act node5ppzero = y3tc(3)/R5 -z2tc(3)/R5 +C3*y3tc(1+3)*3



	//  return

	// *************** m = 2 ;*************************
	m = 2 ;

	// y1y2(3): Tayl coef 2 = der2/2!
	  y1y2[4] = (y1tc[4]+y2tc[4])/den ;

	// (( m=1 , 
	//   differentiation { exp((z1-y1-y2)/den)*(( y1p+y2p)/den) } p 527
	  smexpzyy = 0.0 ;
	  for (int jdx=0;jdx<=2;jdx++){
		 smexpzyy = smexpzyy + expz1y1y2[3-jdx]* (jdx+1)* y1y2[1+jdx+1] ;
	  }
	  expzyy[3] = smexpzyy ;
	// ***))

	//  verif expzyy(3)

	// differentiation { AA(1) }
	//     AA(1) = ((1/R1 +1/R2)*y1p+ Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den) *( -(y1p+y2p)/den ) ) 
	//    => AA(2) = ...

	// origtmp  AA(3) = (1/R1 +1/R2)*y1tc(4)+  Uettc(4)/R0 + 0.01*fcoef*expzyy(3) ;


	  AA[3] = ((1/R1 +1/R2)*(3)*y1tc[4]+ (3)*  Uettc[4]/R0 +  0.01*fcoef *  expzyy[3]) ;

	// BB(1)=(1/R0 +1/R1 +1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den  )

	  BB[3] = 0.01*fcoef * expz1y1y2[3]/den ;


	  //  *******************************************************************************
	  //  gen. Tayl Coeffs:   y1tc() ;   y2tc() ;   y3tc()  ;  z1tc()  ; z2tc()  ;   
	  //  using Pryce's System Jacobian
	  //  *******************************************************************************

	// differentiation { z1 = A/B }
	//    z1p = A/B => z1^{(2)} = 1/B^0(t) {A^{(2)}(t) - sm[z1^{(3-i)} * B^{(i)}(t) ] }  
	//  z1pzero = AA(1)/BB(1)- z1p

	  smBz = 0.0 ;
	  for (int jdx=1;jdx<=2;jdx++){
		 smBz=smBz + (3-jdx)* z1tc[3-jdx+1]*BB[1+jdx] ;
	  }
	  z1tc[4] = (AA[3] - smBz )/BB[1]/(3) ;

	// ok B0zero = (1/R0 +1/R1+1/R2 +0.01* fcoef *expz1y1y2(1)/den) - BB(1)


	// ok z1pzero = (1/R1 + 1/R2)*y1tc(2) + Uettc(2)/R0 + 0.01* fcoef *expzyy(1) -( z1p* (1/R0 +1/R1+1/R2 + 0.01* fcoef *expz1y1y2(1)/den )  )


	//  z1ppzero = (1/R1 + 1/R2)*2* y1tc(3) + 2* Uettc(3)/R0 + 0.01* fcoef* expzyy(2) - ( 2* z1tc(3) *(1/R0 +1/R1+1/R2 +0.01* fcoef *expz1y1y2(1)/den) +z1tc(2) *( 0.01* fcoef *expz1y1y2(2)/den) )


	  // ********* verif (B*z1p)' = A' **************
	  // OK: AAzero=BB(1)*z1tc(3)+BB(2)*z1tc(2)-AA(2)
	  // OK: z1tc2zero = AA(2)/BB(1)+AA(1)*(-BB(2)/BB(1)^2) -z1tc(3 )

	// f(z1-y1-y2 ) = ffU2mU3 = fcoef  *( exp((z1-y1-y2)/den) -1 ) ;

	 z1y1y2[4] = (z1tc[4] -y1tc[4] -y2tc[4])/den ;

	 smexpz1y1y2 = 0.0 ;
	 for (int jdx=0;jdx<=2;jdx++){
		smexpz1y1y2 = smexpz1y1y2 + (3-jdx)*z1y1y2[4-jdx] *expz1y1y2[1+jdx];
	 }
	 expz1y1y2[4] =  smexpz1y1y2/(3) ;

	// ok expz1y1y2_3zero = (3*z1y1y2(1+3)*expz1y1y2(1) + 2*z1y1y2(3) *expz1y1y2(2) + z1y1y2(2) *expz1y1y2(3))/3 -expz1y1y2(1+3) 


	//   z2p = (y3p/R5 -0.99*fcoef *expz1y1y2(2) )/(1/R4+1/R5) ;
	 z2tc[4] = ( y3tc[4]/R5 - 0.99*fcoef * expz1y1y2[4])/(1/R4+1/R5) ;

	//  y1ppp   = ( z1pp/R0 - Uetpp/R0 )/C1  =>
	//     y1tc(3+2)  = ( z1tc(4)/R0 - Uettc(4)/R0 )/C1/(4) ;
	 y1tc[5]  = ( -z1tc[4]/R0 + Uettc[4]/R0 )/C1/(4) ;

	// simil.:  y2ppp = (- y2pp/R3  + fcoef * expz1y1y2pp )/C2 =>
	//     y2tc(3+2) = (- y2tc(4)/R3  + fcoef  * expz1y1y2(4) )/C2/(4) ;
	 y2tc[5] = (- y2tc[4]/R3  + fcoef  * expz1y1y2[4] )/C2/(4) ;

	// y3ppp
	 y3tc[5] = ( z2tc[4]/R5 - y3tc[4]/R5 )/C3/(4) ;



	// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
	// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

	// act node1pppzero = -z1tc(1+3)/R0 +Uettc(1+3)/R0 -C1*y1tc(1+4)*4
	// act node3pppzero = -y2tc(1+3)/R3 + fcoef *expz1y1y2(1+3) -C2*y2tc(1+4)*4

	// node5 eq = F(3)
	// act node5pppzero = y3tc(1+3)/R5 -z2tc(1+3)/R5 +C3*y3tc(1+4)*4


	// ok 
	//AlgEq1pppzero = (1/R1 + 1/R2)*3* y1tc(1+3) + 3* Uettc(1+3)/R0 + 0.01* fcoef* expzyy(3) - ( 3* z1tc(1+3) *(1/R0 +1/R1+1/R2 +0.01* fcoef *expz1y1y2(1)/den) +2* z1tc(3) *( 0.01* fcoef *expz1y1y2(2)/den) +z1tc(3) *( 0.01* fcoef *expz1y1y2(2)/den) +z1tc(2) *( 0.01* fcoef *expz1y1y2(3)/den) )

	// act AlgEq1pppzero2 = (1/R1 + 1/R2)* y1tc(1+3) -z1tc(1+3)*(1/R0+1/R1+1/R2) +  Uettc(1+3)/R0 - 0.01*  fcoef*expz1y1y2(1+3)

	// (alg Eq1)' = F(4)' 

	// act AlgEq2pppzero = y3tc(1+3)/R5 -z2tc(1+3)*(1/R4 +1/R5) - 0.99*fcoef*expz1y1y2(1+3)

	//  return


	// *************** m = 3 ;*************************
	// m = 3 ;

	for (int mIdx=3;mIdx<=ord-1;mIdx++){
		m=mIdx;
		// y1y2(3): Tayl coef 2 = der2/2!
		  y1y2[1+m+1] = (y1tc[1+m+1]+y2tc[1+m+1])/den ;

		// ((  
		//   differentiation { exp((z1-y1-y2)/den)*(( y1p+y2p)/den) } p 527
		  smexpzyy = 0.0 ;
		  for (int jdx=0;jdx<=m;jdx++){
			 smexpzyy = smexpzyy + expz1y1y2[1+m-jdx]* (jdx+1)* y1y2[1+jdx+1];
		  }
		  expzyy[1+m] = smexpzyy ;
		// ***))

		//  verif expzyy(1+m)

		// ok expzyyo2zero =  expz1y1y2(3)* y1y2(2) + expz1y1y2(2)* 2* y1y2(3) + expz1y1y2(1)* 3* y1y2(1+3)  -expzyy(3)


		// differentiation { AA(1) }
		//     AA(1) = ((1/R1 +1/R2)*y1p+ Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den) *( -(y1p+y2p)/den ) ) 
		//    => AA(2) = ...


		  AA[1+m] = ((1/R1 +1/R2)*(m+1)*y1tc[1+m+1]+ (m+1)*  Uettc[1+m+1]/R0 +  0.01*fcoef *  expzyy[1+m]) ;

		// BB(1)=(1/R0 +1/R1 +1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den  )

		  BB[1+m] = 0.01*fcoef * expz1y1y2[1+m]/den ;


		  //  *******************************************************************************
		  //  gen. Tayl Coeffs:   y1tc() ;   y2tc() ;   y3tc()  ;  z1tc()  ; z2tc()  ;   
		  //  using Pryce's System Jacobian
		  //  *******************************************************************************

		  // differentiation { A/B }
		  //    z1p = A/B => z1^{(m)} = 1/B^0(t) {A^{(m)}(t) - sm[z1^{(m+1-i)} * B^{(i)}(t) ] }  
		  //  z1pzero = AA(1)/BB(1)- z1p

		  smBz = 0.0 ;
		  for (int jdx=1;jdx<=m;jdx++)
			 smBz=smBz + (m+1-jdx)* z1tc[m+1-jdx+1]*BB[1+jdx] ;
		  
		  z1tc[1+m+1] = (AA[1+m] - smBz )/BB[1]/(m+1) ;


		 z1y1y2[1+m+1] = (z1tc[1+m+1] -y1tc[1+m+1] -y2tc[1+m+1])/den ;

		 smexpz1y1y2 = 0.0 ;
		 for (int jdx=0;jdx<=m;jdx++)
			smexpz1y1y2 = smexpz1y1y2 + (m+1-jdx)*z1y1y2[1+m+1-jdx] *expz1y1y2[1+jdx] ;
		 
		 expz1y1y2[1+m+1] =  smexpz1y1y2/(m+1) ;

		// ok expz1y1y2_3zero = (3*z1y1y2(1+3)*expz1y1y2(1) + 2*z1y1y2(3) *expz1y1y2(2) + z1y1y2(2) *expz1y1y2(3))/3 -expz1y1y2(1+3) 


		//   z2p = (y3p/R5 -0.99*fcoef *expz1y1y2(2) )/(1/R4+1/R5) ;
		 z2tc[1+m+1] = ( y3tc[1+m+1]/R5 - 0.99*fcoef * expz1y1y2[1+m+1])/(1/R4+1/R5) ;

		//  y1ppp   = ( z1pp/R0 - Uetpp/R0 )/C1  =>
		//     y1tc[1+m+2]  = ( z1tc[1+m+1]/R0 - Uettc[1+m+1]/R0 )/C1/(m+2) ;
		 y1tc[1+m+2]  = ( -z1tc[1+m+1]/R0 + Uettc[1+m+1]/R0 )/C1/(m+2) ;

		// simil.:  y2ppp = (- y2pp/R3  + fcoef * expz1y1y2pp )/C2 =>
		//     y2tc[1+m+2] = (- y2tc[1+m+1]/R3  + fcoef  * expz1y1y2[1+m+1] )/C2/(m+2) ;
		 y2tc[1+m+2] = (- y2tc[1+m+1]/R3  + fcoef  * expz1y1y2[1+m+1] )/C2/(m+2) ;

		// y3ppp
		 y3tc[1+m+2] = ( z2tc[1+m+1]/R5 - y3tc[1+m+1]/R5 )/C3/(m+2) ;


	}
	// (end for m=3:ord-1)


	yvalvo[1][1] =y1; yvalvo[1][2] =y2; yvalvo[1][3] =y3; yvalvo[1][4] =y1p ; yvalvo[1][5] =y2p ;  yvalvo[1][6] =y3p;
	for (int idx=1;idx<=ord;idx++){ 
	   yvalvo[idx+1][1]=y1tc[1+idx]*ft[idx] ; 
	   yvalvo[idx+1][2]=y2tc[1+idx]*ft[idx]; 
	   yvalvo[idx+1][3]=y3tc[1+idx]*ft[idx] ; 
	   yvalvo[idx+1][4]=y1tc[1+idx+1]*ft[idx+1] ; 
	   yvalvo[idx+1][5]=y2tc[1+idx+1]*ft[idx+1]; 
	   yvalvo[idx+1][6]=y3tc[1+idx+1]*ft[idx+1] ;
	}


	// Ex:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)

	// Ex:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)

	//free memory
	delete F;
	delete ft;
	delete z1y1y2;
	delete expz1y1y2;
	delete xvc;
	delete JFvc;
	for(int i=1;i<=7;i++)delete invJac[i];
	delete invJac;
	delete y1tc;
	delete y2tc;
	delete y3tc;
	delete z1tc;
	delete z2tc;
	delete Uettc;
	delete y1y2;
	delete expzyy;
	delete AA;
	delete BB;
}	
static void f(double t, double*yyvc, int ord,double TOL,double**yvalvo, int nbcmp){
	// amplifier prob p379,  Hairer
	// tend = 0.2 TOL = 1e-4, Radau5 accepted 556 steps 

	// Newton method p 611, Burden Faires

	// k_d = -max_j d_j = -1 =>
	// stage k= k_d = -1: solve for Tayl coeffs y1 ,   y2,   y3 ,  z1 , z2 ;
	//    F(4) = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 )   ;
	//    F(5) = y3/R5 -z2*(1/R4 +1/R5) +Ub/R2 -0.99*fcoef  *( exp((z1-y1-y2)/den) -1 )  ;
	//
	// stage k=0: solve for Tayl coeffs  y1p ;   y2p;   y3p ;  z1p ; z2p , 5 lin eq :
	//             y1p ;   y2p;   y3p ;  z1p ; z2p   
	//    F(1) = -z1/R0 +Uet/R0 -C1*y1p  ;
	//    F(2) = -y2/R3 +  fcoef  *( exp((z1-y1-y2)/den) -1 ) -C2*y2p  ;
	//    F(3) = y3/R5 -z2/R5 +C3*y3p  ;
	//        (F(4)' = F(6))
	//    F(6) = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2)+ (Uept/R0) -0.01*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;
	//        (F(5)' = F(7))
	//    F(7) = y3p/R5 -z2p*(1/R4 +1/R5) - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) ;


	// corrector & f eval


	// input t, yyvc(1),yyvc(2) ,
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13 ;
	double*ft=new double[18];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;

	//  Taylor output: y1, y2, y3, y1p, y2p, y3p (nbcmp=6)
	//  Newton iter output: y1, y2, y3, z1, z2  (5 var, 5 eq)
	//    =>  U1=z1 ; U2 = z1-y1 ; U3 = y2 ; U4 = z2 ; U5 = z2 - y3

	double C1 = 1e-6 ,C2 = 2*C1  ,C3 = 3*C1,R0 = 1000.0 ,R1 = 9000.0 ;
	double R2 = 9000.0 ,R3 = 9000.0 ,R4 = 9000.0 ,R5 = 9000.0 ;


	//C1 = 0.001 ;
	//C2 = 2*C1 ;  
	//C3 = 3*C1 ;
	//R0 = 100 ;
	//R1 = 900 ;
	//R2 = 900 ;
	//R3 = 900 ;
	//R4 = 900 ;
	//R5 = 900 ;



	// C1 = 0.8 ;C2 = 0.82*C1 ;  C3 = 0.83*C1 ;R0 = 1.2 ;R1 = 1.4 ;R2 = 1.4 ;R3 = 1.4 ;R4 = 1.4 ;R5 = 1.4 ;

	double pi=3.141592653589793238462643383279502884197169399375105820974944592;
	// act 
	double om=200*pi ;
	// om= 5 ;
	// tmp om*t = rem(om*t,2*pi ) ; 

	double Uet = 0.4*sin(om*t) ;
	double Uept = 0.4*cos(om*t)*om ;

	// Init :
	double Ub = 6.0 ;

	 // expy   = yyvc(1) ;
	 double y1     = yyvc[1] ;
	 double y2     = yyvc[2] ;
	 double y3     = yyvc[3] ;
	 double y1p    = yyvc[4] ;
	 double y2p    = yyvc[5] ;
	 double y3p    = yyvc[6] ;


	//Uet = 0.4*sin(om*t) ;
	//Uept = 0.4*cos(om*t)*om ;

	// eq F(1)=0 & F(3)=0 =>  guess z1, z2:
	double z1 =  (Uet/R0 -C1*y1p)*R0 ;
	double z2 =   (y3/R5 +C3*y3p )*R5 ;
	// orig
	double den= 0.026 ;
	// den = 2.2 ;
	// den=1.0 ;
	// act
	double fcoef=1e-6 ;
	// fcoef=0.90 ;
	// fcoef=1.0 ;

	double ffU2mU3 = fcoef  *( exp((z1-y1-y2)/den) -1 ) ;

	// fprintf ('corr-feval :  y1 = //10.5e , y2= //10.5e, y3= //10.5e, z1= //10.5e, z2= //10.5e , t= //7.2e  \n', y1, y2, y3, z1, z2, t ) ;

	// fprintf ('corr-feval :  y1p = //10.5e , y2p= //10.5e, y3p= //10.5e  \n', y1p, y2p, y3p ) ;


	// Alg. Eq 1 :   F(4) = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 ) = 0   ;
	// Alg. Eq 2 :   F(5) = y3/R5 -z2*(1/R4 +1/R5) +Ub/R2 -0.99*fcoef  *( exp((z1-y1-y2)/den) -1 ) = 0 ;

	// act  while (k <= N )
	// while (k <= 99 ) & (max(abs(JFvc)) >= TOL)

		// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
		// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

		// prespos : enl sys: 7 eq
		

	double	fU2mU3p = fcoef *exp((z1-y1-y2)/den) ;
	double	fU2mU3p2 = 0.01* fU2mU3p ;

	////          y1 ; y2; y3 ;  z1 ; z2 
	//    Jac= [ 0,   0,   0,  -1/R0,  0  ; ...
	//       -fU2mU3p/den, (-1/R3-fU2mU3p/den), 0, +fU2mU3p/den, 0 ; ...
	//           0,   0,  1/R5,    0,   -1/R5 ; ...
	//       1/R1+1/R2+fU2mU3p2/den, +fU2mU3p2/den,    0, (-1/R0-1/R1-1/R2-fU2mU3p2/den),    0 ; ...
	//     +0.99*fU2mU3p/den, +0.99*fU2mU3p/den,  1/R5,   -0.99*fU2mU3p/den, -(1/R4+1/R5)   ] ; 

		//JFvc = inv(Jac)*(-F) ;
		//xvc = xvc+JFvc ;

		//k = k+1 ;

		//clear all
		//return

		//y1 = xvc(1) ;
		//y2 = xvc(2) ;
		//y3 = xvc(3) ;
		//z1 = xvc(4) ;
		//z2 = xvc(5) ;

	// end;
	//// ( while (k <= 2 ) & (max(abs(JFvc)) >= TOL))
	 
	// fprintf ( ' succ:  xvc = //10.5e \n', xvc ) ;       
//	 fprintf ('y_{n+c_i}-fevalder1 :  y1 = //10.5e , y2= //10.5e, y3= //10.5e, z1= //10.5e, z2= //10.5e , t= //7.2e  \n', y1, y2, y3, z1, z2, t ) ;
	int szTbl=ord+10;
	int szTblP1=szTbl+1;
	double*y1tc=new double[szTblP1];
	double*y2tc=new double[szTblP1];
	double*y3tc=new double[szTblP1];
	double*z1tc=new double[szTblP1];
	double*z2tc=new double[szTblP1];
	  y1tc[1] = y1 ;
	  y2tc[1] = y2 ;
	  y3tc[1] = y3 ;
	  z1tc[1] = z1 ;
	  z2tc[1] = z2 ;

	  y1tc[1+1] = y1p ;
	  y2tc[1+1] = y2p ;
	  y3tc[1+1] = y3p ;


	// Alg. Eq 1 :   F(4) = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 ) = 0   ;
	// act   z1zero = (1/R1+1/R2)*y1 -z1*(1/R0 +1/R1 + 1/R2) +Uet/R0 +Ub/R2 -0.01*fcoef*( exp((z1-y1-y2)/den) -1 ) 
	//  => z1pzero =  (1/R1+1/R2)*y1p -z1p*(1/R0 +1/R1 + 1/R2) +Uept/R0  -0.01*fcoef* exp((z1-y1-y2)/den) * (z1p-y1p-y2p)/den    ;

	// Alg Eq 1 =>  z1p = ..
	// ok  z1p = ((1/R1 +1/R2)*y1p+ Uept/R0 - fU2mU3p2*( -(y1p+y2p)/den ) )/(1/R0 +1/R1 +1/R2 + fU2mU3p2/den  ) ;


	  double z1p = ((1/R1 +1/R2)*y1p+ Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den)*( -(y1p+y2p)/den ) )/(1/R0 +1/R1 +1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den  ) ;

	// f'(z1-y1-y2) = fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)
	// act  z1pzero =  (1/R1+1/R2)*y1p -z1p*(1/R0 +1/R1 + 1/R2) +Uept/R0  -0.01*fcoef* exp((z1-y1-y2)/den) * (z1p-y1p-y2p)/den    

	// act z1p = ((1/R1 +1/R2)*y1p+ Uept/R0 -0.01*fcoef *exp((z1-y1-y2)/den)*(( -y1p-y2p)/den) )/(1/R0+1/R1+1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den) ;

	// Alg Eq 2 =>  z2p = ..


	   int m=1 ;
	   // **((
	   // m=1 , expz1y1y2(1+m) = smexpz1y1y2 p 527
	   // differentiation { exp((z1-y1-y2)/den) }
		double*z1y1y2=new double[szTblP1];
		double*expz1y1y2=new double[szTblP1];
	   z1y1y2[1] = (z1-y1-y2)/den ;
	   z1y1y2[1+1] = (z1p-y1p-y2p)/den ;

	   expz1y1y2[1] = exp((z1-y1-y2)/den) ;
	   double smexpz1y1y2 = z1y1y2[1+m] *expz1y1y2[1];
	   
	   expz1y1y2[1+m] = smexpz1y1y2 ;

	   //expz1y1y2_1zero = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -expz1y1y2(1+1) 
	   //expz1y1y2_1zero2 = expz1y1y2(1) * z1y1y2(1+1) -expz1y1y2(1+1) 


	  double z2p = (y3p/R5 -0.99*fcoef *expz1y1y2[1+1] )/(1/R4+1/R5) ;

	// ok  z2pzero = y3p/R5 -z2p*(1/R4+1/R5) -0.99* fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)
	// ok:  z2p=   (y3p/R5 - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den))/(1/R4 +1/R5) ;


	//// **********(( Pryce's System Jacobian OK: **************
	//// (1) SYSTEM JAC. A_MAT ( gen. Tayl Coeffs: y1p ;   y2p;   y3p ;  z1p ; z2p ; ) 
	//A_MAT = ...
	//[    -C1,      0,      0,      0,      0; ...
	//      0,    -C2,      0,      0,      0 ; ...
	//      0,      0,     C3,      0,      0 ; ...
	// 1/R1+1/R2+1/100*fcoef*exp((z1-y1-y2)/den)/den, 1/100*fcoef*exp((z1-y1-y2)/den)/den,   0, -1/R0-1/R1-1/R2-1/100*fcoef*exp((z1-y1-y2)/den)/den,      0 ; ...
	//      99/100*fcoef*exp((z1-y1-y2)/den)/den,      99/100*fcoef*exp((z1-y1-y2)/den)/den,   1/R5,     -99/100*fcoef*exp((z1-y1-y2)/den)/den,     -1/R4-1/R5] ;
	//
	//RHS1 = z1/R0 -Uet/R0 ;
	//RHS2 = y2/R3 -  fcoef  *( exp((z1-y1-y2)/den) -1 ) ;
	//RHS3 = -y3/R5 +z2/R5   ;
	//RHS4 = - (Uept/R0)  ;
	//RHS5 = 0.0 ;

	//RHS = [ RHS1; RHS2; RHS3; RHS4 ; RHS5 ] ;
	//
	//b_v = A_MAT\RHS ;

	//bv1zero = b_v(1)-y1p
	//bv2zero = b_v(2)-y2p
	//bv3zero = b_v(3)-y3p
	//bv4zero = b_v(4)-z1p
	//bv5zero = b_v(5)-z2p

	// fprintf ('y_{n+c_i}-fevalder1 :  y1p = //10.5e , y2p= //10.5e, y3p= //10.5e, z1p= //10.5e, z2p= //10.5e , t= //7.2e  \n', y1p, y2p, y3p, z1p, z2p, t ) ;
	//// ********** Pryce's System Jacobian OK: )) **************



	// ********** ORIG EQUATIONS  : ****************
	double U1 = z1 ;
	double U2 = z1-y1 ;
	double U3 = y2 ;
	double U4 = z2 ;
	double U5 = z2 - y3 ;

	double U1p= z1p ;
	double U2p= z1p-y1p ;
	double U3p = y2p ;
	double U4p = z2p ;
	double U5p= z2p - y3p ;

	// act feval_node1zero = Uet/R0 -U1/R0 +C1*(U2p -U1p)
	// act feval_node2zero = Ub/R2 - U2*(1/R1 +1/R2) +C1*(U1p-U2p)-0.01*fcoef  *( exp((U2-U3)/den) -1 )
	// act feval_node3zero = fcoef  *( exp((U2-U3)/den) -1 ) -U3/R3 -C2*U3p
	// act feval_node4zero = Ub/R2 -U4/R4 +C3*(U5p - U4p) -0.99 *fcoef  *( exp((U2-U3)/den) -1 ) 
	// act feval_node5zero = -U5/R5 +C3*(U4p-U5p)


	// return



	// y1pp
	double y1pp = (-z1p/R0 + Uept/R0 )/C1 ;

	// act y1ppzero = -z1p/R0 + Uept/R0 -C1*y1pp

	// y2pp
	double y2pp = (-y2p/R3  + fU2mU3p *((z1p-y1p-y2p)/den))/C2 ;

	// act y2ppzero = -C2*y2pp - y2p/R3 + fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)

	double y3pp = (z2p/R5 -y3p/R5 )/C3 ;

	// act y3ppzero = C3*y3pp +y3p/R5-z2p/R5

	// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
	// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

	// act node1pzero= -z1p/R0 +Uept/R0 -C1*y1pp
	// act node3pzero= -y2p/R3 + fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -C2*y2pp
	// act node5pzero = y3p/R5 -z2p/R5 +C3*y3pp

	// temp:
	// act  AE1pzero = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2)+ (Uept/R0) -0.01*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)

	// tmp  
	// act AE1pzero2 = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2)+ (Uept/R0) -0.01*fcoef *exp((z1-y1-y2)/den)*(z1p/den) -0.01*fcoef *exp((z1-y1-y2)/den)*(( -y1p-y2p)/den)
	// tmp  AE1zero3 = (1/R1+1/R2)*y1p - z1p*(1/R0+1/R1+1/R2 + 0.01*fcoef *exp((z1-y1-y2)/den)/den)+ (Uept/R0)  -0.01*fcoef *exp((z1-y1-y2)/den)*(( -y1p-y2p)/den)


	// act AE2pzero = y3p/R5 -z2p*(1/R4 +1/R5) - 0.99*fcoef *exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)

	// return

	 U1=z1 ;
	 U2=z1-y1 ;
	 U3=y2 ;
	 U4=z2 ;
	 U5= z2-y3 ;

	// fprintf ('corr-feval :  U1 = //10.5e , U2=//10.5e,  U3= //10.5e, U4= //10.5e, U5= //10.5e  \n', U1, U2,  U3, U4, U5 ) ;

	// fprintf ('corr-feval :  Uet = //10.5e , z2=//10.5e,  y3= //10.5e, U5= //10.5e  \n', Uet, z2,  y3, U5 ) ;

	// fprintf ('corr-feval :  Uet = //10.5e , z1= //10.5e, y1p= //10.5e, y1= //10.5e, z1= //10.5e  \n', Uet,  z1, y1p, y1, z1 ) ;

	// fprintf ('corr-feval :  z1p = //10.5e , z2p= //10.5e, y1p= //10.5e, y2p= //10.5e, y3p= //10.5e  \n', z1p, z2p, y1p, y2p, y3p ) ;

	// fprintf ('corr-feval :  z1p = //10.5e , z2p= //10.5e, y1pp= //10.5e, y2pp= //10.5e, y3pp= //10.5e  \n', z1p, z2p, y1pp, y2pp, y3pp ) ;


	// ********** OK )) ******************

	// *** (( Uettc(1..)
	 double*Uettc=new double[szTblP1];
	  Uettc[1] = 0.4*sin(om*t) ;
	  Uettc[1+1] = 0.4*cos(om*t)*om  ;
	  Uettc[1+2] = - Uettc[1]*om*om/ft[2]  ;
	  for (int idx=3;idx<=ord;idx++){
		 Uettc[1+idx] = - ft[idx-2]*Uettc[1+idx-2]*om*om/ft[idx]  ;
		 //  Uettc(1+2) : Tayl coef 2 = der2/2! 

		 //tmp Uettc(1+idx+1) = -0.4*sin(om*t)* (om)^(idx+1)/ft(idx+1)  ;
		 //Uettc(1+idx+2) = -0.4*cos(om*t)* (om)^(idx+2)/ft(idx+2)  ;
		 //tmp Uettc(1+idx+3) =  0.4*sin(om*t)* (om)^(idx+3)/ft(idx+3)  ;
	  }
	// ***  Uettc(1..) )) ***


	  Uettc[1] = 0.4*sin(om*t) ;
	//////  Uettc(1+2) : Tayl coef 2 = der2/2! 
	//Uettc1zero =  Uettc(1+1) - 0.4*cos(om*t)*om 
	//Uettc2zero =  Uettc(1+2) - -0.4*sin(om*t)*om^2/ft(2) 
	//Uettc3zero =  Uettc(1+3) - -0.4*cos(om*t)*om^3/ft(3) 
	//Uettc4zero =  Uettc(1+4) -  0.4*sin(om*t)*om^4/ft(4) 
	//Uettc5zero =  Uettc(1+5) -  0.4*cos(om*t)*om^5/ft(5) 
	//Uettc6zero =  Uettc(1+6) - -0.4*sin(om*t)*om^6/ft(6) 
	//Uettc7zero =  Uettc(1+7) - -0.4*cos(om*t)*om^7/ft(7) 
	//Uettc8zero =  Uettc(1+8) -  0.4*sin(om*t)*om^8/ft(8) 
	//Uettc9zero =  Uettc(1+9) -  0.4*cos(om*t)*om^9/ft(9) 
	//Uettc10zero=  Uettc(1+10)- -0.4*sin(om*t)*om^10/ft(10) 
	//Uettc11zero=  Uettc(1+11)- -0.4*cos(om*t)*om^11/ft(11) 
	//Uettc12zero=  Uettc(1+12)-  0.4*sin(om*t)*om^12/ft(12) 
	// ***** prespos verif Uettc(1+idx)
	//clear all
	//return


	  z1tc[1+1] = z1p ;
	  z2tc[1+1] = z2p ;

	  y1tc[1+2] = y1pp/ft[2] ;
	  y2tc[1+2] = y2pp/ft[2] ;
	  y3tc[1+2] = y3pp/ft[2] ;


	  // y2tccopy(1+1) =  (- y2tc(1)/R3  + fcoef  * (expz1y1y2(1)-1) )/C2 ;
	  // act y2tccopy(1+1) =  (- y2/R3  + fcoef  * (exp((z1-y1-y2)/den)-1) )/C2 ;
	  // OK: y2tc1zero = y2tc(1+1)-y2tccopy(1+1)


	  // OK: expz1y1y2_1zero = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -expz1y1y2(1+1) 
	  // y2tccopy(1+2) =  (- y2tc(1+1)/R3  + fcoef  * expz1y1y2(1+1) )/C2/2 ;
	  // ok y2tc2zero = y2tc(1+2)-y2tccopy(1+2)


	  //z1y1y2(1) = (z1-y1-y2)/den ;
	  //z1y1y2(1+1) = (z1p-y1p-y2p)/den ;

	  m=1 ;
double*y1y2=new double[szTblP1];
double*expzyy=new double[szTblP1];
	  y1y2[1] = (y1+y2)/den ;
	  y1y2[1+m] = (y1tc[1+m]+y2tc[1+m])/den ;
	// y1y2(1+2): Tayl coef 2 = der2/2!
	  y1y2[1+m+1] = (y1tc[1+m+1]+y2tc[1+m+1])/den ;

	  expzyy[1] = expz1y1y2[1]* y1y2[1+1] ;

	// (( m=1 , 
	//   differentiation { exp((z1-y1-y2)/den)*(( y1p+y2p)/den) } p 527
	  double smexpzyy = 0.0 ;
	  for (int jdx=0;jdx<=m;jdx++)
		 smexpzyy = smexpzyy + expz1y1y2[1+m-jdx]* (jdx+1)* y1y2[1+jdx+1] ;
	  
	  expzyy[1+m] = smexpzyy ;
	// ***))

	  //expzyyo1zero =expz1y1y2(1+1)* y1y2(1+1) +expz1y1y2(1)*2*y1y2(1+2)  -expzyy(1+1)
	  // ok expzyyo1zero2 = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)*(( y1p+y2p)/den) + exp((z1-y1-y2)/den)*(( y1pp+y2pp)/den) -expzyy(1+1)

	  // OK AAcopy(1) = ((1/R1 +1/R2)*y1p+ Uept/R0 - fU2mU3p2*( -(y1p+y2p)/den ) ) ;
	double*AA=new double[szTblP1];
	double*BB=new double[szTblP1];
	  AA[1] = (1/R1 +1/R2)*y1tc[1+1]+ Uettc[1+1]/R0 + 0.01*fcoef * expzyy[1] ;
	  // ok: AAzero3 = AA(1)-AAcopy(1)


	  // ok: BBcopy(1) = (1/R0 +1/R1 +1/R2 + fU2mU3p2/den ) ;
	  BB[1] = 1/R0 +1/R1 +1/R2 + 0.01*fcoef * expz1y1y2[1]/den ;
	  // ok: BBzero3 = BB(1)-BBcopy(1)

	// differentiation { AA(1) }
	//     AA(1) = ((1/R1 +1/R2)*y1p+ Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den) *( -(y1p+y2p)/den ) ) 
	//    => AA(1+1) = ...

	// => 

	  AA[1+m] = ((1/R1 +1/R2)*(m+1)*y1tc[1+m+1]+ (m+1)*  Uettc[1+m+1 ]/R0 + 0.01*fcoef * expzyy[1+m]) ;


	// BB(1)=(1/R0 +1/R1 +1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den  )

	  BB[1+m ] = 0.01*fcoef * expz1y1y2[1+m]/den ;

	// differentiation { A/B }
	//    z1p = A/B => z1^{(m)} = 1/B^0(t) {A^{(m)}(t) - sm[z1^{(m+1-i)} * B^{(i)}(t) ] }  
	  //z1pzero = AA(1)/BB(1)- z1p

	double  smBz = z1tc[m+1]*BB[2] ;

	  z1tc[1+m+1] = (AA[1+m] - smBz )/BB[1]/(m+1) ;

	  double z1pp = z1tc[1+2]*ft[2] ;

	//// z1p*B=A => verif:
	//  smxy = 0.0;
	//  for idx=0:m
	//     smxy = smxy + (m+1-idx)* z1tc(m+1-idx+1)*BB(1+idx) ;
	//  end;
	//  // OK: AAzero = AA(1+m)-smxy

	  

	  // ********* verif (B*z1p)' = A' **************
	  // OK: AAzero=BB(1)*z1tc(1+2)+BB(1+1)*z1tc(1+1)-AA(1+1)
	  // OK: z1tc2zero = AA(1+1)/BB(1)+AA(1)*(-BB(1+1)/BB(1)^2) -z1tc(1+2 )

	// f(z1-y1-y2 ) = ffU2mU3 = fcoef  *( exp((z1-y1-y2)/den) -1 ) ;

	 z1y1y2[1+2] = (z1tc[1+2] -y1tc[1+2] -y2tc[1+2])/den ;

	 smexpz1y1y2 = 0.0 ;
	 for (int jdx=0;jdx<=m;jdx++)
		smexpz1y1y2 = smexpz1y1y2 + (m+1-jdx)*z1y1y2[1+m+1-jdx] *expz1y1y2[1+jdx] ;
	 
	 expz1y1y2[1+m+1] =  smexpz1y1y2/(m+1) ;

	// OK: expz1y1y2_1zero = exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den) -expz1y1y2(1+1) 
	// OK:   expz1y1y2_1zero2 = expz1y1y2(1) * z1y1y2(1+1) -expz1y1y2(1+1) 

	// act expz1y1y2_2zero =  exp((z1-y1-y2)/den)*((z1p-y1p-y2p)/den)^2 + exp((z1-y1-y2)/den)*((z1pp-y1pp-y2pp)/den) -expz1y1y2(1+2)*2

	// =>
	// ok 
	// act expz1y1y2_2zero2 = z1y1y2(1+2)*2*expz1y1y2(1) +z1y1y2(1+1) *expz1y1y2(1+1) -expz1y1y2(1+2)*2 

	// ok : z1pzero2 = (1/R1 + 1/R2)*y1tc(1+1) + Uettc(1+1)/R0 - 0.01* fcoef *expz1y1y2(1+1) -( z1tc(1+1)*(1/R0+1/R1+1/R2)  )


	//  z1pzero = (1/R1 + 1/R2)*y1p + Uept/R0 - 0.01* fcoef *exp((z1-y1-y2)/den)*(-(y1p+y2p)/den) -( z1p*(1/R0 +1/R1+1/R2 + 0.01* fcoef *exp((z1-y1-y2)/den)/den )  )

	// OK z1ppzero = (1/R1 + 1/R2)*y1tc(1+2) +Uettc(1+2)/R0 + 0.01* fcoef* expzyy(1+1) - ( z1tc(1+2) *(1/R0 +1/R1+1/R2 +0.01* fcoef *expz1y1y2(1)) +z1tc(1+1) *( 0.01* fcoef *expz1y1y2(1+1)) )

	//   z2p = (y3p/R5 -0.99*fcoef *expz1y1y2(1+1) )/(1/R4+1/R5) ;
	 z2tc[1+m+1] = ( y3tc[1+m+1]/R5 - 0.99*fcoef * expz1y1y2[1+m+1])/(1/R4+1/R5) ;
	 double z2pp = z2tc[1+2]*ft[2] ;
	// ok z2pzero = y3p/R5 -z2p*(1/R4+1/R5) -0.99* fcoef *exp((z1-y1-y2)/den)*(-(-z1p+y1p+y2p)/den)
	// ok z2ppzero = y3tc(1+2)/R5 -z2tc(1+2)*(1/R4+1/R5) -0.99* fcoef *expz1y1y2(1+2)


	//  y1ppp   = ( z1pp/R0 - Uetpp/R0 )/C1  =>
	//     y1tc(1+m+2)  = ( z1tc(1+m+1)/R0 - Uettc(1+m+1)/R0 )/C1/(m+2) ;
	 y1tc[1+m+2]  = ( -z1tc[1+m+1]/R0 + Uettc[1+m+1]/R0 )/C1/(m+2) ;

	// simil.:  y2ppp = (- y2pp/R3  + fcoef * expz1y1y2pp )/C2 =>
	//     y2tc(1+m+2) = (- y2tc(1+m+1)/R3  + fcoef  * expz1y1y2(1+m+1) )/C2/(m+2) ;

	 y2tc[1+m+2] = (- y2tc[1+m+1]/R3  + fcoef  * expz1y1y2[1+m+1] )/C2/(m+2) ;

	// y3ppp
	 y3tc[1+m+2] = ( z2tc[1+m+1]/R5 - y3tc[1+m+1]/R5 )/C3/(m+2) ;

	// F(1): node1 ;  F(2): node3 ;  F(3): node5 ;
	// F(4): Alg Eq1 ; F(5): Alg Eq2 ;

	// act node1ppzero = -z1tc(1+2)/R0 +Uettc(1+2)/R0 -C1*y1tc(1+3)*3
	// act node3ppzero= -y2tc(1+2)/R3 + fcoef *expz1y1y2(1+2) -C2*y2tc(1+3)*3

	// node5 eq = F(3)
	// act node5ppzero = y3tc(1+2)/R5 -z2tc(1+2)/R5 +C3*y3tc(1+3)*3


	// ok 
	// act AlgEq1ppzero = (1/R1 + 1/R2)*2* y1tc(1+2) + 2* Uettc(1+2)/R0 + 0.01* fcoef* expzyy(1+1) - ( 2* z1tc(1+2) *(1/R0 +1/R1+1/R2 +0.01* fcoef *expz1y1y2(1)/den) +z1tc(1+1) *( 0.01* fcoef *expz1y1y2(1+1)/den) )

	// (alg Eq1)' = F(4)' 
	// act  AlgEq1ppzero2 =  (1/R1+1/R2)*y1pp -z1pp*(1/R0 +1/R1 + 1/R2) +ft(2)*Uettc(1+2)/R0 -0.01*fcoef/den* ( exp((z1-y1-y2)/den) * (z1p-y1p-y2p)^2/den + exp((z1-y1-y2)/den) * (z1pp-y1pp-y2pp) )   

	// act AlgEq2ppzero = y3pp/R5 -z2pp*(1/R4 +1/R5) - 0.99*fcoef/den *(exp((z1-y1-y2)/den)*(z1p-y1p-y2p)^2/den  + exp((z1-y1-y2)/den)*(z1pp-y1pp-y2pp) )

	//  return



	yvalvo[1][1] =y1; yvalvo[1][2] =y2; yvalvo[1][3] =y3; yvalvo[1][4] =y1p ; yvalvo[1][5] =y2p ;  yvalvo[1][6] =y3p;
	for (int idx=1;idx<=ord;idx++){ 
	   yvalvo[idx+1][1]=   y1tc[1+idx]*ft[idx] ; 
	    yvalvo[idx+1][2]=y2tc[1+idx]*ft[idx] ; 
		 yvalvo[idx+1][3]=y3tc[1+idx ]*ft[idx ] ; 
		  yvalvo[idx+1][4]=y1tc[1+idx+1]*ft[idx+1] ; 
		   yvalvo[idx+1][5]=y2tc[1+idx+1]*ft[idx+1] ;
		    yvalvo[idx+1][6]=y3tc[1+idx+1]*ft[idx+1] ;
	}



	// Ex:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)

	//Free memory
	delete ft;
	delete y1tc;
	delete y2tc;
	delete y3tc;
	delete z1tc;
	delete z2tc;
	delete z1y1y2;
	delete expz1y1y2;
	delete Uettc;
	delete y1y2;
	delete expzyy;
	delete AA;
	delete BB;

}

