#include "linSolver.cpp"
#include "autoDiff.cpp"

//Test problem (VO means variable order): 
//INPUT:  t, yyvc:y(t), ord:compute y^{(i)}(t) up to i=ord or ord+1, nbcmp:size(y)
//OUTPUT:  yvalvo/ydervo: array containing the computed y^{(i)}(t)'s
static void fvo(double t, double*yyvc, int ord,double TOL, double**ydervo,int nbcmp){

	// corrector & f eval

	// input t, yyvc(1),yyvc(2) ,

	// p 142,p 151 "Numerical Solution...", Brenan, Campbell & Petzold

	// assoc pendulum ODE: \phi'' = (g/L)*sin(\phi)
	// where : 
	//   x= L*sin(\phi)
	//   y= L*cos(\phi)

	// p 611, Burden Faires
	double*F=new double[6];for(int i=1;i<=5;i++)F[i]=0.0;
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13
	int L =1 ;
	int g =1;
	double*ft=new double[18];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;


	// (1)
	// Since the following x,y, xp, yp, lbd acquired by means of yyvc()
	// are close-to-consistent, 
	// stage k=-2,-1 p 200 , J.D. Pryce can be completed 
	//    and adjusted in Newton iteration below:

	 double x    = yyvc[1] ;
	 double y    = yyvc[2] ;
	 double xp   = yyvc[3] ;
	 double yp   = yyvc[4] ;
	 double lbd  = yyvc[5] ;

	// stage k = 0, solve for xpp, ypp, la:
	// 3 eq E1, E2, C'' p 540 Barrio :

double*b_v=new double[4];b_v[3]=(xp*xp+yp*yp+y*g)/(x*x+y*y);b_v[1]=-b_v[3]*x;b_v[2]=g-b_v[3]*y;//b_v = A_MAT\RHS ;
	
	 double xpp  = b_v[1] ;
	 double ypp  = b_v[2] ;
	 double la = b_v[3] ;

	// act la = lbd ;

	//  feval_lbdzero=lbd-la
	// act la = -ypp/y ;

	//   the values x,y, xp, yp, la=lbd SHOULD be projected 
	//   onto the constraints manifold by means Newton iterations
	//     adjust xvc = [ x ; y; xp ; yp ; la   ];
	//     or adjust xvc = [ xp ; yp ; xpp ; ypp ; la   ];

	// starting "close-to-consistent" xvc = [ x ; y; xp ; yp ; la   ];
	 double*xvc=new double[6];
	 double*JFvc=new double[6];
	 xvc[1]=x ; xvc[2]=y; xvc[3]=xp ; xvc[4]=yp ; xvc[5]=la;
	 
	 for(int i=1;i<=5;i++)JFvc[i]=1111.0;

	double maxAbsJFvc=1111.0;
	double**invJac=new double*[6];
	for(int i=1;i<=5;i++)invJac[i]=new double[6];
	
	// act  while (k <= N )
	while (k <= N  && maxAbsJFvc >= TOL){

		// ENLARGED SYSTEM:
		// calc F(), Jac() p 540 Barrio
		// 5 eq E1, E2, C, C', C''
		// 5 var x,  y, xp, yp, la
		// (solve for consistent point [ x ; y; xp ; yp ; la ; xpp ; ypp  ]
		//     p 372-373, Pryce,"a simple structural.." )
		// The following equations F() are chosen such that all equations
		// from stage k = -max_j(d_j) to k = 0 (Pryce,"Solving high index...")
		// are satisfied

		F[1] = xpp + x*la ;
		F[2] = ypp + y*la -g  ;
		F[3] = x*x + y*y - L*L ;
		F[4] = 2*x*xp +2* y*yp ;
		F[5] = 2*x*xpp + 2*y*ypp +2*(xp)*xp + 2*(yp)*yp ;

		//      x,  y, xp, yp, la
		//Jac= [ la, 0, 0, 0, x  ; ...
		//       0, la, 0, 0, y ; ...
		//       2*x, 2*y, 0, 0, 0 ; ...
		//       2*xp,2*yp, 2*x, 2*y, 0 ; ...
		//       2*xpp,2*ypp, 4*xp, 4*yp, 0 ] ; 

	//   fprintf ( ' feval: t = //7.2e, x = //7.2e, y = //7.2e, xp = //7.2e, yp = //7.2e, la = //7.2e \n', t, x, y, xp, yp, la ) ;

		invJac[1][1] =y*y/(x*x+y*y)/la;
		invJac[1][2] =  -x*y/(x*x+y*y)/la;
		invJac[1][3] =0.5*x/(x*x+y*y);
		invJac[1][4] =	0;
		invJac[1][5] =0 ;

		invJac[2][1] =-x*y/(x*x+y*y)/la;
		invJac[2][2] =x*x/(x*x+y*y)/la;
		invJac[2][3] =0.5*y/(x*x+y*y);
		invJac[2][4] =0;
		invJac[2][5] =0.0 ;

		invJac[3][1] = -0.5*y*(-2*x*yp*yp+x*ypp*y+2*xp*yp*y-y*y*xpp)/la/(yp*x*x*x-xp*y*x*x+yp*y*y*x-xp*y*y*y);
		invJac[3][2] =0.5*x*(-2*x*yp*yp+x*ypp*y+2*xp*yp*y-y*y*xpp)/la/(yp*x*x*x-xp*y*x*x+yp*y*y*x-xp*y*y*y);
		invJac[3][3] =0.25*(-2*x*xp*yp+x*y*xpp-2*yp*yp*y+y*y*ypp)/(yp*x*x*x-xp*y*x*x+yp*y*y*x-xp*y*y*y);
		invJac[3][4] =0.5*yp/(x*yp-xp*y);
		invJac[3][5] =-0.25*y/(x*yp-xp*y) ;

		invJac[4][1] = 0.5*y*(x*x*ypp-2*x*xp*yp-x*y*xpp+2*xp*xp*y)/la/(yp*x*x*x-xp*y*x*x+yp*y*y*x-xp*y*y*y);
		invJac[4][2] =-0.5*x*(x*x*ypp-2*x*xp*yp-x*y*xpp+2*xp*xp*y)/la/(yp*x*x*x-xp*y*x*x+yp*y*y*x-xp*y*y*y);
		invJac[4][3] =-0.25*(x*x*xpp-2*xp*xp*x+x*ypp*y-2*xp*yp*y)/(yp*x*x*x-xp*y*x*x+yp*y*y*x-xp*y*y*y);
		invJac[4][4] =-0.5*xp/(x*yp-xp*y);
		invJac[4][5] =0.25*x/(x*yp-xp*y);

		invJac[5][1] =x/(x*x+y*y);
		invJac[5][2] =y/(x*x+y*y);
		invJac[5][3] =-1/2*la/(x*x+y*y);
		invJac[5][4] =0;
		invJac[5][5] =0;
	 

		// feval_invJac=invJac
		//feval_F=F
 
		for(int i=1;i<=5;i++){
			JFvc[i]=0.0;
			for(int j=1;j<=5;j++)JFvc[i]+=invJac[i][j]*-F[j];
			xvc[i] +=JFvc[i] ;
		}

		k = k+1 ;

		//clear all
		//return

		x = xvc[1] ;
		y = xvc[2] ;
		xp = xvc[3] ;
		yp = xvc[4] ;
		la = xvc[5] ;

		maxAbsJFvc=0.0;
		for(int i=1;i<=5;i++)maxAbsJFvc=max(maxAbsJFvc,fabs(JFvc[i]));
	 }

	 
	//fprintf ( ' succ:  xvc = //10.5e \n', xvc ) ;       


	////// (( OK:
	//E1zero = xpp+x*la
	//E2zero=ypp+y*la-g
	//Czero=x^2+y^2 -L^2
	//Cpzero = 2*x*xp +2*y*yp
	//Cppzero = 2*x*xpp+2*y*ypp+2*xp^2 +2*yp^2
	//////  OK:))


	// return

	//  *********** ydervo output new x, y **********
	   ydervo[1][1] = x  ; 
	   ydervo[1][2] =y  ; 
	   ydervo[1][3] =xp   ; 
	   ydervo[1][4] =yp  ; 
	   ydervo[1][5] =la ;


	// Ex: Taylor coefficients recursive formula:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)

	// **** STEP 2: obtain  deriv.   xd(1+k+2 ) ;   yd(1+k+2) ;   ld(1+k ) ;k=0,1,.. *******

		int szTbl=ord+10;
		int szTblP1=szTbl+1;
	  double*ld=new double[szTblP1];
	  double*xd=new double[szTblP1];
	  double*yd=new double[szTblP1];



	   ld[1]=la ;
	   xd[1]=x ;
	   xd[1+1]=xp ;
	   xd[1+2]=xpp ;

	   yd[1]  =y ;
	   yd[1+1]=yp ;
	   yd[1+2]=ypp ;


	//  ********************************
	   k=1 ;

	   //A_MAT=[ 1, 0, xd(1) ; ...
	   //        0, 1, yd(1) ; ...
	   //        2*xd(1), 2*yd(1), 0   ] ;

	   //r = [ -xd[1+1]*ld[1] ; -yd[1+1]*ld[1] ; 2*(-3*xd[1+1]*xd[1+2]-3*yd[1+1]*yd[1+2]) ] ; 


	   double x9 = xd[1] ;
	   double y9 = yd[1] ;
	//   invA = ...
	//[   y9^2/(y9^2+x9^2), -y9*x9/(y9^2+x9^2), 1/2*x9/(y9^2+x9^2) ; ...
	// -y9*x9/(y9^2+x9^2),   x9^2/(y9^2+x9^2), 1/2*y9/(y9^2+x9^2) ; ...
	//	 x9/(y9^2+x9^2),     y9/(y9^2+x9^2),   -1/2/(y9^2+x9^2)] ;

	   // b_v = A_MAT\r ;

	   b_v[1]=y9*y9/(y9*y9+x9*x9)*-xd[1+1]*ld[1] -y9*x9/(y9*y9+x9*x9)*-yd[1+1]*ld[1]+ 0.5*x9/(y9*y9+x9*x9)*2*(-3*xd[1+1]*xd[1+2]-3*yd[1+1]*yd[1+2]);
	   b_v[2]=-y9*x9/(y9*y9+x9*x9)*-xd[1+1]*ld[1]+x9*x9/(y9*y9+x9*x9)*-yd[1+1]*ld[1]+0.5*y9/(y9*y9+x9*x9)*2*(-3*xd[1+1]*xd[1+2]-3*yd[1+1]*yd[1+2]);
		b_v[3]=x9/(y9*y9+x9*x9)*-xd[1+1]*ld[1]+y9/(y9*y9+x9*x9)*-yd[1+1]*ld[1]-0.5/(y9*y9+x9*x9)*2*(-3*xd[1+1]*xd[1+2]-3*yd[1+1]*yd[1+2]);

	   xd[1+3]=b_v[1] ;
	   yd[1+3]=b_v[2] ;
	   ld[1+1]=b_v[3] ;


	//  Ex: ydervo(3,1:4) =[ xpp ; ypp ; xppp ; yppp   ] ;
	//  act   ydervo(k+2,1:4) =[ xd(1+k+1)  ; yd(1+k+1) ; xd(1+k+2)  ; yd(1+k+2)  ] ;


	//  ********************************

	   k=2 ;

		double*xc=new double[szTblP1];
		double*yc=new double[szTblP1];
		double*lc=new double[szTblP1];

	   xc[1]=xd[1] ;
	   yc[1]=yd[1] ;
	   lc[1]=ld[1] ;

	   for (int idx=1;idx<=k+1;idx++){
		  xc[1+idx]=xd[1+idx]/ft[idx] ;
		  yc[1+idx]=yd[1+idx]/ft[idx] ;
	   }

	   for (int idx=1;idx<=k-1;idx++)
		  lc[1+idx]=ld[1+idx]/ft[idx] ;
	   

	   //smxl=0;
	   //for idx=1:k
	   //   smxl=smxl+xc(1+idx)*lc(k-idx+1) ;
	   //end;

	   double smxl =0.0;//tcprodRHS(xc ,lc,k) ;
	   for (int jdx=0;jdx<=k-1;jdx++)
		   smxl=smxl+xc[k-jdx+1]*lc[1+jdx] ;

	   double smyl =0.0;//tcprodRHS(yc ,lc,k) ;
	   for (int jdx=0;jdx<=k-1;jdx++)
		   smyl=smyl+yc[k-jdx+1]*lc[1+jdx] ;

	   double smxx =0.0;//tcprodRHS_2b(xc ,xc,k+2) ;
	   for (int jdx=1;jdx<=k+1;jdx++)
		   smxx=smxx+xc[k+3-jdx]*xc[1+jdx];

	   double smyy =0.0;//tcprodRHS_2b(yc ,yc,k+2) ;
	   for (int jdx=1;jdx<=k+1;jdx++)
		   smyy=smyy+yc[k+3-jdx]*yc[1+jdx];


	   //A_MAT=[ 1, 0, xc(1) ; ...
	   //       0, 1, yc(1) ; ...
	   //   2*xc(1), 2*yc(1), 0   ] ;

//	   r = [ -smxl*ft[k]  ; -smyl*ft[k]  ; -(smxx+smyy)*ft[k+2]  ] ; 

	   x9 = xc[1] ;
	   y9 = yc[1] ;

//	   invA = ...
//	[   y9^2/(y9^2+x9^2), -y9*x9/(y9^2+x9^2), 1/2*x9/(y9^2+x9^2) ; ...
//	 -y9*x9/(y9^2+x9^2),   x9^2/(y9^2+x9^2), 1/2*y9/(y9^2+x9^2) ; ...
//		 x9/(y9^2+x9^2),     y9/(y9^2+x9^2),   -1/2/(y9^2+x9^2)] ;

	   // ( b_v = invA*r  replaces  b_v = A_MAT\r ;)

//	   b_v = invA*r ;

	   b_v[1]=y9*y9/(y9*y9+x9*x9)*-smxl*ft[k] -y9*x9/(y9*y9+x9*x9)*-smyl*ft[k]+ 0.5*x9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
	   b_v[2]=-y9*x9/(y9*y9+x9*x9)*-smxl*ft[k]+x9*x9/(y9*y9+x9*x9)*-smyl*ft[k]+0.5*y9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
		b_v[3]=x9/(y9*y9+x9*x9)*-smxl*ft[k]+y9/(y9*y9+x9*x9)*-smyl*ft[k]-0.5/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];

	   xc[1+k+2]=b_v[1]/ft[k+2] ;
	   yc[1+k+2]=b_v[2]/ft[k+2] ;
	   lc[1+k]=b_v[3]/ft[k] ;

	   xd[1+k+2]=b_v[1] ;
	   yd[1+k+2]=b_v[2] ;
	   ld[1+k]=b_v[3] ;

	   k = 3 ;

	   //smxl=0;
	   //for idx=1:k
	   //   smxl=smxl+xc(1+idx)*lc(k-idx+1) ;
	   //end;

	   smxl =0.0;//tcprodRHS(xc ,lc,k) ;
	   for (int jdx=0;jdx<=k-1;jdx++)
		   smxl=smxl+xc[k-jdx+1]*lc[1+jdx] ;

	   smyl =0.0;//tcprodRHS(yc ,lc,k) ;
	   for (int jdx=0;jdx<=k-1;jdx++)
		   smyl=smyl+yc[k-jdx+1]*lc[1+jdx] ;

	   smxx =0.0;//tcprodRHS_2b(xc ,xc,k+2) ;
	   for (int jdx=1;jdx<=k+1;jdx++)
		   smxx=smxx+xc[k+3-jdx]*xc[1+jdx];

	   smyy =0.0;//tcprodRHS_2b(yc ,yc,k+2) ;
	   for (int jdx=1;jdx<=k+1;jdx++)
		   smyy=smyy+yc[k+3-jdx]*yc[1+jdx];

	   //A_MAT=[ 1, 0, xc(1) ; ...
	   //       0, 1, yc(1) ; ...
	   //2*xc(1), 2*yc(1), 0   ] ;

//	   r = [ -smxl*ft(k)  ; -smyl*ft(k)  ; -(smxx+smyy)*ft(k+2)  ] ; 

	   x9 = xc[1] ;
	   y9 = yc[1] ;
//	   invA = ...
//	[   y9^2/(y9^2+x9^2), -y9*x9/(y9^2+x9^2), 1/2*x9/(y9^2+x9^2) ; ...
//	 -y9*x9/(y9^2+x9^2),   x9^2/(y9^2+x9^2), 1/2*y9/(y9^2+x9^2) ; ...
//		 x9/(y9^2+x9^2),     y9/(y9^2+x9^2),   -1/2/(y9^2+x9^2)] ;

	   // ( b_v = invA*r  replaces  b_v = A_MAT\r ;)

	//   b_v = invA*r ;

	   	   b_v[1]=y9*y9/(y9*y9+x9*x9)*-smxl*ft[k] -y9*x9/(y9*y9+x9*x9)*-smyl*ft[k]+ 0.5*x9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
	   b_v[2]=-y9*x9/(y9*y9+x9*x9)*-smxl*ft[k]+x9*x9/(y9*y9+x9*x9)*-smyl*ft[k]+0.5*y9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
		b_v[3]=x9/(y9*y9+x9*x9)*-smxl*ft[k]+y9/(y9*y9+x9*x9)*-smyl*ft[k]-0.5/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];


	   xc[1+k+2]=b_v[1]/ft[k+2] ;
	   yc[1+k+2]=b_v[2]/ft[k+2] ;
	   lc[1+k]=b_v[3]/ft[k] ;

	   xd[1+k+2]=b_v[1] ;
	   yd[1+k+2]=b_v[2] ;
	   ld[1+k]=b_v[3] ;

	//  *********************************
	k = 4 ;
	for (int k=4;k<=ord;k++){

	   //smxl=0;
	   //for idx=1:k
	   //   smxl=smxl+xc(1+idx)*lc(k-idx+1) ;
	   //end;

	   smxl =0.0;//tcprodRHS(xc ,lc,k) ;
	   for (int jdx=0;jdx<=k-1;jdx++)
		   smxl=smxl+xc[k-jdx+1]*lc[1+jdx] ;

	   smyl =0.0;//tcprodRHS(yc ,lc,k) ;
	   for (int jdx=0;jdx<=k-1;jdx++)
		   smyl=smyl+yc[k-jdx+1]*lc[1+jdx] ;

	   smxx =0.0;//tcprodRHS_2b(xc ,xc,k+2) ;
	   for (int jdx=1;jdx<=k+1;jdx++)
		   smxx=smxx+xc[k+3-jdx]*xc[1+jdx];

	   smyy =0.0;//tcprodRHS_2b(yc ,yc,k+2) ;
	   for (int jdx=1;jdx<=k+1;jdx++)
		   smyy=smyy+yc[k+3-jdx]*yc[1+jdx];

	   //A_MAT=[ 1, 0, xc(1) ; ...
	   //       0, 1, yc(1) ; ...
	   //2*xc(1), 2*yc(1), 0   ] ;

	 //  r = [ -smxl*ft(k)  ; -smyl*ft(k)  ; -(smxx+smyy)*ft(k+2)  ] ; 

	   x9 = xc[1] ;
	   y9 = yc[1] ;
	 //  invA = ...
	//[   y9^2/(y9^2+x9^2), -y9*x9/(y9^2+x9^2), 1/2*x9/(y9^2+x9^2) ; ...
	// -y9*x9/(y9^2+x9^2),   x9^2/(y9^2+x9^2), 1/2*y9/(y9^2+x9^2) ; ...
	//	 x9/(y9^2+x9^2),     y9/(y9^2+x9^2),   -1/2/(y9^2+x9^2)] ;

	   // ( b_v = invA*r  replaces  b_v = A_MAT\r ;)

	  // b_v = invA*r ;

	   b_v[1]=y9*y9/(y9*y9+x9*x9)*-smxl*ft[k] -y9*x9/(y9*y9+x9*x9)*-smyl*ft[k]+ 0.5*x9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
	   b_v[2]=-y9*x9/(y9*y9+x9*x9)*-smxl*ft[k]+x9*x9/(y9*y9+x9*x9)*-smyl*ft[k]+0.5*y9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
		b_v[3]=x9/(y9*y9+x9*x9)*-smxl*ft[k]+y9/(y9*y9+x9*x9)*-smyl*ft[k]-0.5/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];


	   xc[1+k+2]=b_v[1]/ft[k+2] ;
	   yc[1+k+2]=b_v[2]/ft[k+2] ;
	   lc[1+k]=b_v[3]/ft[k] ;

	   xd[1+k+2]=b_v[1] ;
	   yd[1+k+2]=b_v[2] ;
	   ld[1+k]=b_v[3] ;

	}
	// (end for k=4:ord-1)


	for (int k=0;k<=ord-1;k++){
	   ydervo[k+2][1] =xd[1+k+1]  ; 
	   ydervo[k+2][2] =yd[1+k+1] ; 
	   ydervo[k+2][3] =xd[1+k+2]  ; 
	   ydervo[k+2][4] =yd[1+k+2] ; 
	   ydervo[k+2][5] =ld[1+k+1]   ;
	}
	//free memory
    delete F;
	delete ft;
	delete b_v;
	delete xvc;
	delete JFvc;
	for(int i=1;i<=5;i++)delete invJac[i];
	delete invJac;
	delete ld;
	delete xd;
	delete yd;
	delete xc;
	delete yc;
	delete lc;
}	
static void f(double t, double*yyvc, int ord,double TOL,double**ydervo, int nbcmp){
	// corrector & f eval
	// input t, yyvc(1),yyvc(2) ,
	// p 142,p 151 "Numerical Solution...", Brenan, Campbell & Petzold
	// assoc pendulum ODE: \phi'' = (g/L)*sin(\phi)
	// where : 
	//   x= L*sin(\phi)
	//   y= L*cos(\phi)

	// p 611, Burden Faires
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13
	int L =1 ;
	int g =1;
	double*ft=new double[18];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;

	// (1)
	// the following x,y, xp, yp, lbd are acquired by means of yyvc()
	//   instead of using Pryce's method at stage k=-2,-1 p 200 , J.D. Pryce


	double x    = yyvc[1] ;
	double y    = yyvc[2] ;
	double xp   = yyvc[3] ;
	double yp   = yyvc[4] ;
	double lbd  = yyvc[5] ;

	// (2)
	// stage k = 0, solve for xpp, ypp, la:
	// 3 eq E1, E2, C'' p 540 Barrio :

	double*b_v=new double[4];b_v[3]=(xp*xp+yp*yp+y*g)/(x*x+y*y);b_v[1]=-b_v[3]*x;b_v[2]=g-b_v[3]*y;//b_v = A_MAT\RHS ;
	double xpp  = b_v[1],ypp  = b_v[2],la = b_v[3] ;
	
	// act la = lbd ;

	//  feval_lbdzero=lbd-la

	// act la = -ypp/y ;

	//   the values x,y, xp, yp, lbd, xpp, ypp should NOT be projected 
	//   onto the constraints manifold by means Newton iterations
	//   NO Newton iteration is needed
	//     adjust xvc = [ x ; y; xp ; yp ; la   ];
	//     or adjust xvc = [ xp ; yp ; xpp ; ypp ; la   ];

	////// act  while (k <= N )
	// while (k <= N ) & (max(abs(JFvc)) >= TOL)

		// calc F(), Jac() p 540 Barrio
		// 5 eq E1, E2, C, C', C''
		// 5 var x,  y, xp, yp, la

		//      x,  y, xp, yp, la
		//Jac= [ la, 0, 0, 0, x  ; ...
		//       0, la, 0, 0, y ; ...
		//       2*x, 2*y, 0, 0, 0 ; ...
		//       2*xp,2*yp, 2*x, 2*y, 0 ; ...
		//       2*xpp,2*ypp, 4*xp, 4*yp, 0 ] ; 

//	   fprintf ( ' feval: x = //7.2e, y = //7.2e, xp = //7.2e, yp = //7.2e, la = //7.2e \n', x, y, xp, yp, la ) ;

	//    invJac = [   y^2/(x^2+y^2)/la,  -x*y/(x^2+y^2)/la,    1/2*x/(x^2+y^2),    0,    0 ; ...
	//  -x*y/(x^2+y^2)/la,   x^2/(x^2+y^2)/la,    1/2*y/(x^2+y^2),    0,    0 ; ...
	// -1/2*y*(-2*x*yp^2+x*ypp*y+2*xp*yp*y-y^2*xpp)/la/(yp*x^3-xp*y*x^2+yp*y^2*x-xp*y^3),  1/2*x*(-2*x*yp^2+x*ypp*y+2*xp*yp*y-y^2*xpp)/la/(yp*x^3-xp*y*x^2+yp*y^2*x-xp*y^3),       1/4*(-2*x*xp*yp+x*y*xpp-2*yp^2*y+y^2*ypp)/(yp*x^3-xp*y*x^2+yp*y^2*x-xp*y^3), 1/2*yp/(x*yp-xp*y), -1/4*y/(x*yp-xp*y) ; ...
	//   1/2*y*(x^2*ypp-2*x*xp*yp-x*y*xpp+2*xp^2*y)/la/(yp*x^3-xp*y*x^2+yp*y^2*x-xp*y^3),  -1/2*x*(x^2*ypp-2*x*xp*yp-x*y*xpp+2*xp^2*y)/la/(yp*x^3-xp*y*x^2+yp*y^2*x-xp*y^3),       -1/4*(x^2*xpp-2*xp^2*x+x*ypp*y-2*xp*yp*y)/(yp*x^3-xp*y*x^2+yp*y^2*x-xp*y^3),-1/2*xp/(x*yp-xp*y),  1/4*x/(x*yp-xp*y) ; ...
	//        x/(x^2+y^2),        y/(x^2+y^2),  -1/2*la/(x^2+y^2),    0,    0] ;
	// 

	//    // feval_invJac=invJac
//		feval_F=F

	//    JFvc = invJac*(-F) 
	//    xvc = xvc+JFvc ;

	//    k = k+1 ;

		//clear all
		//return

	//    x = xvc(1) ;
	//    y = xvc(2) ;
	//    xp = xvc(3) ;
	//    yp = xvc(4) ;
	//    la = xvc(5) ;
	//
	// end;
	 
	//fprintf ( ' succ:  xvc = //10.5e \n', xvc ) ;       

	////// (( OK:
	//E1zero = xpp+x*la
	//E2zero=ypp+y*la-g
	//Czero=x^2+y^2 -L^2
	//Cpzero = 2*x*xp +2*y*yp
	//Cppzero = 2*x*xpp+2*y*ypp+2*xp^2 +2*yp^2
	//////  OK:))


	// return

	//  ***********  ydervo output new x, y **********
	   ydervo[1][1] = x  ; ydervo[1][2] =y  ; ydervo[1][3] =xp   ; ydervo[1][4] =yp  ; ydervo[1][5] =la ;

	// Ex: Taylor coefficients recursive formula:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)

	// ********* STEP 2: obtain  deriv.   xd(1+k+2 ) ;   yd(1+k+2) ;   ld(1+k ) ;k=0,1,.. ************
	int szTbl=ord+10;
	int szTblP1=szTbl+1;
	  double*ld=new double[szTblP1];
	  double*xd=new double[szTblP1];
	  double*yd=new double[szTblP1];

	   ld[1]=la ;
	   xd[1]=x ;
	   xd[1+1]=xp ;
	   xd[1+2]=xpp ;

	   yd[1]  =y ;
	   yd[1+1]=yp ;
	   yd[1+2]=ypp ;


	//  ********************************
	   k=1 ;

	   //A_MAT=[ 1, 0, xd(1) ; ...
	   //        0, 1, yd(1) ; ...
	   //        2*xd(1), 2*yd(1), 0   ] ;
double x9 = xd[1], y9 = yd[1];double*xc=new double[szTblP1];double*yc=new double[szTblP1];double*lc=new double[szTblP1];
	b_v[1]=-y9*y9/(y9*y9+x9*x9)*xd[2]*ld[1]+y9*x9/(y9*y9+x9*x9)*yd[2]*ld[1]+ 0.5*x9/(y9*y9+x9*x9)*2*(-3*xd[2]*xd[3]-3*yd[2]*yd[3]);
	b_v[2]=y9*x9/(y9*y9+x9*x9)*xd[2]*ld[1]-x9*x9/(y9*y9+x9*x9)*yd[2]*ld[1]+ 0.5*y9/(y9*y9+x9*x9)*2*(-3*xd[2]*xd[3]-3*yd[2]*yd[3]);
	b_v[3]=-x9/(y9*y9+x9*x9)*xd[2]*ld[1]-y9/(y9*y9+x9*x9)*yd[2]*ld[1]-0.5/(y9*y9+x9*x9)*2*(-3*xd[2]*xd[3]-3*yd[2]*yd[3]);
	 xd[4]=b_v[1] ;yd[4]=b_v[2] ;ld[2]=b_v[3];
	
	//  Ex: ydervo(3,1:4) =[ xpp ; ypp ; xppp ; yppp   ] ;
	//  act   ydervo(k+2,1:4) =[ xd(1+k+1)  ; yd(1+k+1) ; xd(1+k+2)  ; yd(1+k+2)  ] ;

	//  ********************************

	   k=2 ;

	   xc[1]=xd[1] ;
	   yc[1]=yd[1] ;
	   lc[1]=ld[1] ;

	   for (int idx=1;idx<=k+1;idx++){
		  xc[1+idx]=xd[1+idx]/ft[idx] ;
		  yc[1+idx]=yd[1+idx]/ft[idx] ;
	   }

	   for (int idx=1;idx<=k-1;idx++)
		  lc[1+idx]=ld[1+idx]/ft[idx] ;
	   

	   //(smxl =tcprodRHS(xc ,lc,k) details:)
	   //smxl=0;
	   //for idx=1:k
	   //   smxl=smxl+xc(1+idx)*lc(k-idx+1) ;
	   //end;

double smxl=xc[3]*lc[1]+xc[2]*lc[2],smyl=yc[3]*lc[1]+yc[2]*lc[2],smxx=xc[4]*xc[2]+xc[3]*xc[3]+xc[2]*xc[4],smyy=yc[4]*yc[2]+yc[3]*yc[3]+yc[2]*yc[4];
     x9 = xc[1] ;y9 = yc[1] ;
    b_v[1]=-y9*y9/(y9*y9+x9*x9)*smxl*ft[k]+y9*x9/(y9*y9+x9*x9)*smyl*ft[k]+ 0.5*x9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
	b_v[2]=y9*x9/(y9*y9+x9*x9)*smxl*ft[k]-x9*x9/(y9*y9+x9*x9)*smyl*ft[k]+ 0.5*y9/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
	b_v[3]=-x9/(y9*y9+x9*x9)*smxl*ft[k]-y9/(y9*y9+x9*x9)*smyl*ft[k]-0.5/(y9*y9+x9*x9)*-(smxx+smyy)*ft[k+2];
	   //A_MAT=[ 1, 0, xc(1) ; ...
	   //       0, 1, yc(1) ; ...
	   //   2*xc(1), 2*yc(1), 0   ] ;

	   xc[1+k+2]=b_v[1]/ft[k+2] ;
	   yc[1+k+2]=b_v[2]/ft[k+2] ;
	   lc[1+k]=b_v[3]/ft[k] ;

	   xd[1+k+2]=b_v[1] ;
	   yd[1+k+2]=b_v[2] ;
	   ld[1+k]=b_v[3] ;

	k=0;
	   // ydervo(k+2,1:5) =[ xd(1+k+1)  ; yd(1+k+1) ; xd(1+k+2)  ; yd(1+k+2) ; ld(1+k)  ] ;
	   ydervo[2][1] =xd[1+k+1]  ; ydervo[2][2] =yd[1+k+1] ; ydervo[2][3] =xd[1+k+2]  ; ydervo[2][4] =yd[1+k+2] ; ydervo[2][5] =ld[1+k+1]  ;



	   // act ydervo(k+2,1:4) =[ xd(1+k+1)  ; yd(1+k+1) ; xd(1+k+2)  ; yd(1+k+2)  ] ;
	//free memory
	delete ft;
	delete b_v;
	delete ld;
	delete xd;
	delete yd;
	delete xc;
	delete yc;
	delete lc;
}

