#include <math.h>
#include <iostream>

using namespace std;
//Linear system Ax=b solver (A is n x n) using optimized LU with partial pivoting
static void linSolver(double**A_in,double*b_in,int n,double*res){
	//square A_in. A_in and b_in are protected from modification by copying their 
	//contents into local variables A and b.
	//A is overwritten by U.
	//System A*res=b. Input: A_in, b_in, n. Output: res
	double**A=new double*[n+1];
	double*b=new double[n+1];
	for(int i=1;i<=n;i++){
		A[i]=new double[n+1];
		for(int j=1;j<=n;j++)A[i][j]=A_in[i][j];
		b[i]=b_in[i];
	}
	double temp,pivot;int pivotLine;
	for(int j=1;j<=n;j++){
		pivotLine=j;
		pivot=0.0;
		for(int i=j;i<=n;i++){
			if(pivot<fabs(A[i][j])){pivot=fabs(A[i][j]);pivotLine=i;}
		}
		res[j]=b[pivotLine];
		for(int l=j;l<=n;l++){
			if(l!=pivotLine){
				if(fabs(A[pivotLine][j])<=pow(10.0,-16.0)){cout<<"Pivot <= 1E-16. LU decomposition can be inaccurate. Enter any number to continue anyway. Else, stop the program manually.";int hg;cin>>hg;}
				temp=-A[l][j]/A[pivotLine][j];
				for(int k=j;k<=n;k++){
					A[l][k]+=temp*A[pivotLine][k];
				}
				b[l]=b[l]+res[j]*temp;
			}
		}
		for(int k=j;k<=n;k++){
			temp=A[j][k];
			A[j][k]=A[pivotLine][k];
			A[pivotLine][k]=temp;
		}		
		temp=b[j];b[j]=b[pivotLine];b[pivotLine]=temp;
	}
	//Solve U*res(old)=res(new). U is the new A
	for(int i=n;i>=1;i--){//rows
		for(int j=n;j>i;j--){
			res[i]-=res[j]*A[i][j];
		}
		res[i]=res[i]/A[i][i];
	}
	//free memory
	for(int i=1;i<=n;i++)delete A[i];
	delete A;
	delete b;
}
