//Automatic differentiation subroutines
static double tcdiv(double*f,double*g,double*h,int m){
	// calc Taylor coef h(o+m) of Taylor series h =f/g
	// Barrio, "Performance of Taylor series..." p 527

	//tcprod_f=f
	//tcprod_g=g
	//tcprod_m=m

	int o=1 ;
	double smprod=0.0 ;
	for (int jdx=1;jdx<=m;jdx++)
	  smprod=smprod+h[m-jdx+o]*g[o+jdx] ;

	double hm =  (f[m+o] - smprod)/g[o] ;

	//h(o+m) = hm ;
	//tcdiv_m=m
	//tcdiv_fmzero = f(o+m)-tcprod(h, g, m)
	// h[m+o] = hm
	return hm;
}

static double tcexpf(double*h,double*f,int m){
	// calc Taylor coef h(o+m) of Taylor series h=exp(f) 
	// Barrio, "Performance of Taylor series..." p 527
	// input: alp, m
	//        h(o), h(o+1),...,h(o+m-1),
	//        f(o), f(o+1),...f(o+m)
	//
	// output: h(o+m) = expftc
	int o=1 ;
	double expftc = 0.0 ;
	for (int jdx=0;jdx<=m-1;jdx++)
	   expftc = expftc + (m-jdx)*f[m-jdx+o]*h[jdx+o] ;
	expftc = expftc/m ;
	// hm=expftc 

	return expftc;
}

static double tcexpo(double*B,double*r,double alp,int m){
	// calc Taylor coef B(o+m) of Taylor series B=r^alp
	// Barrio, "Performance of Taylor series..." p 527
	// input: alp, m
	//        r(o), r(o+1),...,r(o+m),
	//        B(o), B(o+1),...B(o+m-1)
	//
	// output: B(o+m)

	//alp=-1.5;
	//B(o)= r( o)^(-1.5) ;
	int o=1 ;

	double Bderm=0;
	for (int jdx=0;jdx<=m-1;jdx++)
	   Bderm=Bderm+(alp*m-(alp+1)*jdx)*r[o+m-jdx]*B[jdx+o] ;
	
	Bderm =Bderm/(m*r[o]) ;

	// Berm = B(o+m)=Bderm/(m*r(o)) ;
	return Bderm;
}

static double tcprod(double*f,double*g,int m){
	// calc Taylor coef h(o+m) of Taylor series h =f*g
	// Barrio, "Performance of Taylor series..." p 527
	//tcprod_f=f
	//tcprod_g=g
	//tcprod_m=m
	int o=1 ;
	double smfg=0;
	for (int jdx=0;jdx<=m;jdx++)
	   smfg=smfg+f[m-jdx+o]*g[o+jdx] ;
	return smfg;
}

static double tcprodRHS(double*f,double*g,int m){
	// calc Taylor coef h(o+m) of Taylor series h =f*g
	// Barrio, "Performance of Taylor series..." p 527
	//tcprod_f=f
	//tcprod_g=g
	//tcprod_m=m
	// Ex:  tcprod(a,b,m) = a(o)*b(o+m) + tcprodRHS(a,b,m)
	//   => a(o)*b(o+m) in lin sys & RHS = -tcprodRHS(a,b,m)

	int o=1 ;
	double smfg=0;
	for (int jdx=0;jdx<=m-1;jdx++)
	   smfg=smfg+f[m-jdx+o]*g[o+jdx] ;

	// tcprod_smfg=smfg
	// => LHS = f(o)*g(o+m)
	return smfg;
}

static double tcprodRHS_2b(double*f,double*g,int m){
	// calc Taylor coef h(o+m) of Taylor series h =f*g
	// Barrio, "Performance of Taylor series..." p 527

	//tcprod_f=f
	//tcprod_g=g
	//tcprod_m=m
	int o=1 ;
	double smfg=0;
	for (int jdx=1;jdx<=m-1;jdx++)
	   smfg=smfg+f[m-jdx+o]*g[o+jdx] ;
	// tcprod_smfg=smfg
	return smfg;
}