//1-step 9-stage 4 derivatives Hermite-Birkhoff-Taylor DAE solver of order 10

#include <math.h>
#include <iostream>

using namespace std;

__inline void fvo(double tc, double*yc,int ord, double TOL,double**yvalvo, int nbcmp);//variable order y^(i) evaluation
__inline void f(double tc, double*yc,int ord, double TOL,double**yvalvo, int nbcmp);//evaluation of y'

static void HBT10DAE(double RELTOL,double TOL, double t0, double tend, double*y0,double*tvals,double**yvals,double**fvals,int*res,int nbcmp,int nbMax){
	//-----input
	//RELTOL: relative tolerance
	//TOL: absolute tolerance
	//t0,tend: integration is done over [t0,tend]
	//y0: y(t_0)
	//nbcmp: size of y0
	//nbMax: max size of the arrays tvals, yvals, fvals
	
	//-----output
	//tvals: mesh t_i=tvals[i]
	//yvals: y_i[1:nbcmp]=yvals[1:nbcmp][i]
	//fvals: y'_i[1:nbcmp]=fvals[1:nbcmp][i]
	//res: res[1]=NFE, res[2]-1=number of success steps, res[3]=number of rejected steps

	int nbcmpP1=nbcmp+1;

	//------- PARAM: -------
	//   ode45 hmin:  eps = 2.220446049250313e-16
	double eps = 2.220446049250313e-16 ;
	double hmax = 0.1*fabs(tend-t0)  ; //maximum stepsize
	double stfac=0.81 ;//safety factor for stepsize modification
	int nbeps=9+3 ;
	double hmin = 1.0e-9  ;//minimum stepsize
	//------- END PARAM ----

	int  om=16 ;

	int szTbl=35;
	int szTblP1=szTbl+1;
	
	double*ft=new double[szTblP1];//ft[i]=i!
	ft[1]=1.0;
	ft[2]=2.0;
	ft[3]=6.0;
	ft[4]=24.0;
	ft[5]=120.0;
	ft[6]=720.0;
	ft[7]=5040.0;
	ft[8]=40320.0;
	ft[9]=362880.0;
	ft[10]=3628800.0;
	ft[11]=39916800.0;
	ft[12]=479001600.0;
	ft[13]=6.227020800000000e+09;
	ft[14]=8.717829120000000e+10;
	ft[15]=1.307674368000000e+12;
	ft[16]=2.092278988800000e+13;
	ft[17]=3.556874280960000e+14;
	ft[18]=6.402373705728000e+15;
	ft[19]=1.216451004088320e+17;
	ft[20]=2.432902008176640e+18;
	ft[21]=5.109094217170944e+19;
	ft[22]=1.124000727777608e+21;
	ft[23]=2.585201673888498e+22;
	ft[24]=6.204484017332395e+23;
	ft[25]=1.551121004333099e+25;
	ft[26]=4.032914611266057e+26;
	ft[27]=1.088886945041835e+28;
	ft[28]=3.048883446117139e+29;
	ft[29]=8.841761993739703e+30;
	ft[30]=2.652528598121911e+32;
	ft[31]=8.222838654177925e+33;
	ft[32]=2.631308369336936e+35;

	//offstep points coefficients:
	double c1 =0;
	double c2 =.24188269998442506809106017979300;
	double c3 =.29025923998131008170927221575160;
	double c4 =.34831108797757209805112665890192;
	double c5 =.62483092493479808204881464916980;
	double c6 =7.810039267253426e-01;
	double c7 =.82198205469221052865691490296740;
	double c8 =.92465627764050439818532822755515;
	double c9 =1;

	//coefficients of the method
	double**acf=new double*[szTblP1];
	for(int i=1;i<=szTbl;i++){
		acf[i]=new double[szTblP1];
		for(int k=1;k<=szTbl;k++)acf[i][k]=0.0;
	}
	double**alp=new double*[szTblP1];
	for(int i=1;i<=szTbl;i++){
		alp[i]=new double[szTblP1];
		for(int k=1;k<=szTbl;k++)alp[i][k]=0.0;
	}

	acf[20][9]=.24710577500330824756346439697016e-1;
	acf[20][8]=.99448550703347769443996221049472e-1;
	acf[20][7]=.13112509918415264357482222609678;
	acf[20][6]=.27873777683717468779887727258676e-11;
	acf[20][5]=.25263667133792854732903336374638;
	acf[20][4]=.28701523250271787638750126504938;
	acf[20][3]=0;
	acf[20][2]=0;
	acf[20][1]=.20506386876873496073992873748299;

	alp[20][3]=.17725424414598056486036523071152e-1;
	alp[20][4]=.77318738511752781507863998118087e-3;
	alp[20][5]=.14537434582084152262382541695579e-4;

	//SCPO7hbothd/hb4d/HBT10_9Ed1_d4SCPO7outp:
	acf[19][9]=-.28942249966917524365356030298400e-3;
	acf[19][8]=.12844855070334776944399622104947;
	acf[19][7]=.11612509918415264357482222609678;
	acf[19][6]=.12284346620048259302420968983711;
	acf[19][5]=-.42955109799313587309901848400076e-1;
	acf[19][4]=.96630497472617334463620063875373;
	acf[19][3]=0;
	acf[19][2]=0;
	acf[19][1]=-.29047755851517358812567336703403;

	alp[19][3]=-.11961036944429413061084795305332;
	alp[19][4]=-.15026372294998361496444898681226e-1;
	alp[19][5]=-.77120788969628605235465552594439e-3;

	//HBT10_9Serr=solu-scp
	double*eracf=new double[szTblP1];
	double*eralp=new double[szTblP1];
	eracf[9]=acf[20][9]-acf[19][9];
	eracf[8]=acf[20][8]-acf[19][8];
	eracf[7]=acf[20][7]-acf[19][7];
	eracf[6]=acf[20][6]-acf[19][6];
	eracf[5]=acf[20][5]-acf[19][5];
	eracf[4]=acf[20][4]-acf[19][4];
	eracf[3]=acf[20][3]-acf[19][3];
	eracf[2]=acf[20][2]-acf[19][2];
	eracf[1]=acf[20][1]-acf[19][1];

	eralp[3]=alp[20][3]-alp[19][3];
	eralp[4]=alp[20][4]-alp[19][4];
	eralp[5]=alp[20][5]-alp[19][5];

	acf[2][1]=.24188269998442506809106017979300;

	alp[2][3]=.29253620275877693417670771402800e-1;
	alp[2][4]=.23586482188828060699172191682042e-2;
	alp[2][5]=.14262904987420708259043096481719e-3;

	acf[3][2]=.12037631200504891708646937331649;
	acf[3][1]=.16988292797626116462280284243511;

	alp[3][3]=.13008265835315085687422497261228e-1;
	alp[3][4]=.55430120062321048887910584228147e-3;
	alp[3][5]=.11830223912766232258380705945801e-4;

	acf[4][3]=.14445157440605870050376324797982;
	acf[4][2]=0.0;
	acf[4][1]=.20385951357151339754736341092211;

	alp[4][3]=.18731902802853723389888396056162e-1;
	alp[4][4]=.95783247467690772478309489546181e-3;
	alp[4][5]=.24531152305512059210978231849187e-4;

	acf[5][4]=5.1369149269990263901726358626381;
	acf[5][3]=-7.9684268044976867673921481211574;
	acf[5][2]=0.0;
	acf[5][1]=3.4563428024334584592683269076890;

	alp[5][3]=.71887192342637430217720194292177;
	alp[5][4]=.64721932086189762088244765500343e-1;
	alp[5][5]=.26495151798602782473671695743566e-2;

	acf[6][5]=1.2342369661579729305024703175121;
	acf[6][4]=-49.138517961667588660634956470286;
	acf[6][3]=83.577569960119119852085451154334;
	acf[6][2]=0.0;
	acf[6][1]=-34.892285037884161543190031047720;

	alp[6][3]=-7.6098771416480449867989041599108;
	alp[6][4]=-.70149908096184327117092555152619;
	alp[6][5]=-.29241805191851957544683708354141e-1;

	acf[7][6]=.48838548708876857830579098375761e-1;
	acf[7][5]=1.2731287293833465613316892837919;
	acf[7][4]=-51.751166075010346780261362169161;
	acf[7][3]=87.985530264572620320327668205414;
	acf[7][2]=0.0;
	acf[7][1]=-36.734349412962286430571659515453;

	alp[7][3]=-8.0089142349933782298079535573595;
	alp[7][4]=-.73802334727205677470000643548048;
	alp[7][5]=-.30747127375859080958036490610118e-1;

	acf[8][7]=.66860566301570575805499832640124;
	acf[8][6]=-.62639037397556312370425662184431;
	acf[8][5]=-1.4129505022003263671707208776045;
	acf[8][4]=104.23000491854622456382626402197;
	acf[8][3]=-176.91228047517492241155371160610;
	acf[8][2]=0.0;
	acf[8][1]=74.977667047429385978732754984733;

	alp[8][3]=16.295938931138396511495992964552;
	alp[8][4]=1.5025884594579290141750272299523;
	alp[8][5]=.62720326630315357013056144083621e-1;

	acf[9][8]=.30322334608112423133047424409521;
	acf[9][7]=-1.7461851485802883471832722405544;
	acf[9][6]=2.2617705038580497569503171415147;
	acf[9][5]=2.7663544105292925952744470045806;
	acf[9][4]=-189.81242295008176183024459579087;
	acf[9][3]=324.88983850345892234231144206787;
	acf[9][2]=0.0;
	acf[9][1]=-137.66257866526533874843881242664;

	alp[9][3]=-30.028505996333697783208092715645;
	alp[9][4]=-2.7748387641271546459519806160826;
	alp[9][5]=-.11604720818920195726140515422844;

	int nbpos=10;//index of the first element in tvals, yvals and fvals

	double TOL111=TOL/500.0;

	double tc = t0;//current t
	double*yc=new double[nbcmpP1];//current y
	for(int i=1;i<=nbcmp;i++)yc[i] = y0[i];

	int nder=4;//number of derivatives
	 
	int nderp1 = nder+1 ;
	int nderm1 = nder-1 ;

	int  ndernew=nder ;
	 
	//array containing y^{(i)}, i=0,...,4. Note: yfnewvo[i][:]=y^{(i-1)}(:), i=1,...,5
	double**yfnewvo=new double*[6];
	for(int i=1;i<=5;i++){
		yfnewvo[i]=new double[nbcmpP1];
		for(int k=1;k<=nbcmp;k++)yfnewvo[i][k]=0.0;
	}

	//evaluate y^{(i)} up to i=4
	fvo(tc, yc, nder, TOL111,yfnewvo,nbcmp) ;
	
	for(int k=1;k<=nbcmp;k++)yc[k]=yfnewvo[1][k] ;

	//array containing y^{(i)}, i=1,...,4. Note: fnewvo[i][:]=y^{(i)}(:), i=1,...,4
	double**fnewvo=new double*[5];
	for(int i=1;i<=4;i++){
		fnewvo[i]=new double[nbcmpP1];
		for(int k=1;k<=nbcmp;k++)fnewvo[i][k]=0.0;
	}
	for (int idx =1;idx<=nder;idx++){
		for(int k=1;k<=nbcmp;k++) fnewvo[idx][k] = yfnewvo[idx+1][k] ;
	}

	//   p 530, "Performance of the Taylor series.." Barrio et Al  
	//   p  99-100 Barrio et al "VSVO form. of Taylor method ..."

	//------selecting initial stepsize (begin)
	double dernynorm1  = 0.0;
	double dernynorm2  = 0.0;

	for(int i=1;i<=nbcmp;i++){
		dernynorm1=max(dernynorm1,fabs(fnewvo[ndernew][i]));
		dernynorm2=max(dernynorm2,fabs(fnewvo[ndernew-1][i]));
	}

	double stsize1 =   pow(TOL/1000.0,1.0/ndernew) *pow(1.0/(dernynorm1/ft[ndernew] ) ,1.0/ndernew  ) ;  
	double stsize2 =   pow(TOL/1000.0,1.0/ndernew-1.0) *pow(1.0/(dernynorm2/ft[ndernew-1] ) ,1.0/(ndernew-1) ) ;  

	double h = min(stsize1,stsize2) ;//stepsize
	double hnew=h ;//new stepsize
	double hv=h;
	//------selecting initial stepsize (end)	
	
	int j=0;
	int jpnbpos=j+nbpos;//position of the current mesh point
	tvals[jpnbpos]=tc;
	
	for(int i=1;i<=nbcmp;i++){
		yvals[i][jpnbpos] = yc[i] ; 
		fvals[i][jpnbpos] = fnewvo[1][i] ;
	}
	
	//array containing y^{(i)}, i=1,...,4. Note: fvalsvo[i][:]=y^{(i)}(:), i=1,...,4
	double**fvalsvo=new double*[5];
	for(int i=1;i<=4;i++){
		fvalsvo[i]=new double[nbcmpP1];
		for(int k=1;k<=nbcmp;k++)fvalsvo[i][k]=fnewvo[i][k];
	}

	// init param:
	int nreje=0;//number of rejected steps
	int nb_f_eval=nder;
	
	double t,xk1,yk1,tnewp,au,f2,f3,f4,f5,f6,f7,f8,f9,stsize,hold,prevh;
	double err_est;//error estimate
	double tnew;//new t
	int jpnbposp1;//j+nbpos+1

	double*f1=new double[szTblP1];
	
	double*y_jpc2=new double[nbcmpP1];//Y_2 (y at n+c_2)
	double*y_jpc3=new double[nbcmpP1];
	double*y_jpc4=new double[nbcmpP1];
	double*y_jpc5=new double[nbcmpP1];
	double*y_jpc6=new double[nbcmpP1];
	double*y_jpc7=new double[nbcmpP1];
	double*y_jpc8=new double[nbcmpP1];
	double*y_jpc9=new double[nbcmpP1];

	double*ynew=new double[nbcmpP1];//new y
	double*fnew=new double[nbcmpP1];//new f
	
	double*err_estvc=new double[nbcmpP1];

	double*fnewk2=new double[nbcmpP1];//F_2 (f at n+c_2)
	double*fnewk3=new double[nbcmpP1];
	double*fnewk4=new double[nbcmpP1];
	double*fnewk5=new double[nbcmpP1];
	double*fnewk6=new double[nbcmpP1];
	double*fnewk7=new double[nbcmpP1];
	double*fnewk8=new double[nbcmpP1];
	double*fnewk9=new double[nbcmpP1];

	double**yfnewk2=new double*[3];//Y_2 and F_2 (y and f at c_2)
	double**yfnewk3=new double*[3];
	double**yfnewk4=new double*[3];
	double**yfnewk5=new double*[3];
	double**yfnewk6=new double*[3];
	double**yfnewk7=new double*[3];
	double**yfnewk8=new double*[3];
	double**yfnewk9=new double*[3];
	for(int i=1;i<=2;i++){
		yfnewk2[i]=new double[nbcmpP1];
		yfnewk3[i]=new double[nbcmpP1];
		yfnewk4[i]=new double[nbcmpP1];
		yfnewk5[i]=new double[nbcmpP1];
		yfnewk6[i]=new double[nbcmpP1];
		yfnewk7[i]=new double[nbcmpP1];
		yfnewk8[i]=new double[nbcmpP1];
		yfnewk9[i]=new double[nbcmpP1];
	}

	//Main loop: integrate until t=tend
	while  (tvals[j+nbpos] < tend){
		
		if( j >= nbMax-10){
			cout<<"j>=nbMax-10. Must stop the program manually.\n";
		}
		
		h=hnew;

		if((tc+h) > tend) h=tend-tc ;
		
		// ***************** (MAIN INTEG STEP) *******************************
		err_est=9999;
		if (h <= hmin )	h=1.2*hmin ;
		
		////// LOOP REPEAT UNTIL SUCCESS -----------------------
		while ( err_est > TOL && h > hmin){
			t=tc;
			xk1=tc ;
			jpnbpos=j+nbpos ;
	
			for(int i=1;i<=nbcmp;i++)yc[i] = yvals[i][jpnbpos] ;

			//  ( loop to prepare y_jpc2() bef calling feval() )
			for (int icol =1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ] ;

				for (int idx=1;idx<=nder;idx++)
					f1[idx]  = fvalsvo[idx][icol];
			  
				//   ( predictor equation:)
				//   tc+ c2* h
				alp[2][2] = acf[2][1] ;
				// Horner form.:
				au=( alp[2][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--)
					au = ( au + alp[2][idx+1]*f1[idx] )*h ;

				y_jpc2[icol]  = au + yk1  ;
			}	

			tnewp= tvals[j+nbpos]+c2 * h ;
			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk2[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c2* h , y_jpc2, 1, TOL ,yfnewk2,nbcmp);//evaluate y'
			for(int l=1;l<=nbcmp;l++)fnewk2[l] = yfnewk2[2][l] ;       

			//  ( loop to prepare y_jpc3() bef calling feval() )
			for (int icol =1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ] ;

				for (int idx=1;idx<=nder;idx++)
					f1[idx]  = fvalsvo[idx][icol];
				f2 = fnewk2[icol] ;
				//   ( predictor equation:)
				alp[3][2] = acf[3][1] ;
				// Horner form.:
				au=( alp[3][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--)
					au = ( au + alp[3][idx+1]*f1[idx] )*h ;
			  
				y_jpc3[icol]  = au + yk1 +  h *( acf[3][2]*f2 )  ;
			}
		
			tnewp= tvals[j+nbpos]+c3 * h ;
			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk3[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c3* h , y_jpc3, 1, TOL,yfnewk3,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk3[l] = yfnewk3[2][l] ;       

			//  ( loop to prepare y_jpc4() bef calling feval() )
			for (int icol =1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ] ;

				for (int idx=1;idx<=nder;idx++)
					 f1[idx]  = fvalsvo[idx][icol];
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				//   ( predictor equation:)
				alp[4][2] = acf[4][1] ;
				// Horner form.:
				au=( alp[4][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + alp[4][idx+1]*f1[idx] )*h ;
				}
				y_jpc4[icol]  = au + yk1 +  h *( acf[4][3]*f3 +acf[4][2]*f2 )  ;
			}

			tnewp= tvals[j+nbpos]+c4 * h ;
   			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk4[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c4* h , y_jpc4, 1, TOL,yfnewk4,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk4[l] = yfnewk4[2][l] ;       

			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ] ;

				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				//   ( predictor equation:)
				alp[5][2] = acf[5][1] ;
				// Horner form.:
				au=( alp[5][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
				  au = ( au + alp[5][idx+1]*f1[idx] )*h ;
				}
				y_jpc5[icol]= au + yk1 +  h *( acf[5][4]*f4 +acf[5][3]*f3 +acf[5][2]*f2 )  ;
			}
	
			tnewp= tvals[j+nbpos]+c5 * h ;
			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk5[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c5* h , y_jpc5, 1, TOL,yfnewk5,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk5[l] = yfnewk5[2][l] ;      

			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ];

				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				f5 = fnewk5[icol] ;
				//   ( predictor equation:)
				alp[6][2] = acf[6][1] ;
				// Horner form.:
				au=( alp[6][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + alp[6][idx+1]*f1[idx] )*h ;
				}
				y_jpc6[icol]  = au + yk1 +  h *( acf[6][5]*f5 +acf[6][4]*f4 +acf[6][3]*f3 +acf[6][2]*f2 )  ;
			}

			tnewp= tvals[j+nbpos]+c6 * h ;
   			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk6[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c6* h , y_jpc6, 1, TOL,yfnewk6,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk6[l] = yfnewk6[2][l] ;      

			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ];
		
				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				f5 = fnewk5[icol] ;
				f6 = fnewk6[icol] ;
				//   ( predictor equation:)
				alp[7][2] = acf[7][1] ;
				// Horner form.:
				au=( alp[7][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + alp[7][idx+1]*f1[idx] )*h ;
				}
				y_jpc7[icol]  = au + yk1 +  h *( acf[7][6]*f6 +acf[7][5]*f5 +acf[7][4]*f4 +acf[7][3]*f3 +acf[7][2]*f2 )  ;
			}

			tnewp= tvals[j+nbpos]+c7 * h ;
			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk7[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c7* h , y_jpc7, 1, TOL,yfnewk7,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk7[l] = yfnewk7[2][l] ;      

			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ];
			
				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				f5 = fnewk5[icol] ;
				f6 = fnewk6[icol] ;
				f7 = fnewk7[icol] ;
				//   ( predictor equation:)
				alp[8][2] = acf[8][1] ;
				// Horner form.:
				au=( alp[8][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + alp[8][idx+1]*f1[idx] )*h ;
				}
				y_jpc8[icol]  = au + yk1 +  h *( acf[8][7]*f7 +acf[8][6]*f6 +acf[8][5]*f5 +acf[8][4]*f4 +acf[8][3]*f3 +acf[8][2]*f2 )  ;
			}
		
			tnewp= tvals[j+nbpos]+c8 * h ;
			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk8[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c8* h , y_jpc8, 1, TOL,yfnewk8,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk8[l] = yfnewk8[2][l] ;       

			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ];
				
				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				f5 = fnewk5[icol] ;
				f6 = fnewk6[icol] ;
				f7 = fnewk7[icol] ;
				f8 = fnewk8[icol] ;
				//   ( predictor equation:)
				alp[9][2] = acf[9][1] ;
				// Horner form.:
				au=( alp[9][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + alp[9][idx+1]*f1[idx] )*h ;
				}
				y_jpc9[icol]  = au + yk1 +  h *( acf[9][8]*f8 +acf[9][7]*f7 +acf[9][6]*f6 +acf[9][5]*f5 +acf[9][4]*f4 +acf[9][3]*f3 +acf[9][2]*f2 )  ;
			}
	
			tnewp= tvals[j+nbpos]+c9 * h ;
   			for(int i=1;i<=2;i++){
				for(int l=1;l<=nbcmp;l++)yfnewk9[i][l]=0.0;
			}
			f(tvals[j+nbpos]+c9* h , y_jpc9, 1, TOL,yfnewk9,nbcmp );
			for(int l=1;l<=nbcmp;l++)fnewk9[l] = yfnewk9[2][l] ;      

			//  ( loop to prepare ynew() bef calling feval() )
			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ];
				
				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				f5 = fnewk5[icol] ;
				f6 = fnewk6[icol] ;
				f7 = fnewk7[icol] ;
				f8 = fnewk8[icol] ;
				f9 = fnewk9[icol] ;
				alp[20][2] = acf[20][1]   ;
				// Horner form.:
				au=( alp[20][nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + alp[20][idx+1]*f1[idx] )*h ;
				}
				ynew[icol]  = au + yk1 +  h *( acf[20][9]*f9+acf[20][8]*f8+acf[20][7]*f7+acf[20][6]*f6+acf[20][5]*f5+acf[20][4]*f4+acf[20][3]*f3+acf[20][2]*f2 );
			}

			//  (prep next step)
			tnew = tc + h; 
	  
			for(int icol=1;icol<=nbcmp;icol++){
				yk1 = yvals[icol][jpnbpos ];
				
				for(int idx=1;idx<=nder;idx++){
					f1[idx]  = fvalsvo[idx][icol];
				}
				f2 = fnewk2[icol] ;
				f3 = fnewk3[icol] ;
				f4 = fnewk4[icol] ;
				f5 = fnewk5[icol] ;
				f6 = fnewk6[icol] ;
				f7 = fnewk7[icol] ;
				f8 = fnewk8[icol] ;
				f9 = fnewk9[icol] ;

				eralp[2] = acf[20][1] - acf[19][1]  ;
				// Horner form.:
				au=( eralp[nderp1  ]*f1[nder  ])*h ;
				for (int idx=nderm1;idx>=1;idx--){
					au = ( au + eralp[idx+1]*f1[idx] )*h ;
				}
				err_estvc[icol]  = au +  h *( eracf[9]*f9 +eracf[8]*f8 +eracf[7]*f7 +eracf[6]*f6 +eracf[5]*f5 +eracf[4]*f4+eracf[3]*f3+ eracf[2] *f2 );
			}
			//  end of for(int icol=1;icol<=nbcmp;icol++){ ( loop to calculate y_est() ) 

			err_est=0.0;
			for(int i=1;i<=nbcmp;i++) err_est  = max(err_est, fabs( err_estvc[i]) )  ;
			err_est  = pow (err_est,9.0/8.0)  ;

			hold=h;
			if (err_est > TOL){
				////////   // (the computed step (hold) is rejected, compute smaller h )
				h =  max(  hold *0.7000 * stfac* pow(TOL/err_est,1.0/9.0), hmin) ;
				nreje=nreje+1;
			}
			////////   // end if err_est > TOL
		}
		//////// (end  LOOP REPEAT UNTIL SUCCESS    while ( err_est > TOL ) ----------------

		//  SECTION: (initial guess ynew is mapped onto constraints 
		//      by a root solving process (Newton method) )
		//   input: Jacob. degree freedom = 0 

		tnew = tc + h ;
		// varstynew_zero =  ynew - exp(-(t+h))

		ndernew=4;

		for(int i=1;i<=5;i++){
			for(int k=1;k<=nbcmp;k++)yfnewvo[i][k]=0.0;
		}

		fvo(tnew, ynew, ndernew, TOL,yfnewvo,nbcmp) ;//evaluate y^{(i)}(tnew) for i=1,...,4

		//   fnewvo output: yfnewvo contient new ynew
		for(int i=1;i<=nbcmp;i++){
			ynew[i]=yfnewvo[1][i] ;
			fnew[i]=yfnewvo[2][i] ;
		}
		
    	for (int idx =1;idx<=nder;idx++){
			for(int l=1;l<=nbcmp;l++)fnewvo[idx][l] = yfnewvo[idx+1][l] ;
		}

		for(int icol=1;icol<=nbcmp;icol++){
			yk1 = yvals[icol][jpnbpos ];

			for(int idx=1;idx<=nder;idx++){
				f1[idx]  = fvalsvo[idx][icol];
			}
			f2 = fnewk2[icol] ;
			f3 = fnewk3[icol] ;
			f4 = fnewk4[icol] ;
			f5 = fnewk5[icol] ;
			f6 = fnewk6[icol] ;
			f7 = fnewk7[icol] ;
			f8 = fnewk8[icol] ;
			f9 = fnew[icol] ;

			eralp[2] = acf[20][1] - acf[19][1]  ;
			// Horner form.:
			au=( eralp[nderp1  ]*f1[nder  ])*h ;
			for(int idx=nderm1;idx>=1;idx--){
				au = ( au + eralp[idx+1]*f1[idx] )*h ;
			}
			err_estvc[icol]  = au +  h *( eracf[9]*f9 +eracf[8]*f8 +eracf[7]*f7 +eracf[6]*f6 +eracf[5]*f5 +eracf[4]*f4+eracf[3]*f3+ eracf[2] *f2 );
		}
		//  end of for(int icol=1;icol<=nbcmp;icol++){ ( loop to calculate y_est() ) 

		err_est=0.0;
		for(int i=1;i<=nbcmp;i++) err_est  = max(err_est, fabs( err_estvc[i] ) )  ;
	    err_est  = pow (err_est,9.0/8.0)  ;

		//  (step size formula : h =hold, stsize = hnew)   
		if (err_est != 0.0){ 
			stsize = h * stfac *pow(TOL/err_est,1.0/9.0) ;
		}else{
			stsize = 2*h ;
		}
		//  (end of step size formula : h =hold, stsize = hnew)

		nb_f_eval=nb_f_eval+ nder+8  ;

		tc=tnew;
		for(int i=1;i<=nbcmp;i++){
			yc[i]=ynew[i] ;
			for(int l=1;l<=4;l++)  fvalsvo[l][i] = fnewvo[l][i];
		}	
		jpnbposp1=j+nbpos+1;//index of the new mesh info in the arrays tvals, yvals and fvals
   
		nder = ndernew ;

		hnew=stsize ;//new h

		//  -----(END OF INTEG STEP) --------------------

		//  (yvals,tvals,.. UPDATE STEP)

		tvals[jpnbposp1 ] =  tc;
		for(int i=1;i<=nbcmp;i++){
			yvals[i][jpnbposp1 ] =  yc[i]; 
			fvals[i][jpnbposp1 ] = fnewvo[1][i]  ; 
		}

		prevh = h ;
		j = j+1 ;
	}
	// ( END OF MAIN LOOP  1 integration step/ iteration) -------------

	int n=j-1;
	int NFE=nb_f_eval;
	res[1]=NFE+nreje*(nder+5) ;
	res[2]=n+1 ;// nb succes step
	res[3]=nreje ;

	//free memory
	delete ft;
	for(int i=1;i<=szTbl;i++)delete acf[i];
	delete acf;
	for(int i=1;i<=szTbl;i++)delete alp[i];
	delete alp;
	delete eracf;
	delete eralp;
	delete yc;
	for(int i=1;i<=5;i++)delete yfnewvo[i];
	delete yfnewvo;
	for(int i=1;i<=4;i++)delete fnewvo[i];
	delete fnewvo;
	for(int i=1;i<=4;i++)delete fvalsvo[i];
	delete fvalsvo;
	delete f1;
	delete y_jpc2;
	delete y_jpc3;
	delete y_jpc4;
	delete y_jpc5;
	delete y_jpc6;
	delete y_jpc7;
	delete y_jpc8;
	delete y_jpc9;
	delete ynew;
	delete fnew;
	delete err_estvc;
	delete fnewk2;
	delete fnewk3;
	delete fnewk4;
	delete fnewk5;
	delete fnewk6;
	delete fnewk7;
	delete fnewk8;
	delete fnewk9;
	for(int i=1;i<=2;i++){
		delete yfnewk2[i];
		delete yfnewk3[i];
		delete yfnewk4[i];
		delete yfnewk5[i];
		delete yfnewk6[i];
		delete yfnewk7[i];
		delete yfnewk8[i];
		delete yfnewk9[i];
	}
	delete yfnewk2;
	delete yfnewk3;
	delete yfnewk4;
	delete yfnewk5;
	delete yfnewk6;
	delete yfnewk7;
	delete yfnewk8;
	delete yfnewk9;
}
