#include "linSolver.cpp"
#include "autoDiff.cpp"

//Test problem (VO means variable order): 
//INPUT:  t, yyvc:y(t), ord:compute y^{(i)}(t) up to i=ord or ord+1, nbcmp:size(y)
//OUTPUT:  yvalvo/yvalvo: array containing the computed y^{(i)}(t)'s
static void fvo(double t, double*yyvc, int ord,double TOL, double**yvalvo,int nbcmp){
	
	// Newton method p 611, Burden Faires


	////      U1    U2    U3    y2   y3   y4   y6   y7       c_i 
	//sigma = ...                                     
	//   [   1,   -99,  -99,   0,  -99, -99, -99, -99  ; ... 0
	//      -99,  -99,  -99,   0,    1, -99, -99, -99  ; ... 0
	//      -99,    1,  -99, -99,  -99,   0,   0, -99  ; ... 0
	//      -99,    0,  -99, -99,  -99,   0,   1, -99  ; ... 0
	//      -99,  -99,   1 , -99,  -99, -99, -99,   0  ; ... 0
	//       0,   -99,  -99,   0,    0, -99, -99, -99  ; ... 0
	//      -99,    0,  -99,   0,    0,   0,   0, -99  ; ... 0
	//      -99,    0,    0, -99,  -99,   0,   0,   0 ] ;    0
	//
	//  d_j  1      1     1    0     1    0    1    0    

	// p 373 Pryce
	// stage k = -1 = k_d < k_c = 0 
	// *************
	//   p 372 Pryce: l = k + d_j
	//   ***(Set X_k hold. var.:)***
	//   j=1,  l = k + d_j = -1 + 1 = 0 => we obtain U1
	//   j=2,  l = k + d_j = -1 + 1 = 0 => we obtain U2
	//   j=3,  l = k + d_j = -1 + 1 = 0 => we obtain U3
	//   j=4,  l = k + d_j = -1 + 0 =-1 =>  y2^{-1} does not exist
	//   j=5,  l = k + d_j = -1 + 1 = 0 => we obtain y3
	//   j=6,  l = k + d_j = -1 + 0 =-1 =>  y4^{-1} does not exist
	//   j=7,  l = k + d_j = -1 + 1 = 0 => we obtain y6
	//   j=8,  l = k + d_j = -1 + 0 =-1 =>  y7^{-1} does not exist
	//   *** (Set F_k hold. eq.:)***
	//   i=1,  l = k + c_i = -1 => eq1^{{-1}} does not exist
	//   i=2,  l = k + c_i = -1 => eq2^{{-1}} does not exist
	//   i=3,  l = k + c_i = -1 => eq3^{{-1}} does not exist
	//   i=4,  l = k + c_i = -1 => eq4^{{-1}} does not exist
	//   i=5,  l = k + c_i = -1 => eq5^{{-1}} does not exist
	//   i=6,  l = k + c_i = -1 => eq6^{{-1}} does not exist
	//   i=7,  l = k + c_i = -1 => eq7^{{-1}} does not exist
	//   i=8,  l = k + c_i = -1 => eq8^{{-1}} does not exist
	//   RESULT:   
	//   =>  X_{-1} = (U1,U2,U3, y3, y6) (=> DF = 5),  F_{-1} = empty set of eq.  

	// stage k = 0  
	// *************
	//   p 372 Pryce: l = k + d_j
	//   ***(Set X_k hold. var.:)***
	//   j=1,  l = k + d_j = 0 + 1 = 0 => we obtain U1p
	//   j=2,  l = k + d_j = 0 + 1 = 0 => we obtain U2p
	//   j=3,  l = k + d_j = 0 + 1 = 0 => we obtain U3p
	//   j=4,  l = k + d_j = 0 + 0 = 0 => we obtain y2
	//   j=5,  l = k + d_j = 0 + 1 = 0 => we obtain y3p
	//   j=6,  l = k + d_j = 0 + 0 = 0 => we obtain y4
	//   j=7,  l = k + d_j = 0 + 1 = 0 => we obtain y6p
	//   j=8,  l = k + d_j = 0 + 0 = 0 => we obtain y7
	//   *** (Set F_k hold. equations:)***
	//   i=1,  l = k + c_i = 0 => obtain eq1=F1
	//   i=2,  l = k + c_i = 0 => obtain eq2=F2
	//   i=3,  l = k + c_i = 0 => obtain eq3=F3
	//   i=4,  l = k + c_i = 0 => obtain eq4=F4
	//   i=5,  l = k + c_i = 0 => obtain eq5=F5
	//   i=6,  l = k + c_i = 0 => obtain eq6=F6
	//   i=7,  l = k + c_i = 0 => obtain eq7=F7
	//   i=8,  l = k + c_i = 0 => obtain eq8=F8
	//   RESULT: 
	//   =>  X_{0} = (U1p,U2p,U3p, y2, y3p, y4, y6p,y7),  
	//       F_{0} = follow. eq. set {F(1),F(2),...F(8)}:
	//
	//  solve for U1p,U2p,U3p, y2, y3p, y4, y6p,y7:
	//    (8 DAES:)
	//    F(1) = c1*U1p -(y2-U1)/r0 +uet/r0   ;
	//    F(2) =-c2*y3p + fac1  -y3/r3 ;
	//    F(3) =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;
	//    F(4) =-c4*y6p + fac2  -y6/r7 ;
	//    F(5) =-c5*U3p +(y7-U3)/r9 ;
	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* fac1  ;
	//    F(7) = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*fac2 ; 
	//    F(8) = ub/r8 -y7/r8 -alpha*fac2  -(y7-U3)/r9 ;



	// corrector & f eval


	// input t, yyvc(1),yyvc(2) ,
	int szTbl=20;
	int szTblP1=szTbl+1;

	double*F=new double[szTblP1];
	for(int i=1;i<=szTbl;i++)F[i]=0.0;
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13 ;
	double*ft=new double[szTblP1];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;

	//  Taylor output: y1, y2, y3, y1p, y2p, y3p (nbcmp=6)
	//  Newton iter output: y1, y2, y3, z1, z2  (5 var, 5 eq)
	//    =>  U1=z1 ; U2 = z1-y1 ; U3 = y2 ; U4 = z2 ; U5 = z2 - y3

	// tmp C1 = 1e-6 ;C2 = 2*C1  ;C3 = 3*C1;R0 = 1000 ;R1 = 9000 ;
	// tmp R2 = 9000 ;R3 = 9000 ;R4 = 9000 ;R5 = 9000 ;


		double  uf=0.026 ;
		double  alpha=0.99 ;
		double  beta=1.0e-6 ;
		double  pi=3.1415926535897931086244 ;
		double  c1=1.0e-6, c2=2.0e-6, c3=3.0e-6, c4=4.0e-6, c5=5.0e-6;

		double  r0=1000.0, r1=9000.0, r2=9000.0, r3=9000.0;
		double  r4=9000.0,r5=9000.0,r6=9000.0,r7=9000.0;
		double  r8=9000.0,r9=9000.0;
		double  om=200.0*pi ;

		double  uet   = 0.1 *sin(200.0*pi*t);

		double  ub=6.0   ;

	 int o = 1 ;

	//C1 = 0.001 ;
	//C2 = 2*C1 ;  
	//C3 = 3*C1 ;
	//R0 = 100 ;
	//R1 = 900 ;
	//R2 = 900 ;
	//R3 = 900 ;
	//R4 = 900 ;
	//R5 = 900 ;



	// C1 = 0.8 ;C2 = 0.82*C1 ;  C3 = 0.83*C1 ;R0 = 1.2 ;R1 = 1.4 ;R2 = 1.4 ;R3 = 1.4 ;R4 = 1.4 ;R5 = 1.4 ;


	// act 
	// tmp  om=200*pi ;
	// om= 5 ;
	// tmp om*t = rem(om*t,2*pi ) ; 

	// tmp Uet = 0.4*sin(om*t) ; Uept = 0.4*cos(om*t)*om ;

	// Init :
	// tmp Ub = 6.0 ;

	 // expy   = yyvc(1) ;
	 double y1     = yyvc[1] ;
	 double y2     = yyvc[2] ;
	 double y3     = yyvc[3] ;
	 double y4      = yyvc[4] ;
	 double y5     = yyvc[5] ;
	 double y6     = yyvc[6] ;
	 double y7     = yyvc[7] ;
	 double y8     = yyvc[8] ;

	// y1p    = yyvc(9) ;
	// y2p    = yyvc(10) ;
	// y3p    = yyvc(11) ;
	// y4p    = yyvc(12) ;
	// y5p    = yyvc(13) ;
	// y6p    = yyvc(14) ;
	// y7p    = yyvc(15) ;
	// y8p    = yyvc(16) ;


	//yyvc916 = yyvc(9:16)
	//return

	 double*y1tc=new double[szTblP1];
	 double*y2tc=new double[szTblP1];
	 double*y3tc=new double[szTblP1];
	 double*y4tc=new double[szTblP1];
	 double*y5tc=new double[szTblP1];
	 double*y6tc=new double[szTblP1];
	 double*y7tc=new double[szTblP1];
	 double*y8tc=new double[szTblP1];

		y1tc[o] = y1 ;
		y2tc[o] = y2 ;
		y3tc[o] = y3 ;
		y4tc[o] = y4 ;
		y5tc[o] = y5 ;
		y6tc[o] = y6 ;
		y7tc[o] = y7 ;
		y8tc[o] = y8 ;


		double U1  = y2-y1 ; 
	//    U1p = y2p-y1p ;
		double U2 = y4-y5 ;
	//    U2p= y4p-y5p ;
		double U3 =y7-y8 ;
	//    U3p=y7p-y8p ;
		double*U1tc=new double[szTblP1];
		double*U2tc=new double[szTblP1];
		double*U3tc=new double[szTblP1];
		U1tc[o] = U1 ;
		U2tc[o] = U2 ;
		U3tc[o] = U3 ;

	//    fac1  = beta*(exp((y2-y3)/uf)-1.0e0);
	//    fac2  = beta*(exp((y4-U2-y6)/uf)-1.0e0);

	//    fac1p = beta*exp((y2-y3)/uf)/uf;
	//    fac2p = beta*exp((y4-U2-y6)/uf)/uf;


	 
	// fprintf ( ' succ:  xvc = //10.5e \n', xvc ) ;       

	 double fac1  = beta*(exp((y2-y3)/uf)-1.0);
	 double fac2  = beta*(exp((y4-U2-y6)/uf)-1.0);

	// *** (( uettc(o..)
	 double*uettc=new double[szTblP1];
	  uettc[o] = 0.1*sin(om*t) ;
	  uettc[o+1] = 0.1*cos(om*t)*om  ;
	  uettc[o+2] = - uettc[o]*om*om/ft[2]  ;
	  uettc[o+3] = - uettc[o+1]*om*om/ft[3]  ;

	  for (int idx=4;idx<=ord;idx++){
		  uettc[o+idx] = - uettc[o+idx-2]*om*om/(idx*(idx-1))   ;
		 //  uettc(o+2) : Tayl coef 2 = der2/2! 


	  
	  }

	//   ********* SECTION 1: eq F(1),F(3),F(5), output U1p, U2p, U3p *****************
	//   ********* SECTION 2: eq F(2),F(4)       output y3p, y6p *****************
	//   ********* SECTION 3: eq F(6),F(7),F(8), output y2p, y4p, y7p *****************


	//   ********* SECTION 1: eq F(1),F(3),F(5), output U1p, U2p, U3p *****************
		// F(1) = c1*U1p -(y2-U1)/r0 +uet/r0   ;

	  double U1p = ((y2-U1)/r0 - uet/r0)/c1 ;

		// F(3) =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;
	double	U2pnum = ub/r4 -y4/r4 -alpha*fac1 ;
		double U2p = U2pnum/c3 ;

		// F(5) =-c5*U3p +(y7-U3)/r9 ;
		double U3pnum = (y7-U3)/r9 ;
		double U3p = U3pnum/c5 ;

		U1tc[o+1] = U1p ;  
		U2tc[o+1] = U2p ;  
		U3tc[o+1] = U3p ;  

	//   ********* SECTION 2: eq F(2),F(4)       output y3p, y6p *****************

		// F(2) =-c2*y3p + fac1  -y3/r3 ;
		double y3p = ( fac1  -y3/r3)/c2 ;


		// F(4) =-c4*y6p + fac2  -y6/r7 ;
		double y6p = ( fac2  -y6/r7)/c4 ; 

		y3tc[o+1] = y3p ;
		y6tc[o+1] = y6p ;

	//   ********* SECTION 3: eq F(6),F(7),F(8), output y2p, y4p, y7p *****************


	//   ***** SUBSECTION 3.1: eq F(6) output y2p ***********
	//    F(6) = node1+node2
	//    node1   = (y(1)-uet)/r0
	//    node2   = y(2)/r1+(y(2)-ub)/r2+(1.0-alpha)*fac1

	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* fac1  ;
	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* beta*(exp((y2-y3)/uf)-1.0e0)   ;
		y1tc[o] = y1 ;    y2tc[o] = y2 ;    y3tc[o] = y3 ;    y4tc[o] = y4 ;
		y5tc[o] = y5 ;    y6tc[o] = y6 ;    y7tc[o] = y7 ;    y8tc[o] = y8 ;

		U1tc[o] = U1 ;       U2tc[o] = U2 ;    U3tc[o] = U3 ;

		double*y2my3tc=new double[szTblP1];
		double*expy2my3tc=new double[szTblP1];
		y2my3tc[o] = (y2tc[o]-y3tc[o])/uf ;
		expy2my3tc[o] = exp(y2my3tc[o]) ;


		// F6_2 = [y1tc[o] -uettc[o]]/r0 + y2tc[o]/r1+[y2tc[o]-ub]/r2+[1.0-alpha]*beta*[exp[[y2tc[o]-y3tc[o]]/uf]-1.0e0]
		double F6_2 = (y1tc[o] -uettc[o])/r0 + y2tc[o]/r1+(y2tc[o]-ub)/r2+(1.0-alpha)*beta*(expy2my3tc[o]-1.0);


		double F6 = uettc[o]/r0 -(y2tc[o]-U1tc[o])/r0 +ub/r2 -y2tc[o]*(1.0/r1+1.0/r2)+(alpha-1)*beta*(expy2my3tc[o]-1.0);

		//y1tc(o+1) = y1p ;
		//y2tc(o+1) = y2p ;
		//y3tc(o+1) = y3p ;
		//U1tc(o+1) = U1p ;   


		// tmp y2my3tc(o+1) = (y2tc(o+1)-y3tc(o+1))/uf ;
		// tmp expy2my3tc(o+1) = tcexpf(expy2my3tc,y2my3tc,1)  ;
		// ok expy2my3tc1zero = expy2my3tc(o+1) - exp((y2-y3)/uf)*(y2p-y3p)/uf

		// tmp ok F6p  = uettc(o+1)/r0 - y2tc(o+1)*(1/r0+1/r1+1/r2 ) +U1tc(o+1)/r0 +(alpha-1)*beta*( expy2my3tc(o) *(y2tc(o+1)-y3tc(o+1))/uf )

		// eq F6p  = uettc(o+1)/r0 - y2tc(o+1)*(1/r0+1/r1+1/r2 - (alpha-1)*beta*(expy2my3tc(o))/uf ) +U1tc(o+1)/r0 +(alpha-1)*beta*( expy2my3tc(o) *(-y3tc(o+1))/uf )
		//  => output y2tc(o+1)

		double y2tcnum = uettc[o+1]/r0 +U1tc[o+1]/r0 +(alpha-1)*beta*( expy2my3tc[o] *(-y3tc[o+1])/uf ) ;
		double y2tcden = (1/r0+1/r1+1/r2 - (alpha-1)*beta*(expy2my3tc[o])/uf ) ;
		// tmp F6p2 = y2tcnum - y2tc(o+1)*y2tcden

		double*y3ptc=new double[szTblP1];
		double*y2numtc=new double[szTblP1];
		double*y2dentc=new double[szTblP1];
		double*y2ptc=new double[szTblP1];
		y3ptc[o]=y3tc[o+1] ;
		y2numtc[o] = uettc[o+1]/r0 +U1tc[o+1]/r0 +(alpha-1)*beta*( -expy2my3tc[o]*y3ptc[o]/uf ) ;
		y2dentc[o] = (1.0/r0+1.0/r1+1.0/r2 - (alpha-1)*beta*(expy2my3tc[o])/uf ) ;


		// *** SOLUTION: y2tc[o+1] ********
		y2tc[o+1] = y2tcnum/y2tcden ;
		double y2p = y2tc[o+1] ;
		y2ptc[o] = y2numtc[o]/y2dentc[o] ;

	 
		y2my3tc[o+1] = (y2tc[o+1]-y3tc[o+1])/uf ;
		expy2my3tc[o+1] = tcexpf(expy2my3tc,y2my3tc,1)  ;
	   
		double F6pver  = uettc[o+1]/r0 -(y2tc[o+1]-U1tc[o+1])/r0 -y2tc[o+1]*(1.0/r1+1.0/r2) +(alpha-1)*beta*(expy2my3tc[o+1]);
		// return



	//   ***** (SUBSECTION 3.2: eq F(7) output y4p) ***********
	//    F(7) = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*fac2 ; 
	//    F(7) = ub/r4 -y4/r4 -alpha*beta*(exp((y2-y3)/uf)-1.0e0) +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*beta*(exp((y4-U2-y6)/uf)-1.0e0)  ; 

		 y4tc[o] = y4 ;
		 U2tc[o] = U2 ;   
		 y6tc[o] = y6 ;
		 double*y4mU2my6tc=new double[szTblP1];
		 double*expy4mU2mmy6tc=new double[szTblP1];
		 y4mU2my6tc[o] = (y4tc[o]-U2tc[o]-y6tc[o])/uf ;
		 expy4mU2mmy6tc[o] = exp(y4mU2my6tc[o]) ;

		 double F7 = ub/r4 -y4tc[o]/r4 -alpha*beta*(expy2my3tc[o]-1.0) +ub/r6 -(y4tc[o]-U2tc[o])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o]-1.0);

		 //y4tc(o+1) = y4p ;
		 //U2tc(o+1) = U2p ;   
		 //y6tc(o+1) = y6p ;

		 //y4mU2my6tc(o+1) = (y4tc(o+1)-U2tc(o+1)-y6tc(o+1))/uf ;
		 //expy4mU2mmy6tc(o+1) = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 1)  ;
		 //expy4mU2mmy6tc1zero = expy4mU2mmy6tc(o+1) - exp((y4-U2-y6)/uf)*(y4p-U2p-y6p)/uf

		 // eq. F7p =  -y4tc(o+1)/r4 -alpha*beta*(expy2my3tc(o+1))  -(y4tc(o+1)-U2tc(o+1))*(1/r5+1/r6) +(alpha-1)*beta*(expy4mU2mmy6tc(o+1) )
		 // output: y4tc(o+1)


		 // eq F7p2 =  -alpha*beta*(expy2my3tc(o+1))  -y4tc(o+1)*(1/r4+1/r5+1/r6 -(alpha-1)*beta*expy4mU2mmy6tc(o)/uf ) +(U2tc(o+1))*(1/r5+1/r6) +(alpha-1)*beta*expy4mU2mmy6tc(o)*(-U2tc(o+1)-y6tc(o+1))/uf
		 double*y4tcnum=new double[szTblP1];
		 double*y4tcden=new double[szTblP1];
		 y4tcnum[1] = -alpha*beta*(expy2my3tc[o+1]) +(U2tc[o+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*expy4mU2mmy6tc[o]*(-U2tc[o+1]-y6tc[o+1])/uf ;
		 y4tcden[1] = (1.0/r4+1.0/r5+1.0/r6 -(alpha-1)*beta*expy4mU2mmy6tc[o]/uf )  ;

		double*U2ptc=new double[szTblP1];
		double*y6ptc=new double[szTblP1];
		double*y4numtc=new double[szTblP1];
		double*y4dentc=new double[szTblP1];
		 U2ptc[o]= U2tc[o+1] ;
		 y6ptc[o]= y6tc[o+1];

		 y4numtc[o] = -alpha*beta*(expy2my3tc[o+1]) +(U2tc[o+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*expy4mU2mmy6tc[o]*(-U2ptc[o]-y6ptc[o])/uf ;
		 y4dentc[o] = (1.0/r4+1.0/r5+1.0/r6 -(alpha-1)*beta*expy4mU2mmy6tc[o]/uf )  ;


		 // tmp F7p3 = y4tcnum - y4tc[o+1]*y4tcden

		// *** SOLUTION: y4tc[o+1]=y4ptc[o]  ********
		 y4tc[o+1] = y4tcnum[1]/y4tcden[1] ;
		 double y4p = y4tc[o+1] ;
		 double*y4ptc=new double[szTblP1];
		 y4ptc[o] = y4tcnum[o]/y4tcden[o] ;


		 y4mU2my6tc[o+1] = (y4tc[o+1]-U2tc[o+1]-y6tc[o+1])/uf ;
		 expy4mU2mmy6tc[o+1] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 1)  ;

		 double F7pver =  -y4tc[o+1]/r4 -alpha*beta*(expy2my3tc[o+1])  -(y4tc[o+1]-U2tc[o+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o+1] );

		 // return

	//   ***** (SUBSECTION 3.3: eq F(8) output y7p) ***********
		// F(8) = ub/r8 -y7/r8 -alpha*fac2  -(y7-U3)/r9 ;
		y7tc[o]  = y7 ;
		//y7tc(o+1)= y7p ;
		U3tc[o]  = U3 ;
		//U3tc(o+1)= U3p ;


		//  F(8) = ub/r8 -y7/r8 -alpha*beta*(exp((y4-U2-y6)/uf)-1.0e0)  -(y7-U3)/r9 ;
		double F8 = ub/r8 -y7tc[o]/r8 -alpha*beta*(expy4mU2mmy6tc[o]-1.0)  -(y7tc[o]-U3tc[o])/r9; 

		//F8ptmpok = -y7tc(o+1)/r8 -alpha*beta*(expy4mU2mmy6tc(o+1))  -(y7tc(o+1)-U3tc(o+1))/r9 

		//F8p = - y7tc(o+1)*(1/r8+1/r9 ) -alpha*beta*(expy4mU2mmy6tc(o+1)) +U3tc(o+1)/r9 

		double y7tcnum = -alpha*beta*(expy4mU2mmy6tc[o+1]) +U3tc[o+1]/r9 ;
		double y7tcden = 1.0/r8+1.0/r9  ;  

		// tmp ok F8p2 = y7tcnum - y7tc(o+1)*y7tcden
		y7tc[o+1] = y7tcnum/y7tcden ;
		double y7p = y7tc[o+1] ;

		double F8pver = -y7tc[o+1]/r8 -alpha*beta*(expy4mU2mmy6tc[o+1])  -(y7tc[o+1]-U3tc[o+1])/r9; 

	double y1p = y2p-U1p ;
	double y5p = y4p-U2p ;
	double y8p = y7p-U3p ;


	// **********  NEWTON PROJECTION **********


		U1  = y2-y1 ; 
		U1p = y2p-y1p ;
		U2 = y4-y5 ;
		U2p= y4p-y5p ;
		U3 =y7-y8 ;
		U3p=y7p-y8p ;

	// sys Jacobian "Jac" non singular => 
	//    adjust xvc = [ U1p ;  U2p ; U3p ; y2 ; y3p ; y4 ; y6p ; y7  ];
	 double*xvc=new double[szTblP1];
		xvc[1]= U1p ; xvc[2]= U2p ; xvc[3]=U3p ;xvc[4]= y2 ; xvc[5]=y3p ; xvc[6]=y4 ;xvc[7]= y6p ;xvc[8]= y7 ;

	 // tmp xvc = [ y1 ; y2; y3 ; y4 ; y5; y6; y7; y8  ];
		double*JFvc=new double[szTblP1];
		for(int i=1;i<=szTbl;i++)JFvc[i]=1111.0;

	// fprintf ('corr-feval :  y1 = //10.5e , y2= //10.5e, y3= //10.5e, z1= //10.5e, z2= //10.5e , t= //7.2e  \n', y1, y2, y3, z1, z2, t ) ;

	// fprintf ('corr-feval :  y1p = //10.5e , y2p= //10.5e, y3p= //10.5e  \n', y1p, y2p, y3p ) ;

	// act  while (k <= N )
		double maxAbsJFvc=1111;
		double fac1p,fac2p;
		double**Jac=new double*[9];
	for(int i=1;i<=8;i++){
		Jac[i]=new double[9];
		for(int j=1;j<=8;j++)Jac[i][j]=0.0;
	}
	while (k <= 99  && maxAbsJFvc >= TOL){




		fac1  = beta*(exp((y2-y3)/uf)-1.0);
		fac2  = beta*(exp((y4-U2-y6)/uf)-1.0);

		fac1p = beta*exp((y2-y3)/uf)/uf;
		fac2p = beta*exp((y4-U2-y6)/uf)/uf;

		F[1] = c1*U1p -(y2-U1)/r0 +uet/r0   ;
		F[2] =-c2*y3p + fac1  -y3/r3 ;

		F[3] =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;
		F[4] =-c4*y6p + fac2  -y6/r7 ;
		F[5] =-c5*U3p +(y7-U3)/r9 ;

		F[6] = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1.0/r1+1.0/r2)+(alpha-1)* fac1  ;
		F[7] = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -(y4-U2)*(1.0/r5+1.0/r6) +(alpha-1)*fac2 ; 
		F[8] = ub/r8 -y7/r8 -alpha*fac2  -(y7-U3)/r9 ;


		//       Jac = jacobian(F, [ U1p  U2p U3p  y2 y3p y4 y6p y7 ] ) 

		//       U1p       U2p      U3p                   y2                                 y3p                          y4                     y6p      y7
		Jac[1][1] = c1;Jac[1][4] =   -1/r0;
		Jac[2][4] =  beta*exp((y2-3)/uf)/uf;Jac[2][5] =  -c2;
		Jac[3][2] = -c3;Jac[3][4] =  -alpha*beta/uf*exp((y2-3)/uf);Jac[3][6] = -1/r4;
		Jac[4][6] =  beta*exp((y4-6)/uf)/uf;Jac[4][7] =-c4;
		Jac[5][3] =  -c5;Jac[5][8] =    1.0/r9 ;
		Jac[6][4] = -1.0/r0-1.0/r1-1.0/r2+(alpha-1.0)*beta/uf*exp((y2-3)/uf);
		Jac[7][4] = -alpha*beta/uf*exp((y2-3)/uf);Jac[7][6] = -1/r4-1/r5-1/r6+(alpha-1)*beta/uf*exp((y4-6)/uf) ;
		Jac[8][6] = -alpha*beta/uf*exp((y4-6)/uf);Jac[8][8] =  -1/r8-1/r9 ;

		//rankJac=rank(Jac)
		//det_Jac = ( det(Jac))
		for(int i=1;i<=8;i++)F[i]=-F[i];
		linSolver(Jac,F,8,JFvc);
		for(int i=1;i<=8;i++)F[i]=-F[i];

		// JFvc = inv(Jac)*(-F) ;
		for(int i=1;i<=8;i++)xvc[i]+=JFvc[i];
	
		k = k+1 ;

		//clear all
		//return

		// xvc = [ U1p ;  U2p ; U3p ; y2 ; y3p ; y4 ; y6p ; y7  ];

		U1p= xvc[1] ;
		U2p= xvc[2] ;
		U3p= xvc[3] ;
		y2 = xvc[4] ;
		y3p= xvc[5] ;
		y4 = xvc[6] ;
		y6p= xvc[7] ;
		y7 = xvc[8] ;
		maxAbsJFvc=0.0;
		for(int i=1;i<=8;i++)maxAbsJFvc=max(maxAbsJFvc,fabs(JFvc[i]));
	}
	// ( while (k <= 2 ) & (max(abs(JFvc)) >= TOL))


	y1tc[o] = y1 ;    y2tc[o] = y2 ;    y3tc[o] = y3 ;    y4tc[o] = y4 ;
	y5tc[o] = y5 ;    y6tc[o] = y6 ;    y7tc[o] = y7 ;    y8tc[o] = y8 ;

	U1tc[o] = U1 ;       U2tc[o] = U2 ;    U3tc[o] = U3 ;

	y1p = y2p-U1p ;
	y5p = y4p-U2p ;
	y8p = y7p-U3p ;

	y2tc[o+1] = y2p ;
	y3tc[o+1] = y3p ;

	y1tc[o+1] = y1p ;    y2tc[o+1] = y2p ;    y3tc[o+1] = y3p ;    y4tc[o+1] = y4p ;
	y5tc[o+1] = y5p ;    y6tc[o+1] = y6p ;    y7tc[o+1] = y7p ;    y8tc[o+1] = y8p ;

	U1tc[o+1] = U1p ;    U2tc[o+1] = U2p ;    U3tc[o+1] = U3p ;


	y2my3tc[o] = (y2tc[o]-y3tc[o])/uf ;
	expy2my3tc[o] = exp(y2my3tc[o]) ;

	y4mU2my6tc[o] = (y4tc[o]-U2tc[o]-y6tc[o])/uf ;


	fac1  = beta*(exp((y2-y3)/uf)-1.0);
	fac2  = beta*(exp((y4-U2-y6)/uf)-1.0);

	double*fac1tc=new double[szTblP1];
	double*fac2tc=new double[szTblP1];
	fac1tc[o] = beta*(expy2my3tc[o]-1.0);
	fac2tc[o] = beta*(expy4mU2mmy6tc[o]-1.0);

	F[1] = c1*U1p -(y2-U1)/r0 +uet/r0   ;
	F[2] =-c2*y3p + fac1tc[o]  -y3/r3 ;
	F[3] =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1tc[o]  ;
	F[4] =-c4*y6p + fac2tc[o]  -y6/r7 ;

	F[5] =-c5*U3p +(y7-U3)/r9 ;

	F[6] = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1.0/r1+1.0/r2)+(alpha-1)* fac1tc[o]  ;
	F[7] = ub/r4 -y4/r4 -alpha*fac1tc[o] +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*fac2tc[o] ; 
	F[8] = ub/r8 -y7/r8 -alpha*fac2tc[o]  -(y7-U3)/r9 ;

	//y1p = y2p-U1p ;
	//y5p = y4p-U2p ;
	//y8p = y7p-U3p ;

	//y2tc(o+1) = y2p ;
	//y3tc(o+1) = y3p ;

	//   ********* SECTION 1: eq F(1)p,F(3)p,F(5)p, output U1pp, U2pp, U3pp **********
	//   ********* SECTION 2: eq F(2)p,F(4)p       output y3pp, y6pp *****************
	//   ********* SECTION 3: eq F(6)p,F(7)p,F(8)p, output y2pp, y4pp, y7pp **********

		//*** F(1) = c1*U1p -(y2-U1)/r0 +uet/r0 = 0.0   ;***
		// act
		double U1pp = ((y2p-U1p)/r0 - uettc[o+1]/r0)/c1 ;
		U1tc[o+2] = (((y2tc[o+1]-U1tc[o+1])/r0 - uettc[o+1]/r0)/c1)/2.0 ;
		double U1ppzero = U1pp-U1tc[o+2]*ft[2];


		//*** F(3) =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;***
		y2my3tc[o+1] = (y2tc[o+1]-y3tc[o+1])/uf ;
		expy2my3tc[o+1] = tcexpf(expy2my3tc,y2my3tc,1)  ;
		fac1tc[o+1] = beta*(expy2my3tc[o+1]);

		// U2pp:
		double U2ppnum =  -y4p/r4 -alpha*fac1tc[o+1] ;
		double U2pp = U2ppnum/c3 ;

		double U2tc_o2num =  (-y4tc[o+1]/r4 -alpha*fac1tc[o+1])/2.0 ;
		U2tc[o+2]  = U2tc_o2num/c3 ;
		double U2ppzero = U2pp-U2tc[o+2]*ft[2];


		//*** F(5) =-c5*U3p +(y7-U3)/r9 ;*****
		double U3ppnum = (y7p-U3p)/r9 ;
		double U3pp = U3ppnum/c5 ;


		double U3tc_o2num = (y7tc[o+1]-U3tc[o+1])/2.0/r9 ;
		U3tc[o+2]  = U3tc_o2num/c5 ;
		double U3ppzero = U3pp-U3tc[o+2]*ft[2];


		//U1tc(o+2) = U1pp/ft(2) ;  
		//U2tc(o+2) = U2pp/ft(2) ;  
		//U3tc(o+2) = U3pp/ft(2) ;  

	//   ********* SECTION 2: eq F(2)p,F(4)p output y3pp, y6pp ************

		//*** F(2)p =-c2*y3pp + fac1tc(o+1)  -y3p/r3 ;***
		// act 
		double y3pp = ( fac1tc[o+1]  -y3p/r3)/c2 ;
		y3tc[o+2] = (( fac1tc[o+1]  -y3tc[o+1]/r3)/c2)/2.0 ;
		double y3ppzero = y3pp -y3tc[o+2]*ft[2];

		// F(4)p =-c4*y6pp + fac2tc(o+1)  -y6p/r7 ;
		 y4mU2my6tc[o+1] = (y4tc[o+1]-U2tc[o+1]-y6tc[o+1])/uf ;
		 expy4mU2mmy6tc[o+1] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 1)  ;
		 fac2tc[o+1] = beta*expy4mU2mmy6tc[o+1];

		// act
		double y6pp = (fac2tc[o+1]  -y6p/r7)/c4 ; 
		y6tc[o+2]  = ((fac2tc[o+1]  -y6tc[o+1]/r7)/c4)/2.0 ; 
		double y6ppzero = y6pp - y6tc[o+2]*ft[2];


		//y3tc(o+2) = y3pp/ft(2) ;
		//y6tc(o+2) = y6pp/ft(2) ;

	//   ********* SECTION 3: eq F(6),F(7),F(8), output y2p, y4p, y7p *****************


	//   ***** SUBSECTION 3.1: eq F(6)p output y2pp ***********
	//    F(6) = node1+node2
	//    node1   = (y(1)-uet)/r0
	//    node2   = y(2)/r1+(y(2)-ub)/r2+(1.0-alpha)*fac1

	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* fac1  ;
	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* beta*(exp((y2-y3)/uf)-1.0e0)   ;

		y3ptc[o+1]=y3tc[o+2]*2 ;
		y2numtc[o+1] = uettc[o+2]*2.0/r0 +U1tc[o+2]*2.0/r0 +(alpha-1)*beta*(-tcprod(expy2my3tc,y3ptc,1)/uf ) ;
		y2dentc[o+1] =  - (alpha-1)*beta*expy2my3tc[o+1]/uf  ;


		// *** SOLUTION: y2tc[o+2] ********
		y2ptc[o+1] = tcdiv(y2numtc,y2dentc,y2ptc ,1) ;
		y2tc[o+2] = y2ptc[o+1]/2 ;
		double y2pp = y2ptc[o+1] ;
		double y2ppzero = y2pp - y2tc[o+2]*ft[2];

		y2my3tc[o+2] = (y2tc[o+2]-y3tc[o+2])/uf ;
		expy2my3tc[o+2] = tcexpf(expy2my3tc,y2my3tc,2)  ;
	   
		double F6ppver  = uettc[o+2]/r0 -(y2tc[o+2]-U1tc[o+2])/r0 -y2tc[o+2]*(1.0/r1+1.0/r2) +(alpha-1)*beta*(expy2my3tc[o+2]);



	//   ***** (SUBSECTION 3.2: eq F(7)p output y4pp) ***********
	//    F(7) = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*fac2 ; 
	//    F(7) = ub/r4 -y4/r4 -alpha*beta*(exp((y2-y3)/uf)-1.0e0) +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*beta*(exp((y4-U2-y6)/uf)-1.0e0)  ; 

		 y4mU2my6tc[o+1] = (y4tc[o+1]-U2tc[o+1]-y6tc[o+1])/uf ;
		 expy4mU2mmy6tc[o+1] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 1)  ;

		double F7p =  -y4tc[o+1]/r4 -alpha*beta*expy2my3tc[o+1]  -(y4tc[o+1]-U2tc[o+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o+1] );


		 U2ptc[o+1]= U2tc[o+2]*2 ;
		 y6ptc[o+1]= y6tc[o+2]*2;
	     

		 y4numtc[o+1] = -alpha*beta*expy2my3tc[o+2]*2 +(U2tc[o+2]*2)*(1.0/r5+1.0/r6) +(alpha-1)*beta*(-tcprod(expy4mU2mmy6tc, U2ptc,1)-tcprod(expy4mU2mmy6tc, y6ptc,1) )/uf ;
		 y4dentc[o+1] =  -(alpha-1)*beta*expy4mU2mmy6tc[o+1]/uf  ;

		 // tmp F7p3 = y4tcnum - y4tc[o+1]*y4tcden

		// *** SOLUTION: y4tc[o+1] ********
		 y4ptc[o+1] = tcdiv(y4numtc,y4dentc,y4ptc ,1) ;
		y4tc[o+2] = y4ptc[o+1]/2 ;
		double y4pp = y4ptc[o+1] ;
		double y4ppzero = y4pp - y4tc[o+2]*ft[2];


		// verif:
		 y4mU2my6tc[o+2] = (y4tc[o+2]-U2tc[o+2]-y6tc[o+2])/uf ;
		 expy4mU2mmy6tc[o+2] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 2)  ;

		 double F7ppver =  -y4tc[o+2]/r4 -alpha*beta*(expy2my3tc[o+2]) -(y4tc[o+2]-U2tc[o+2])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o+2] );


	//   ***** (SUBSECTION 3.3: eq F(8)p output y7pp) ***********
		// F(8) = ub/r8 -y7/r8 -alpha*fac2  -(y7-U3)/r9 ;


		y7tcnum = -alpha*beta*(expy4mU2mmy6tc[o+2]) +U3tc[o+2]/r9 ;
		y7tcden = 1.0/r8+1.0/r9  ;  

		// tmp ok F8p2 = y7tcnum - y7tc(o+1)*y7tcden
		y7tc[o+2] = y7tcnum/y7tcden ;

		double y7pp = y7tc[o+2]*ft[2] ;


		double F8ppver = -y7tc[o+2]/r8 -alpha*beta*(expy4mU2mmy6tc[o+2])  -(y7tc[o+2]-U3tc[o+2])/r9 ;

		// return

	double y1pp = y2pp-U1pp ;
	double y5pp = y4pp-U2pp ;
	double y8pp = y7pp-U3pp ;

	y1tc[o+2] = y2tc[o+2]-U1tc[o+2] ;
	y5tc[o+2] = y4tc[o+2]-U2tc[o+2] ;
	y8tc[o+2] = y7tc[o+2]-U3tc[o+2] ;

	double y1ppzero =y1pp -y1tc[o+2]*ft[2];
	double y5ppzero =y5pp -y5tc[o+2]*ft[2];
	double y8ppzero =y8pp -y8tc[o+2]*ft[2];



	//   ********* SECTION 1: eq F(1)p,F(3)p,F(5)p, output U1pp, U2pp, U3pp **********
	//   ********* SECTION 2: eq F(2)p,F(4)p       output y3pp, y6pp *****************
	//   ********* SECTION 3: eq F(6)p,F(7)p,F(8)p, output y2pp, y4pp, y7pp **********
	//    m=2 ;
	double F8pppver,F7pppver;


	for (int m2=2;m2<=ord-1;m2++){

		//*** F(1) = c1*U1p -(y2-U1)/r0 +uet/r0 = 0.0   ;***
		// act
		// tmp U1pp = ((y2p-U1p)/r0 - uettc(o+1)/r0)/c1 ;
		U1tc[o+m2+1] = (((y2tc[o+m2]-U1tc[o+m2])/r0 - uettc[o+m2]/r0)/c1)/(m2+1)  ;
		// U1ppzero = U1pp-U1tc(o+2)*ft(2)


		//*** F(3) =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;***
		y2my3tc[o+m2] = (y2tc[o+m2]-y3tc[o+m2])/uf ;
		expy2my3tc[o+m2] = tcexpf(expy2my3tc,y2my3tc,m2)  ;
		fac1tc[o+m2] = beta*(expy2my3tc[o+m2]);

		// U2pp:
		//U2ppnum =  -y4p/r4 -alpha*fac1tc(o+1) ;
		//U2pp = U2ppnum/c3 ;


		U2tc_o2num =  (-y4tc[o+m2]/r4 -alpha*fac1tc[o+m2])/(m2+1) ;
		U2tc[o+m2+1]  = U2tc_o2num/c3 ;
		// tmp U2ppzero = U2pp-U2tc(o+2)*ft(2)


		//*** F(5) =-c5*U3p +(y7-U3)/r9 ;*****
		//U3ppnum = (y7p-U3p)/r9 ;
		//U3pp = U3ppnum/c5 ;


		U3tc_o2num = (y7tc[o+m2]-U3tc[o+m2])/(m2+1)/r9 ;
		U3tc[o+m2+1]  = U3tc_o2num/c5 ;
		// U3ppzero = U3pp-U3tc(o+2)*ft(2)


	//   ********* SECTION 2: eq F(2)p,F(4)p output y3pp, y6pp ************

		//*** F(2)p =-c2*y3pp + fac1tc(o+1)  -y3p/r3 ;***
		// act 
		// y3pp = ( fac1tc(o+1)  -y3p/r3)/c2 ;
		y3tc[o+m2+1] = (( fac1tc[o+m2]  -y3tc[o+m2]/r3)/c2)/(m2+1)  ;
		// y3ppzero = y3pp -y3tc(o+2)*ft(2)


		// F(4)p =-c4*y6pp + fac2tc(o+1)  -y6p/r7 ;
		 y4mU2my6tc[o+m2] = (y4tc[o+m2]-U2tc[o+m2]-y6tc[o+m2])/uf ;
		 expy4mU2mmy6tc[o+m2] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, m2)  ;
		 fac2tc[o+m2] = beta*expy4mU2mmy6tc[o+m2];

		// act
		// y6pp = [fac2tc[o+1]  -y6p/r7]/c4 ; 
		y6tc[o+m2+1]  = ((fac2tc[o+m2]  -y6tc[o+m2]/r7)/c4)/(m2+1) ; 
		// y6ppzero = y6pp - y6tc(o+2)*ft(2)


		//y3tc(o+2) = y3pp/ft(2) ;
		//y6tc(o+2) = y6pp/ft(2) ;

	//   ********* SECTION 3: eq F(6),F(7),F(8), output y2p, y4p, y7p *****************


	//   ***** SUBSECTION 3.1: eq F(6)p output y2pp ***********
	//    F(6) = node1+node2
	//    node1   = (y(1)-uet)/r0
	//    node2   = y(2)/r1+(y(2)-ub)/r2+(1.0-alpha)*fac1

	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* fac1  ;
	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* beta*(exp((y2-y3)/uf)-1.0e0)   ;

		y3ptc[o+m2]=y3tc[o+m2+1]*(m2+1) ;
		y2numtc[o+m2] = uettc[o+m2+1]*(m2+1)/r0 +U1tc[o+m2+1]*(m2+1)/r0 +(alpha-1)*beta*(-tcprod(expy2my3tc,y3ptc,m2)/uf ) ;
		y2dentc[o+m2] = ( - (alpha-1)*beta*(expy2my3tc[o+m2])/uf ) ;


		// *** SOLUTION: y2tc[o+2] ********
		y2ptc[o+m2] = tcdiv(y2numtc,y2dentc,y2ptc ,m2) ;
		y2tc[o+m2+1] = y2ptc[o+m2]/(m2+1) ;
		//y2pp = y2ptc[o+1] ;
		//y2ppzero = y2pp - y2tc[o+2]*ft[2]

		y2my3tc[o+m2+1] = (y2tc[o+m2+1]-y3tc[o+m2+1])/uf ;
		expy2my3tc[o+m2+1] = tcexpf(expy2my3tc,y2my3tc,m2+1)  ;
	   
		// F6ppver  = uettc[o+2]/r0 -[y2tc[o+2]-U1tc[o+2]]/r0 -y2tc[o+2]*[1/r1+1/r2] +[alpha-1]*beta*[expy2my3tc[o+2]]



	//   ***** [SUBSECTION 3.2: eq F[7]p output y4pp] ***********
	//    F[7] = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -[y4-U2]*[1/r5+1/r6] +[alpha-1]*fac2 ; 
	//    F[7] = ub/r4 -y4/r4 -alpha*beta*[exp[[y2-y3]/uf]-1.0e0] +ub/r6 -[y4-U2]*[1/r5+1/r6] +[alpha-1]*beta*[exp[[y4-U2-y6]/uf]-1.0e0]  ; 

		 y4mU2my6tc[o+m2] = (y4tc[o+m2]-U2tc[o+m2]-y6tc[o+m2])/uf ;
		 expy4mU2mmy6tc[o+m2] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, m2)  ;

		 // F7p =  -y4tc[o+1]/r4 -alpha*beta*[expy2my3tc[o+1]]  -[y4tc[o+1]-U2tc[o+1]]*[1/r5+1/r6] +[alpha-1]*beta*[expy4mU2mmy6tc[o+1] ]


		 U2ptc[o+m2]= U2tc[o+m2+1]*(m2+1) ;
		 y6ptc[o+m2]= y6tc[o+m2+1]*(m2+1) ;
	     


		 y4numtc[o+m2] = -alpha*beta*(expy2my3tc[o+m2+1]*(m2+1)) +(U2tc[o+m2+1]*(m2+1))*(1.0/r5+1.0/r6) +(alpha-1)*beta*(-tcprod(expy4mU2mmy6tc, U2ptc,m2)-tcprod(expy4mU2mmy6tc, y6ptc,m2) )/uf ;
		 y4dentc[o+m2] = ( -(alpha-1)*beta*expy4mU2mmy6tc[o+m2]/uf )  ;

		 // tmp F7p3 = y4tcnum - y4tc[o+1]*y4tcden

		// *** SOLUTION: y4tc[o+1] ********
		y4ptc[o+m2] = tcdiv(y4numtc,y4dentc,y4ptc ,m2) ;
		y4tc[o+m2+1] = y4ptc[o+m2]/(m2+1) ;
		// y4pp = y4ptc[o+1] ;
		// y4ppzero = y4pp - y4tc[o+2]*ft[2]


		// verif:
		 y4mU2my6tc[o+m2+1] = (y4tc[o+m2+1]-U2tc[o+m2+1]-y6tc[o+m2+1])/uf ;
		 expy4mU2mmy6tc[o+m2+1] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc,m2+1)  ;


		 // tmp F7ppver =  -y4tc[o+2]/r4 -alpha*beta*[expy2my3tc[o+2]]  -[y4tc[o+2]-U2tc[o+2]]*[1/r5+1/r6] +[alpha-1]*beta*[expy4mU2mmy6tc[o+2] ]

		 F7pppver =  -y4tc[o+m2+1]/r4 -alpha*beta*expy2my3tc[o+m2+1]  -(y4tc[o+m2+1]-U2tc[o+m2+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o+m2+1] );


	//   ***** [SUBSECTION 3.3: eq F[8]p output y7pp] ***********
		// F[8] = ub/r8 -y7/r8 -alpha*fac2  -[y7-U3]/r9 ;


		y7tcnum = -alpha*beta*expy4mU2mmy6tc[o+m2+1] +U3tc[o+m2+1]/r9 ;
		y7tcden = 1.0/r8+1.0/r9  ;  

		// tmp ok F8p2 = y7tcnum - y7tc(o+1)*y7tcden
		y7tc[o+m2+1] = y7tcnum/y7tcden ;

		// y7pp = y7tc[o+2]*ft[2] ;


		F8pppver = -y7tc[o+m2+1]/r8 -alpha*beta*expy4mU2mmy6tc[o+m2+1]  -(y7tc[o+m2+1]-U3tc[o+m2+1])/r9; 

		y1tc[o+m2+1] = y2tc[o+m2+1]-U1tc[o+m2+1] ;
		y5tc[o+m2+1] = y4tc[o+m2+1]-U2tc[o+m2+1] ;
		y8tc[o+m2+1] = y7tc[o+m2+1]-U3tc[o+m2+1] ;

	}
	// (end for m=2:4)

	//yvalvo(1,1:8) =[  y1; y2; y3; y4 ; y5 ;  y6 ;  y7 ;  y8  ] ;
	//yvalvo(2,1:8) =[ y1p; y2p; y3p; y4p ; y5p ;  y6p ;  y7p ;  y8p  ] ;
	//yvalvo(3,1:8) =[ y1pp; y2pp; y3pp; y4pp ; y5pp ;  y6pp ;  y7pp ;  y8pp  ] ;


	yvalvo[1][1] = y1tc[o] ;
	yvalvo[1][2] =y2tc[o] ;
	yvalvo[1][3] =y3tc[o] ;
	yvalvo[1][4] =y4tc[o] ;
	yvalvo[1][5] =y5tc[o] ;
	yvalvo[1][6] =y6tc[o] ;
	yvalvo[1][7] =y7tc[o] ;
	yvalvo[1][8] =y8tc[o]  ;
	yvalvo[2][1] =y1tc[o+1] ; 
	yvalvo[2][2] =y2tc[o+1] ; 
	yvalvo[2][3] =y3tc[o+1] ;
	yvalvo[2][4] =y4tc[o+1] ; 
	yvalvo[2][5] =y5tc[o+1] ;
	yvalvo[2][6] =y6tc[o+1] ;
	yvalvo[2][7] =y7tc[o+1] ; 
	yvalvo[2][8] =y8tc[o+1] ;

	for (int idx=3;idx<=ord+1;idx++){
	   yvalvo[idx][1]= y1tc[o+idx-1]*ft[idx-1] ; 
		yvalvo[idx][2]=y2tc[o+idx-1]*ft[idx-1] ; 
		yvalvo[idx][3]=y3tc[o+idx-1]*ft[idx-1] ; 
		yvalvo[idx][4]=y4tc[o+idx-1]*ft[idx-1] ; 
		yvalvo[idx][5]=y5tc[o+idx-1]*ft[idx-1] ; 
		yvalvo[idx][6]=y6tc[o+idx-1]*ft[idx-1] ;
		yvalvo[idx][7]=y7tc[o+idx-1]*ft[idx-1] ; 
		yvalvo[idx][8]=y8tc[o+idx-1]*ft[idx-1]   ;
	}

	//for idx=1:ord 
	//   yvalvo(idx+1,1:8) =[   y1tc(o+idx)*ft(idx) ; y2tc(o+idx )*ft(idx ) ; y3tc(o+idx )*ft(idx ) ;  y4tc(o+idx)*ft(idx) ; y5tc(o+idx )*ft(idx ) ; y6tc(o+idx )*ft(idx ) ; y7tc(o+idx)*ft(idx) ; y8tc(o+idx )*ft(idx )  ] ;
	//end;



	// Ex:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)
	//free memory:
	delete F;delete ft;
	delete y1tc;delete y2tc;delete y3tc;delete y4tc;delete y5tc;delete y6tc;delete y7tc;delete y8tc;
	delete U1tc;delete U2tc;delete U3tc;delete uettc;
	delete y2my3tc;delete expy2my3tc;
	delete y3ptc;
	delete y2numtc;delete y2dentc;
	delete y2ptc;
	delete y4mU2my6tc;delete expy4mU2mmy6tc;
	delete y4tcnum;delete y4tcden;
	delete U2ptc;
	delete y6ptc;
	delete y4numtc;delete y4dentc;
	delete y4ptc;
	delete xvc;delete JFvc;
	for(int i=1;i<=8;i++)delete Jac[i];
	delete Jac;
	delete fac1tc;delete fac2tc;
}	
static void f(double t, double*yyvc, int ord,double TOL,double**yvalvo, int nbcmp){


	
	// Newton method p 611, Burden Faires


	////      U1    U2    U3    y2   y3   y4   y6   y7       c_i 
	//sigma = ...                                     
	//   [   1,   -99,  -99,   0,  -99, -99, -99, -99  ; ... 0
	//      -99,  -99,  -99,   0,    1, -99, -99, -99  ; ... 0
	//      -99,    1,  -99, -99,  -99,   0,   0, -99  ; ... 0
	//      -99,    0,  -99, -99,  -99,   0,   1, -99  ; ... 0
	//      -99,  -99,   1 , -99,  -99, -99, -99,   0  ; ... 0
	//       0,   -99,  -99,   0,    0, -99, -99, -99  ; ... 0
	//      -99,    0,  -99,   0,    0,   0,   0, -99  ; ... 0
	//      -99,    0,    0, -99,  -99,   0,   0,   0 ] ;    0
	//
	//  d_j  1      1     1    0     1    0    1    0    

	// p 373 Pryce
	// stage k = -1 = k_d < k_c = 0 
	// *************
	//   p 372 Pryce: l = k + d_j
	//   ***(Set X_k hold. var.:)***
	//   j=1,  l = k + d_j = -1 + 1 = 0 => we obtain U1
	//   j=2,  l = k + d_j = -1 + 1 = 0 => we obtain U2
	//   j=3,  l = k + d_j = -1 + 1 = 0 => we obtain U3
	//   j=4,  l = k + d_j = -1 + 0 =-1 =>  y2^{-1} does not exist
	//   j=5,  l = k + d_j = -1 + 1 = 0 => we obtain y3
	//   j=6,  l = k + d_j = -1 + 0 =-1 =>  y4^{-1} does not exist
	//   j=7,  l = k + d_j = -1 + 1 = 0 => we obtain y6
	//   j=8,  l = k + d_j = -1 + 0 =-1 =>  y7^{-1} does not exist
	//   *** (Set F_k hold. eq.:)***
	//   i=1,  l = k + c_i = -1 => eq1^{{-1}} does not exist
	//   i=2,  l = k + c_i = -1 => eq2^{{-1}} does not exist
	//   i=3,  l = k + c_i = -1 => eq3^{{-1}} does not exist
	//   i=4,  l = k + c_i = -1 => eq4^{{-1}} does not exist
	//   i=5,  l = k + c_i = -1 => eq5^{{-1}} does not exist
	//   i=6,  l = k + c_i = -1 => eq6^{{-1}} does not exist
	//   i=7,  l = k + c_i = -1 => eq7^{{-1}} does not exist
	//   i=8,  l = k + c_i = -1 => eq8^{{-1}} does not exist
	//   RESULT:   
	//   =>  X_{-1} = (U1,U2,U3, y3, y6) (=> DF = 5),  F_{-1} = empty set of eq.  

	// stage k = 0  
	// *************
	//   p 372 Pryce: l = k + d_j
	//   ***(Set X_k hold. var.:)***
	//   j=1,  l = k + d_j = 0 + 1 = 0 => we obtain U1p
	//   j=2,  l = k + d_j = 0 + 1 = 0 => we obtain U2p
	//   j=3,  l = k + d_j = 0 + 1 = 0 => we obtain U3p
	//   j=4,  l = k + d_j = 0 + 0 = 0 => we obtain y2
	//   j=5,  l = k + d_j = 0 + 1 = 0 => we obtain y3p
	//   j=6,  l = k + d_j = 0 + 0 = 0 => we obtain y4
	//   j=7,  l = k + d_j = 0 + 1 = 0 => we obtain y6p
	//   j=8,  l = k + d_j = 0 + 0 = 0 => we obtain y7
	//   *** (Set F_k hold. equations:)***
	//   i=1,  l = k + c_i = 0 => obtain eq1=F1
	//   i=2,  l = k + c_i = 0 => obtain eq2=F2
	//   i=3,  l = k + c_i = 0 => obtain eq3=F3
	//   i=4,  l = k + c_i = 0 => obtain eq4=F4
	//   i=5,  l = k + c_i = 0 => obtain eq5=F5
	//   i=6,  l = k + c_i = 0 => obtain eq6=F6
	//   i=7,  l = k + c_i = 0 => obtain eq7=F7
	//   i=8,  l = k + c_i = 0 => obtain eq8=F8
	//   RESULT: 
	//   =>  X_{0} = (U1p,U2p,U3p, y2, y3p, y4, y6p,y7),  
	//       F_{0} = follow. eq. set {F(1),F(2),...F(8)}:
	//
	//  solve for U1p,U2p,U3p, y2, y3p, y4, y6p,y7:
	//    (8 DAES:)
	//    F(1) = c1*U1p -(y2-U1)/r0 +uet/r0   ;
	//    F(2) =-c2*y3p + fac1  -y3/r3 ;
	//    F(3) =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;
	//    F(4) =-c4*y6p + fac2  -y6/r7 ;
	//    F(5) =-c5*U3p +(y7-U3)/r9 ;
	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* fac1  ;
	//    F(7) = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*fac2 ; 
	//    F(8) = ub/r8 -y7/r8 -alpha*fac2  -(y7-U3)/r9 ;



	// corrector & f eval


	// input t, yyvc(1),yyvc(2) ,
	int szTbl=20;
	int szTblP1=szTbl+1;

	double*F=new double[szTblP1];
	for(int i=1;i<=szTbl;i++)F[i]=0.0;
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13 ;
	double*ft=new double[szTblP1];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;

	//  Taylor output: y1, y2, y3, y1p, y2p, y3p (nbcmp=6)
	//  Newton iter output: y1, y2, y3, z1, z2  (5 var, 5 eq)
	//    =>  U1=z1 ; U2 = z1-y1 ; U3 = y2 ; U4 = z2 ; U5 = z2 - y3

	// tmp C1 = 1e-6 ;C2 = 2*C1  ;C3 = 3*C1;R0 = 1000 ;R1 = 9000 ;
	// tmp R2 = 9000 ;R3 = 9000 ;R4 = 9000 ;R5 = 9000 ;


		double  uf=0.026 ;
		double  alpha=0.99 ;
		double  beta=1.0e-6 ;
		double  pi=3.1415926535897931086244 ;
		double  c1=1.0e-6, c2=2.0e-6, c3=3.0e-6, c4=4.0e-6, c5=5.0e-6;

		double  r0=1000.0, r1=9000.0, r2=9000.0, r3=9000.0;
		double  r4=9000.0,r5=9000.0,r6=9000.0,r7=9000.0;
		double  r8=9000.0,r9=9000.0;
		double  om=200.0*pi ;

		double  uet   = 0.1 *sin(200.0*pi*t);

		double  ub=6.0   ;

	 int o = 1 ;

	//C1 = 0.001 ;
	//C2 = 2*C1 ;  
	//C3 = 3*C1 ;
	//R0 = 100 ;
	//R1 = 900 ;
	//R2 = 900 ;
	//R3 = 900 ;
	//R4 = 900 ;
	//R5 = 900 ;



	// C1 = 0.8 ;C2 = 0.82*C1 ;  C3 = 0.83*C1 ;R0 = 1.2 ;R1 = 1.4 ;R2 = 1.4 ;R3 = 1.4 ;R4 = 1.4 ;R5 = 1.4 ;


	// act 
	// tmp  om=200*pi ;
	// om= 5 ;
	// tmp om*t = rem(om*t,2*pi ) ; 

	// tmp Uet = 0.4*sin(om*t) ; Uept = 0.4*cos(om*t)*om ;

	// Init :
	// tmp Ub = 6.0 ;

	 // expy   = yyvc(1) ;
	 double y1     = yyvc[1] ;
	 double y2     = yyvc[2] ;
	 double y3     = yyvc[3] ;
	 double y4      = yyvc[4] ;
	 double y5     = yyvc[5] ;
	 double y6     = yyvc[6] ;
	 double y7     = yyvc[7] ;
	 double y8     = yyvc[8] ;

	// y1p    = yyvc(9) ;
	// y2p    = yyvc(10) ;
	// y3p    = yyvc(11) ;
	// y4p    = yyvc(12) ;
	// y5p    = yyvc(13) ;
	// y6p    = yyvc(14) ;
	// y7p    = yyvc(15) ;
	// y8p    = yyvc(16) ;


	//yyvc916 = yyvc(9:16)
	//return

	 double*y1tc=new double[szTblP1];
	 double*y2tc=new double[szTblP1];
	 double*y3tc=new double[szTblP1];
	 double*y4tc=new double[szTblP1];
	 double*y5tc=new double[szTblP1];
	 double*y6tc=new double[szTblP1];
	 double*y7tc=new double[szTblP1];
	 double*y8tc=new double[szTblP1];

		y1tc[o] = y1 ;
		y2tc[o] = y2 ;
		y3tc[o] = y3 ;
		y4tc[o] = y4 ;
		y5tc[o] = y5 ;
		y6tc[o] = y6 ;
		y7tc[o] = y7 ;
		y8tc[o] = y8 ;


		double U1  = y2-y1 ; 
	//    U1p = y2p-y1p ;
		double U2 = y4-y5 ;
	//    U2p= y4p-y5p ;
		double U3 =y7-y8 ;
	//    U3p=y7p-y8p ;
		double*U1tc=new double[szTblP1];
		double*U2tc=new double[szTblP1];
		double*U3tc=new double[szTblP1];
		U1tc[o] = U1 ;
		U2tc[o] = U2 ;
		U3tc[o] = U3 ;

	//    fac1  = beta*(exp((y2-y3)/uf)-1.0e0);
	//    fac2  = beta*(exp((y4-U2-y6)/uf)-1.0e0);

	//    fac1p = beta*exp((y2-y3)/uf)/uf;
	//    fac2p = beta*exp((y4-U2-y6)/uf)/uf;


	 
	// fprintf ( ' succ:  xvc = //10.5e \n', xvc ) ;       

	 double fac1  = beta*(exp((y2-y3)/uf)-1.0);
	 double fac2  = beta*(exp((y4-U2-y6)/uf)-1.0);

	// *** (( uettc(o..)
	 double*uettc=new double[szTblP1];
	  uettc[o] = 0.1*sin(om*t) ;
	  uettc[o+1] = 0.1*cos(om*t)*om  ;
	  uettc[o+2] = - uettc[o]*om*om/ft[2]  ;
	  uettc[o+3] = - uettc[o+1]*om*om/ft[3]  ;

	  for (int idx=4;idx<=ord;idx++){
		  uettc[o+idx] = - uettc[o+idx-2]*om*om/(idx*(idx-1))   ;
		 //  uettc(o+2) : Tayl coef 2 = der2/2! 


	  
	  }

	//   ********* SECTION 1: eq F(1),F(3),F(5), output U1p, U2p, U3p *****************
	//   ********* SECTION 2: eq F(2),F(4)       output y3p, y6p *****************
	//   ********* SECTION 3: eq F(6),F(7),F(8), output y2p, y4p, y7p *****************


	//   ********* SECTION 1: eq F(1),F(3),F(5), output U1p, U2p, U3p *****************
		// F(1) = c1*U1p -(y2-U1)/r0 +uet/r0   ;

	  double U1p = ((y2-U1)/r0 - uet/r0)/c1 ;

		// F(3) =-c3*U2p +ub/r4 -y4/r4 -alpha*fac1  ;
	double	U2pnum = ub/r4 -y4/r4 -alpha*fac1 ;
		double U2p = U2pnum/c3 ;

		// F(5) =-c5*U3p +(y7-U3)/r9 ;
		double U3pnum = (y7-U3)/r9 ;
		double U3p = U3pnum/c5 ;

		U1tc[o+1] = U1p ;  
		U2tc[o+1] = U2p ;  
		U3tc[o+1] = U3p ;  

	//   ********* SECTION 2: eq F(2),F(4)       output y3p, y6p *****************

		// F(2) =-c2*y3p + fac1  -y3/r3 ;
		double y3p = ( fac1  -y3/r3)/c2 ;


		// F(4) =-c4*y6p + fac2  -y6/r7 ;
		double y6p = ( fac2  -y6/r7)/c4 ; 

		y3tc[o+1] = y3p ;
		y6tc[o+1] = y6p ;

	//   ********* SECTION 3: eq F(6),F(7),F(8), output y2p, y4p, y7p *****************


	//   ***** SUBSECTION 3.1: eq F(6) output y2p ***********
	//    F(6) = node1+node2
	//    node1   = (y(1)-uet)/r0
	//    node2   = y(2)/r1+(y(2)-ub)/r2+(1.0-alpha)*fac1

	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* fac1  ;
	//    F(6) = uet/r0 -(y2-U1)/r0 +ub/r2 -y2*(1/r1+1/r2)+(alpha-1)* beta*(exp((y2-y3)/uf)-1.0e0)   ;
		y1tc[o] = y1 ;    y2tc[o] = y2 ;    y3tc[o] = y3 ;    y4tc[o] = y4 ;
		y5tc[o] = y5 ;    y6tc[o] = y6 ;    y7tc[o] = y7 ;    y8tc[o] = y8 ;

		U1tc[o] = U1 ;       U2tc[o] = U2 ;    U3tc[o] = U3 ;

		double*y2my3tc=new double[szTblP1];
		double*expy2my3tc=new double[szTblP1];
		y2my3tc[o] = (y2tc[o]-y3tc[o])/uf ;
		expy2my3tc[o] = exp(y2my3tc[o]) ;


		// F6_2 = [y1tc[o] -uettc[o]]/r0 + y2tc[o]/r1+[y2tc[o]-ub]/r2+[1.0-alpha]*beta*[exp[[y2tc[o]-y3tc[o]]/uf]-1.0e0]
		double F6_2 = (y1tc[o] -uettc[o])/r0 + y2tc[o]/r1+(y2tc[o]-ub)/r2+(1.0-alpha)*beta*(expy2my3tc[o]-1.0);


		double F6 = uettc[o]/r0 -(y2tc[o]-U1tc[o])/r0 +ub/r2 -y2tc[o]*(1.0/r1+1.0/r2)+(alpha-1)*beta*(expy2my3tc[o]-1.0);

		//y1tc(o+1) = y1p ;
		//y2tc(o+1) = y2p ;
		//y3tc(o+1) = y3p ;
		//U1tc(o+1) = U1p ;   


		// tmp y2my3tc(o+1) = (y2tc(o+1)-y3tc(o+1))/uf ;
		// tmp expy2my3tc(o+1) = tcexpf(expy2my3tc,y2my3tc,1)  ;
		// ok expy2my3tc1zero = expy2my3tc(o+1) - exp((y2-y3)/uf)*(y2p-y3p)/uf

		// tmp ok F6p  = uettc(o+1)/r0 - y2tc(o+1)*(1/r0+1/r1+1/r2 ) +U1tc(o+1)/r0 +(alpha-1)*beta*( expy2my3tc(o) *(y2tc(o+1)-y3tc(o+1))/uf )

		// eq F6p  = uettc(o+1)/r0 - y2tc(o+1)*(1/r0+1/r1+1/r2 - (alpha-1)*beta*(expy2my3tc(o))/uf ) +U1tc(o+1)/r0 +(alpha-1)*beta*( expy2my3tc(o) *(-y3tc(o+1))/uf )
		//  => output y2tc(o+1)

		double y2tcnum = uettc[o+1]/r0 +U1tc[o+1]/r0 +(alpha-1)*beta*( expy2my3tc[o] *(-y3tc[o+1])/uf ) ;
		double y2tcden = (1/r0+1/r1+1/r2 - (alpha-1)*beta*(expy2my3tc[o])/uf ) ;
		// tmp F6p2 = y2tcnum - y2tc(o+1)*y2tcden

		// *** SOLUTION: y2tc[o+1] ********
		y2tc[o+1] = y2tcnum/y2tcden ;
		double y2p = y2tc[o+1] ;
	 
		y2my3tc[o+1] = (y2tc[o+1]-y3tc[o+1])/uf ;
		expy2my3tc[o+1] = tcexpf(expy2my3tc,y2my3tc,1)  ;
	   
		double F6pver  = uettc[o+1]/r0 -(y2tc[o+1]-U1tc[o+1])/r0 -y2tc[o+1]*(1.0/r1+1.0/r2) +(alpha-1)*beta*(expy2my3tc[o+1]);
		// return



	//   ***** (SUBSECTION 3.2: eq F(7) output y4p) ***********
	//    F(7) = ub/r4 -y4/r4 -alpha*fac1 +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*fac2 ; 
	//    F(7) = ub/r4 -y4/r4 -alpha*beta*(exp((y2-y3)/uf)-1.0e0) +ub/r6 -(y4-U2)*(1/r5+1/r6) +(alpha-1)*beta*(exp((y4-U2-y6)/uf)-1.0e0)  ; 

		 y4tc[o] = y4 ;
		 U2tc[o] = U2 ;   
		 y6tc[o] = y6 ;
		 double*y4mU2my6tc=new double[szTblP1];
		 double*expy4mU2mmy6tc=new double[szTblP1];
		 y4mU2my6tc[o] = (y4tc[o]-U2tc[o]-y6tc[o])/uf ;
		 expy4mU2mmy6tc[o] = exp(y4mU2my6tc[o]) ;

		 double F7 = ub/r4 -y4tc[o]/r4 -alpha*beta*(expy2my3tc[o]-1.0) +ub/r6 -(y4tc[o]-U2tc[o])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o]-1.0);

		 //y4tc(o+1) = y4p ;
		 //U2tc(o+1) = U2p ;   
		 //y6tc(o+1) = y6p ;

		 //y4mU2my6tc(o+1) = (y4tc(o+1)-U2tc(o+1)-y6tc(o+1))/uf ;
		 //expy4mU2mmy6tc(o+1) = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 1)  ;
		 //expy4mU2mmy6tc1zero = expy4mU2mmy6tc(o+1) - exp((y4-U2-y6)/uf)*(y4p-U2p-y6p)/uf

		 // eq. F7p =  -y4tc(o+1)/r4 -alpha*beta*(expy2my3tc(o+1))  -(y4tc(o+1)-U2tc(o+1))*(1/r5+1/r6) +(alpha-1)*beta*(expy4mU2mmy6tc(o+1) )
		 // output: y4tc(o+1)


		 // eq F7p2 =  -alpha*beta*(expy2my3tc(o+1))  -y4tc(o+1)*(1/r4+1/r5+1/r6 -(alpha-1)*beta*expy4mU2mmy6tc(o)/uf ) +(U2tc(o+1))*(1/r5+1/r6) +(alpha-1)*beta*expy4mU2mmy6tc(o)*(-U2tc(o+1)-y6tc(o+1))/uf

		 double*y4tcnum=new double[szTblP1];
		 double*y4tcden=new double[szTblP1];
		 y4tcnum[1] = -alpha*beta*(expy2my3tc[o+1]) +(U2tc[o+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*expy4mU2mmy6tc[o]*(-U2tc[o+1]-y6tc[o+1])/uf ;
		 y4tcden[1] = (1.0/r4+1.0/r5+1.0/r6 -(alpha-1)*beta*expy4mU2mmy6tc[o]/uf )  ;


		 // tmp F7p3 = y4tcnum - y4tc[o+1]*y4tcden

		// *** SOLUTION: y4tc[o+1]=y4ptc[o]  ********
		 y4tc[o+1] = y4tcnum[1]/y4tcden[1] ;
		 double y4p = y4tc[o+1] ;

		 y4mU2my6tc[o+1] = (y4tc[o+1]-U2tc[o+1]-y6tc[o+1])/uf ;
		 expy4mU2mmy6tc[o+1] = tcexpf(expy4mU2mmy6tc, y4mU2my6tc, 1)  ;

		 double F7pver =  -y4tc[o+1]/r4 -alpha*beta*(expy2my3tc[o+1])  -(y4tc[o+1]-U2tc[o+1])*(1.0/r5+1.0/r6) +(alpha-1)*beta*(expy4mU2mmy6tc[o+1] );

		 // return

	//   ***** (SUBSECTION 3.3: eq F(8) output y7p) ***********
		// F(8) = ub/r8 -y7/r8 -alpha*fac2  -(y7-U3)/r9 ;
		y7tc[o]  = y7 ;
		//y7tc(o+1)= y7p ;
		U3tc[o]  = U3 ;
		//U3tc(o+1)= U3p ;


		//  F(8) = ub/r8 -y7/r8 -alpha*beta*(exp((y4-U2-y6)/uf)-1.0e0)  -(y7-U3)/r9 ;
		double F8 = ub/r8 -y7tc[o]/r8 -alpha*beta*(expy4mU2mmy6tc[o]-1.0)  -(y7tc[o]-U3tc[o])/r9; 

		//F8ptmpok = -y7tc(o+1)/r8 -alpha*beta*(expy4mU2mmy6tc(o+1))  -(y7tc(o+1)-U3tc(o+1))/r9 

		//F8p = - y7tc(o+1)*(1/r8+1/r9 ) -alpha*beta*(expy4mU2mmy6tc(o+1)) +U3tc(o+1)/r9 

		double y7tcnum = -alpha*beta*(expy4mU2mmy6tc[o+1]) +U3tc[o+1]/r9 ;
		double y7tcden = 1.0/r8+1.0/r9  ;  

		// tmp ok F8p2 = y7tcnum - y7tc(o+1)*y7tcden
		y7tc[o+1] = y7tcnum/y7tcden ;
		double y7p = y7tc[o+1] ;

		double F8pver = -y7tc[o+1]/r8 -alpha*beta*(expy4mU2mmy6tc[o+1])  -(y7tc[o+1]-U3tc[o+1])/r9; 

	double y1p = y2p-U1p ;
	double y5p = y4p-U2p ;
	double y8p = y7p-U3p ;


	// **********  NEWTON PROJECTION **********


		U1  = y2-y1 ; 
		U1p = y2p-y1p ;
		U2 = y4-y5 ;
		U2p= y4p-y5p ;
		U3 =y7-y8 ;
		U3p=y7p-y8p ;



	// sys Jacobian "Jac" non singular => 
	//    adjust xvc = [ U1p ;  U2p ; U3p ; y2 ; y3p ; y4 ; y6p ; y7  ];

	 // tmp xvc = [ y1 ; y2; y3 ; y4 ; y5; y6; y7; y8  ];

	// fprintf ('corr-feval :  y1 = //10.5e , y2= //10.5e, y3= //10.5e, z1= //10.5e, z2= //10.5e , t= //7.2e  \n', y1, y2, y3, z1, z2, t ) ;

	// fprintf ('corr-feval :  y1p = //10.5e , y2p= //10.5e, y3p= //10.5e  \n', y1p, y2p, y3p ) ;

	// act  while (k <= N )
		double maxAbsJFvc=1111;
		double fac1p,fac2p;

		fac1  = beta*(exp((y2-y3)/uf)-1.0);
		fac2  = beta*(exp((y4-U2-y6)/uf)-1.0);

		fac1p = beta*exp((y2-y3)/uf)/uf;
		fac2p = beta*exp((y4-U2-y6)/uf)/uf;

	// ( while (k <= 2 ) & (max(abs(JFvc)) >= TOL))


		y1p = y2p-U1p ;
		y5p = y4p-U2p ;
		y8p = y7p-U3p ;



	yvalvo[1][1] =  y1;yvalvo[1][2] = y2;yvalvo[1][3] = y3;yvalvo[1][4] = y4 ;yvalvo[1][5] = y5 ;yvalvo[1][6] =  y6 ;yvalvo[1][7] =  y7 ; yvalvo[1][8] = y8  ;
	yvalvo[2][1] = y1p;yvalvo[2][2] =  y2p;yvalvo[2][3] =  y3p;yvalvo[2][4] =  y4p ;yvalvo[2][5] =  y5p ;yvalvo[2][6] =   y6p ;yvalvo[2][7] =   y7p ;yvalvo[2][8] =   y8p  ;

	//free memory
	delete F;delete ft;
	delete y1tc;delete y2tc;delete y3tc;delete y4tc;delete y5tc;delete y6tc;delete y7tc;delete y8tc;
	delete U1tc;delete U2tc;delete U3tc;
	delete uettc;
	delete y2my3tc;delete expy2my3tc;
	delete y4mU2my6tc;delete expy4mU2mmy6tc;
	delete y4tcnum;delete y4tcden;
}

