#include "linSolver.cpp"
#include "autoDiff.cpp"

//Test problem (VO means variable order): 
//INPUT:  t, yyvc:y(t), ord:compute y^{(i)}(t) up to i=ord or ord+1, nbcmp:size(y)
//OUTPUT:  yvalvo/ydervo: array containing the computed y^{(i)}(t)'s
static void fvo(double t, double*yyvc, int ord,double TOL, double**ydervo,int nbcmp){

	// corrector & f eval

	// ((*********** Algo 3.1 p 377 **********

	////    xlpp, ylpp, xrpp, yrpp, lam1, lam2
	//sigma = ...                                     c_i
	//   [  2,    0,    0,   -999,   0,    0   ; ...   0
	//      0,    2,  -999,    0,    0,    0   ; ...   0
	//      0,  -999,   2,     0,  -999,   0   ; ...   0
	//    -999,   0,    0,     2,  -999,   0   ; ...   0
	//      0,    0,  -999,  -999, -999, -999  ; ...   2
	//      0,    0,    0,    0,  -999,  -999  ] ;     2
	// -----------------------------------------
	//d_j=  2     2     2     2     0      0

	// 1 HVT : (1,1), (2,5), (3,3), (4,6), (5,2), (6,4)

	int maxci=6;
	int maxdi=6;

	// HVT optjdx():
	//optjdx(1) = 1;
	//optjdx(2) = 5;
	//optjdx(3) = 3;
	//optjdx(4) = 6;
	//optjdx(5) = 2;
	//optjdx(6) = 4;

	//  [ c, d ] = cidjdet(maxci, maxdi, optjdx, sigma) ;

	// d_j = 2.00e+00   d_j = 2.00e+00   d_j = 2.00e+00   d_j = 2.00e+00   d_j = 0.00e+00   d_j = 0.00e+00    
	// c_i = 0.00e+00   c_i = 0.00e+00   c_i = 0.00e+00   c_i = 0.00e+00   c_i = 2.00e+00   c_i = 2.00e+00  
	// 4 DF
	// *********** Algo 3.1 p 377 **********))


	int szTbl=20;
	int szTblP1=szTbl+1;
	// p 611, Burden Faires
	double*F=new double[szTblP1];
	for(int i=1;i<=szTbl;i++)F[i]=0.0;
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13
	// g =1;

	double	  eps = 0.01;
	double	  M   = 10;
	double	  L   = 1;
	double	  L0  = 0.5;
	double	  r   = 0.1;
	double	  w   = 10;
	double	  g   = 1;


	double*ft=new double[szTblP1];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;
	  int o = 1 ;


	double xl = yyvc[1] ;
	double yl = yyvc[2] ;
	double xr = yyvc[3] ;
	double yr = yyvc[4] ;
	double xlp= yyvc[5] ;
	double ylp= yyvc[6] ;
	double xrp= yyvc[7] ;
	double yrp= yyvc[8] ;
	double inlam1= yyvc[9] ;
	double inlam2= yyvc[10] ;


	double yb  = r*sin(w*t);
	double xb  = sqrt(L*L-yb*yb);

	double Ll = sqrt(xl*xl+yl*yl);
	double Lr = sqrt((xr-xb)*(xr-xb)+(yr-yb)*(yr-yb));
	// => Lr = sqrt( xr^2 -2*xr*xb +xb^2 +yr^2 -2*yr*yb + yb^2 );
	double ybp = r*cos(w*t)*w;
	double xbp  = 0.5*(-2*yb*ybp)/sqrt(L*L-yb*yb);

	double*ybtc=new double[szTblP1];
	ybtc[o] = yb ;
	ybtc[o+1] = r*cos(w*t)*w  ;
	ybtc[o+2] = (-r*sin(w*t)*pow(w,2.0))/2.0 ;
	ybtc[o+3] = (-r*cos(w*t)*pow(w,3.0))/ft[3] ; 
	ybtc[o+4] = (r*sin(w*t)*pow(w,4.0))/ft[4] ; 
	ybtc[o+5] = (r*cos(w*t)*pow(w,5.0))/ft[5] ; 

	for (int idx=3;idx<=ord+3;idx+=2)
	  ybtc[o+idx] = -ybtc[o+idx-2]*w*w/(idx*(idx-1));
	
	for (int idx=2;idx<=ord+3;idx+=2)
	  ybtc[o+idx] = -ybtc[o+idx-2]*w*w/(idx*(idx-1));
	



	double ybpp = ybtc[o+2]*2 ;

	double*LL_ybyb=new double[szTblP1];
	LL_ybyb[o] = L*L-yb*yb ;
	LL_ybyb[o+1] = - tcprod(ybtc,ybtc, 1) ;
	LL_ybyb[o+2] = - tcprod(ybtc,ybtc, 2) ;

	// Ex:
	//LL_ybyb(o+3) = - tcprod(ybtc,ybtc, 3) ;
	//LL_ybyb(o+4) = - tcprod(ybtc,ybtc, 4) ;
	for (int idx=3;idx<=ord+3;idx++)
	   LL_ybyb[o+idx] = - tcprod(ybtc,ybtc, idx) ;

	double*xbtc=new double[szTblP1];
	xbtc[o]= sqrt(L*L-yb*yb);
	xbtc[o+1]=tcexpo(xbtc , LL_ybyb , 0.5, 1 ) ;
	xbtc[o+2]=tcexpo(xbtc , LL_ybyb , 0.5, 2 ) ;
	//xbtc(o+3)=tcexpo(xbtc , LL_ybyb , 0.5, 3 ) ;
	//xbtc(o+4)=tcexpo(xbtc , LL_ybyb , 0.5, 4 ) ;
	for (int idx=3;idx<=ord+3;idx++)
	   xbtc[o+idx]=tcexpo(xbtc , LL_ybyb , 0.5, idx  ) ;
	
	double xbpp = xbtc[o+2]*2 ;
	//xbppp= xbtc(o+3)*ft(3) ;


	// lbd  = yyvc(5) ;

	// stage k = 0, solve for xlpp  ylpp xrpp yrpp lam1 lam2  ;
	// 6 eq  :
	// xlpp  ylpp xrpp yrpp lam1 lam2
	double**A_MAT=new double*[7];
	for(int i=1;i<=6;i++){
		A_MAT[i]=new double[7];
		for(int j=1;j<=6;j++)A_MAT[i][j]=0.0;
	}
	double eps2=eps*eps;
	A_MAT[1][1]=-1;A_MAT[1][5]=2.0/M/eps2*xb;A_MAT[1][6]=2/M/eps2*(2*xl-2*xr) ;
	A_MAT[2][2]=-1;A_MAT[2][5]= 2/M/eps2*yb;A_MAT[2][6]=2/M/eps2*(2*yl-2*yr) ;
	A_MAT[3][3]=-1;A_MAT[3][6]= 2/M/eps2*(-2*xl+2*xr) ;
	A_MAT[4][4]=-1;A_MAT[4][6]=2/M/eps2*(-2*yl+2*yr) ;
	A_MAT[5][1]=  xb;A_MAT[5][2]= yb;
	A_MAT[6][1]=2*xl-2*xr;A_MAT[6][2]= 2*yl-2*yr;A_MAT[6][3]= -2*xl+2*xr;A_MAT[6][4]=   -2*yl+2*yr;

	// rankAMAT=rank(A_MAT)
	double*RHS=new double[7];
	RHS[1] = -2.0/(M*eps*eps)*(L0-Ll)*xl/Ll ;
	RHS[2] = -2.0/(M*eps*eps)*( (L0-Ll)*yl/Ll -M*eps*eps/2.0 ) ;
	RHS[3] = -2.0/(M*eps*eps)*(L0-Lr)*(xr-xb)/Lr  ;
	RHS[4] = -2.0/(M*eps*eps)*( (L0-Lr)*(yr-yb)/Lr -M*eps*eps/2.0 ) ;
	RHS[5] = -(xlp*xbp + xlp*xbp + xl*xbpp +ylp*ybp + ylp*ybp +yl*ybpp ) ;
	RHS[6] =-(2*(xlp-xrp)*(xlp-xrp) +2*(ylp-yrp)*(ylp-yrp)) ;
	
	double*b_v = new double[7];
	linSolver(A_MAT,RHS,6,b_v);

	double xlpp = b_v[1] ;
	double ylpp = b_v[2] ;
	double xrpp = b_v[3] ;
	double yrpp = b_v[4] ;
	double lam1 = b_v[5] ;
	double lam2 = b_v[6] ;



	     
	double	F1   =(L0-Ll)*xl/Ll     +lam1*xb+2.0*lam2*(xl-xr);
	double	F2   =(L0-Ll)*yl/Ll     +lam1*yb+2.0*lam2*(yl-yr)-M*eps*eps/2.0;
	double	F3   =(L0-Lr)*(xr-xb)/Lr        -2.0*lam2*(xl-xr);
	double	F4   =(L0-Lr)*(yr-yb)/Lr        -2.0*lam2*(yl-yr)-M*eps*eps/2.0;


		F[1] = 2.0/(M*eps*eps)* F1-xlpp ;
		F[2] = 2.0/(M*eps*eps)* F2-ylpp  ;
		F[3] = 2.0/(M*eps*eps)* F3-xrpp  ;
		F[4] = 2.0/(M*eps*eps)* F4-yrpp  ;
		F[5] = xlpp*xb +xlp*xbp + xlp*xbp + xl*xbpp +ylpp*yb +ylp*ybp + ylp*ybp +yl*ybpp ;
		F[6]= 2*((xlp-xrp)*(xlp-xrp) +(xl-xr)*(xlpp-xrpp)) +2*((ylp-yrp)*(ylp-yrp)+ (yl-yr)*(ylpp-yrpp) ) ;


	//clear all
	//return

	// ********** Algorithm : solve for consistent point **********************************
	// the following Newton projection (iterated) equiv projection: stage k=kd,kd+1,..., 0 p 200 , J.D. Pryce

	//     adjust  xvc = [ xl; yl; xr; yr; xlp;  ylp; xrp; yrp; lam1; lam2   ];

	// starting "close-to-consistent"  xvc = [ xl; yl; xr; yr; xlp;  ylp; xrp; yrp; lam1; lam2   ];

	double*xvc=new double[10];
	xvc[1]=xl;
	xvc[2]=yl;
	xvc[3]=xr;
	xvc[4]=yr;
	xvc[5]=xlp;  
	xvc[6]=ylp; 
	xvc[7]=xrp;
	xvc[8]=lam1; 
	xvc[9]=lam2;

	double*JFvc=new double[10];
	for(int i=1;i<=9;i++)JFvc[i]=1111;	
	double maxAbsJFvc=1111;
	////// act  while (k <= N )

	double**Jac=new double*[10];
	for(int i=1;i<=9;i++){
		Jac[i]=new double[10];
		for(int j=1;j<=9;j++)Jac[i][j]=0.0;
	}

	while (k <= N && maxAbsJFvc >= TOL){

		// ENLARGED SYSTEM:
		// calc F(), Jac() p 540 Barrio
		// 9 eq : F(1) = 0, F(2) = 0,...F(9) = 0 ; 
		// 9 var xl; yl; xr; yr; xlp;  ylp; xrp;  lam1; lam2
		// (solve for consistent point [ xl; yl; xr; yr; xlp;  ylp; xrp;  lam1; lam2   ]
		//     p 372-373, Pryce,"a simple structural.." )
		// The following equations F() are chosen such that all equations
		// from stage k = -max_j(d_j) to k = 0 (Pryce,"Solving high index...")
		// are satisfied


		Ll = sqrt(xl*xl+yl*yl);
		Lr = sqrt(pow(xr-xb,2.0)+pow(yr-yb,2.0));
	     
		F1   =(L0-Ll)*xl/Ll     +lam1*xb+2.0*lam2*(xl-xr);
		F2   =(L0-Ll)*yl/Ll     +lam1*yb+2.0*lam2*(yl-yr)-M*eps*eps/2.0;
		F3   =(L0-Lr)*(xr-xb)/Lr        -2.0*lam2*(xl-xr);
		F4   =(L0-Lr)*(yr-yb)/Lr        -2.0*lam2*(yl-yr)-M*eps*eps/2.0;
	 
		F[1] = 2.0/(M*eps*eps)* F1-xlpp ;
		F[2] = 2.0/(M*eps*eps)* F2-ylpp  ;
		F[3] = 2.0/(M*eps*eps)* F3-xrpp  ;
		F[4] = 2.0/(M*eps*eps)* F4-yrpp  ;
		F[5] = xb*xl+yb*yl;
		F[6]= pow(xl-xr,2.0)+pow(yl-yr,2.0)-L*L;
		F[7] = xlp*xb + xl*xbp +ylp*yb + yl*ybp ;
		F[8]= 2*(xl-xr)*(xlp-xrp) +2*(yl-yr)*(ylp-yrp) ;
		F[9] = xlpp*xb +xlp*xbp + xlp*xbp + xl*xbpp +ylpp*yb +ylp*ybp + ylp*ybp +yl*ybpp ;
		// F(10)= 2*((xlp-xrp)*(xlp-xrp) +(xl-xr)*(xlpp-xrpp)) +2*((ylp-yrp)*(ylp-yrp)+ (yl-yr)*(ylpp-yrpp) ) ;

		for(int i=1;i<=9;i++)F[i]=-F[i];

		eps2=eps*eps;
		double xl2,yl2,xr2,yr2,xb2,yb2;
		xl2=xl*xl;yl2=yl*yl;xr2=xr*xr;yr2=yr*yr;xb2=xb*xb;yb2=yb*yb;

		Jac[1][1] =  2/M/eps2*(-1/(xl2+yl2)*xl2+(L0-pow(xl2+yl2,0.5))/pow(xl2+yl2,0.5)-(L0-pow(xl2+yl2,0.5))*xl2/pow(xl2+yl2,1.5)+2*lam2);
		Jac[1][2] =2/M/eps2*(-1/(xl2+yl2)*yl*xl-(L0-pow(xl2+yl2,0.5))*xl/pow(xl2+yl2,1.5)*yl);
		Jac[1][3] = -4/M/eps2*lam2;
		Jac[1][8] =2/M/eps2*xb;
		Jac[1][9] =2/M/eps2*(2*xl-2*xr) ;

		Jac[2][1] =2/M/eps2*(-1/(xl2+yl2)*yl*xl-(L0-pow(xl2+yl2,0.5))*xl/pow(xl2+yl2,1.5)*yl);
		Jac[2][2] =2/M/eps2*(-1/(xl2+yl2)*yl2+(L0-pow(xl2+yl2,0.5))/pow(xl2+yl2,0.5)-(L0-pow(xl2+yl2,0.5))*yl2/pow(xl2+yl2,1.5)+2*lam2);
		Jac[2][4]= -4/M/eps2*lam2;
		Jac[2][8] =2/M/eps2*yb;
		Jac[2][9] =2/M/eps2*(2*yl-2*yr) ;

		Jac[3][1] = -4/M/eps2*lam2;
		Jac[3][3] =2/M/eps2*(-0.5/(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2)*(2*xr-2*xb)*(xr-xb)+(L0-pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5))/pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5)-0.5*(L0-pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5))*(xr-xb)/pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,1.5)*(2*xr-2*xb)+2*lam2);
		Jac[3][4] =2/M/eps2*(-0.5/(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2)*(2*yr-2*yb)*(xr-xb)-0.5*(L0-pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5))*(xr-xb)/pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,1.5)*(2*yr-2*yb));
		Jac[3][9] =  2/M/eps2*(-2*xl+2*xr);

		Jac[4][2] =-4/M/eps2*lam2;
		Jac[4][3] =2/M/eps2*(-0.5/(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2)*(2*xr-2*xb)*(yr-yb)-0.5*(L0-pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5))*(yr-yb)/pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,1.5)*(2*xr-2*xb));
		Jac[4][4] =2/M/eps2*(-0.5/(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2)*(2*yr-2*yb)*(yr-yb)+(L0-pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5))/pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5)-0.5*(L0-pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,0.5))*(yr-yb)/pow(xr2-2*xr*xb+xb2+yr2-2*yr*yb+yb2,1.5)*(2*yr-2*yb)+2*lam2);
		Jac[4][9] = 2/M/eps2*(-2*yl+2*yr) ;

		Jac[5][1] =  xb;Jac[5][2] = yb;

		Jac[6][1] =2*xl-2*xr;
		Jac[6][2] = 2*yl-2*yr;
		Jac[6][3] =-2*xl+2*xr;
		Jac[6][4] =-2*yl+2*yr;

		Jac[7][1]= xbp;Jac[7][2]=ybp;Jac[7][5]=  xb;Jac[7][6]= yb;

		Jac[8][1] =  2*xlp-2*xrp;Jac[8][2] =  2*ylp-2*yrp;
		Jac[8][3] =-2*xlp+2*xrp; Jac[8][4] =-2*ylp+2*yrp;Jac[8][5] = 2*xl-2*xr;
		Jac[8][6] = 2*yl-2*yr;Jac[8][7] =-2*xl+2*xr ;

		Jac[9][1] = xbpp;Jac[9][2] =ybpp;Jac[9][5] =  2*xbp;Jac[9][6] =   2*ybp;

		linSolver(Jac,F,9,JFvc);
		//  JFvc = invJac*(-F) 
		for(int i=1;i<=9;i++)xvc[i] = xvc[i]+JFvc[i] ;

		k = k+1 ;

		xl  = xvc[1] ;
		yl  = xvc[2] ;
		xr  = xvc[3] ;
		yr  = xvc[4] ;
		xlp = xvc[5] ;
		ylp = xvc[6] ;
		xrp = xvc[7] ;
		//////// tmp yrp = xvc[8] ;
		lam1= xvc[8] ;
		lam2= xvc[9] ;

		maxAbsJFvc=0.0;
		for(int i=1;i<=9;i++)maxAbsJFvc=max(maxAbsJFvc,fabs(JFvc[i]));
	}

	double*xltc=new double[szTblP1];
	double*xrtc=new double[szTblP1];
	double*yltc=new double[szTblP1];
	double*yrtc=new double[szTblP1];
	double*lam1tc=new double[szTblP1];
	double*lam2tc=new double[szTblP1];
	xltc[o]   = xl ;
	xltc[o+1] = xlp ;
	xltc[o+2] = xlpp/2 ;

	xrtc[o]   = xr ;
	xrtc[o+1] = xrp ;
	xrtc[o+2] = xrpp/2 ;

	yltc[o]   = yl ;
	yltc[o+1] = ylp ;
	yltc[o+2] = ylpp/2 ;

	yrtc[o]   = yr ;
	yrtc[o+1] = yrp ;
	yrtc[o+2] = yrpp/2 ;

	lam1tc[o] = lam1 ;
	lam2tc[o] = lam2 ;

	double*xl2pyl2=new double[szTblP1];
	double*Lltc=new double[szTblP1];
	xl2pyl2[o] = xl*xl+yl*yl ;
	xl2pyl2[o+1]= tcprod(xltc,xltc,1) + tcprod(yltc,yltc,1) ;
	Lltc[o] = Ll;
	Lltc[o+1] = tcexpo(Lltc,xl2pyl2,0.5,1 );
	// => Lr = sqrt( xr^2 -2*xr*xb +xb^2 +yr^2 -2*yr*yb + yb^2 ); 
	double*Lrinput=new double[szTblP1];
	Lrinput[o] = xr*xr -2*xr*xb +xb*xb +yr*yr -2*yr*yb + yb*yb ;
	Lrinput[o+1] = tcprod(xrtc,xrtc,1) -2*tcprod(xrtc,xbtc,1) +tcprod(xbtc,xbtc,1) + tcprod(yrtc,yrtc,1) -2*tcprod(yrtc,ybtc,1) + tcprod(ybtc,ybtc,1) ;
	double*Lrtc=new double[szTblP1];
	Lrtc[o] = Lr ;
	Lrtc[o+1] = tcexpo(Lrtc,Lrinput,0.5,1 ) ;

	// ******************** m=1 ****************************

	int m=1 ;

	double*xldLl=new double[szTblP1];
	double*yldLl=new double[szTblP1];
	double*xrdLr=new double[szTblP1];
	double*yrdLr=new double[szTblP1];
	double*xbdLr=new double[szTblP1];
	double*ybdLr=new double[szTblP1];
	xldLl[o] = xl/Ll ;
	xldLl[o+m] = tcdiv( xltc, Lltc,xldLl,m ) ;
	yldLl[o] =  yl/Ll ;
	yldLl[o+m] = tcdiv( yltc, Lltc,yldLl,m ) ;
	xrdLr[o] = xr/Lr ;
	xrdLr[o+m] = tcdiv( xrtc, Lrtc,xrdLr,m ) ;
	xbdLr[o] = xb/Lr ;
	xbdLr[o+m] = tcdiv( xbtc, Lrtc,xbdLr,m ) ;

	yrdLr[o] = yr/Lr ;
	yrdLr[o+m] = tcdiv( yrtc, Lrtc,yrdLr,m ) ;

	ybdLr[o] = yb/Lr ;
	ybdLr[o+m] = tcdiv( ybtc, Lrtc,ybdLr,m ) ;


	// stage k = 1, solve for xlppp  ylppp xrppp yrppp lam1p lam2p  ;
	// 6 eq  :
	// xlppp  ylppp xrppp yrppp lam1p lam2p
	// xltc(o+3) yltc(o+3) xrtc(o+3) yrtc(o+3) lam1tc(o+1) lam2tc(o+1)
	eps2=eps*eps;
	A_MAT[1][1] =-1*(m+1)*(m+2);A_MAT[1][5] = 2/M/eps2*xb;A_MAT[1][6] =  2/M/eps2*(2*xl-2*xr) ;
	A_MAT[2][2] =-1*(m+1)*(m+2);A_MAT[2][5] =2/M/eps2*yb;A_MAT[2][6] =  2/M/eps2*(2*yl-2*yr) ;
	A_MAT[3][3] =-1*(m+1)*(m+2);A_MAT[3][6] =  2/M/eps2*(-2*xl+2*xr) ;
	A_MAT[4][4] = -1*(m+1)*(m+2);A_MAT[4][6] = 2/M/eps2*(-2*yl+2*yr) ;
	A_MAT[5][1] =  xb;A_MAT[5][2] =yb;
	A_MAT[6][1] =2*xl-2*xr;A_MAT[6][2] = 2*yl-2*yr;A_MAT[6][3] =-2*xl+2*xr;A_MAT[6][4] =-2*yl+2*yr;

	// rankAMAT=rank(A_MAT)

	RHS[1 ]= 2.0/(M*eps*eps)*( L0*xldLl[o+m]-xltc[o+m] +tcprodRHS(xbtc, lam1tc, m) +2*tcprodRHS(xltc, lam2tc, m)- 2*tcprodRHS(xrtc, lam2tc, m)  ) ;
	RHS[1]= -RHS[1] ;
	RHS[2] = 2.0/(M*eps*eps)*( L0*yldLl[o+m]-yltc[o+m] +tcprodRHS(ybtc, lam1tc, m) +2*tcprodRHS(yltc, lam2tc, m)- 2*tcprodRHS(yrtc, lam2tc, m) ) ;
	RHS[2]=-RHS[2] ;
	RHS[3] = 2.0/(M*eps*eps)*( L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m] -2*tcprodRHS(xltc, lam2tc, m)+ 2*tcprodRHS(xrtc, lam2tc, m) )  ;
	RHS[3]=-RHS[3] ;
	RHS[4] = 2.0/(M*eps*eps)*( L0*( yrdLr[o+m] - ybdLr[o+m] ) -yrtc[o+m] +ybtc[o+m] -2*tcprodRHS(yltc, lam2tc, m)+ 2*tcprodRHS(yrtc, lam2tc, m) ) ;
	RHS[4]=-RHS[4] ;
	RHS[5] = tcprodRHS(xbtc, xltc, m+2) + tcprodRHS(ybtc, yltc, m+2) ;
	RHS[5] =-RHS[5] ;
	RHS[6] = tcprodRHS_2b(xltc, xltc,m+2)-2*tcprodRHS_2b( xrtc, xltc,m+2)+ tcprodRHS_2b( xrtc, xrtc,m+2) + tcprodRHS_2b(yltc, yltc,m+2)-2*tcprodRHS_2b( yrtc, yltc,m+2)+ tcprodRHS_2b( yrtc, yrtc,m+2) ;
	RHS[6] =-RHS[6] ;

	linSolver(A_MAT,RHS,6,b_v);

	xltc[o+m+2] = b_v[1] ;
	yltc[o+m+2] = b_v[2] ;
	xrtc[o+m+2] = b_v[3] ;
	yrtc[o+m+2] = b_v[4] ;
	lam1tc[o+m] = b_v[5] ;
	lam2tc[o+m] = b_v[6] ;

	     
		//F1   =(L0-Ll)*xl/Ll     +lam1*xb+2.0*lam2*(xl-xr);
		//F2   =(L0-Ll)*yl/Ll     +lam1*yb+2.0*lam2*(yl-yr)-M*eps*eps/2.0;
		//F3   =(L0-Lr)*(xr-xb)/Lr        -2.0*lam2*(xl-xr);
		//F4   =(L0-Lr)*(yr-yb)/Lr        -2.0*lam2*(yl-yr)-M*eps*eps/2.0;

		xltc[o]   = xl ;
		xltc[o+1] = xlp ;
		xltc[o+2] = xlpp/2 ;

		yltc[o]   = yl ;
		yltc[o+1] = ylp ;
		yltc[o+2] = ylpp/2 ;

		xrtc[o]   = xr ;
		xrtc[o+1] = xrp ;
		xrtc[o+2] = xrpp/2 ;

		yrtc[o]   = yr ;
		yrtc[o+1] = yrp ;
		yrtc[o+2] = yrpp/2 ;



		//Lltc(o) = Ll ;
		//Lltc(o+1) = Llp ;
		//xldLl(o) = xl/Ll ;

		//lam1tc(o) = lam1 ;
		//lam2tc(o) = lam2 ;
		//xbtc(o) = xb ;
		//xldLl(o+m)= tcdiv(xltc,Lltc,xldLl,m)
		double*lam1xb=new double[szTblP1];
		double*lam1yb=new double[szTblP1];
		double*lam2xl=new double[szTblP1];
		double*lam2xr=new double[szTblP1];
		double*lam2yl=new double[szTblP1];
		double*lam2yr=new double[szTblP1];
		lam1xb[o]= lam1*xb ;
		lam1xb[o+m]= tcprod(lam1tc,xbtc,m ) ;     

		lam1yb[o]= lam1*yb ;
		lam1yb[o+m]= tcprod(lam1tc,ybtc,m ) ;     


		lam2xl[o]= lam2*xl ;
		lam2xl[o+m]= tcprod(lam2tc,xltc,m ) ;     

		lam2xr[o]= lam2*xr ;
		lam2xr[o+m]= tcprod(lam2tc,xrtc,m ) ;     

		lam2yl[o]= lam2*yl ;
		lam2yl[o+m]= tcprod(lam2tc,yltc,m ) ;     

		lam2yr[o]= lam2*yr ;
		lam2yr[o+m]= tcprod(lam2tc,yrtc,m ) ;     

		double*xbxl=new double[szTblP1];
		double*xlxl=new double[szTblP1];
		double*xrxr=new double[szTblP1];
		double*xlxr=new double[szTblP1];
		double*ybyl=new double[szTblP1];
		double*ylyl=new double[szTblP1];
		double*yryr=new double[szTblP1];
		double*ylyr=new double[szTblP1];
		xbxl[o] = xb*xl ;
		xbxl[o+1] =tcprod(xbtc,xltc, 1)  ;
		xbxl[o+2] =tcprod(xbtc,xltc, 2)  ;
		xbxl[o+3] =tcprod(xbtc,xltc, 3)  ;


		xlxl[o] = xl*xl ;
		xlxl[o+1] =tcprod(xltc,xltc, 1)  ;
		xlxl[o+2] =tcprod(xltc,xltc, 2)  ;
		xlxl[o+3] =tcprod(xltc,xltc, 3)  ;

		xrxr[o] = xr*xr ;
		xrxr[o+1] =tcprod(xrtc,xrtc, 1)  ;
		xrxr[o+2] =tcprod(xrtc,xrtc, 2)  ;
		xrxr[o+3] =tcprod(xrtc,xrtc, 3)  ;


		xlxr[o] = xl*xr ;
		xlxr[o+1] =tcprod(xltc,xrtc, 1)  ;
		xlxr[o+2] =tcprod(xltc,xrtc, 2)  ;
		xlxr[o+3] =tcprod(xltc,xrtc, 3)  ;

		ybyl[o]   = yb*yl ;
		ybyl[o+1] =tcprod(ybtc,yltc, 1)  ;
		ybyl[o+2] =tcprod(ybtc,yltc, 2)  ;
		ybyl[o+3] =tcprod(ybtc,yltc, 3)  ;

		ylyl[o]   = yl*yl ;
		ylyl[o+1] =tcprod(yltc,yltc, 1)  ;
		ylyl[o+2] =tcprod(yltc,yltc, 2)  ;
		ylyl[o+3] =tcprod(yltc,yltc, 3)  ;

		ylyr[o]   = yl*yr ;
		ylyr[o+1] =tcprod(yltc,yrtc, 1)  ;
		ylyr[o+2] =tcprod(yltc,yrtc, 2)  ;
		ylyr[o+3] =tcprod(yltc,yrtc, 3)  ;

		yryr[o]   = yr*yr ;
		yryr[o+1] =tcprod(yrtc,yrtc, 1)  ;
		yryr[o+2] =tcprod(yrtc,yrtc, 2)  ;
		yryr[o+3] =tcprod(yrtc,yrtc, 3)  ;

		//       F1   =(L0-Ll)*xl/Ll     +lam1*xb+2.0*lam2*(xl-xr);
		// ***** F1   = L0*xl/Ll - xl   +lam1*xb +2.0*(lam2*xl -lam2*xr); *****


		double F1exp = L0*xldLl[o+m] -xltc[o+m] +lam1xb[o+m]+2.0*(lam2xl[o+m] -lam2xr[o+m]) ;


		//       F2   =[L0-Ll]*yl/Ll     +lam1*yb+2.0*lam2*[yl-yr]-M*eps*eps/2.0;
		// ***** F2   = L0*yl/Ll - yl    +lam1*yb +2.0*[lam2*yl -lam2*yr] -M*eps*eps/2.0 ; ****
		double F2exp = L0*yldLl[o+m] -yltc[o+m] +lam1yb[o+m]+2.0*(lam2yl[o+m] -lam2yr[o+m]) ;



		// ***** F3   =[L0-Lr]*[xr-xb]/Lr        -2.0*lam2*[xl-xr]; ***************************
		// ***** F3   =L0*[xr-xb]/Lr + [-Lr]*[xr-xb]/Lr       -2.0*lam2*[xl-xr]; ***********************
		double F3exp = L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m]  -2.0*(lam2xl[o+m] -lam2xr[o+m]) ;


		// ***** F4   =[L0-Lr]*[yr-yb]/Lr        -2.0*lam2*[yl-yr]-M*eps*eps/2.0; **************
		// ***** F4   =L0*[yr-yb]/Lr -Lr*[yr-yb]/Lr      -2.0*lam2*[yl-yr]-M*eps*eps/2.0; **************

		double F4exp = L0*( yrdLr[o+m] - ybdLr[o+m]) -yrtc[o+m] +ybtc[o+m]  -2.0*(lam2yl[o+m] -lam2yr[o+m]) ;


		// ***** f9  = xb*xl+yb*yl **********************************

		double*f9=new double[szTblP1];
		f9[o]  = xbxl[o] + ybyl[o] ;
		f9[o+1]= xbxl[o+1] + ybyl[o+1] ;
		f9[o+2]= xbxl[o+2] + ybyl[o+2] ;
		f9[o+3]= xbxl[o+3] + ybyl[o+3] ; 

		// ***** f10[o] = [xl-xr]**2+[yl-yr]**2-L*L ******************
		// f10[o] = xl^2 -2*xl*xr +xr^2 + yl^2 -2*yl*yr + yr^2 -L*L ;
		double*f10=new double[szTblP1];
		f10[o]  = xlxl[o]  -2*xlxr[o]  + xrxr[o]  + ylyl[o]  -2*ylyr[o]  + yryr[o] -L*L ;
		f10[o+1]= xlxl[o+1]-2*xlxr[o+1]+ xrxr[o+1]+ ylyl[o+1]-2*ylyr[o+1]+ yryr[o+1]  ;
		f10[o+2]= xlxl[o+2]-2*xlxr[o+2]+ xrxr[o+2]+ ylyl[o+2]-2*ylyr[o+2]+ yryr[o+2]  ;
		f10[o+3]= xlxl[o+3]-2*xlxr[o+3]+ xrxr[o+3]+ ylyl[o+3]-2*ylyr[o+3]+ yryr[o+3]  ;
		double f10_3   = (2*xl-2*xr)*xltc[o+3]+(2*yl-2*yr)*yltc[o+3] +(-2*xl+2*xr)*xrtc[o+3]+( -2*yl+2*yr)*yrtc[o+3] -RHS[6]  ;


		F[1] = 2.0/(M*eps*eps)* F1exp- xltc[o+m+2]*(m+1)*(m+2) ;
		F[2] = 2.0/(M*eps*eps)* F2exp- yltc[o+m+2]*(m+1)*(m+2) ;
		F[3] = 2.0/(M*eps*eps)* F3exp- xrtc[o+m+2]*(m+1)*(m+2) ;
		F[4] = 2.0/(M*eps*eps)* F4exp- yrtc[o+m+2]*(m+1)*(m+2)  ;
		F[5] = f9[o+3]  ;
		F[6] = f10[o+3] ;
	



	// ******************** m=2 ****************************

	// m=2 ;

	for (int m=2;m<=ord;m++){

	   xl2pyl2[o+m]= tcprod(xltc,xltc,m) + tcprod(yltc,yltc,m) ;

	   Lltc[o+m] = tcexpo(Lltc,xl2pyl2,0.5,m );
	   Lrinput[o+m] = tcprod(xrtc,xrtc,m) -2*tcprod(xrtc,xbtc,m) +tcprod(xbtc,xbtc,m) + tcprod(yrtc,yrtc,m) -2*tcprod(yrtc,ybtc,m) + tcprod(ybtc,ybtc,m) ;
	   Lrtc[o+m] = tcexpo(Lrtc,Lrinput,0.5,m ) ;

	   xldLl[o+m] = tcdiv( xltc, Lltc,xldLl,m ) ;
	   yldLl[o+m] = tcdiv( yltc, Lltc,yldLl,m ) ;
	   xrdLr[o+m] = tcdiv( xrtc, Lrtc,xrdLr,m ) ;
	   xbdLr[o+m] = tcdiv( xbtc, Lrtc,xbdLr,m ) ;
	   yrdLr[o+m] = tcdiv( yrtc, Lrtc,yrdLr,m ) ;
	   ybdLr[o+m] = tcdiv( ybtc, Lrtc,ybdLr,m ) ;


	   // stage k = 1, solve for xlppp  ylppp xrppp yrppp lam1p lam2p  ;
	   // 6 eq  :
	   // xlppp  ylppp xrppp yrppp lam1p lam2p
	   // xltc(o+3) yltc(o+3) xrtc(o+3) yrtc(o+3) lam1tc(o+1) lam2tc(o+1)

		eps2=eps*eps;
		A_MAT[1][1] =-1*(m+1)*(m+2);A_MAT[1][5] = 2/M/eps2*xb;A_MAT[1][6] =  2/M/eps2*(2*xl-2*xr) ;
		A_MAT[2][2] =-1*(m+1)*(m+2);A_MAT[2][5] =2/M/eps2*yb;A_MAT[2][6] =  2/M/eps2*(2*yl-2*yr) ;
		A_MAT[3][3] =-1*(m+1)*(m+2);A_MAT[3][6] =  2/M/eps2*(-2*xl+2*xr) ;
		A_MAT[4][4] = -1*(m+1)*(m+2);A_MAT[4][6] = 2/M/eps2*(-2*yl+2*yr) ;
		A_MAT[5][1] =  xb;A_MAT[5][2] =yb;
		A_MAT[6][1] =2*xl-2*xr;A_MAT[6][2] = 2*yl-2*yr;A_MAT[6][3] =-2*xl+2*xr;A_MAT[6][4] =-2*yl+2*yr;

		// rankAMAT=rank(A_MAT)

		RHS[1 ]= 2.0/(M*eps*eps)*( L0*xldLl[o+m]-xltc[o+m] +tcprodRHS(xbtc, lam1tc, m) +2*tcprodRHS(xltc, lam2tc, m)- 2*tcprodRHS(xrtc, lam2tc, m)  ) ;
		RHS[1]= -RHS[1] ;
		RHS[2] = 2.0/(M*eps*eps)*( L0*yldLl[o+m]-yltc[o+m] +tcprodRHS(ybtc, lam1tc, m) +2*tcprodRHS(yltc, lam2tc, m)- 2*tcprodRHS(yrtc, lam2tc, m) ) ;
		RHS[2]=-RHS[2] ;
		RHS[3] = 2.0/(M*eps*eps)*( L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m] -2*tcprodRHS(xltc, lam2tc, m)+ 2*tcprodRHS(xrtc, lam2tc, m) )  ;
		RHS[3]=-RHS[3] ;
		RHS[4] = 2.0/(M*eps*eps)*( L0*( yrdLr[o+m] - ybdLr[o+m] ) -yrtc[o+m] +ybtc[o+m] -2*tcprodRHS(yltc, lam2tc, m)+ 2*tcprodRHS(yrtc, lam2tc, m) ) ;
		RHS[4]=-RHS[4] ;
		RHS[5] = tcprodRHS(xbtc, xltc, m+2) + tcprodRHS(ybtc, yltc, m+2) ;
		RHS[5] =-RHS[5] ;
		RHS[6] = tcprodRHS_2b(xltc, xltc,m+2)-2*tcprodRHS_2b( xrtc, xltc,m+2)+ tcprodRHS_2b( xrtc, xrtc,m+2) + tcprodRHS_2b(yltc, yltc,m+2)-2*tcprodRHS_2b( yrtc, yltc,m+2)+ tcprodRHS_2b( yrtc, yrtc,m+2) ;
		RHS[6] =-RHS[6] ;

		linSolver(A_MAT,RHS,6,b_v);

	   xltc[o+m+2] = b_v[1] ;
	   yltc[o+m+2] = b_v[2] ;
	   xrtc[o+m+2] = b_v[3] ;
	   yrtc[o+m+2] = b_v[4] ;
	   lam1tc[o+m] = b_v[5] ;
	   lam2tc[o+m] = b_v[6] ;


		lam1xb[o+m]= tcprod(lam1tc,xbtc,m ) ;     
		lam1yb[o+m]= tcprod(lam1tc,ybtc,m ) ;     
		lam2xl[o+m]= tcprod(lam2tc,xltc,m ) ;     
		lam2xr[o+m]= tcprod(lam2tc,xrtc,m ) ;     
		lam2yl[o+m]= tcprod(lam2tc,yltc,m ) ;     
		lam2yr[o+m]= tcprod(lam2tc,yrtc,m ) ;     


		xbxl[o+m+2] =tcprod(xbtc,xltc,m+2 )  ;
		xlxl[o+m+2] =tcprod(xltc,xltc,m+2 )  ;
		xrxr[o+m+2] =tcprod(xrtc,xrtc,m+2 )  ;
		xlxr[o+m+2] =tcprod(xltc,xrtc,m+2 )  ;
		ybyl[o+m+2] =tcprod(ybtc,yltc,m+2 )  ;
		ylyl[o+m+2] =tcprod(yltc,yltc,m+2 )  ;
		ylyr[o+m+2] =tcprod(yltc,yrtc,m+2 )  ;
		yryr[o+m+2] =tcprod(yrtc,yrtc,m+2 )  ;



		// ***** F1   = L0*xl/Ll - xl   +lam1*xb +2.0*(lam2*xl -lam2*xr); *****

		F1exp = L0*xldLl[o+m] -xltc[o+m] +lam1xb[o+m]+2.0*(lam2xl[o+m] -lam2xr[o+m]) ;



		// ***** F2   = L0*yl/Ll - yl     +lam1*yb +2.0*[lam2*yl -lam2*yr] -M*eps*eps/2.0 ; ****
		F2exp = L0*yldLl[o+m] -yltc[o+m] +lam1yb[o+m]+2.0*(lam2yl[o+m] -lam2yr[o+m]) ;



		// ***** F3   =[L0-Lr]*[xr-xb]/Lr        -2.0*lam2*[xl-xr]; ***************************
		F3exp = L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m]  -2.0*(lam2xl[o+m] -lam2xr[o+m]) ;

		// ***** F4   =[L0-Lr]*[yr-yb]/Lr        -2.0*lam2*[yl-yr]-M*eps*eps/2.0; **************
		F4exp = L0*( yrdLr[o+m] - ybdLr[o+m] ) -yrtc[o+m] +ybtc[o+m]  -2.0*(lam2yl[o+m] -lam2yr[o+m]) ;

	   // ***** f9  = xb*xl+yb*yl **********************************

		f9[o+m+2]  = xbxl[o+m+2] + ybyl[o+m+2] ;

		// ***** f10[o] = [xl-xr]**2+[yl-yr]**2-L*L ******************
		// f10[o] = xl^2 -2*xl*xr +xr^2 + yl^2 -2*yl*yr + yr^2 -L*L ;
		f10[o+m+2]= xlxl[o+m+2]-2*xlxr[o+m+2]+ xrxr[o+m+2]+ ylyl[o+m+2]-2*ylyr[o+m+2]+ yryr[o+m+2]  ;


		//feval_m=m
		//TaylcF=F

	}

	   ydervo[1][1] = xl ; 
	   ydervo[1][2] =yl ; 
	   ydervo[1][3] =xr ; 
	   ydervo[1][4] =yr ; 
	   ydervo[1][5] =xlp ; 
	   ydervo[1][6] =ylp ; 
	   ydervo[1][7] =xrp ; 
	   ydervo[1][8] =yrp ; 
	   ydervo[1][9] =lam1 ;
	   ydervo[1][10] =lam2  ;

	   for (int idx=2;idx<=ord+1;idx++){
		  ydervo[idx][1]= xltc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][2]=yltc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][3]=xrtc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][4]=yrtc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][5]=xltc[o+idx]*ft[idx]; 
		  ydervo[idx][6]=yltc[o+idx]*ft[idx]; 
		  ydervo[idx][7]=xrtc[o+idx]*ft[idx]; 
		  ydervo[idx][8]=yrtc[o+idx]*ft[idx] ; 
		  ydervo[idx][9]=lam1tc[o+idx-1]*ft[idx-1] ;
		  ydervo[idx][10]=lam2tc[o+idx-1]*ft[idx-1] ;
	   }

	   // act ydervo(2,1:8) =[ xlp ; ylp ; xrp ; yrp ; xlpp ; ylpp ; xrpp ; yrpp ] ;


	// Ex:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)
		//free memory
		delete F;
		delete ft;
		delete ybtc;
		delete LL_ybyb;
		delete xbtc;
		for(int i=1;i<=6;i++)delete A_MAT[i];
		delete A_MAT;
		delete RHS;
		delete b_v;
		delete xvc;
		delete JFvc;
		for(int i=1;i<=9;i++)Jac[i];
		delete Jac;
		delete xltc;
		delete xrtc;
		delete yltc;
		delete yrtc;
		delete lam1tc;
		delete lam2tc;
		delete xl2pyl2;
		delete Lltc;
		delete Lrinput;
		delete Lrtc;
		delete xldLl;
		delete yldLl;
		delete xrdLr;
		delete yrdLr;
		delete xbdLr;
		delete ybdLr;
		delete lam1xb;
		delete lam1yb;
		delete lam2xl;
		delete lam2xr;
		delete lam2yl;
		delete lam2yr;
		delete xbxl;
		delete xlxl;
		delete xrxr;
		delete xlxr;
		delete ybyl;
		delete ylyl;
		delete yryr;
		delete ylyr;
		delete f9;
		delete f10;
}	
static void f(double t, double*yyvc, int ord,double TOL,double**ydervo, int nbcmp){

	// corrector & f eval

	// ((*********** Algo 3.1 p 377 **********

	////    xlpp, ylpp, xrpp, yrpp, lam1, lam2
	//sigma = ...                                     c_i
	//   [  2,    0,    0,   -999,   0,    0   ; ...   0
	//      0,    2,  -999,    0,    0,    0   ; ...   0
	//      0,  -999,   2,     0,  -999,   0   ; ...   0
	//    -999,   0,    0,     2,  -999,   0   ; ...   0
	//      0,    0,  -999,  -999, -999, -999  ; ...   2
	//      0,    0,    0,    0,  -999,  -999  ] ;     2
	// -----------------------------------------
	//d_j=  2     2     2     2     0      0

	// 1 HVT : (1,1), (2,5), (3,3), (4,6), (5,2), (6,4)

	int maxci=6;
	int maxdi=6;

	// HVT optjdx():
	//optjdx(1) = 1;
	//optjdx(2) = 5;
	//optjdx(3) = 3;
	//optjdx(4) = 6;
	//optjdx(5) = 2;
	//optjdx(6) = 4;

	//  [ c, d ] = cidjdet(maxci, maxdi, optjdx, sigma) ;

	// d_j = 2.00e+00   d_j = 2.00e+00   d_j = 2.00e+00   d_j = 2.00e+00   d_j = 0.00e+00   d_j = 0.00e+00    
	// c_i = 0.00e+00   c_i = 0.00e+00   c_i = 0.00e+00   c_i = 0.00e+00   c_i = 2.00e+00   c_i = 2.00e+00  
	// 4 DF
	// *********** Algo 3.1 p 377 **********))


	int szTbl=20;
	int szTblP1=szTbl+1;
	// p 611, Burden Faires
	double*F=new double[szTblP1];
	for(int i=1;i<=szTbl;i++)F[i]=0.0;
	int k=1 ;
	int N=99 ;
	// TOL= 5e-13
	// g =1;

	double	  eps = 0.01;
	double	  M   = 10;
	double	  L   = 1;
	double	  L0  = 0.5;
	double	  r   = 0.1;
	double	  w   = 10;
	double	  g   = 1;


	double*ft=new double[szTblP1];
	   ft[1] =1.0;
	   ft[2] =2.0;
	   ft[3] = 6.0;
	   ft[4] = 24.0 ;
	   ft[5] =   120.0 ;
	   ft[6] =   720.0 ;
	   ft[7] =   5040.0 ;
	   ft[8] =   40320.0 ;
	   ft[9] =      362880.0 ;
	   ft[10] =     3628800.0 ;
	   ft[11] =    39916800.0 ;
	   ft[12] =   479001600.0 ;
	   ft[13] =     6.227020800000000e+09 ;
	   ft[14] =     8.717829120000000e+10 ;
	   ft[15] =     1.307674368000000e+12 ;
	   ft[16] =     2.092278988800000e+13 ;
	   ft[17] =     3.556874280960000e+14 ;
	  int o = 1 ;


	double xl = yyvc[1] ;
	double yl = yyvc[2] ;
	double xr = yyvc[3] ;
	double yr = yyvc[4] ;
	double xlp= yyvc[5] ;
	double ylp= yyvc[6] ;
	double xrp= yyvc[7] ;
	double yrp= yyvc[8] ;
	double lam1= yyvc[9] ;
	double lam2= yyvc[10] ;


	double yb  = r*sin(w*t);
	double xb  = sqrt(L*L-yb*yb);

	double Ll = sqrt(xl*xl+yl*yl);
	double Lr = sqrt((xr-xb)*(xr-xb)+(yr-yb)*(yr-yb));
	// => Lr = sqrt( xr^2 -2*xr*xb +xb^2 +yr^2 -2*yr*yb + yb^2 );
	double ybp = r*cos(w*t)*w;
	double xbp  = 0.5*(-2*yb*ybp)/sqrt(L*L-yb*yb);

	double*ybtc=new double[szTblP1];
	ybtc[o] = yb ;
	ybtc[o+1] = r*cos(w*t)*w  ;
	ybtc[o+2] = (-r*sin(w*t)*pow(w,2.0))/2.0 ;
	ybtc[o+3] = (-r*cos(w*t)*pow(w,3.0))/ft[3] ; 
	ybtc[o+4] = (r*sin(w*t)*pow(w,4.0))/ft[4] ; 
	ybtc[o+5] = (r*cos(w*t)*pow(w,5.0))/ft[5] ; 

	for (int idx=3;idx<=ord+3;idx+=2)
	  ybtc[o+idx] = -ybtc[o+idx-2]*w*w/(idx*(idx-1));
	
	for (int idx=2;idx<=ord+3;idx+=2)
	  ybtc[o+idx] = -ybtc[o+idx-2]*w*w/(idx*(idx-1));
	



	double ybpp = ybtc[o+2]*2 ;

	double*LL_ybyb=new double[szTblP1];
	LL_ybyb[o] = L*L-yb*yb ;
	LL_ybyb[o+1] = - tcprod(ybtc,ybtc, 1) ;
	LL_ybyb[o+2] = - tcprod(ybtc,ybtc, 2) ;

	// Ex:
	//LL_ybyb(o+3) = - tcprod(ybtc,ybtc, 3) ;
	//LL_ybyb(o+4) = - tcprod(ybtc,ybtc, 4) ;
	for (int idx=3;idx<=ord+3;idx++)
	   LL_ybyb[o+idx] = - tcprod(ybtc,ybtc, idx) ;

	double*xbtc=new double[szTblP1];
	xbtc[o]= sqrt(L*L-yb*yb);
	xbtc[o+1]=tcexpo(xbtc , LL_ybyb , 0.5, 1 ) ;
	xbtc[o+2]=tcexpo(xbtc , LL_ybyb , 0.5, 2 ) ;
	//xbtc(o+3)=tcexpo(xbtc , LL_ybyb , 0.5, 3 ) ;
	//xbtc(o+4)=tcexpo(xbtc , LL_ybyb , 0.5, 4 ) ;
	for (int idx=3;idx<=ord+3;idx++)
	   xbtc[o+idx]=tcexpo(xbtc , LL_ybyb , 0.5, idx  ) ;
	
	double xbpp = xbtc[o+2]*2 ;
	//xbppp= xbtc(o+3)*ft(3) ;


	// lbd  = yyvc(5) ;

	// stage k = 0, solve for xlpp  ylpp xrpp yrpp lam1 lam2  ;
	// 6 eq  :
	// xlpp  ylpp xrpp yrpp lam1 lam2
	double**A_MAT=new double*[7];
	for(int i=1;i<=6;i++){
		A_MAT[i]=new double[7];
		for(int j=1;j<=6;j++)A_MAT[i][j]=0.0;
	}
	double eps2=eps*eps;
	A_MAT[1][1]=-1;A_MAT[1][5]=2.0/M/eps2*xb;A_MAT[1][6]=2/M/eps2*(2*xl-2*xr) ;
	A_MAT[2][2]=-1;A_MAT[2][5]= 2/M/eps2*yb;A_MAT[2][6]=2/M/eps2*(2*yl-2*yr) ;
	A_MAT[3][3]=-1;A_MAT[3][6]= 2/M/eps2*(-2*xl+2*xr) ;
	A_MAT[4][4]=-1;A_MAT[4][6]=2/M/eps2*(-2*yl+2*yr) ;
	A_MAT[5][1]=  xb;A_MAT[5][2]= yb;
	A_MAT[6][1]=2*xl-2*xr;A_MAT[6][2]= 2*yl-2*yr;A_MAT[6][3]= -2*xl+2*xr;A_MAT[6][4]=   -2*yl+2*yr;

	// rankAMAT=rank(A_MAT)
	double*RHS=new double[7];
	RHS[1] = -2.0/(M*eps*eps)*(L0-Ll)*xl/Ll ;
	RHS[2] = -2.0/(M*eps*eps)*( (L0-Ll)*yl/Ll -M*eps*eps/2.0 ) ;
	RHS[3] = -2.0/(M*eps*eps)*(L0-Lr)*(xr-xb)/Lr  ;
	RHS[4] = -2.0/(M*eps*eps)*( (L0-Lr)*(yr-yb)/Lr -M*eps*eps/2.0 ) ;
	RHS[5] = -(xlp*xbp + xlp*xbp + xl*xbpp +ylp*ybp + ylp*ybp +yl*ybpp ) ;
	RHS[6] =-(2*(xlp-xrp)*(xlp-xrp) +2*(ylp-yrp)*(ylp-yrp)) ;
	
	double*b_v = new double[7];
	linSolver(A_MAT,RHS,6,b_v);

	double xlpp = b_v[1] ;
	double ylpp = b_v[2] ;
	double xrpp = b_v[3] ;
	double yrpp = b_v[4] ;
	double dumlam1 = b_v[5] ;
	double dumlam2 = b_v[6] ;



	     

	//clear all
	//return

	// ********** Algorithm : solve for consistent point **********************************
	// the following Newton projection (iterated) equiv projection: stage k=kd,kd+1,..., 0 p 200 , J.D. Pryce

	//     adjust  xvc = [ xl; yl; xr; yr; xlp;  ylp; xrp; yrp; lam1; lam2   ];

	// starting "close-to-consistent"  xvc = [ xl; yl; xr; yr; xlp;  ylp; xrp; yrp; lam1; lam2   ];

	double*xltc=new double[szTblP1];
	double*xrtc=new double[szTblP1];
	double*yltc=new double[szTblP1];
	double*yrtc=new double[szTblP1];
	double*lam1tc=new double[szTblP1];
	double*lam2tc=new double[szTblP1];
	xltc[o]   = xl ;
	xltc[o+1] = xlp ;
	xltc[o+2] = xlpp/2 ;

	xrtc[o]   = xr ;
	xrtc[o+1] = xrp ;
	xrtc[o+2] = xrpp/2 ;

	yltc[o]   = yl ;
	yltc[o+1] = ylp ;
	yltc[o+2] = ylpp/2 ;

	yrtc[o]   = yr ;
	yrtc[o+1] = yrp ;
	yrtc[o+2] = yrpp/2 ;

	lam1tc[o] = lam1 ;
	lam2tc[o] = lam2 ;

	double*xl2pyl2=new double[szTblP1];
	double*Lltc=new double[szTblP1];
	xl2pyl2[o] = xl*xl+yl*yl ;
	xl2pyl2[o+1]= tcprod(xltc,xltc,1) + tcprod(yltc,yltc,1) ;
	Lltc[o] = Ll;
	Lltc[o+1] = tcexpo(Lltc,xl2pyl2,0.5,1 );
	// => Lr = sqrt( xr^2 -2*xr*xb +xb^2 +yr^2 -2*yr*yb + yb^2 ); 
	double*Lrinput=new double[szTblP1];
	Lrinput[o] = xr*xr -2*xr*xb +xb*xb +yr*yr -2*yr*yb + yb*yb ;
	Lrinput[o+1] = tcprod(xrtc,xrtc,1) -2*tcprod(xrtc,xbtc,1) +tcprod(xbtc,xbtc,1) + tcprod(yrtc,yrtc,1) -2*tcprod(yrtc,ybtc,1) + tcprod(ybtc,ybtc,1) ;
	double*Lrtc=new double[szTblP1];
	Lrtc[o] = Lr ;
	Lrtc[o+1] = tcexpo(Lrtc,Lrinput,0.5,1 ) ;

	// ******************** m=1 ****************************

	int m=1 ;

	double*xldLl=new double[szTblP1];
	double*yldLl=new double[szTblP1];
	double*xrdLr=new double[szTblP1];
	double*yrdLr=new double[szTblP1];
	double*xbdLr=new double[szTblP1];
	double*ybdLr=new double[szTblP1];
	xldLl[o] = xl/Ll ;
	xldLl[o+m] = tcdiv( xltc, Lltc,xldLl,m ) ;
	yldLl[o] =  yl/Ll ;
	yldLl[o+m] = tcdiv( yltc, Lltc,yldLl,m ) ;
	xrdLr[o] = xr/Lr ;
	xrdLr[o+m] = tcdiv( xrtc, Lrtc,xrdLr,m ) ;
	xbdLr[o] = xb/Lr ;
	xbdLr[o+m] = tcdiv( xbtc, Lrtc,xbdLr,m ) ;

	yrdLr[o] = yr/Lr ;
	yrdLr[o+m] = tcdiv( yrtc, Lrtc,yrdLr,m ) ;

	ybdLr[o] = yb/Lr ;
	ybdLr[o+m] = tcdiv( ybtc, Lrtc,ybdLr,m ) ;


	// stage k = 1, solve for xlppp  ylppp xrppp yrppp lam1p lam2p  ;
	// 6 eq  :
	// xlppp  ylppp xrppp yrppp lam1p lam2p
	// xltc(o+3) yltc(o+3) xrtc(o+3) yrtc(o+3) lam1tc(o+1) lam2tc(o+1)
	eps2=eps*eps;
	A_MAT[1][1] =-1*(m+1)*(m+2);A_MAT[1][5] = 2/M/eps2*xb;A_MAT[1][6] =  2/M/eps2*(2*xl-2*xr) ;
	A_MAT[2][2] =-1*(m+1)*(m+2);A_MAT[2][5] =2/M/eps2*yb;A_MAT[2][6] =  2/M/eps2*(2*yl-2*yr) ;
	A_MAT[3][3] =-1*(m+1)*(m+2);A_MAT[3][6] =  2/M/eps2*(-2*xl+2*xr) ;
	A_MAT[4][4] = -1*(m+1)*(m+2);A_MAT[4][6] = 2/M/eps2*(-2*yl+2*yr) ;
	A_MAT[5][1] =  xb;A_MAT[5][2] =yb;
	A_MAT[6][1] =2*xl-2*xr;A_MAT[6][2] = 2*yl-2*yr;A_MAT[6][3] =-2*xl+2*xr;A_MAT[6][4] =-2*yl+2*yr;

	// rankAMAT=rank(A_MAT)

	RHS[1 ]= 2.0/(M*eps*eps)*( L0*xldLl[o+m]-xltc[o+m] +tcprodRHS(xbtc, lam1tc, m) +2*tcprodRHS(xltc, lam2tc, m)- 2*tcprodRHS(xrtc, lam2tc, m)  ) ;
	RHS[1]= -RHS[1] ;
	RHS[2] = 2.0/(M*eps*eps)*( L0*yldLl[o+m]-yltc[o+m] +tcprodRHS(ybtc, lam1tc, m) +2*tcprodRHS(yltc, lam2tc, m)- 2*tcprodRHS(yrtc, lam2tc, m) ) ;
	RHS[2]=-RHS[2] ;
	RHS[3] = 2.0/(M*eps*eps)*( L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m] -2*tcprodRHS(xltc, lam2tc, m)+ 2*tcprodRHS(xrtc, lam2tc, m) )  ;
	RHS[3]=-RHS[3] ;
	RHS[4] = 2.0/(M*eps*eps)*( L0*( yrdLr[o+m] - ybdLr[o+m] ) -yrtc[o+m] +ybtc[o+m] -2*tcprodRHS(yltc, lam2tc, m)+ 2*tcprodRHS(yrtc, lam2tc, m) ) ;
	RHS[4]=-RHS[4] ;
	RHS[5] = tcprodRHS(xbtc, xltc, m+2) + tcprodRHS(ybtc, yltc, m+2) ;
	RHS[5] =-RHS[5] ;
	RHS[6] = tcprodRHS_2b(xltc, xltc,m+2)-2*tcprodRHS_2b( xrtc, xltc,m+2)+ tcprodRHS_2b( xrtc, xrtc,m+2) + tcprodRHS_2b(yltc, yltc,m+2)-2*tcprodRHS_2b( yrtc, yltc,m+2)+ tcprodRHS_2b( yrtc, yrtc,m+2) ;
	RHS[6] =-RHS[6] ;

	linSolver(A_MAT,RHS,6,b_v);

	xltc[o+m+2] = b_v[1] ;
	yltc[o+m+2] = b_v[2] ;
	xrtc[o+m+2] = b_v[3] ;
	yrtc[o+m+2] = b_v[4] ;
	lam1tc[o+m] = b_v[5] ;
	lam2tc[o+m] = b_v[6] ;

	     
		//F1   =(L0-Ll)*xl/Ll     +lam1*xb+2.0*lam2*(xl-xr);
		//F2   =(L0-Ll)*yl/Ll     +lam1*yb+2.0*lam2*(yl-yr)-M*eps*eps/2.0;
		//F3   =(L0-Lr)*(xr-xb)/Lr        -2.0*lam2*(xl-xr);
		//F4   =(L0-Lr)*(yr-yb)/Lr        -2.0*lam2*(yl-yr)-M*eps*eps/2.0;

		xltc[o]   = xl ;
		xltc[o+1] = xlp ;
		xltc[o+2] = xlpp/2 ;

		yltc[o]   = yl ;
		yltc[o+1] = ylp ;
		yltc[o+2] = ylpp/2 ;

		xrtc[o]   = xr ;
		xrtc[o+1] = xrp ;
		xrtc[o+2] = xrpp/2 ;

		yrtc[o]   = yr ;
		yrtc[o+1] = yrp ;
		yrtc[o+2] = yrpp/2 ;



		//Lltc(o) = Ll ;
		//Lltc(o+1) = Llp ;
		//xldLl(o) = xl/Ll ;

		//lam1tc(o) = lam1 ;
		//lam2tc(o) = lam2 ;
		//xbtc(o) = xb ;
		//xldLl(o+m)= tcdiv(xltc,Lltc,xldLl,m)
		double*lam1xb=new double[szTblP1];
		double*lam1yb=new double[szTblP1];
		double*lam2xl=new double[szTblP1];
		double*lam2xr=new double[szTblP1];
		double*lam2yl=new double[szTblP1];
		double*lam2yr=new double[szTblP1];
		lam1xb[o]= lam1*xb ;
		lam1xb[o+m]= tcprod(lam1tc,xbtc,m ) ;     

		lam1yb[o]= lam1*yb ;
		lam1yb[o+m]= tcprod(lam1tc,ybtc,m ) ;     


		lam2xl[o]= lam2*xl ;
		lam2xl[o+m]= tcprod(lam2tc,xltc,m ) ;     

		lam2xr[o]= lam2*xr ;
		lam2xr[o+m]= tcprod(lam2tc,xrtc,m ) ;     

		lam2yl[o]= lam2*yl ;
		lam2yl[o+m]= tcprod(lam2tc,yltc,m ) ;     

		lam2yr[o]= lam2*yr ;
		lam2yr[o+m]= tcprod(lam2tc,yrtc,m ) ;     

		double*xbxl=new double[szTblP1];
		double*xlxl=new double[szTblP1];
		double*xrxr=new double[szTblP1];
		double*xlxr=new double[szTblP1];
		double*ybyl=new double[szTblP1];
		double*ylyl=new double[szTblP1];
		double*yryr=new double[szTblP1];
		double*ylyr=new double[szTblP1];
		xbxl[o] = xb*xl ;
		xbxl[o+1] =tcprod(xbtc,xltc, 1)  ;
		xbxl[o+2] =tcprod(xbtc,xltc, 2)  ;
		xbxl[o+3] =tcprod(xbtc,xltc, 3)  ;


		xlxl[o] = xl*xl ;
		xlxl[o+1] =tcprod(xltc,xltc, 1)  ;
		xlxl[o+2] =tcprod(xltc,xltc, 2)  ;
		xlxl[o+3] =tcprod(xltc,xltc, 3)  ;

		xrxr[o] = xr*xr ;
		xrxr[o+1] =tcprod(xrtc,xrtc, 1)  ;
		xrxr[o+2] =tcprod(xrtc,xrtc, 2)  ;
		xrxr[o+3] =tcprod(xrtc,xrtc, 3)  ;


		xlxr[o] = xl*xr ;
		xlxr[o+1] =tcprod(xltc,xrtc, 1)  ;
		xlxr[o+2] =tcprod(xltc,xrtc, 2)  ;
		xlxr[o+3] =tcprod(xltc,xrtc, 3)  ;

		ybyl[o]   = yb*yl ;
		ybyl[o+1] =tcprod(ybtc,yltc, 1)  ;
		ybyl[o+2] =tcprod(ybtc,yltc, 2)  ;
		ybyl[o+3] =tcprod(ybtc,yltc, 3)  ;

		ylyl[o]   = yl*yl ;
		ylyl[o+1] =tcprod(yltc,yltc, 1)  ;
		ylyl[o+2] =tcprod(yltc,yltc, 2)  ;
		ylyl[o+3] =tcprod(yltc,yltc, 3)  ;

		ylyr[o]   = yl*yr ;
		ylyr[o+1] =tcprod(yltc,yrtc, 1)  ;
		ylyr[o+2] =tcprod(yltc,yrtc, 2)  ;
		ylyr[o+3] =tcprod(yltc,yrtc, 3)  ;

		yryr[o]   = yr*yr ;
		yryr[o+1] =tcprod(yrtc,yrtc, 1)  ;
		yryr[o+2] =tcprod(yrtc,yrtc, 2)  ;
		yryr[o+3] =tcprod(yrtc,yrtc, 3)  ;

		//       F1   =(L0-Ll)*xl/Ll     +lam1*xb+2.0*lam2*(xl-xr);
		// ***** F1   = L0*xl/Ll - xl   +lam1*xb +2.0*(lam2*xl -lam2*xr); *****


		double F1exp = L0*xldLl[o+m] -xltc[o+m] +lam1xb[o+m]+2.0*(lam2xl[o+m] -lam2xr[o+m]) ;


		//       F2   =[L0-Ll]*yl/Ll     +lam1*yb+2.0*lam2*[yl-yr]-M*eps*eps/2.0;
		// ***** F2   = L0*yl/Ll - yl    +lam1*yb +2.0*[lam2*yl -lam2*yr] -M*eps*eps/2.0 ; ****
		double F2exp = L0*yldLl[o+m] -yltc[o+m] +lam1yb[o+m]+2.0*(lam2yl[o+m] -lam2yr[o+m]) ;



		// ***** F3   =[L0-Lr]*[xr-xb]/Lr        -2.0*lam2*[xl-xr]; ***************************
		// ***** F3   =L0*[xr-xb]/Lr + [-Lr]*[xr-xb]/Lr       -2.0*lam2*[xl-xr]; ***********************
		double F3exp = L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m]  -2.0*(lam2xl[o+m] -lam2xr[o+m]) ;


		// ***** F4   =[L0-Lr]*[yr-yb]/Lr        -2.0*lam2*[yl-yr]-M*eps*eps/2.0; **************
		// ***** F4   =L0*[yr-yb]/Lr -Lr*[yr-yb]/Lr      -2.0*lam2*[yl-yr]-M*eps*eps/2.0; **************

		double F4exp = L0*( yrdLr[o+m] - ybdLr[o+m]) -yrtc[o+m] +ybtc[o+m]  -2.0*(lam2yl[o+m] -lam2yr[o+m]) ;


		// ***** f9  = xb*xl+yb*yl **********************************

		double*f9=new double[szTblP1];
		f9[o]  = xbxl[o] + ybyl[o] ;
		f9[o+1]= xbxl[o+1] + ybyl[o+1] ;
		f9[o+2]= xbxl[o+2] + ybyl[o+2] ;
		f9[o+3]= xbxl[o+3] + ybyl[o+3] ; 

		// ***** f10[o] = [xl-xr]**2+[yl-yr]**2-L*L ******************
		// f10[o] = xl^2 -2*xl*xr +xr^2 + yl^2 -2*yl*yr + yr^2 -L*L ;
		double*f10=new double[szTblP1];
		f10[o]  = xlxl[o]  -2*xlxr[o]  + xrxr[o]  + ylyl[o]  -2*ylyr[o]  + yryr[o] -L*L ;
		f10[o+1]= xlxl[o+1]-2*xlxr[o+1]+ xrxr[o+1]+ ylyl[o+1]-2*ylyr[o+1]+ yryr[o+1]  ;
		f10[o+2]= xlxl[o+2]-2*xlxr[o+2]+ xrxr[o+2]+ ylyl[o+2]-2*ylyr[o+2]+ yryr[o+2]  ;
		f10[o+3]= xlxl[o+3]-2*xlxr[o+3]+ xrxr[o+3]+ ylyl[o+3]-2*ylyr[o+3]+ yryr[o+3]  ;
		double f10_3   = (2*xl-2*xr)*xltc[o+3]+(2*yl-2*yr)*yltc[o+3] +(-2*xl+2*xr)*xrtc[o+3]+( -2*yl+2*yr)*yrtc[o+3] -RHS[6]  ;


		F[1] = 2.0/(M*eps*eps)* F1exp- xltc[o+m+2]*(m+1)*(m+2) ;
		F[2] = 2.0/(M*eps*eps)* F2exp- yltc[o+m+2]*(m+1)*(m+2) ;
		F[3] = 2.0/(M*eps*eps)* F3exp- xrtc[o+m+2]*(m+1)*(m+2) ;
		F[4] = 2.0/(M*eps*eps)* F4exp- yrtc[o+m+2]*(m+1)*(m+2)  ;
		F[5] = f9[o+3]  ;
		F[6] = f10[o+3] ;



	// ******************** m=2 ****************************

	// m=2 ;

	for (int m=2;m<=ord-1;m++){

	   xl2pyl2[o+m]= tcprod(xltc,xltc,m) + tcprod(yltc,yltc,m) ;

	   Lltc[o+m] = tcexpo(Lltc,xl2pyl2,0.5,m );
	   Lrinput[o+m] = tcprod(xrtc,xrtc,m) -2*tcprod(xrtc,xbtc,m) +tcprod(xbtc,xbtc,m) + tcprod(yrtc,yrtc,m) -2*tcprod(yrtc,ybtc,m) + tcprod(ybtc,ybtc,m) ;
	   Lrtc[o+m] = tcexpo(Lrtc,Lrinput,0.5,m ) ;

	   xldLl[o+m] = tcdiv( xltc, Lltc,xldLl,m ) ;
	   yldLl[o+m] = tcdiv( yltc, Lltc,yldLl,m ) ;
	   xrdLr[o+m] = tcdiv( xrtc, Lrtc,xrdLr,m ) ;
	   xbdLr[o+m] = tcdiv( xbtc, Lrtc,xbdLr,m ) ;
	   yrdLr[o+m] = tcdiv( yrtc, Lrtc,yrdLr,m ) ;
	   ybdLr[o+m] = tcdiv( ybtc, Lrtc,ybdLr,m ) ;


	   // stage k = 1, solve for xlppp  ylppp xrppp yrppp lam1p lam2p  ;
	   // 6 eq  :
	   // xlppp  ylppp xrppp yrppp lam1p lam2p
	   // xltc(o+3) yltc(o+3) xrtc(o+3) yrtc(o+3) lam1tc(o+1) lam2tc(o+1)

		eps2=eps*eps;
		A_MAT[1][1] =-1*(m+1)*(m+2);A_MAT[1][5] = 2/M/eps2*xb;A_MAT[1][6] =  2/M/eps2*(2*xl-2*xr) ;
		A_MAT[2][2] =-1*(m+1)*(m+2);A_MAT[2][5] =2/M/eps2*yb;A_MAT[2][6] =  2/M/eps2*(2*yl-2*yr) ;
		A_MAT[3][3] =-1*(m+1)*(m+2);A_MAT[3][6] =  2/M/eps2*(-2*xl+2*xr) ;
		A_MAT[4][4] = -1*(m+1)*(m+2);A_MAT[4][6] = 2/M/eps2*(-2*yl+2*yr) ;
		A_MAT[5][1] =  xb;A_MAT[5][2] =yb;
		A_MAT[6][1] =2*xl-2*xr;A_MAT[6][2] = 2*yl-2*yr;A_MAT[6][3] =-2*xl+2*xr;A_MAT[6][4] =-2*yl+2*yr;

		// rankAMAT=rank(A_MAT)

		RHS[1 ]= 2.0/(M*eps*eps)*( L0*xldLl[o+m]-xltc[o+m] +tcprodRHS(xbtc, lam1tc, m) +2*tcprodRHS(xltc, lam2tc, m)- 2*tcprodRHS(xrtc, lam2tc, m)  ) ;
		RHS[1]= -RHS[1] ;
		RHS[2] = 2.0/(M*eps*eps)*( L0*yldLl[o+m]-yltc[o+m] +tcprodRHS(ybtc, lam1tc, m) +2*tcprodRHS(yltc, lam2tc, m)- 2*tcprodRHS(yrtc, lam2tc, m) ) ;
		RHS[2]=-RHS[2] ;
		RHS[3] = 2.0/(M*eps*eps)*( L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m] -2*tcprodRHS(xltc, lam2tc, m)+ 2*tcprodRHS(xrtc, lam2tc, m) )  ;
		RHS[3]=-RHS[3] ;
		RHS[4] = 2.0/(M*eps*eps)*( L0*( yrdLr[o+m] - ybdLr[o+m] ) -yrtc[o+m] +ybtc[o+m] -2*tcprodRHS(yltc, lam2tc, m)+ 2*tcprodRHS(yrtc, lam2tc, m) ) ;
		RHS[4]=-RHS[4] ;
		RHS[5] = tcprodRHS(xbtc, xltc, m+2) + tcprodRHS(ybtc, yltc, m+2) ;
		RHS[5] =-RHS[5] ;
		RHS[6] = tcprodRHS_2b(xltc, xltc,m+2)-2*tcprodRHS_2b( xrtc, xltc,m+2)+ tcprodRHS_2b( xrtc, xrtc,m+2) + tcprodRHS_2b(yltc, yltc,m+2)-2*tcprodRHS_2b( yrtc, yltc,m+2)+ tcprodRHS_2b( yrtc, yrtc,m+2) ;
		RHS[6] =-RHS[6] ;

		linSolver(A_MAT,RHS,6,b_v);

	   xltc[o+m+2] = b_v[1] ;
	   yltc[o+m+2] = b_v[2] ;
	   xrtc[o+m+2] = b_v[3] ;
	   yrtc[o+m+2] = b_v[4] ;
	   lam1tc[o+m] = b_v[5] ;
	   lam2tc[o+m] = b_v[6] ;


		lam1xb[o+m]= tcprod(lam1tc,xbtc,m ) ;     
		lam1yb[o+m]= tcprod(lam1tc,ybtc,m ) ;     
		lam2xl[o+m]= tcprod(lam2tc,xltc,m ) ;     
		lam2xr[o+m]= tcprod(lam2tc,xrtc,m ) ;     
		lam2yl[o+m]= tcprod(lam2tc,yltc,m ) ;     
		lam2yr[o+m]= tcprod(lam2tc,yrtc,m ) ;     


		xbxl[o+m+2] =tcprod(xbtc,xltc,m+2 )  ;
		xlxl[o+m+2] =tcprod(xltc,xltc,m+2 )  ;
		xrxr[o+m+2] =tcprod(xrtc,xrtc,m+2 )  ;
		xlxr[o+m+2] =tcprod(xltc,xrtc,m+2 )  ;
		ybyl[o+m+2] =tcprod(ybtc,yltc,m+2 )  ;
		ylyl[o+m+2] =tcprod(yltc,yltc,m+2 )  ;
		ylyr[o+m+2] =tcprod(yltc,yrtc,m+2 )  ;
		yryr[o+m+2] =tcprod(yrtc,yrtc,m+2 )  ;



		// ***** F1   = L0*xl/Ll - xl   +lam1*xb +2.0*(lam2*xl -lam2*xr); *****

		F1exp = L0*xldLl[o+m] -xltc[o+m] +lam1xb[o+m]+2.0*(lam2xl[o+m] -lam2xr[o+m]) ;



		// ***** F2   = L0*yl/Ll - yl     +lam1*yb +2.0*[lam2*yl -lam2*yr] -M*eps*eps/2.0 ; ****
		F2exp = L0*yldLl[o+m] -yltc[o+m] +lam1yb[o+m]+2.0*(lam2yl[o+m] -lam2yr[o+m]) ;



		// ***** F3   =[L0-Lr]*[xr-xb]/Lr        -2.0*lam2*[xl-xr]; ***************************
		F3exp = L0*( xrdLr[o+m] - xbdLr[o+m] ) -xrtc[o+m] +xbtc[o+m]  -2.0*(lam2xl[o+m] -lam2xr[o+m]) ;

		// ***** F4   =[L0-Lr]*[yr-yb]/Lr        -2.0*lam2*[yl-yr]-M*eps*eps/2.0; **************
		F4exp = L0*( yrdLr[o+m] - ybdLr[o+m] ) -yrtc[o+m] +ybtc[o+m]  -2.0*(lam2yl[o+m] -lam2yr[o+m]) ;

	   // ***** f9  = xb*xl+yb*yl **********************************

		f9[o+m+2]  = xbxl[o+m+2] + ybyl[o+m+2] ;

		// ***** f10[o] = [xl-xr]**2+[yl-yr]**2-L*L ******************
		// f10[o] = xl^2 -2*xl*xr +xr^2 + yl^2 -2*yl*yr + yr^2 -L*L ;
		f10[o+m+2]= xlxl[o+m+2]-2*xlxr[o+m+2]+ xrxr[o+m+2]+ ylyl[o+m+2]-2*ylyr[o+m+2]+ yryr[o+m+2]  ;


		//feval_m=m
		//TaylcF=F

	}

	   ydervo[1][1] = xl ; 
	   ydervo[1][2] =yl ; 
	   ydervo[1][3] =xr ; 
	   ydervo[1][4] =yr ; 
	   ydervo[1][5] =xlp ; 
	   ydervo[1][6] =ylp ; 
	   ydervo[1][7] =xrp ; 
	   ydervo[1][8] =yrp ; 
	   ydervo[1][9] =lam1 ;
	   ydervo[1][10] =lam2  ;

	   for (int idx=2;idx<=ord+1;idx++){
		  ydervo[idx][1]= xltc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][2]=yltc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][3]=xrtc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][4]=yrtc[o+idx-1]*ft[idx-1]; 
		  ydervo[idx][5]=xltc[o+idx]*ft[idx]; 
		  ydervo[idx][6]=yltc[o+idx]*ft[idx]; 
		  ydervo[idx][7]=xrtc[o+idx]*ft[idx]; 
		  ydervo[idx][8]=yrtc[o+idx]*ft[idx] ; 
		  ydervo[idx][9]=lam1tc[o+idx-1]*ft[idx-1] ;
		  ydervo[idx][10]=lam2tc[o+idx-1]*ft[idx-1] ;
	   }

	   // act ydervo(2,1:8) =[ xlp ; ylp ; xrp ; yrp ; xlpp ; ylpp ; xrpp ; yrpp ] ;


	// Ex:
	// (a*b)''''/4! = (a''''/4!)*b + (a'''/3!)*(b'/1!) + (a''/2!)*(b''/2!)+ (a'/1!)*(b'''/3!)+ (a)*(b''''/4!)

	   //free memory
		delete F;
		delete ft;
		delete ybtc;
		delete LL_ybyb;
		delete xbtc;
		for(int i=1;i<=6;i++)delete A_MAT[i];
		delete A_MAT;
		delete RHS;
		delete b_v;
		delete xltc;
		delete xrtc;
		delete yltc;
		delete yrtc;
		delete lam1tc;
		delete lam2tc;
		delete xl2pyl2;
		delete Lltc;
		delete Lrinput;
		delete Lrtc;
		delete xldLl;
		delete yldLl;
		delete xrdLr;
		delete yrdLr;
		delete xbdLr;
		delete ybdLr;
		delete lam1xb;
		delete lam1yb;
		delete lam2xl;
		delete lam2xr;
		delete lam2yl;
		delete lam2yr;
		delete xbxl;
		delete xlxl;
		delete xrxr;
		delete xlxr;
		delete ybyl;
		delete ylyl;
		delete yryr;
		delete ylyr;
		delete f9;
		delete f10;
}

