/*Calling file for the solution of DAE problems using the Dormand-Prince DP(8,7)13M*/

#include <time.h>
#include <fstream>

#include "prob_transam.cpp"//function evaluation
#include "solver_DP87DAE.cpp"//DP87 solver

int main(){
	//input--begin
	int nbcmp=6;//size(y)

	double t0=0.0;//t_0
	double tend=0.2;//t_f
	
	double RELTOL=5.0*pow(10.0,-14.0);//relative tolerance
	int tolPowMin=4;//min absolute tolerance
	int tolPowMax=10;//max absolute tolerance
	//input--end

	int nbcmpP1=nbcmp+1;
	int nbMax=60000;//max array size for tvals, yvals, fvals
	int nbMaxP1=nbMax+1;

	double*tvals=new double[nbMaxP1];//t values array
	double**yvals=new double*[nbcmpP1];//y values array
	double**fvals=new double*[nbcmpP1];//f=y' values array
	for(int ii=1;ii<=nbcmp;ii++){
		yvals[ii]=new double[nbMaxP1];
		fvals[ii]=new double[nbMaxP1];
	}

	int*res=new int[4];//res[1]=NFE, res[2]-1=number of success steps, res[3]=number of rejected steps
	double*exSol=new double[nbcmpP1];
	double*y0=new double[nbcmpP1];//y0=y_0=y(t_0)

	ofstream myfile;//write to file
	double*rerr=new double[nbcmpP1];

	for(int tolPow=tolPowMin;tolPow<=tolPowMax;tolPow++){	
		double TOL=pow(10.0,-tolPow);//absolute tolerance
		
		y0[1]=-3.0;y0[2]=3.0;y0[3]=6.0;y0[4]=0.0;y0[5]=-500.0/3.0; y0[6]=0.0;//transam
		
		//initializing arrays
		for(int ii=1;ii<=nbMax;ii++)tvals[ii]=0.0;
		for(int ii=1;ii<=nbcmp;ii++){
			for(int jj=1;jj<=nbMax;jj++){
				yvals[ii][jj]=0.0;	
				fvals[ii][jj]=0.0;	
			}
		}
		res[1]=0;res[2]=0;res[3]=0;
		
		double iniTime=clock();//initializing time for CPU measure
		DP87DAESolver(RELTOL,TOL, t0, tend, y0,tvals,yvals,fvals,res,nbcmp,nbMax);
		double duration=(clock()-iniTime)/CLOCKS_PER_SEC;

		if(duration<1.0){//iterate nbrIter times if duration is too small
			int nbrIter=1000;//allow about 10 seconds for the test
			for(int i=1;i<=nbrIter;i++){
				//initializing arrays
				for(int ii=1;ii<=nbMax;ii++)tvals[ii]=0.0;
				for(int ii=1;ii<=nbcmp;ii++){
					for(int jj=1;jj<=nbMax;jj++){
						yvals[ii][jj]=0.0;	
						fvals[ii][jj]=0.0;	
					}
				}
				res[1]=0;res[2]=0;res[3]=0;

				iniTime=clock();//initializing time for CPU measure
				DP87DAESolver(RELTOL,TOL, t0, tend, y0,tvals,yvals,fvals,res,nbcmp,nbMax);
				duration+=(clock()-iniTime)/CLOCKS_PER_SEC;
			}
			duration=duration/(nbrIter+1);
		}

		int NFE=res[1];//number of function evaluations
		int n=res[2]-1;//number of success steps
		int nreje=res[3];//number of rejected steps

		//reference solution (obtained using DP87 at TOL=1E-12)
		exSol[1]=-3.09097599287196933560e+00;
		exSol[2]=2.89834944884998924053e+00;
		exSol[3]=3.23449544763482821352e+00;
		exSol[4]=2.22670931405664873637e+01;
		exSol[5]=1.88903023965471305701e+02;
		exSol[6]=-6.42613572048336578746e+01;

		//Compute SCD
		double SCD=0.0;
		for(int i=1;i<=nbcmp;i++){
			rerr[i]=fabs((exSol[i]-yvals[i][n+11])/exSol[i]);
			SCD=max(SCD,rerr[i]);
		}
		SCD=-log(SCD)/log(10.0);

		myfile.open ("DAE tests HBT10 DP87.txt",ios::app);
		myfile<<"Solver: DP87DAE Prb=transam TOL="<<TOL<<" NFE="<<NFE<<" SCD="<<SCD<<" n="<<n<<" nreje="<<nreje<<" CPU time="<<duration<<"********\n";
		myfile.close();

		cout<<"Solver: DP87DAE Prb=transam TOL="<<TOL<<" NFE="<<NFE<<" SCD="<<SCD<<" n="<<n<<" nreje="<<nreje<<" CPU time="<<duration<<"********\n";
	}

	myfile.open ("DAE tests HBT10 DP87.txt",ios::app);
	myfile << "\n";
	myfile.close();

	//free memory
	delete y0;
	delete exSol;
	delete tvals;
	for(int ii=1;ii<=nbcmp;ii++){
		delete yvals[ii];
		delete fvals[ii];
	}
	delete yvals;
	delete fvals;
	delete res;
	delete rerr;

	return 0;
}
