#include <math.h>

//Exact solution of D problems
static void odeSolD(double x,double* y,int nbcmp, double eps,double*u){
	
	double a=x+eps*sin(x);
	//use Newton Method to solve Kepler equation
	for(long int i=1;fabs(a-eps*sin(a)-x)>4.0*pow(10.0,-13.0);i++)
		a=a-(a-eps*sin(a)-x)/(1-eps*cos(a));

	
	u[1]=cos(a)-eps;
	u[2]=sqrt(1-eps*eps)*sin(a);
	u[3]=-sin(a)/(1.0-eps*cos(a));
	u[4]=sqrt(1-eps*eps)*cos(a)/(1-eps*cos(a));
}
