/*

% Test out: HBO144q16 solves Henon-Heiles problem 
%
%   1. Initialisation
%      - set  initial t0=0;
%             initial y0 is calculated below 
%             integration final time "tend"
%                  t0 =0  to  tend = 70.0
%
%
%   2. Perform the integration : call  "HBO144q16"
%   3. Output
%       write on file "HBORKcpu.txt" the following informations:
%         - CPU time, number of steps, number of function evaluations, 
%           Max. global error and Max. energy error 
%

  Thanks are due to Martin Lara for supplying the authors with this Henon-Heiles problem

*/

#include <time.h>
#include <stdio.h>

#define includeName "odeHH.cpp"//y'=f(x,y)
#include "HBO144q16.cpp"//Used solver
#include "HBODP87.cpp"//Solver calculating exact solution

using namespace std;

//Print methods for easy reading
void print(double*x, int dim){
	for(int i=1;i<dim;i++)cout<<x[i]<< ", ";
	cout<<x[dim]<<'\n';
}
void print(double x, double*y,int dim){
	cout<<" tc = "<<x<<"; yc = (";
	for(int i=1;i<dim;i++)cout<<y[i]<< ", ";
	cout<<y[dim]<<")\n";
}

int main()
{
	//...Input...
	int nbcmp=4;//number of components of y0
    double ham, me;
	int nbcmpP1=nbcmp+1;
    double ic[nbcmpP1];	
	
    int nbyva=20000 ;
    int nbyvap1=nbyva+1 ;
	
//  HH ep=1.0
	double ep= 1.0;
	
	double RELTOL=4*pow(10.0,-14);//Relative tolerance
	int minIdxTol=4 ;
	int maxIdxTol=13 ;//Tolerance goes from 1e-minIdxTol to 1e-maxIdxTol
	
	double t0=0.0;//Initial t
	double tend = 70.0;
// orig	double tend = 70.0;/*Final t 
	//............

	double TOL;
	//Initializing main arrays
	double*tvals =new double[nbyvap1];//values of t_n
	double**yvals=new double*[nbyvap1];//values of y_n
	double**fvals=new double*[nbyvap1];
	double**f2vals=new double*[nbyvap1];
	double**f3vals=new double*[nbyvap1];
			
	int*res=new int[4];
	for(int j=0;j<=nbyva;j++){
		tvals[j]=0.0;
		yvals[j]=new double[nbcmpP1];
		fvals[j]=new double[nbcmpP1];
		f2vals[j]=new double[nbcmpP1];
		f3vals[j]=new double[nbcmpP1];	
					
		for(int i=0;i<=nbcmp;i++){
			yvals[j][i]=0.0;
			fvals[j][i]=0.0;
			f2vals[j][i]=0.0;
			f3vals[j][i]=0.0;
																																																				
		}
	}
//  (end for(int j=0;j<=nbyva;j++){} )		
	//y0
	double* y0=new double[nbcmpP1];
     double ham0 = 0.125  ;
//! Sample initial conditions
        ic[1] = 0.0  ;
        ic[2] = 0.2 ;
        ic[4] = 0.2 ;
//! Compute corresponding ic(3)
        double x2 = ic[1]*ic[1];
        double y2 = ic[2]*ic[2];
        ic[3] = 2.0*ham0 - (x2 + y2) - 2.0 *ep*ic[2]*(x2 - y2/3.0 )  - ic[4]*ic[4] ;
        if (ic[3] >=  0.0 ){
          ic[3] = sqrt(ic[3]) ;
		  }
        else {
          // STOP 'BAD ICS'
    	  cout << " cHH : STOP 'BAD ICS'  " <<  endl ;		  
		  exit(1);
		  } ;

	y0[1]=ic[1];
	y0[2]=ic[2];
	y0[3]=ic[3];
	y0[4]=ic[4];

	//To calculate the CPU
	double duration;
	clock_t start;

	//To calculate the maximum global error
	double maxGE;
	double y;
	double x;
	double xPrec;
	double*sol=new double[nbcmpP1];//exact solution
	double*tvals2=new double[nbyvap1];//values of t_n for the solver calculating exact solution
	double**yvals2=new double*[nbyvap1];//values of y_n for the solver calculating exact solution
	int*res2=new int[4];
	for(int j=0;j<=nbyva;j++){
		tvals2[j]=0.0;
		yvals2[j]=new double[nbcmpP1];
		for(int i=0;i<=nbcmp;i++){
			yvals2[j][i]=0.0;
		}
	}
	
	//Output file
	FILE* file=fopen("HBORKcpu.txt","a");

	char*dProb="012345";	
	double nbeps=4+5 ;
	int nbpos=10;
	double NFE;//Number of function evaluations
	double n;//Number of succes step:
	double nreje, nbit;
    int inbit ;
	
	//Print to file
	fprintf (file,"%%% HBORK  METHOD prb   %15s, tend= %7.2e \n", "PrbHH" , tend) ;

	for(int j=minIdxTol;j<=maxIdxTol;j++){
		TOL=1.0*pow(10.0,-j*1.0);
		
    	cout << " cprog : j= " << j << ", TOL =" << TOL << endl ;
// orig		nbit=400.0 ;		
		nbit=1.0 ;
		inbit=int(nbit) ;
		//CPU
		start=clock();
		for(int i=1;i<=inbit ;i++){
			HBO144q16(RELTOL,TOL,t0,tend,y0,tvals,yvals,fvals,f2vals,f3vals,res,nbcmp);
		}
		duration = (double)(clock()-start)/CLOCKS_PER_SEC/nbit ;
    	cout << " cprog : duration= " << duration  << endl ;

		//Maximum global error
		maxGE=0.0;
		me=0;
		for(int i=1;i<=nbcmp;i++)
			sol[i]=y0[i];
		xPrec=t0;
		for(int i=11;i<=nbpos+res[2];i++){
			x=tvals[i];
			dp87(RELTOL,5.0*pow(10.0,-14.0),xPrec,x,sol,tvals2,yvals2,fvals,res2,nbcmp);			
			for(int j=1;j<=nbcmp;j++){
				sol[j]=yvals2[nbpos+res2[2]][j];//exact solution
				y=yvals[i][j];
				if(fabs(y-sol[j])>maxGE)maxGE=fabs(y-sol[j]);
				if(i>=nbpos+res[2]-5) cout << " cprog: i= " << i << " tvals= " << tvals[i] << ", fabs(y-sol[j]) =" << fabs(y-sol[j]) << ", maxGE =" << maxGE << endl ;
				
				// cout << " cprog:  tvals[i]= " << tvals[i] << " i= " << i << ", fabs(y-sol[j]) =" << fabs(y-sol[j]) << ", maxGE =" << maxGE << endl ;								
			}
            //(end for(int j=1;j<=nbcmp;j++){})

          //! test hamiltonian value   
          ic[1] = yvals[i][1] ;
          ic[2] = yvals[i][2] ;
          ic[3] = yvals[i][3] ;
          ic[4] = yvals[i][4] ;		  		  
		  
          x2 = ic[1]*ic[1];
          y2 = ic[2]*ic[2];

          ham = (ic[3]*ic[3] + ic[4]*ic[4])*0.5  + (x2 + y2)*0.5   + ep*ic[2]*(x2 - y2/3.0 ) ;
			
            ham = fabs(ham/ham0 - 1.0 ) ;
            if(ham >=  me) me = ham ;
			// cout << "\n cprog: me = " << me  << "  ham = " << ham  << "  ham0 = " << ham0  <<  "  i = " << i  <<  endl ;	

			if(i >= 12000000  ){
		        // cout << "\n cprog: me = " << me  << "  ham = " << ham  <<  "  i = " << i  <<  endl ;	
				exit(1);			   
			    }																		
			
			xPrec=x;
		}
		//(end for(int i=11;i<=nbpos+res[2];i++){})
				
		cout << " cprog: tend=" << tvals[nbpos+res[2] ] <<  "tendzero= " << (tvals[nbpos+res[2] ]-tend) <<   " maxGE =" << maxGE << endl ;
				
		NFE=res[1]*1.0;//Number of function evaluations
		n=res[2]-1.0;//Number of succes step:
		nreje=res[3]*1.0;

		//Print to file
		fprintf (file,"%%% HBO  METHOD  nsuccesstp = %5.0f, nreje = %5.0f \n", n+1, nreje) ;
		fprintf (file," HBO144q16CPU( 84, %3.0f ) = %7.2e ; HBO144q16NST( 84, %3.0f ) = %5.0f ; HBO144q16NFE( 84, %3.0f ) = %5.0f ;  HBO144q16MXGE( 84, %3.0f ) = %7.2e ;  HBO144q16ENER( 84, %3.0f ) = %7.2e ; \n"  ,j*1.0, duration, j*1.0, n  , j*1.0, NFE ,j*1.0, maxGE , j*1.0, me ,j) ;
		
		//Completed work
		cout << "\n cprog: CPU est. nb iteration  inbit = " << inbit  <<  endl ;		
		cout<<"Completed tolerance : "<<TOL<<'\n';
	}
	fclose(file);

	//freeing memory
	delete tvals;
	delete y0;
	for(int j=0;j<=nbyva;j++){
		delete yvals[j];
		delete fvals[j];
		delete f2vals[j];
		delete f3vals[j];												
	}
	delete yvals;
	delete fvals;
	delete f2vals;
	delete f3vals;	
	delete res;
	delete sol;
	//Print
	cout<<"\nDone.\n";
	return 0;
}
