//Dormand-Prince DP8(7)13M

#include <iostream>
#include <math.h>

#ifndef includeName
#include includeName
#endif

using namespace std;

//subfunction of DP87
static double dp87sub(double RELTOL, double TOL, double t,double*y,double*inpf,double h,int k,int j,double*tvals, double**yvals,double** fvals, int nbpos,int nbcmp){

	int nbcmpP1=nbcmp+1;

	double temp;
	// orig trny =transpose(y);

	//
	// Post: tnew=tc+h, ynew is an approximate solution at t=tnew, and
	//	fnew = f(tnew, ynew)

	double tc=t;

	// (( PARAM:
	double stfac=0.9 ;
	double hmax = 10.0 ;

	//   ode45 hmin:  compeps = 2.220446049250313e-16
	double compeps = 2.220446049250313e-16 ;
	double hmin = 16*compeps  ; 
	// PARAM ))


	// %%%%%%%%%%% b formula: (step cntrl) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	double be1 =13451932.0/455176623.0,be2=0.0,be3=0.0,be4=0.0,be5=0.0;
	double be6 =-808719846.0/976000145.0, be7 =1757004468.0/5645159321.0;
	double be8 =656045339.0/265891186.0, be9 =-3867574721.0/1518517206.0;
	double be10 =465885868.0/322736535.0, be11 =53011238.0/667516719.0;
	double be12 =2.0/45.0, be13 =0.0;
 
	// %%%%%%%%%%% b hat formula: (cont solution) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	double beh1 = 14005451.0/335480064.0, beh2 =0.0, beh3 = 0.0, beh4 = 0.0, beh5 = 0.0;
	double beh6=-59238493.0/1068277825.0,beh7=181606767.0/758867731.0;
	double beh8=561292985.0/797845732.0,beh9=-1041891430.0/1371343529.0;
	double beh10=760417239.0/1151165299.0,beh11=118820643.0/751138087.0;
	double beh12=-528747749.0/2220607170.0,beh13=1.0/4.0;

	// 
	double c1=0.0,c2=1.0/18.0,c3=1.0/12.0,c4=1.0/8.0;
	double c5=5.0/16.0,c6=3.0/8.0,c7=59.0/400.0,c8=93.0/200.0;
	double c9=5490023248.0/9719169821.0,c10=13.0/20.0,c11=1201146811.0/1299019798.0;
	double c12=1.0,c13=1.0;
	//

	double a21= 1.0/18.0 ;
	double a31= 1.0/48.0;
	double a32= 1.0/16.0 ;

	double a41=1.0/32.0;
	double a42=-0.0;
	double a43=3.0/32.0;

	double a51=5.0/16.0;
	double a52=0.0;
	double a53=-75.0/64.0;
	double a54=75.0/64.0;

	double a61=3.0/80.0;
	double a62=0.0;
	double a63=0.0;
	double a64=3.0/16.0;
	double a65=3.0/20.0;

	double a71=29443841.0/614563906.0;
	double a72=0.0;
	double a73=0.0;
	double a74=77736538.0/692538347.0;
	double a75=-28693883.0/1125000000.0;
	double a76=23124283.0/1800000000.0;

	double a81=16016141.0/946692911.0;
	double a82=0.0;
	double a83=0.0;
	double a84=61564180.0/158732637.0;
	double a85=22789713.0/633445777.0;
	double a86=545815736.0/2771057229.0;
	double a87=-180193667.0/1043307555.0;

	double a91=39632708.0/573591083.0;
	double a92=0.0;
	double a93=0.0;
	double a94=-433636366.0/683701615.0;
	double a95=-421739975.0/2616292301.0;
	double a96=100302831.0/723423059.0;
	double a97=790204164.0/839813087.0;
	double a98=800635310.0/3783071287.0;

	double a101=246121993.0/1340847787.0;
	double a102=0.0;
	double a103=0.0;
	double a104=-37695042795.0/15268766246.0;
	double a105=-309121744.0/1061227803.0;
	double a106=-12992083.0/490766935.0;
	double a107=6005943493.0/2108947869.0;
	double a108=393006217.0/1396673457.0;
	double a109=123872331.0/1001029789.0;

	double a111=-1028468189.0/846180014.0;
	double a112=0.0;
	double a113=0.0;
	double a114=8478235783.0/508512852.0;
	double a115=1311729495.0/1432422823.0;
	double a116=-10304129995.0/1701304382.0;
	double a117=-48777925059.0/3047939560.0;
	double a118=15336726248.0/1032824649.0;
	double a119=-45442868181.0/3398467696.0;
	double a1110=3065993473.0/597172653.0;

	double a121=185892177.0/718116043.0;
	double a122=0.0;
	double a123=0.0;
	double a124=-3185094517.0/667107341.0;
	double a125=-477755414.0/1098053517.0;
	double a126=-703635378.0/230739211.0;
	double a127=5731566787.0/1027545527.0;
	double a128=5232866602.0/850066563.0;
	double a129=-4093664535.0/808688257.0;
	double a1210=3962137247.0/1805957418.0;
	double a1211=65686358.0/487910083.0;

	double a131=403863854.0/491063109.0;
	double a132=0.0;
	double a133=0.0;
	double a134=-5068492393.0/434740067.0;
	double a135=-411421997.0/543043805.0;
	double a136=652783627.0/914296604.0;
	double a137=11173962825.0/925320556.0;
	double a138=-13158990841.0/6184727034.0;
	double a139=3936647629.0/1978049680.0;
	double a1310=-160528059.0/685178525.0;
	double a1311=248638103.0/1413531060.0;
	double a1312=0.0;

	//          2               4               6                    8               10                     12   

	double** B=new double*[14];
	for(int i=0;i<=13;i++){
		B[i]=new double[14];
		for(int jj=0;jj<=13;jj++)
			B[i][jj]=0.0;
	}
	B[1][1]=a21;
	B[1][2]=a31;
	B[1][3]=a41;
	B[1][4]=a51;
	B[1][5]=a61;
	B[1][6]=a71;
	B[1][7]=a81;
	B[1][8]=a91;
	B[1][9]=a101;
	B[1][10]=a111;
	B[1][11]=a121;
	B[1][12]=a131;
	B[1][13]=beh1;

	B[2][2]=a32;
	B[2][3]=a42;
	B[2][4]=a52;
	B[2][5]=a62;
	B[2][6]=a72;
	B[2][7]=a82;
	B[2][8]=a92;
	B[2][9]=a102;
	B[2][10]=a112;
	B[2][11]=a122;
	B[2][12]=a132;
	B[2][13]=beh2;

	B[3][3]=a43;
	B[3][4]=a53;
	B[3][5]=a63;
	B[3][6]=a73;
	B[3][7]=a83;
	B[3][8]=a93;
	B[3][9]=a103;
	B[3][10]=a113;
	B[3][11]=a123;
	B[3][12]=a133;
	B[3][13]=beh3;

	B[4][4]=a54;
	B[4][5]=a64;
	B[4][6]=a74;
	B[4][7]=a84;
	B[4][8]=a94;
	B[4][9]=a104;
	B[4][10]=a114;
	B[4][11]=a124;
	B[4][12]=a134;
	B[4][13]=beh4;

	B[5][5]=a65;
	B[5][6]=a75;
	B[5][7]=a85;
	B[5][8]=a95;
	B[5][9]=a105;
	B[5][10]=a115;
	B[5][11]=a125;
	B[5][12]=a135;
	B[5][13]=beh5;

	B[6][6]=a76;
	B[6][7]=a86;
	B[6][8]=a96;
	B[6][9]=a106;
	B[6][10]=a116;
	B[6][11]=a126;
	B[6][12]=a136;
	B[6][13]=beh6;

	B[7][7]=a87;
	B[7][8]=a97;
	B[7][9]=a107;
	B[7][10]=a117;
	B[7][11]=a127;
	B[7][12]=a137;
	B[7][13]=beh7;

	B[8][8]=a98;
	B[8][9]=a108;
	B[8][10]=a118;
	B[8][11]=a128;
	B[8][12]=a138;
	B[8][13]=beh8;

	B[9][9]=a109;
	B[9][10]=a119;
	B[9][11]=a129;
	B[9][12]=a139;
	B[9][13]=beh9;

	B[10][10]=a1110;
	B[10][11]=a1210;
	B[10][12]=a1310;
	B[10][13]=beh10;

	B[11][11]=a1211;
	B[11][12]=a1311;
	B[11][13]=beh11;

	B[12][12]=a1312;
	B[12][13]=beh12;

	B[13][13]=beh13;

	double* y_estcf=new double[14];
	y_estcf[0]=0.0;
	y_estcf[1]=be1;
	y_estcf[2]=be2;
	y_estcf[3]=be3;
	y_estcf[4]=be4;
	y_estcf[5]=be5;
	y_estcf[6]=be6;
	y_estcf[7]=be7;
	y_estcf[8]=be8;
	y_estcf[9]=be9;
	y_estcf[10]=be10;
	y_estcf[11]=be11;
	y_estcf[12]=be12;
	y_estcf[13]=be13;

	double**fT=new double*[14];

	for(int i=0;i<=13;i++)
		fT[i]=new double[nbcmpP1];
	
    int jpnbpos=j+nbpos;

	for(int i=1;i<=nbcmp;i++)
		fT[1][i] = fvals[jpnbpos][i];

	// hA: 12 comp
	double* hA=new double[14];
	hA[0]=0.0;
	hA[1]=h/18.0;
	hA[2]=h/12.0;
	hA[3]=h/8.0;
	hA[4]=h*5.0/16.0;
	hA[5]=h*3.0/8.0;
	hA[6]=h*59.0/400.0;
	hA[7]=h*93.0/200.0;
	hA[8]=h*5490023248.0/9719169821.0;
	hA[9]=h*13.0/20.0;
	hA[10]=h*1201146811.0/1299019798.0;
	hA[11]=h;
	hA[12]=h;
	hA[13]=h;
	/*double hA[] = {0.0,h/18.0,h/12.0,h/8.0,h*5.0/16.0,h*3.0/8.0,h*59.0/400.0,h*93.0/200.0,h*5490023248.0/9719169821.0,h*13.0/20.0,h*1201146811.0/1299019798.0,h,h,h};
	double*hAptr=&hA[0];*/
	
	double* E=new double[14];
	
	E[0]=0.0;
	E[1]=beh1-be1;
	E[2]=beh2-be2;
	E[3]=beh3-be3;
	E[4]=beh4-be4;
	E[5]=beh5-be5;
	E[6]=beh6-be6;
	E[7]=beh7-be7;
	E[8]=beh8-be8;
	E[9]=beh9-be9;
	E[10]=beh10-be10;
	E[11]=beh11-be11;
	E[12]=beh12-be12;
	E[13]=beh13-be13;
	

	double*tempV=new double[nbcmpP1];
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][1];
	}
	f(t+hA[1],tempV,nbcmp,fT[2]);
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][2]+fT[2][i]*h*B[2][2];
	}
    f(t+hA[2],tempV,nbcmp,fT[3]);
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][3]+fT[2][i]*h*B[2][3]+fT[3][i]*h*B[3][3];	
	}
    f(t+hA[3],tempV,nbcmp,fT[4]);
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];	
		tempV[i]+=fT[1][i]*h*B[1][4]+fT[2][i]*h*B[2][4]+fT[3][i]*h*B[3][4]+fT[4][i]*h*B[4][4];
	}
    f(t+hA[4],tempV,nbcmp,fT[5]);
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i]+fT[1][i]*h*B[1][5];	
		tempV[i]+=fT[2][i]*h*B[2][5]+fT[3][i]*h*B[3][5]+fT[4][i]*h*B[4][5]+fT[5][i]*h*B[5][5];
	}
    f(t+hA[5],tempV,nbcmp,fT[6]);
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][6]+fT[2][i]*h*B[2][6]+fT[3][i]*h*B[3][6]+fT[4][i]*h*B[4][6];
		tempV[i]+=fT[5][i]*h*B[5][6]+fT[6][i]*h*B[6][6];
	}
    f(t+hA[6],tempV,nbcmp,fT[7]);
	
	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][7]+fT[2][i]*h*B[2][7]+fT[3][i]*h*B[3][7]+fT[4][i]*h*B[4][7];
		tempV[i]+=fT[5][i]*h*B[5][7]+fT[6][i]*h*B[6][7]+fT[7][i]*h*B[7][7];
	}
    f(t+hA[7],tempV,nbcmp,fT[8]);

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][8]+fT[2][i]*h*B[2][8]+fT[3][i]*h*B[3][8]+fT[4][i]*h*B[4][8];
		tempV[i]+=fT[5][i]*h*B[5][8]+fT[6][i]*h*B[6][8]+fT[7][i]*h*B[7][8]+fT[8][i]*h*B[8][8];
	}
    f(t+hA[8],tempV,nbcmp,fT[9]);

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i]+fT[1][i]*h*B[1][9];
		tempV[i]+=fT[2][i]*h*B[2][9]+fT[3][i]*h*B[3][9]+fT[4][i]*h*B[4][9]+fT[5][i]*h*B[5][9];
		tempV[i]+=fT[6][i]*h*B[6][9]+fT[7][i]*h*B[7][9]+fT[8][i]*h*B[8][9]+fT[9][i]*h*B[9][9];
	}
    f(t+hA[9],tempV,nbcmp,fT[10]);

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][10]+fT[2][i]*h*B[2][10]+fT[3][i]*h*B[3][10]+fT[4][i]*h*B[4][10];
		tempV[i]+=fT[5][i]*h*B[5][10]+fT[6][i]*h*B[6][10]+fT[7][i]*h*B[7][10]+fT[8][i]*h*B[8][10];
		tempV[i]+=fT[9][i]*h*B[9][10]+fT[10][i]*h*B[10][10];
	}
    f(t+hA[10],tempV,nbcmp,fT[11]);

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][11]+fT[2][i]*h*B[2][11]+fT[3][i]*h*B[3][11]+fT[4][i]*h*B[4][11];
		tempV[i]+=fT[5][i]*h*B[5][11]+fT[6][i]*h*B[6][11]+fT[7][i]*h*B[7][11]+fT[8][i]*h*B[8][11];
		tempV[i]+=fT[9][i]*h*B[9][11]+fT[10][i]*h*B[10][11]+fT[11][i]*h*B[11][11];
	}
    f(t+hA[11],tempV,nbcmp,fT[12]);

	for(int i=1;i<=nbcmp;i++){
		tempV[i]=y[i];
		tempV[i]+=fT[1][i]*h*B[1][12]+fT[2][i]*h*B[2][12]+fT[3][i]*h*B[3][12]+fT[4][i]*h*B[4][12];
		tempV[i]+=fT[5][i]*h*B[5][12]+fT[6][i]*h*B[6][12]+fT[7][i]*h*B[7][12]+fT[8][i]*h*B[8][12];
		tempV[i]+=fT[9][i]*h*B[9][12]+fT[10][i]*h*B[10][12]+fT[11][i]*h*B[11][12]+fT[12][i]*h*B[12][12];
	}
    f(t+hA[12],tempV,nbcmp,fT[13]);

    double tnew = t + hA[13];
	
	double*ynew=new double[nbcmpP1];
	for(int i=1;i<=nbcmp;i++){
		ynew[i]=y[i]+fT[1][i]*h*B[1][13];
		ynew[i]+=fT[2][i]*h*B[2][13]+fT[3][i]*h*B[3][13]+fT[4][i]*h*B[4][13]+fT[5][i]*h*B[5][13];
		ynew[i]+=fT[6][i]*h*B[6][13]+fT[7][i]*h*B[7][13]+fT[8][i]*h*B[8][13]+fT[9][i]*h*B[9][13];
		ynew[i]+=fT[10][i]*h*B[10][13]+fT[11][i]*h*B[11][13]+fT[12][i]*h*B[12][13]+fT[13][i]*h*B[13][13];
	}

    f(tnew,ynew,nbcmp,fT[13]);
	// return  
	double*fnew=new double[nbcmpP1];
    for(int i=1;i<=nbcmp;i++)
		fnew[i]= fT[13][i];

	//   erk =   max(abs(f * ( hB(:,13)- h*y_estcf)  )) = max(abs(f *  hE  ))
	double erk=0.0;
	for(int i=1;i<=nbcmp;i++){
		temp=0.0;
		for(int ii=1;ii<=13;ii++){
			temp+=fT[ii][i]*E[ii];
		}
		if(fabs(temp)>erk)
			erk=fabs(temp);
	}
    erk*= fabs(h);   


	// Ex:  ode45 hmin:  compeps = 2.220446049250313e-16
	//    compeps = 2.220446049250313e-16 ;
	//    hmin = 16*compeps*abs(tc);    stephmin2=hmin
	//  PART :  STEP SIZE ********************

	//  (step size formula : h =hold, stsize = hnew)   
	double stsize;	
	if (erk != 0.0) {
		// ACT    (HB../HB11 step cntrl)
		stsize = h *stfac *pow(TOL/erk ,1.0/8.0 ) ;  
	}
	else
      stsize = 2.0*h ;

    //  (end of step size formula : h =hold, stsize = hnew)

	//  constraints that stsize must satisfy :
	//     (a) h( next step) = max (h( next step), hmin, 0.5* h(last step))
	//     (b) h( next step) = min (h( next step), hmax, 4 * h(last step))

	stsize=max(stsize,0.5*h);
	stsize=max(stsize,hmin);
	stsize=min(stsize,hmax);
	stsize=min(stsize,4.0*h);

	//freeing memory
	for(int i=0;i<=13;i++){
		delete fT[i];
		delete B[i];
	}
	delete fT;
	delete tempV;
	delete ynew;
	delete fnew;
	delete E;
	delete hA;
	delete y_estcf;
	delete B;

	//returning step size
	return stsize;
}

//main DP87 method
static void dp87(double RELTOL, double TOL, double t0, double tend, double *y0, double*tvals,double**yvals,double**fvals,int*res, int nbcmp){

	int nbcmpP1=nbcmp+1;

	int temp; 
	double tempD;
	// p 180 Hairer

	// (( PARAM %%%%%%%%%

	//   ode45 hmin:  eps = 2.220446049250313e-16
    double eps = 2.220446049250313e-16;
	int nbpos=10;
	int nbeps=13;
	double hmax = (tend-t0)/5.0;
	//%%%  PARAM )) %%%%%%%%%

	double tc = t0;
	double*yc=new double[nbcmpP1];
	for(int i=1;i<=nbcmp;i++)
		yc[i] =y0[i];

	double*fc=new double[nbcmpP1];
	f(tc,yc,nbcmp,fc);


    // p 169, Hairer: first guess for step size:
	double normY0=0.0;
	double normFc=0.0;
	for(int i=1;i<=nbcmp;i++){
		normY0+=pow(y0[i],2.0);
		normFc+=pow(fc[i],2.0);
	}
	double h=0.01*(sqrt(normY0)/sqrt(normFc));
	int j=0;
	int jpnbpos=j+nbpos;
	tvals[jpnbpos] =  tc;
	for(int i=1;i<=nbcmp;i++){
		yvals[jpnbpos][i] =yc[i];
		fvals[jpnbpos][i] = fc[i];
	}
	
	int k=1111 ;
	
	// TOL/10000

	//calling the subFunction
	double hnew=dp87sub(RELTOL, TOL/10000.0, tc,yc,fc,h,k, j,tvals, yvals, fvals, nbpos,nbcmp);
	
	// TOL/10000  step size:
	h=hnew;

	//REINIT tc, yc, fc,

	tc = tvals[jpnbpos];
	
	for(int i=1;i<=nbcmp;i++){
		yc[i]=yvals[jpnbpos][i];
		fc[i]=fvals[jpnbpos][i];
	}

	j=0;
	int nreje=0;

	// hnew = h ;
	// (( PARAM:
	double stfac=0.9 ;
	//   ode45 hmin:  compeps = 2.220446049250313e-16
	double compeps = 2.220446049250313e-16;
	double hmin = 16*compeps;
	// PARAM ))

	// %%%%%%%%%%% b formula: (step cntrl) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	double be1 =13451932.0/455176623.0,be2=0.0,be3=0.0,be4=0.0,be5=0.0;
	double be6 =-808719846.0/976000145.0, be7 =1757004468.0/5645159321.0;
	double be8 =656045339.0/265891186.0, be9 =-3867574721.0/1518517206.0;
	double be10 =465885868.0/322736535.0, be11 =53011238.0/667516719.0;
	double be12 =2.0/45.0, be13 =0.0;
 
	// %%%%%%%%%%% b hat formula: (cont solution) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	double beh1 = 14005451.0/335480064.0, beh2 =0.0, beh3 = 0.0, beh4 = 0.0, beh5 = 0.0;
	double beh6=-59238493.0/1068277825.0,beh7=181606767.0/758867731.0;
	double beh8=561292985.0/797845732.0,beh9=-1041891430.0/1371343529.0;
	double beh10=760417239.0/1151165299.0,beh11=118820643.0/751138087.0;
	double beh12=-528747749.0/2220607170.0,beh13=1.0/4.0;

	// 
	double c1=0.0,c2=1.0/18.0,c3=1.0/12.0,c4=1.0/8.0;
	double c5=5.0/16.0,c6=3.0/8.0,c7=59.0/400.0,c8=93.0/200.0;
	double c9=5490023248.0/9719169821.0,c10=13.0/20.0,c11=1201146811.0/1299019798.0;
	double c12=1.0,c13=1.0;
	//

	double a21= 1.0/18.0 ;
	double a31= 1.0/48.0;
	double a32= 1.0/16.0 ;

	double a41=1.0/32.0;
	double a42=-0.0;
	double a43=3.0/32.0;

	double a51=5.0/16.0;
	double a52=0.0;
	double a53=-75.0/64.0;
	double a54=75.0/64.0;

	double a61=3.0/80.0;
	double a62=0.0;
	double a63=0.0;
	double a64=3.0/16.0;
	double a65=3.0/20.0;

	double a71=29443841.0/614563906.0;
	double a72=0.0;
	double a73=0.0;
	double a74=77736538.0/692538347.0;
	double a75=-28693883.0/1125000000.0;
	double a76=23124283.0/1800000000.0;

	double a81=16016141.0/946692911.0;
	double a82=0.0;
	double a83=0.0;
	double a84=61564180.0/158732637.0;
	double a85=22789713.0/633445777.0;
	double a86=545815736.0/2771057229.0;
	double a87=-180193667.0/1043307555.0;

	double a91=39632708.0/573591083.0;
	double a92=0.0;
	double a93=0.0;
	double a94=-433636366.0/683701615.0;
	double a95=-421739975.0/2616292301.0;
	double a96=100302831.0/723423059.0;
	double a97=790204164.0/839813087.0;
	double a98=800635310.0/3783071287.0;

	double a101=246121993.0/1340847787.0;
	double a102=0.0;
	double a103=0.0;
	double a104=-37695042795.0/15268766246.0;
	double a105=-309121744.0/1061227803.0;
	double a106=-12992083.0/490766935.0;
	double a107=6005943493.0/2108947869.0;
	double a108=393006217.0/1396673457.0;
	double a109=123872331.0/1001029789.0;

	double a111=-1028468189.0/846180014.0;
	double a112=0.0;
	double a113=0.0;
	double a114=8478235783.0/508512852.0;
	double a115=1311729495.0/1432422823.0;
	double a116=-10304129995.0/1701304382.0;
	double a117=-48777925059.0/3047939560.0;
	double a118=15336726248.0/1032824649.0;
	double a119=-45442868181.0/3398467696.0;
	double a1110=3065993473.0/597172653.0;

	double a121=185892177.0/718116043.0;
	double a122=0.0;
	double a123=0.0;
	double a124=-3185094517.0/667107341.0;
	double a125=-477755414.0/1098053517.0;
	double a126=-703635378.0/230739211.0;
	double a127=5731566787.0/1027545527.0;
	double a128=5232866602.0/850066563.0;
	double a129=-4093664535.0/808688257.0;
	double a1210=3962137247.0/1805957418.0;
	double a1211=65686358.0/487910083.0;

	double a131=403863854.0/491063109.0;
	double a132=0.0;
	double a133=0.0;
	double a134=-5068492393.0/434740067.0;
	double a135=-411421997.0/543043805.0;
	double a136=652783627.0/914296604.0;
	double a137=11173962825.0/925320556.0;
	double a138=-13158990841.0/6184727034.0;
	double a139=3936647629.0/1978049680.0;
	double a1310=-160528059.0/685178525.0;
	double a1311=248638103.0/1413531060.0;
	double a1312=0.0;

	//          2               4               6                    8               10                     12   

	double** B=new double*[14];
	for(int i=0;i<=13;i++){
		B[i]=new double[14];
		for(int jj=0;jj<=13;jj++)
			B[i][jj]=0.0;
	}
	B[1][1]=a21;
	B[1][2]=a31;
	B[1][3]=a41;
	B[1][4]=a51;
	B[1][5]=a61;
	B[1][6]=a71;
	B[1][7]=a81;
	B[1][8]=a91;
	B[1][9]=a101;
	B[1][10]=a111;
	B[1][11]=a121;
	B[1][12]=a131;
	B[1][13]=beh1;

	B[2][2]=a32;
	B[2][3]=a42;
	B[2][4]=a52;
	B[2][5]=a62;
	B[2][6]=a72;
	B[2][7]=a82;
	B[2][8]=a92;
	B[2][9]=a102;
	B[2][10]=a112;
	B[2][11]=a122;
	B[2][12]=a132;
	B[2][13]=beh2;

	B[3][3]=a43;
	B[3][4]=a53;
	B[3][5]=a63;
	B[3][6]=a73;
	B[3][7]=a83;
	B[3][8]=a93;
	B[3][9]=a103;
	B[3][10]=a113;
	B[3][11]=a123;
	B[3][12]=a133;
	B[3][13]=beh3;

	B[4][4]=a54;
	B[4][5]=a64;
	B[4][6]=a74;
	B[4][7]=a84;
	B[4][8]=a94;
	B[4][9]=a104;
	B[4][10]=a114;
	B[4][11]=a124;
	B[4][12]=a134;
	B[4][13]=beh4;

	B[5][5]=a65;
	B[5][6]=a75;
	B[5][7]=a85;
	B[5][8]=a95;
	B[5][9]=a105;
	B[5][10]=a115;
	B[5][11]=a125;
	B[5][12]=a135;
	B[5][13]=beh5;

	B[6][6]=a76;
	B[6][7]=a86;
	B[6][8]=a96;
	B[6][9]=a106;
	B[6][10]=a116;
	B[6][11]=a126;
	B[6][12]=a136;
	B[6][13]=beh6;

	B[7][7]=a87;
	B[7][8]=a97;
	B[7][9]=a107;
	B[7][10]=a117;
	B[7][11]=a127;
	B[7][12]=a137;
	B[7][13]=beh7;

	B[8][8]=a98;
	B[8][9]=a108;
	B[8][10]=a118;
	B[8][11]=a128;
	B[8][12]=a138;
	B[8][13]=beh8;

	B[9][9]=a109;
	B[9][10]=a119;
	B[9][11]=a129;
	B[9][12]=a139;
	B[9][13]=beh9;

	B[10][10]=a1110;
	B[10][11]=a1210;
	B[10][12]=a1310;
	B[10][13]=beh10;

	B[11][11]=a1211;
	B[11][12]=a1311;
	B[11][13]=beh11;

	B[12][12]=a1312;
	B[12][13]=beh12;

	B[13][13]=beh13;

	double* y_estcf=new double[14];
	y_estcf[0]=0.0;
	y_estcf[1]=be1;
	y_estcf[2]=be2;
	y_estcf[3]=be3;
	y_estcf[4]=be4;
	y_estcf[5]=be5;
	y_estcf[6]=be6;
	y_estcf[7]=be7;
	y_estcf[8]=be8;
	y_estcf[9]=be9;
	y_estcf[10]=be10;
	y_estcf[11]=be11;
	y_estcf[12]=be12;
	y_estcf[13]=be13;
	
	double**fT=new double*[14];
	for(int i=0;i<=13;i++)
		fT[i]=new double[nbcmpP1];

	// ( MAIN LOOP  1 integration step/ iteration)
	double tnew;
	double*ynew=new double[nbcmpP1];
	double*y_est=new double[nbcmpP1];
	double*fnew=new double[nbcmpP1];
	double hold;
	double stsize;
	double err_est;
	double erk;
	int jpnbposp1;
	double prevh;
	
	double* E=new double[14];
	E[0]=0.0;
	E[1]=beh1-be1;
	E[2]=beh2-be2;
	E[3]=beh3-be3;
	E[4]=beh4-be4;
	E[5]=beh5-be5;
	E[6]=beh6-be6;
	E[7]=beh7-be7;
	E[8]=beh8-be8;
	E[9]=beh9-be9;
	E[10]=beh10-be10;
	E[11]=beh11-be11;
	E[12]=beh12-be12;
	E[13]=beh13-be13;

	double*tempV=new double[nbcmpP1];

	double* hA=new double[14];

	while(tvals[j+nbpos] < tend){
		
		if (j >= 40000000){
		
			temp=j+nbpos;

			break;
		}
		h=hnew;
		if(tc+h > tend)
			h=tend-tc ;

		//  (MAIN INTEG STEP)
	
		err_est=9999;

		//LOOP REPEAT THE STEP UNTIL SUCCESS -----------------------
	
		while ( err_est > TOL  ){

			jpnbpos=j+nbpos;

			for(int i=1;i<=nbcmp;i++)
				fT[1][i] = fvals[jpnbpos][i];
		    // hA: 12 comp
			hA[0]=0.0;
			hA[1]=h/18.0;
			hA[2]=h/12.0;
			hA[3]=h/8.0;
			hA[4]=h*5.0/16.0;
			hA[5]=h*3.0/8.0;
			hA[6]=h*59.0/400.0;
			hA[7]=h*93.0/200.0;
			hA[8]=h*5490023248.0/9719169821.0;
			hA[9]=h*13.0/20.0;
			hA[10]=h*1201146811.0/1299019798.0;
			hA[11]=h;
			hA[12]=h;
			hA[13]=h;
			

			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][1];
			}
			f(tc+hA[1],tempV,nbcmp,fT[2]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][2]+fT[2][i]*h*B[2][2];
			}
			f(tc+hA[2],tempV,nbcmp,fT[3]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][3]+fT[2][i]*h*B[2][3]+fT[3][i]*h*B[3][3];	
			}
			f(tc+hA[3],tempV,nbcmp,fT[4]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];	
				tempV[i]+=fT[1][i]*h*B[1][4]+fT[2][i]*h*B[2][4]+fT[3][i]*h*B[3][4]+fT[4][i]*h*B[4][4];
			}
			f(tc+hA[4],tempV,nbcmp,fT[5]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i]+fT[1][i]*h*B[1][5];	
				tempV[i]+=fT[2][i]*h*B[2][5]+fT[3][i]*h*B[3][5]+fT[4][i]*h*B[4][5]+fT[5][i]*h*B[5][5];
			}
			f(tc+hA[5],tempV,nbcmp,fT[6]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][6]+fT[2][i]*h*B[2][6]+fT[3][i]*h*B[3][6]+fT[4][i]*h*B[4][6];
				tempV[i]+=fT[5][i]*h*B[5][6]+fT[6][i]*h*B[6][6];
			}
			f(tc+hA[6],tempV,nbcmp,fT[7]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][7]+fT[2][i]*h*B[2][7]+fT[3][i]*h*B[3][7]+fT[4][i]*h*B[4][7];
				tempV[i]+=fT[5][i]*h*B[5][7]+fT[6][i]*h*B[6][7]+fT[7][i]*h*B[7][7];
			}
			f(tc+hA[7],tempV,nbcmp,fT[8]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][8]+fT[2][i]*h*B[2][8]+fT[3][i]*h*B[3][8]+fT[4][i]*h*B[4][8];
				tempV[i]+=fT[5][i]*h*B[5][8]+fT[6][i]*h*B[6][8]+fT[7][i]*h*B[7][8]+fT[8][i]*h*B[8][8];
			}
			f(tc+hA[8],tempV,nbcmp,fT[9]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i]+fT[1][i]*h*B[1][9];
				tempV[i]+=fT[2][i]*h*B[2][9]+fT[3][i]*h*B[3][9]+fT[4][i]*h*B[4][9]+fT[5][i]*h*B[5][9];
				tempV[i]+=fT[6][i]*h*B[6][9]+fT[7][i]*h*B[7][9]+fT[8][i]*h*B[8][9]+fT[9][i]*h*B[9][9];
			}
			f(tc+hA[9],tempV,nbcmp,fT[10]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][10]+fT[2][i]*h*B[2][10]+fT[3][i]*h*B[3][10]+fT[4][i]*h*B[4][10];
				tempV[i]+=fT[5][i]*h*B[5][10]+fT[6][i]*h*B[6][10]+fT[7][i]*h*B[7][10]+fT[8][i]*h*B[8][10];
				tempV[i]+=fT[9][i]*h*B[9][10]+fT[10][i]*h*B[10][10];
			}
			f(tc+hA[10],tempV,nbcmp,fT[11]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][11]+fT[2][i]*h*B[2][11]+fT[3][i]*h*B[3][11]+fT[4][i]*h*B[4][11];
				tempV[i]+=fT[5][i]*h*B[5][11]+fT[6][i]*h*B[6][11]+fT[7][i]*h*B[7][11]+fT[8][i]*h*B[8][11];
				tempV[i]+=fT[9][i]*h*B[9][11]+fT[10][i]*h*B[10][11]+fT[11][i]*h*B[11][11];
			}
			f(tc+hA[11],tempV,nbcmp,fT[12]);
			
			for(int i=1;i<=nbcmp;i++){
				tempV[i]=yc[i];
				tempV[i]+=fT[1][i]*h*B[1][12]+fT[2][i]*h*B[2][12]+fT[3][i]*h*B[3][12]+fT[4][i]*h*B[4][12];
				tempV[i]+=fT[5][i]*h*B[5][12]+fT[6][i]*h*B[6][12]+fT[7][i]*h*B[7][12]+fT[8][i]*h*B[8][12];
				tempV[i]+=fT[9][i]*h*B[9][12]+fT[10][i]*h*B[10][12]+fT[11][i]*h*B[11][12]+fT[12][i]*h*B[12][12];
			}
			f(tc+hA[12],tempV,nbcmp,fT[13]);
			
			tnew = tc + hA[13];

			for(int i=1;i<=nbcmp;i++){
				ynew[i]=yc[i]+fT[1][i]*h*B[1][13];
				ynew[i]+=fT[2][i]*h*B[2][13]+fT[3][i]*h*B[3][13]+fT[4][i]*h*B[4][13]+fT[5][i]*h*B[5][13];
				ynew[i]+=fT[6][i]*h*B[6][13]+fT[7][i]*h*B[7][13]+fT[8][i]*h*B[8][13]+fT[9][i]*h*B[9][13];
				ynew[i]+=fT[10][i]*h*B[10][13]+fT[11][i]*h*B[11][13]+fT[12][i]*h*B[12][13]+fT[13][i]*h*B[13][13];
			}

			for(int i=1;i<=nbcmp;i++){
				y_est[i]=yc[i]+fT[1][i]*h*y_estcf[1];
				y_est[i]+=fT[2][i]*h*y_estcf[2]+fT[3][i]*h*y_estcf[3]+fT[4][i]*h*y_estcf[4]+fT[5][i]*h*y_estcf[5];
				y_est[i]+=fT[6][i]*h*y_estcf[6]+fT[7][i]*h*y_estcf[7]+fT[8][i]*h*y_estcf[8]+fT[9][i]*h*y_estcf[9];
				y_est[i]+=fT[10][i]*h*y_estcf[10]+fT[11][i]*h*y_estcf[11]+fT[12][i]*h*y_estcf[12]+fT[13][i]*h*y_estcf[13];
			}
						
			// PART:  STEP SIZE, ORDER SELECTION 
			err_est=0.0;
			for(int i=1;i<=nbcmp;i++){
				if(fabs(y_est[i]-ynew[i])>err_est)
					err_est=fabs(y_est[i]-ynew[i]);
			}

			hold=h;
	
			if (err_est >  TOL){
				//  (the computed step (hold) is rejected, compute smaller h )
				//      h =  max(  hold *0.5000, hmin) ;			

				h =  max(hold*0.7*stfac*pow(TOL/err_est,1.0/8.0), hmin);

				nreje=nreje+1;
				
			}
			// end if err_est > TOL

		}

		// (--------- end  LOOP REPEAT UNTIL SUCCESS    while ( err_est > TOL ) ----------------
		f(tnew,ynew,nbcmp,fT[13]);
		// return  
		for(int i=1;i<=nbcmp;i++)
			fnew[i]= fT[13][i];

		//   erk =   max(abs(f * ( hB(:,13)- h*y_estcf)  )) = max(abs(f *  hE  ))
		erk=0.0;
		for(int i=1;i<=nbcmp;i++){
			tempD=0.0;
			for(int ii=1;ii<=13;ii++){
				tempD+=fT[ii][i]*E[ii];
			}
			if(fabs(tempD)>erk)
				erk=fabs(tempD);
		}
		erk*= fabs(h);   

		//   ode45 hmin:  eps = 2.220446049250313e-16
		//    eps = 2.220446049250313e-16 ;
		//    hmin = 16*eps*abs(tc);    stephmin2=hmin
		//  PART :  STEP SIZE ********************
	
		//  (step size formula : h =hold, stsize = hnew)   
		if (erk != 0.0){
			// ACT    (HB../HB11 step cntrl)
			stsize = h *stfac *pow(TOL/erk ,1.0/8.0 ) ;  
		}
		else
	      stsize = 2*h ;

		//(end of step size formula : h =hold, stsize = hnew)

		//  constraints that stsize must satisfy :
		//    (a) h( next step) = max (h( next step), hmin, 0.5* h(last step))
		//    (b) h( next step) = min (h( next step), hmax, 4 * h(last step))

		stsize = max ( stsize, 0.5* h ) ;
		stsize = max ( stsize, hmin ) ;
		stsize = min( stsize, hmax) ;
		stsize = min( stsize, 4*h) ;

		tc=tnew;
		for(int i=1;i<=nbcmp;i++)
			yc[i]=ynew[i] ;
		jpnbposp1=j+nbpos+1;
		for(int i=1;i<=nbcmp;i++){
			fvals[jpnbposp1][i]= fnew[i]; 
			yvals[jpnbposp1][i] =  yc[i]; 
		}
		hnew=stsize ;
		//  -----(END OF INTEG STEP) --------------------
		//  (yvals,tvals,.. UPDATE STEP)
	
		tvals[jpnbposp1] =  tc;
   
		prevh = h ;
		j++ ;
		
	}
	// ( END OF MAIN LOOP  1 integration step/ iteration) -------------
	
	// print out statistics
	// with index j-1,  yvals(n+1+nbpos, . )  cont solution
	int n=j-1;
	int nb_f_eval=(n+1+nreje)*nbeps ;

	int NFE=nb_f_eval;//number of function (ode) evaluations

	res[1]=NFE;
	// nb succes step:
	res[2]=n+1 ;
	res[3]=nreje ;

	//freeing memory
	delete yc;
	delete fc;
	for(int i=0;i<=13;i++){
		delete fT[i];
		delete B[i];
	}
	delete fT;
	delete ynew;
	delete y_est;
	delete fnew;
	delete tempV;
	delete y_estcf;
	delete B;
	delete E;
	delete hA;
}
