/*
%  Variable-step 4-stage Hermite-Birkhoff-Obrechkoff d1-d3
%  ode solver of order 14 "HBOQ144q16.cpp" solves Kepler's problem 
% with eccentricity = 0.9 (D5 of DETEST)
%
%   1. INITIALISATION 
%      - set  initial t0=0;
%             initial y0 = [ (1-epsv);    0 ;   0 ;   sqrt((1+epsv)/(1-epsv)) ] 
%                where epsv=0.9 ;
%             integration final time "tend"
%                (test for var. step)  ecc near 1 and long term integ. : t0 =0  to  tend=200* 2*pi
%
%
%   2. PERFORM THE INTEGRATION: call  "HBO144q16"
%   3. OUTPUT
%       write on file "HBORKcpu.txt" the following informations:
%         - CPU time, number of steps, number of function evaluations, 
%           Max. global error, Max. energy error and Max. angular momentum error
%
%



*/

#include <time.h>
#include <stdio.h>

#include "odeSOLD.cpp"//Calculate exact solution
#define includeName "odeD.cpp"//y'=f(x,y)
#include "HBO144q16.cpp"//Used solver

using namespace std;

//Print methods for easy reading
void print(double*x, int dim){
	for(int i=1;i<dim;i++)cout<<x[i]<< ", ";
	cout<<x[dim]<<'\n';
}
void print(double x, double*y,int dim){
	cout<<" tc = "<<x<<"; yc = (";
	for(int i=1;i<dim;i++)cout<<y[i]<< ", ";
	cout<<y[dim]<<")\n";
}

int main()
{
	//...Input...
	int nbcmp=4;//number of components of y0
    double me, ham, mxame, am;	
    int nbyva=200000 ;
    int nbyvap1=nbyva+1 ;
	
//  Problem D1 : epsv = 0.1
//  Problem D2 : epsv = 0.3
//  Problem D3 : epsv = 0.5
//  Problem D4 : epsv = 0.7
//  Problem D5 : epsv = 0.9	
	
	double epsv=0.9 ;//epsilon in D problems
	
	double RELTOL=4*pow(10.0,-14);//Relative tolerance

// ****** long term integr. Tol=11 ******
	int minIdxTol= 10 ;
	int maxIdxTol= 11 ;//Tolerance goes from 1e-minIdxTol to 1e-maxIdxTol
	
	double t0=0.0;//Initial t

    double tend=200.0 *2.0 *3.1415926535897932384626433832795;
    // act double tend=200 *2 *3.1415926535897932384626433832795;
	//............
	double TOL;
	int nbcmpP1=nbcmp+1;
	//Initializing main arrays
	double*tvals =new double[nbyvap1];//values of t_n
	double**yvals=new double*[nbyvap1];//values of y_n
	double**fvals=new double*[nbyvap1];
	double**f2vals=new double*[nbyvap1];
	double**f3vals=new double*[nbyvap1];
				
	int*res=new int[4];
	for(int j=0;j<=nbyva;j++){
		tvals[j]=0.0;
		yvals[j]=new double[nbcmpP1];
		fvals[j]=new double[nbcmpP1];
		f2vals[j]=new double[nbcmpP1];
		f3vals[j]=new double[nbcmpP1];	
						
		for(int i=0;i<=nbcmp;i++){
			yvals[j][i]=0.0;
			fvals[j][i]=0.0;
			f2vals[j][i]=0.0;
			f3vals[j][i]=0.0;																																																					
		}
	}
//  (end for(int j=0;j<=nbyva;j++){} )		

//                                  1. INITIALISATION 

	double* y0=new double[nbcmpP1];
	y0[1]=1.0-epsv;
	y0[2]=0.0;
	y0[3]=0.0;
	y0[4]=sqrt((1+epsv)/(1-epsv));

//! Initial energy value:
	double ham0 = 0.5*(y0[3]*y0[3] + y0[4]*y0[4]) - 1.0/sqrt(y0[1]*y0[1] + y0[2]*y0[2]) ;
//! Initial angular momentum value:
	double am0 = y0[3]*y0[2] -y0[4]*y0[1] ;

	//To calculate the CPU
	double duration;
	clock_t start;
	//To calculate the maximum global error
	double maxGE;
	double y;
	double x;
	double*sol=new double[nbcmpP1];//exact solution
	
	//Output file
	FILE* file=fopen("HBORKcpu.txt","a");
	char*dProb="012345";
	char fname[6]="PrbD";
	fname[4]=dProb[(int)ceil((epsv*10.0+1.0)/2.0)];
	fname[5]='\0';
	
	double nbeps=4+5 ;
	int nbpos=10;
	double NFE;//Number of function evaluations
	double n;//Number of succes step:
	double nreje, nbit;
    int inbit ;
	
	//Print to file
	fprintf (file," HBORK  METHOD prb   %15s, ecc eps= %9.8e , tend= %7.2e \n", fname, epsv,tend) ;

	for(int j=minIdxTol;j<=maxIdxTol;j++){
		TOL=1.0*pow(10.0,-j*1.0);		

    	cout << " cprog : j= " << j << ", TOL =" << TOL << endl ;
// act		nbit=200.0 ;		
		nbit=1.0 ;
		inbit=int(nbit) ;
		//CPU
		start=clock();

//                             2. PERFORM THE INTEGRATION: call  "HBO144q16"

		for(int i=1;i<=inbit ;i++){

			HBO144q16(RELTOL,TOL,t0,tend,y0,tvals,yvals,fvals,f2vals,f3vals,res,nbcmp);

		}
		duration = (double)(clock()-start)/CLOCKS_PER_SEC/nbit ;

		//Maximum global error
		maxGE=0.0;
	    me=0.0;		
        mxame = 0.0 ;

		for(int i=11;i<=nbpos+res[2];i++){
			x=tvals[i];
			odeSolD(x,yvals[i],nbcmp,epsv,sol);//exact solution
			for(int j=1;j<=nbcmp;j++){
				y=yvals[i][j];
				if(fabs(y-sol[j])>maxGE)maxGE=fabs(y-sol[j]);								
			}
			// (end for(int j=1;j<=nbcmp;j++){})				

            // calc. hamiltonian error:   
			ham = 0.5*( yvals[i][3]*yvals[i][3] +yvals[i][4]*yvals[i][4]  ) - 1.0/sqrt(  yvals[i][1]*yvals[i][1] + yvals[i][2]*yvals[i][2]) ;
            ham = fabs(ham/ham0 - 1.0 ) ;
            if(ham >=  me) me = ham ;
			// cout << "\n cprog: me = " << me  << "  ham = " << ham  << "  ham0 = " << ham0  <<  "  i = " << i  <<  endl ;	

            // calc. angular momentum error:
	        am = yvals[i][3]*yvals[i][2] -yvals[i][4]*yvals[i][1] ;
            am = fabs(am/am0 - 1.0 ) ;
            if( am >=  mxame) mxame = am ;			
		}
//		(end for(int i=11;i<=nbpos+res[2];i++){	)	
		// cout << " cprog: tend=" << tvals[nbpos+res[2] ] <<  "tendzero= " << (tvals[nbpos+res[2] ]-tend) <<   " maxGE =" << maxGE << endl ;
		
		NFE=res[1]*1.0;//Number of function evaluations
		n=res[2]-1.0;//Number of succes step:
		nreje=res[3]*1.0;

		
//                                          3. OUTPUT		
		//Print to file
		fprintf (file," HBO  METHOD   %15s, nsuccesstp = %5.0f, nreje = %5.0f \n", fname, n+1, nreje) ;
		fprintf (file," HBO144q16CPU( 20, %3.0f ) = %7.2e ; HBO144q16NST( 20, %3.0f ) = %5.0f ; HBO144q16NFE( 20, %3.0f ) = %5.0f ;  HBO144q16MXGE( 20, %3.0f ) = %7.2e ;  HBO144q16ENER( 20, %3.0f ) = %7.2e ;  HBO144q16AME( 20, %3.0f ) = %7.2e ; \n"  ,j*1.0, duration, j*1.0, n , j*1.0, NFE ,j*1.0, maxGE , j*1.0, me, j*1.0, mxame ) ;
				
		//Completed work
		cout << "\n cprog: CPU est. nb iteration  inbit = " << inbit  <<  endl ;		
		cout<<"Completed tolerance : "<<TOL<<'\n';
	}
	fclose(file);

	// ******* freeing memory ************
	delete tvals;
	delete y0;
	for(int j=0;j<=nbyva;j++){
		delete yvals[j];
		delete fvals[j];
		delete f2vals[j];
		delete f3vals[j];													
	}
	delete yvals;
	delete fvals;
	delete f2vals;
	delete f3vals;	
	
	delete res;
	delete sol;

	//Print
	cout<<"\nDone.\n";
	return 0;
}
