import java.text.DecimalFormat;

// ITI1120 Fall 2012, Assignment 3, Question 3
// Name: Gilbert Arbez, Student #: 81069665

// This library contains methods to manipulate the R-L-C circuit.

public class Circuit 
{
    // Class constants
    public static final int VIX = 0;  // Index to battery value (volts)
    public static final int CIX = 1;  // Index to capacitor value (farads)
    public static final int LIX = 2;  // Index to inductor value (henrys)
    public static final int RIX = 3;  // Index to resistor value (ohms)
  
    /*----------------------------------------------------------------------------------------------------------------*/
    /**
    *  Method: computeQ
    *  Description: Computes the charge Q on the capacitor for a given time
    *               and component values  
    *  Parameters (GIVENS):
    *        time - the current time
    *        compArr - reference to a components value array
    *  Assumptions:
    *     compArr[VIX] has values ranging between 4 and 15 volts
    *     compArr[CIX] has values ranging between 10-9 and 10-7 farads
    *     compArr[LIX] has values ranging between 10-3 and 10-1 henrys
    *     compArr]RIX] has values ranging between 5 and 10 ohms
    */
    public static double computeQ(double time, double [] compArr)
   {
      // Declare variables
      double eVal;    // For storing value of e's exponent
      double cosVal;  // For storing argument value to cosine
      double cap, ind, res; // For values of capacitor, inductor and resistor respectively
      double q;       // RESULT: the charge on the capacitor
     
      // Method Body
      cap = compArr[CIX];
      ind = compArr[LIX];
      res = compArr[RIX];
      eVal = -time * res/(2.0 * ind);
      cosVal = time*Math.sqrt(1.0/(ind*cap)-Math.pow((res/(2.0*ind)),2));
      q = compArr[VIX]*cap*Math.exp(eVal)*Math.cos(cosVal);
      return(q);  
 }
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: genTimeArray
      *  Description: Generates a time array.  
      *  Parameters (GIVENS):
      *        tmax - the maximum time
      *        tstep - the time step value
      */
 public static double [] genTimeArray(double tmax, double tstep)
 {
    // Variable declarations
    double [] timeArray;  // Reference to time array
    double curTime;       // current time
    int n;                // number of elements in the array
    int ix;               // for indexing into the array
   
    // Method Body
    curTime = 0;
    n = ((int) (tmax/tstep))+1;
    timeArray = new double[n];
    for(ix = 0; ix < n; ix++)
    {
      timeArray[ix] = curTime;
      curTime = curTime + tstep;
    }
    return(timeArray);
 }
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: genQArray
      *  Description: Generates a time array.  
      *  Parameters (GIVENS):
      *        compArr - references to a component values array
      *        timeArr - reference to a time array
      *        n       - length of the time array (given by timeArr.length)
      */
 public static double [] genQArray(double [] compArr, double [] timeArr)
 {
    // Variable declarations
    double [] qArray;  // RESULTS: Reference to q value array
    int n = timeArr.length; // number of elements in the time and q array
    int ix;            // for indexing into the array
    
    // Method Body
    qArray = new double[n];
    for(ix = 0; ix < n; ix++)
    {
      qArray[ix] = computeQ(timeArr[ix],compArr);
    }
    return(qArray);
 }
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: displayQFunction
      *  Description: Outputs a table that gives the values of the Q function 
      *  Parameters (GIVENS):
      *        timeArray - references to a time array
      *        qArray - reference to a q value array
      *        n       - length of the arrays (given by timeArr.length)
      *        Assume that both the timeArray and qArray are of the same length
      */
 public static void displayQFunction(double [] timeArray, double [] qArray)
 {
    // Variable declarations
    int n = timeArray.length; // number of elements in the time and q arrays
    int ix;            // for indexing into the array  
    DecimalFormat df = new DecimalFormat("0.000E000");
    
    // Method Body
    System.out.println("--------------------------------------------");
    System.out.println("Time t      Q(t)");
    for(ix=0; ix<n; ix++)
    {
       System.out.println(df.format(timeArray[ix]) + "   " + df.format(qArray[ix]));
    }
    System.out.println("--------------------------------------------");
 } 

}
