import java.text.DecimalFormat;

// ITI1120 Fall 2012, Assignment 3, Question 3
// Name: Gilbert Arbez, Student #: 81069665

// The program allows the simulation of an R-L-C circuit.

public class A3Q3 
{

 /**
  * The main program controls the execution of the to define the values
  * for each component in the circuit (and redefine them) and run
  * multiple simulations of the circuit's operation.
  */
 public static void main(String[] args) 
 {
     // Declaration of variables
     double [] compArr;  // Reference to array of component values
     boolean flag;  // flag to control the loop
     char answer;  // to store a y/n answer from the user
   
     // PRINT IDENTIFICATION INFORMATION
     System.out.println();
     System.out.println("ITI1120 Fall 2012, Assignment 3, Question 3");
     System.out.println("Name: Gilbert Arbez, Student# 81069665");
        
     // Method Body
     compArr = getCircuitComp();
     flag = true;
     while(flag)
     {
         compArr = updateCircuitComp(compArr);
         runSimulations(compArr);
         System.out.print("Do you want to quit (y/n)? ");
         answer = ITI1120.readChar();
         flag = (answer != 'y');
     }
     System.out.println("Program Terminated");
 }
 
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: updateCircuitComp
      *  Description: Allows a user to reset the component values. The method creates
      *               a new array if new values are assigned.  
      *  Parameters (GIVENS):
      *        origCompArr - reference to the existing components value array
      */
 public static double [] updateCircuitComp(double [] origCompArr)
 {
     // Declaration of variables
     char answer; // y/n answer from user to reset component values
     double [] compArr;  // RESULT: reference to array returned
    
     // Formatter
     DecimalFormat df = new DecimalFormat("0.000E00"); 
     
     // Method BODY
     // Display current values
     System.out.println("--------------------------------------------");
     System.out.println("Voltage Source V = " + origCompArr[Circuit.VIX] + " volts");
     System.out.println("Capacitor C = " + df.format(origCompArr[Circuit.CIX]) + " farads");
     System.out.println("Inductor L = " + df.format(origCompArr[Circuit.LIX]) + " henrys");
     System.out.println("Resistor R = " + origCompArr[Circuit.RIX] + " ohms");
     System.out.println("--------------------------------------------");
     System.out.print("Reset component values? ");
     answer = ITI1120.readChar();
     if(answer == 'y')
     {
        compArr = getCircuitComp();
     }
     else
     {
        compArr = origCompArr;
     }
     
     // Return results
     return(compArr);
 }
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: runSimulations
      *  Description: Allows a user to run multiple simulations for given component values.  
      *  Parameters (GIVENS):
      *        compArr - reference to a components value array
      */
 public static void runSimulations(double [] compArr)
 {
     // Declaration of variables
     boolean flag;  // flag to control loop
     char answer;   // y/n answer from user
     double tMax;   // maximum value for creating function
     double tStep;  // time step for incrementing time
     double [] timeArr;  // reference to time array
     double [] qArray;   // reference to q value array
       
     // Method Body
     flag = true;
     while(flag)
     {
        System.out.print("Run a simulation? ");
        answer = ITI1120.readChar();
        if(answer == 'y')
        {
           System.out.print("Enter a maximum time (sec): ");
           tMax = ITI1120.readDouble();
           System.out.print("Enter a time step (sec): ");
           tStep = ITI1120.readDouble();
           timeArr = Circuit.genTimeArray(tMax, tStep);
           qArray = Circuit.genQArray(compArr, timeArr);
           Circuit.displayQFunction(timeArr, qArray);    
        }
        else
        {
            flag = false;
        }
     }
 }
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: compArr
      *  Description: Get values for the circuit components.  
      *  Parameters (GIVENS): none
      */
 public static double [] getCircuitComp()
 {
     // Declaration of variables
     double [] compArr;  // RESULT
     
     // Method Body
     compArr = new double[4];
     compArr[Circuit.VIX] = getValue("Enter a value for V (4 to 15): ", 4.0, 15.0);
     compArr[Circuit.CIX] = getValue("Enter a value for C (1e-9 to 1e-7): ", 1e-9, 1e-7);
     compArr[Circuit.LIX] = getValue("Enter a value for L (1e-3 to 1e-1): ", 1e-3, 1e-1);
     compArr[Circuit.RIX] = getValue("Enter a value for R (5 to 10): ", 5.0, 10.0);
     
     // Return value
     return(compArr);
 }
 
 /*----------------------------------------------------------------------------------------------------------------*/
    /**
      *  Method: getValue
      *  Description: Get a real value from the user and check for validity.  
      *  Parameters (GIVENS): 
      *      prompt - reference to String prompt to prompt user for value
      *      minValue - minimum allowed value
      *      maxValue - maximum allowed value
      */
 public static double getValue(String prompt, double minValue, double maxValue)
 {
     // Declare variables
     boolean flag;       // For controlling loop
     double value=0.0;   // RESULT - valid value to return
     
     // Method Body
     flag = true;
     while(flag)
     {
        System.out.print(prompt);
        value = ITI1120.readDouble();
        if(value >= minValue && value <= maxValue)
        {
           flag = false;
        }
        else
        {
           System.out.println("Bad value: " + value);
        }   
     }
     return(value);  
 }
}
