/*
 * CSI2131 Winter 2005
 *
 * Assignment#1 Solution : The main function
 *
 * by Shantanu Das / Dt: 2005-02-04
 *
 * This is the main program that inputs the filenames from command line, 
 * opens or creates the files and invokes the HtmlTranslator class 
 * to translate from HTML to TEXT.

 *************** ASSUMPTIONS ABOUT THE HTML FILE **********************
 1. Tags may be written using either upper or lower case characters.
 2. Tags begin with '<' and a non-space character following it.
 3. There are NO nested tags inside <a> and </a> or, <hn> and </hn>.
 4. Every <li> tag has a matching </li> tag and, 
    every <ol> or <ul> tag has a matching </ol> or </ul>.  
 **********************************************************************
 *
 */

#include "HtmlTranslator.h"
#include <iostream>
#include <fstream>
using namespace std;


// main method ... uses command line arguments

int main(int argc,char* argv[])
{
   
  fstream input;                  // input stream
  fstream output;				  // output stream
  
  // check for the correct number of arguments.
  if(argc!=3){
	  cerr << "USAGE: " << argv[0] << " <Inputfile> <Outputfile>" << endl;
	  return 1;
  }

  // open the first file in input mode
  input.open(argv[1], ios::in);

  // Check to make sure that we could open the file properly!
  if (input.fail()) {
    cerr << "Could not open file ";
    cerr << argv[1];
    cerr << ".\n";
    return 1;
  }

  // open the output file in binary mode and truncate the file if it already exists
  output.open(argv[2], ios::out | ios::trunc | ios::binary );

  // Check to make sure that we could open the file properly!
  if (output.fail()) {
    cerr << "Could not create file ";
    cerr << argv[2];
    cerr << ".\n";
    return 1;
  }

  HtmlTranslator translator(input, output);		// create HtmlTranslator object

  translator.parse();		// parse the file to translate it

  input.close();            // Close the files
  output.close();

  // Program completed successfully! */
  return 0;
}





